<?php

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
namespace SCHLIX;
interface interface_cmsAdmin
{    
    // display html
    public function setPageTitle($title = '');

    public function viewMainPage();

    public function getMenuInfo();
    
    public function ajaxGetMenuInfo();

                    
    public function recordLog($message);

    public function RunInstallScript($sample_data = false);

    public function RunUninstallScript($uninstall_db, $uninstall_everything);
    
    public function createFriendlyAdminURL($action_query_string);
    
    public function getDataModelURL();

    public function Run();
}

interface interface_cmsAdmin_List extends interface_cmsAdmin
{

    public function getItemByID($id);

    public function ajaxGetAllItems($start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC');

    //public function genericSearch($fieldname, $keyword, $sortby='', $sortdirection='ASC');
    public function getItemFieldNamesForAjaxListing();

    public function ajaxCopyObjects($mixed_items_to_copy, $destination = '');

    public function ajaxSearchObjects($keyword = '', $start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC');

    public function editItem($id);

    public function saveItem($id);

    public function Hide($str);

    public function ajaxDeleteObjects($str);

    public function ajaxUpdateField();
}

interface interface_cmsAdmin_CategorizedList extends interface_cmsAdmin_List
{

    // display html
    public function getFullPathByCategoryID($cat_id);

    public function ajaxMoveObjects($mixed_items_to_move, $destination);

    public function ajaxGetAllCategories($start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC');

    public function getCategoryByID($id);

    public function getCategoryFieldNamesForAjaxListing();

    public function ajaxGetItemsByCategoryID($id, $start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC');

    public function editCategory($id);

    public function saveCategory($id);
}

interface interface_cmsAdmin_HierarchicalTreeList extends interface_cmsAdmin_CategorizedList
{

    public function getChildCategoriesByParentID($id, $start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC');
}

interface interface_cmsAdmin_ManyToMany extends interface_cmsAdmin_HierarchicalTreeList
{
    
}

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++//
class cmsAdmin_Basic implements interface_cmsAdmin
{
    use cmsTemplateViewer;
    /**
     * The application
     * @var cmsApplication_Basic
     */
    protected $app;
    
    /**
     * Application name
     * @var string 
     */
    // protected $app_name; // already defined in cmsTemplateViewer
    // protected $full_app_name; // already defined in cmsTemplateViewer
    /**
     * Application version
     * @var string 
     */
    protected $app_version;
    public $data_type;
    public $public_methods;
    public $ajax_controller_name;
        
    /**
     * @internal
     * @var array 
     */
    protected $lastSaveResult;
    /**
     * @internal
     * @var array 
     */
    protected $lastConfigSaveResult;
    
    protected $_before_save_config_functions;
    protected $_more_save_config_validations;
    protected $_after_save_config_functions;
    
    protected $app_frontend_classname;
    
    
    /**
     * List of default restricted view files
     * @var tarray
     */
    protected $default_restricted_view_files = ['config.template.php', 'edit.item.template.php','edit.category.template.php'];
    /**
     * List of restricted view files
     * @var tarray
     */    
    protected $restricted_view_files = [];

    /* PHP 8.2 compatibility */
    protected $app_js_controller;
    
    protected $app_real_class_alias;
    protected $app_subclass_suffix;
    
    protected $app_admin_url_path;
    protected $app_admin_url_path_no_base;
    protected $app_description;
    
    //_________________________________________________________________________//
     /**
      * Constructor
      * @param string $data_type
      * @param array $public_methods
      */
    public function __construct($data_type = null, $public_methods = null)
    {
        $this->setSchlixClassInformation();
        $this->data_type = $data_type;
        $this->public_methods = [];
        //$this->loadLanguageFile();
        $class_name = '\\App\\'.$this->app_frontend_classname;        
        
        $this->app = new $class_name;
        $this->app_description = $this->app->getApplicationDescription();
        if (is_array($public_methods) && ___c($public_methods) > 0)
            foreach (array_keys($public_methods) as $key)
                $this->public_methods[] = array('action' => $key, 'description' => $public_methods[$key]);
    }        

    public function getCustomizableClassInfo()
    {
        $at_system = false;
        $at_web = false;
        $at_theme = false;
        $original_classes = [];
        $af = _schlix_get_classes_to_load(get_class($this->app));
        foreach ($af as $c)
        {
            $og = null;
            $prefix = null;
            if (str_starts_with($c, SCHLIX_SYSTEM_PATH))
            {
                $at_system = true;
                $prefix = SCHLIX_SYSTEM_PATH;
                $relative_prefix = SCHLIX_SYSTEM_URL_PATH;
                $data = ['original_file' => $og, 'prefix' => $prefix, 'relative_prefix' => $relative_prefix ];
                
            }
            elseif (str_starts_with($c, CURRENT_THEME_PATH))
            {
                $at_theme = true;
                $prefix = CURRENT_THEME_PATH;
                $relative_prefix = CURRENT_THEME_URL_PATH;
                $data = ['original_file' => $og, 'prefix' => $prefix, 'relative_prefix' => $relative_prefix ];
                
            }
            elseif (str_starts_with($c, CURRENT_SUBSITE_PATH))
            {
                $at_web = true;
                $prefix = CURRENT_SUBSITE_PATH;
                $relative_prefix = CURRENT_SUBSITE_URL_PATH;
                $data = ['original_file' => $og, 'prefix' => $prefix, 'relative_prefix' => $relative_prefix ];
                
            }
            
            if ($prefix != null)
            {
                $og = remove_prefix_from_string($c, $prefix);
                $data = ['original_file' => $og, 'prefix' => $prefix, 'relative_prefix' => $relative_prefix ];
                $text = '';
                if ($at_system)
                    $text = sprintf(___('You can override the system file %s located in %s by copying it to %s.'), $data['original_file'], $data['relative_prefix'], CURRENT_SUBSITE_URL_PATH.$data['original_file']) ;
                elseif ($at_web) 
                {
                    if (file_exists(SCHLIX_SYSTEM_PATH.$og))
                        $text = sprintf(___('The file %s located in %s was copied from %s.'), $data['original_file'], $data['relative_prefix'], SCHLIX_SYSTEM_URL_PATH.$data['original_file']) ;
                    else
                        $text = ___('N/A') ;
                } else
                    $text = sprintf(___('The file %s located in %s'), $data['original_file'], $data['relative_prefix']) ;
                $data['text'] = $text;
                $original_classes[] = $data;
                
            }
        }
        $pdir = $this->app_relative_directory;
        if (isset($this->schlix_subclass) && !empty($this->schlix_subclass) )
        {
            $sub_dir = $pdir.'/'.$this->schlix_subclass;
            if (is_dir(SCHLIX_SYSTEM_PATH.$sub_dir) || is_dir(CURRENT_SUBSITE_PATH.$sub_dir))
                $pdir = $sub_dir;
        }
        $item_array = null;
        $view_dir =  null;
        if (is_dir(SCHLIX_SYSTEM_PATH.'/'.$pdir))
        {
            $view_dir = SCHLIX_SYSTEM_PATH;
            $item_array = $this->getListOfFilesInDirectory(SCHLIX_SYSTEM_PATH, $pdir);
        } else if (is_dir(CURRENT_SUBSITE_PATH.'/'.$pdir))
        {
            $view_dir = CURRENT_SUBSITE_PATH;
            $item_array = $this->getListOfFilesInDirectory(CURRENT_SUBSITE_PATH, $pdir);
        }
                    
        return ['main_files' => $original_classes, 'view_files' => $item_array, 'view_dir' => $view_dir ];
        
    }
                    
    private function getListOfFilesInDirectory($prefix_dir, $sub_dir)
    {
        //$dir = $prefix_dir.'/'.$sub_dir;
        $forbidden_listing = $this->default_restricted_view_files;
        if (___c($this->restricted_view_files) > 0)
            $forbidden_listing = array_merge($forbidden_listing, $this->restricted_view_files);
        return get_list_of_view_files($prefix_dir, $sub_dir, $forbidden_listing);
    }        
    /**
     * Return the app's hook priority
     * @return int
     */
    public function getHookPriority()
    {
        return $this->app->getHookPriority();
    }
    /**
     * Returns this frontend app
     * @return \SCHLIX\cmsApplication_Basic
     */
    public function frontendApp()
    {
        return $this->app;
    }
    
    public function createFriendlyMainApplicationAdminURL($action_query_string = '')
    {
        $admin_url_path = $this->app_admin_url_path;
        return $action_query_string ?  $admin_url_path."?{$action_query_string}" : $admin_url_path;
    }
    

    public function createFriendlySubApplicationAdminURL($sub_app = '', $action_query_string = '')
    {
        $admin_url_path = $sub_app ? $this->app_admin_url_path.'.'.$sub_app : $this->app_admin_url_path;
        return $action_query_string ?  $admin_url_path."?{$action_query_string}" : $admin_url_path;
    }
    
    public function createFriendlyAdminURL($action_query_string)
    {
        $admin_url_path = empty($this->schlix_subclass) ? $this->app_admin_url_path : $this->app_admin_url_path.'.'.$this->schlix_subclass;
        return $admin_url_path."?{$action_query_string}";
        //return  SCHLIX_SITE_HTTPBASE . "/admin/app/{$this->app_name}?{$action_query_string}";
    }
    
    /**
     * Returns the URL of the data model
     * @return string
     */
    public function getDataModelURL()
    {
        return empty ($this->schlix_subclass) ? $this->app_admin_url_path_no_base : $this->app_admin_url_path_no_base.'.'.$this->schlix_subclass;
        // return SCHLIX_SITE_HTTPBASE . "/admin/app/{$this->app_name}";
    }
    //_______________________________________________________________________________________________________________//
    /**
     * Returns the application name (without the extra addon class
     * e.g. users_history will return users without the 'history'
     * @return type
     */
    public function getApplicationName()
    {
        return $this->app_name;
    }

    /**
     * Get the ajax controller default script file name.
     * @return string
     */
    public function getAjaxControllerScript()
    {
        $app_name_only = $this->app->getApplicationNameOnly();
        $expected_name = "/apps/{$app_name_only}/{$app_name_only}.admin.js";
        if (file_exists(SCHLIX_SITE_PATH . $expected_name)) {
            return SCHLIX_SITE_HTTPBASE . $expected_name;
        }
        elseif (file_exists(SCHLIX_SYSTEM_PATH . $expected_name)) {
            return SCHLIX_SYSTEM_URL_PATH . $expected_name;
        }
        else
            return FALSE;
    }

    //_______________________________________________________________________________________________________________//
    /**
     * Returns the application description
     * @return string
     */
    public function getApplicationDescription()
    {
        return $this->app_description;
    }

    //_________________________________________________________________________//
    /**
     * set the application alias
     * @param string $alias
     * @return bool
     */
    public function setMyApplicationAlias($alias)
    {
        $app = new \App\Core_ApplicationManager;
        return $app->setApplicationAlias($this->app_name, $alias);
    }

    //_________________________________________________________________________//
    public function setMyApplicationDescriptionAlias($description)
    {
        $app = new \App\Core_ApplicationManager;
        $app->setApplicationDescription($this->app_name, $description);
    }
    //_________________________________________________________________________//
    /**
     * Record Log
     * @global \SCHLIX\cmsLogger $SystemLog
     * @param string $message
     */
    public function recordLog($message)
    {
        global $SystemLog;

        if (method_exists($SystemLog, 'Record'))
            $SystemLog->record($message, $this->app_name);
        else
            echo $message;
    }

    //_________________________________________________________________________//
    public function CheckIfCurrentUserAllowedAccess()
    {
        global $SystemConfig, $CurrentUser;

        $array_groups_allowed_for_backend_access = $SystemConfig->get($this->app_name, 'array_groups_allowed_for_backend_access');
        return ($CurrentUser->hasPermission($array_groups_allowed_for_backend_access));
    }

    //_________________________________________________________________________//
    public function setPageTitle($title = '')
    {
        global $HTMLHeader;
        $str = ($this->app) ? $this->app->getOriginalApplicationDescription() : '';
        $HTMLHeader->ADD(\__HTML::TITLE($str . ' ' . ___('Administration') . ' ' . $title . ' - SCHLIX'));
    }

    /**
     * Returns the absolute path of the script relative to current class directory
     * @param string $script_path
     * @return string
     */
    public function getURLofScript($script_path)
    {
          return $this->app->getURLofScript($script_path, false, true);
    }
    
    //_________________________________________________________________________//
    public function loadApplicationJavascript()
    {        
        $this->JAVASCRIPT($this->app_js_controller, false, true); 
    }

    //_________________________________________________________________________//
    /**
     * Returns an array(app_name, data_type, public_method) for the Menus class
     * so it knows the info about it
     * @return array
     */
    public function getMenuInfo()
    {
        $answer['app_name'] = $this->app_name;
        $answer['data_type'] = $this->data_type;
        if ($this->app_description)
            $answer['app_description'] = $this->app_description;
        /* 		$answer['field_id'] =
          $answer['field_category_id'] = */
        $answer['public_methods'] = $this->public_methods;
        return $answer;
    }    
    /**
     * Returns a JSON encoded of array(app_name, data_type, public_method) for
     * the menus
     * @return string
     */
    public function ajaxGetMenuInfo()
    {
        return ajax_reply(200, $this->getMenuInfo());
    }

    /**
     * Edit Config
     * @global \SCHLIX\cmsConfigRegistry $SystemConfig
     * @param string $override_app_name
     * @param string $override_template_file
     */ 

    public function editConfig($override_app_name = '', $override_template_file = '') {
        global $SystemConfig;
        global $SystemConfig;
        
        $this->setPageTitle(___('Configuration'));
        ob_start();
        $config_file =   $override_template_file ? $override_template_file : 'config';
        // 2019 July
        $app_name = $override_app_name ? $override_app_name : $this->app->getFullApplicationName();
        
        $config = $SystemConfig->get($app_name);
        $config = cmsHooks::execute(__FUNCTION__, $this, $config); // add more
        
        $local_variables = ['__app__' => $this, 'view' => 'config', 'config' => $config];
        
        $filename = $this->findTemplateScriptFile($config_file.'.template.php', self::class, false);
                    
        include ($filename);
        $config_html = ob_get_contents();
        ob_end_clean();
        
        $filled_config = skin_html($config_html,$local_variables, ['x-ui','schlix-config']);
        
        echo $filled_config;
    }

    /**
     * Internal helper to add hook to function array
     * @param array $array
     * @param object $object
     * @param string $function_name
     * @return bool
     */
    protected function __addHookToFunctionArray(&$array, $object, $function_name) {
        if (method_exists($object, $function_name))
        {
            $array[] = array('object' => $object, 'function' => $function_name);
            return true;
        }
        return false;
    }

    /**
     * Add hook to before save config.
     * Parameters: array $datavalues
     * Return: array $datavalues
     * @param object $object
     * @param string $function_name
     * @return bool
     */
    public function addBeforeSaveConfigFunctionHook($object, $function_name) {
        return $this->__addHookToFunctionArray($this->_before_save_config_functions, $object, $function_name);
    }

    /**
     * Add hook to validate before save config.
     * Parameters: array $datavalues
     * Return: array $error_list
     * @param object $object
     * @param string $function_name
     * @return bool
     */
    public function addBeforeSaveConfigValidationHook($object, $function_name) {
        return $this->__addHookToFunctionArray($this->_more_save_config_validations, $object, $function_name);
    }

    /**
     * Add hook to after save config.
     * Parameters: array $datavalues, array $original_datavalues, array $previous_config, array $retval
     * @param object $object
     * @param string $function_name
     * @return bool
     */
    public function addAfterSaveConfigFunctionHook($object, $function_name) {
        return $this->__addHookToFunctionArray($this->_after_save_config_functions, $object, $function_name);
    }

    /**
     * Modify data before save config
     * @param array $datavalues
     * @return array
     */
    public function onModifyDataBeforeSaveConfig($datavalues) {
        return $datavalues;
    }

    /**
     * After save config.
     * @param array $datavalues
     * @param array $original_datavalues
     * @param array $previous_config
     * @param array $retval
     */
    public function onAfterSaveConfig($datavalues, $original_datavalues, $previous_config, $retval) {
    }


    /**
     * Validates config before saved
     * @param array $datavalues
     * @return array
     */
    public function getSaveConfigValidationErrorList($datavalues)
    {
        
        $post_keys = array_keys($datavalues); 
        $error_list = [];
        if (!is_valid_csrf()) {
            $error_list[] = ___('Invalid CSRF Verification. Please refresh this page');
        }
        foreach ($post_keys as $post_key)
        {
            if (str_starts_with($post_key,'str_') && strlen(utf8_decode($datavalues[$post_key])) > 65535)
            {
                $error_list[] = sprintf(___('Invalid config value %s - total bytes must be less than 65535 bytes'), $post_key);
            }
            
        }
        $hook_errors = cmsHooks::executeModifyReturn(2, __FUNCTION__, $this, $datavalues) ;
        return ___c($hook_errors) > 0 ? array_merge($error_list, $hook_errors) : $error_list;
        
    }
    
    /**

    /**
     * Save Configuration. You can override the app name if required
     * @global \SCHLIX\cmsConfigRegistry $SystemConfig
     * @global \App\Users $CurrentUser
     * @param string $override_app_name
     * @return array
     */
    public function saveConfig($override_app_name = '')
    {
        global $SystemConfig, $CurrentUser;
        $retval = [];
        
        $original_datavalues = $datavalues = $_POST;
        
        $datavalues = cmsHooks::executeModifyReturn(2, __FUNCTION__, $this, $datavalues) ;
        $datavalues = $this->onModifyDataBeforeSaveConfig($datavalues);
        if ($this->_before_save_config_functions)
            foreach ($this->_before_save_config_functions as $objfunc)
                if (method_exists($objfunc['object'], $objfunc['function']))
                    $datavalues = $objfunc['object']->{$objfunc['function']}($datavalues);
        $error_list = $this->getSaveConfigValidationErrorList($datavalues);
        $app_name = $override_app_name ? $override_app_name : $this->app->getFullApplicationName();
        if (empty($error_list)) {
            $post_keys = array_keys($datavalues); 
            $validated_config_key = [];
            
            foreach ($post_keys as $post_key)
            {
                if (str_starts_with($post_key,'str_') || str_starts_with($post_key,'bool_') ||
                    str_starts_with($post_key,'double_') || str_starts_with($post_key,'float_') ||
                    str_starts_with($post_key,'array_') || str_starts_with($post_key,'int_') ||
                    str_starts_with($post_key,'array_') )
                {

                    $validated_config_key[$post_key] = str_starts_with($post_key,'array_') ? $datavalues[$post_key] : strval($datavalues[$post_key]);
                }
            }
            $new_config_keys = array_keys  ($validated_config_key);
            
            foreach ($new_config_keys as $key)
            {
                if (str_starts_with($key,'int_'))
                {
                    $validated_config_key[$key] = (int) $validated_config_key[$key];
                } else if (str_starts_with($key,'bool_'))
                {
                    $validated_config_key[$key] = (bool) $validated_config_key[$key];
                }
                else if (str_starts_with($key,'double_'))
                {
                    $validated_config_key[$key] = (float) $validated_config_key[$key]; // float is an alias of double in PHP
                }
                else if (str_starts_with($key,'float_'))
                {
                    $validated_config_key[$key] = (float) $validated_config_key[$key];
                }
                switch ($key)
                {
                    case 'str_alias': $corrected_alias = $this->setMyApplicationAlias($validated_config_key[$key]);
                        $_POST[$key] = $validated_config_key[$key] = $corrected_alias;
                        break;
                    case 'str_app_description' :
                        //2021-Jan-30 - remove ??
                        $this->setMyApplicationDescriptionAlias($validated_config_key[$key]);
                        break;
                }
                $SystemConfig->set($app_name, $key, $validated_config_key[$key]);
            }
            
            $retval['status'] = SAVE_OK;
            /*$CurrentUser->recordCurrentUserActivity("Modified configuration for {$app_name}");
            if (method_exists($this, 'forceRefreshMenuLinks'))                
                $this->forceRefreshMenuLinks();*/
            
        } else
        {
            $retval['status'] = SAVE_INVALID_DATA;
            $retval['errors'] = $error_list;
            $retval['override'] = $override_app_name;
            return $retval;
        }

        if ($this->_more_save_config_validations) {
            foreach ($this->_more_save_config_validations as $objfunc) {
                if (method_exists($objfunc['object'], $objfunc['function'])) {
                    $more_error_list = $objfunc['object']->{$objfunc['function']}($datavalues);
                    if (!empty($more_error_list)) {
                        $retval['status'] = SAVE_INVALID_DATA;
                        $retval['errors'] = $more_error_list;
                        $retval['override'] = $override_app_name;
                        return $retval;
                    }
                }
            }
        }
        /*  duplicated lines
         $app_name = $override_app_name ? $override_app_name : $this->app->getFullApplicationName();
        $post_keys = array_keys($datavalues); 
        $validated_config_key = [];
        $previous_config = $SystemConfig->get($app_name);

        foreach ($post_keys as $post_key)
        {
            if (str_starts_with($post_key,'str_') || str_starts_with($post_key,'bool_') ||
                str_starts_with($post_key,'double_') || str_starts_with($post_key,'float_') ||
                str_starts_with($post_key,'array_') || str_starts_with($post_key,'int_') ||
                str_starts_with($post_key,'array_') )
            {

                $validated_config_key[$post_key] = str_starts_with($post_key,'array_') ? $datavalues[$post_key] : strval($datavalues[$post_key]);
            }
        }
        $new_config_keys = array_keys  ($validated_config_key);

        foreach ($new_config_keys as $key)
        {
            if (str_starts_with($key,'int_'))
            {
                $validated_config_key[$key] = (int) $validated_config_key[$key];
            } else if (str_starts_with($key,'bool_'))
            {
                $validated_config_key[$key] = (bool) $validated_config_key[$key];
            }
            else if (str_starts_with($key,'double_'))
            {
                $validated_config_key[$key] = (float) $validated_config_key[$key]; // float is an alias of double in PHP
            }
            else if (str_starts_with($key,'float_'))
            {
                $validated_config_key[$key] = (float) $validated_config_key[$key];
            }
            switch ($key)
            {
                case 'str_alias': $corrected_alias = $this->setMyApplicationAlias($validated_config_key[$key]);
                    $_POST[$key] = $corrected_alias;
                    break;
                case 'str_app_description' : $this->setMyApplicationDescriptionAlias($validated_config_key[$key]);
                    break;
            }
            $SystemConfig->set($app_name, $key, $validated_config_key[$key]);
        }
        */
        $previous_config = $SystemConfig->get($app_name);
        $retval['status'] = SAVE_OK;
        $this->onAfterSaveConfig($datavalues, $original_datavalues, $previous_config, $retval);
        if ($this->_after_save_config_functions)
            foreach ($this->_after_save_config_functions as $objfunc)
                if (method_exists($objfunc['object'], $objfunc['function']))
                    $objfunc['object']->{$objfunc['function']}($datavalues, $original_datavalues, $previous_config, $retval);
        $CurrentUser->recordCurrentUserActivity("Modified configuration for {$app_name}");
        if (method_exists($this, 'forceRefreshMenuLinks'))
            $this->forceRefreshMenuLinks();
        
        return $retval;
    }
    
    public function checkForUpgrade()
    {
        if (!empty($this->app_version))
        {
            $current_app_version = $this->app->getConfig('str_app_version');
            if (strval($current_app_version) !== strval($this->app_version))
            {
                $this->recordLog("Trying to upgrade {$this->app_name} from v{$current_app_version} to v{$this->app_version}");
                $this->RunUpgradeScript();
                $this->app->setConfig('str_app_version', $current_app_version);
                        
            }
        }
    }

    /**
     * View the main admin page of this app
     */
    public function viewMainPage()
    {

        $this->checkForUpgrade();
        $this->setPageTitle('Main');
        $main_template_name = 'view.main.admin'; // empty($this->schlix_subclass) ? 'view.main.admin' : "view.{$this->schlix_subclass}.main.admin";
        $app_name_only = $this->app->getApplicationNameOnly();
        
        $local_variables = compact(array_keys(get_defined_vars()));
        if (!$this->loadTemplateFile($main_template_name, $local_variables, true))
        {
            echo ___('Cannot find the main admin template ').$main_template_name;
        }
    }
    
    /**
     * Display save error. $retval is the return array from saveItem operation
     * @param array $retval
     * @return type
     */
    public function getLastConfigSaveResult() {

        $retval = $this->lastConfigSaveResult;
        return $retval;
    }

    
    /**
     * Display save error. $retval is the return array from saveItem operation
     * @deprecated since version 2.2.6-5
     * @param array $retval
     * @return type
     */
    public function displayLastConfigSaveResult() {
        
        $retval = $this->lastConfigSaveResult;
        if ($retval != NULL && $retval['status'] != SAVE_OK) {

            ob_start();
            $this->viewErrorMessage($retval['errors']);
            $config_html = ob_get_contents();
            ob_end_clean();
            echo "<![CDATA[\n".$config_html."]]>";
        }
    }

    /**
     * Display save error. $retval is the return array from saveItem operation
     * @param array $retval
     * @return type
     */
    public function displayLastSaveResult()
    {
        $retval = $this->lastSaveResult;
        if ($retval != NULL && $retval['status'] != SAVE_OK)
        {
            $this->viewErrorMessage($retval['errors']);
            return;
        }
        
    }
    //_________________________________________________________________________//
    /**
     * Run installation script.
     * @param bool $sample_data
     */
    public function RunInstallScript($sample_data = false)
    {
        $install_sql_script = SCHLIX_SITE_PATH . '/apps/' . $this->app_name . '/install.sql';
        if (file_exists($install_sql_script)) {
            restore_mysql_backup_from_file($install_sql_script);
        }
        if ($sample_data)
        {
            $sample_data_script = SCHLIX_SITE_PATH . '/apps/' . $this->app_name . '/sample_data.sql';
            
            if (file_exists($sample_data_script)) {            
                
                restore_mysql_backup_from_file($sample_data_script);
            }
            
        }
    }

    /**
     * Run upgrade script (you can override this)
     */
    public function RunUpgradeScript()
    {
        $install_sql_script = SCHLIX_SITE_PATH . '/apps/' . $this->app_name . '/upgrade.sql';
        if (file_exists($install_sql_script)) {
            restore_mysql_backup_from_file($install_sql_script);
        }
    }

    
    //_________________________________________________________________________//
    /**
     * Run uninstall script
     * @param bool $uninstall_db
     * @param bool $uninstall_everything
     * @return boolean
     */
    public function RunUninstallScript($uninstall_db, $uninstall_everything)
    {
        if ($uninstall_db) {
            $uninstall_sql_script = SCHLIX_SITE_PATH . '/apps/' . $this->app_name . '/uninstall.sql';
            if (file_exists($uninstall_sql_script))
                restore_mysql_backup_from_file($uninstall_sql_script);
        }
        if ($uninstall_everything) {
            // TODO: delete all files in this folder. Not very important at this stage
        }
        return true;
    }
   
    /**
     * Run AJAX command. The alpha-numeric action parameter will be evaluated as the function name if it exists.
     * The method name must start with either ajxg_ for get methods only or ajxp_ if it handles postback and get.
     * The called method is responsible for sanitizing its own POST and GET variables, including ensuring that
     * CSRF is checked prior to run
     * @return array
     */
    public function RunAjax()
    {
        if (!is_ajax_request())
            return RETURN_FULLPAGE;
        else
        {            
            $prefix = 'ajx';
            $h = is_postback() ? 'p' : 'g';
            $s_command=  sanitize_action_command(fget_alphanumeric('action'));
            $func = $prefix.$h.'_'. $s_command;
            if (method_exists($this, $func))
            {
                $result = call_user_func([$this, $func]);
                return ajax_echo($result);
            } else 
            {
                return ajax_echo (ajax_reply_invalid_method($s_command));
            }
            
        }        
    }

    //_________________________________________________________________________//
    public function Run()
    {
        $this->CheckIfCurrentUserAllowedAccess();
        switch (fget_alphanumeric('action'))
        {
            case 'getmenuinfo': 
                return ajax_echo($this->ajaxGetMenuInfo());
                break;
            case 'editconfig': 
                $this->lastConfigSaveResult = NULL;
                $this->editConfig();
                return RETURN_FULLPAGE;
                break;
            case 'saveconfig': 
                $this->lastConfigSaveResult = $this->saveConfig();
                if ($this->lastConfigSaveResult['status'] == SAVE_OK)
                    $this->returnToMainAdminApplication();
                else
                {
                    $this->editConfig();
                    return RETURN_FULLPAGE;
                }
                break;
            case 'help':
                $this->viewHelp();
                return RETURN_FULLPAGE;
                break;
            case 'helpabout':
                $this->viewHelpAbout();
                return RETURN_FULLPAGE;
                break;            
            default:
                if (is_ajax_request())
                {
                    $this->RunAjax ();
                    return RETURN_AS_AJAX;
                }
                else 
                
                    $this->viewMainPage();
                return RETURN_FULLPAGE;
                break;
        }
    }

    //_________________________________________________________________________//
    public function returnToMainAdminApplication()
    {
        $app_name = empty($this->schlix_subclass) ? $this->app_name : $this->app_name.'.'.$this->schlix_subclass;
        
        $this->doRedirect('app/'.$app_name);
    }

    public function returnToMainAdmin()
    {
        $this->doRedirect('');
    }
    
    public function doRedirect($admin_app_url)
    {
        $_SESSION['schlix_internal_redirect'] = 1;
        $url = SCHLIX_SITE_HTTPBASE . '/admin/' . $admin_app_url;
        ob_end_clean();
        ob_start();
        header("Location: {$url}");
        exit(); // must use, for db-based session with no lock
    }
    
    /**
     * Return application toolbar view as string
     * @return type
     */
    public function getSubApplicationHeaderAsString()
    {
        ob_start();
        $this->loadTemplateFile('view.main.admin.subapp-toolbar', null, false, true); 
        $html = ob_get_contents();

        ob_end_clean();
        
        return $html;
    }
        
    //_________________________________________________________________________//
    public function viewHelp()
    {
        $this->setPageTitle(___('Help'));

        if (!$this->loadTemplateFile('help', true))
            include ('view.help.skeleton.php');
    }
   
    public function viewHelpAbout()
    {
        
        $this->setPageTitle(___('About'));
        //$customizable_files = $this->getListOfCustomizableFiles();
        $local_variables = compact(array_keys(get_defined_vars()));
        $this->loadTemplateFile('view.help.about', $local_variables, true);
        

    }
    

}

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++//
abstract class cmsAdmin_List extends \SCHLIX\cmsAdmin_Basic implements interface_cmsAdmin_List
{

    protected $_fieldname_items;
    protected $table_items;
    protected $field_id;
    /**
     * The application
     * @var cmsApplication_list 
     */
    protected $app;
    protected $search_field = 'title'; // fieldname for search
    
    protected $ajaxfieldname_items;
    protected $ajaxfield_items;
    protected $default_item_options;
    /**
     * Updatable item field names
     * @var array
     */
    protected $updatable_fieldname_items;


    
    //_________________________________________________________________________//

    public function __construct($data_type = null, $public_methods = null)
    {
        parent::__construct($data_type, $public_methods);
        $this->table_items = $this->app->getItemTable();
        $this->_fieldname_items = $this->app->getItemFieldNames();
        $this->field_id = $this->app->getFieldID();
        $this->setItemFieldNamesForAjaxListing('id', 'status', 'title', 'virtual_filename', 'date_available', 'date_created', 'date_modified', 'sort_order');
        $this->setItemFieldNamesForAjaxUpdate('status','sort_order', 'date_available','date_expiry', 'is_main_image', 'featured');
        // Add item save hooks
        $this->app->addBeforeSaveItemFunctionHook($this, 'onModifyDataBeforeSaveItem');
        $this->app->addAfterSaveItemFunctionHook($this, 'onAfterSaveItem');
        $this->app->addBeforeSaveItemValidationHook($this, 'onGetAdminValidationErrorListBeforeSaveItem');        
        $this->default_item_options = $this->app->getDefaultItemMetaOptionKeys();
        
    }

    /**
     * Resets meta option keys for all items
     */
    protected function resetAllItemsMetaOptionKeys()
    {
        global $SystemDB;
        
        if ($this->app->itemColumnExists('options'))
        {
            $sanitized_item_opts = sanitize_string(@serialize($this->app->getDefaultItemMetaOptionKeys()));
            $SystemDB->query("UPDATE {$this->table_items} SET `options` = {$sanitized_item_opts} ");
        }
    }
    
    /**
     * Intersect fields
     * @param array $db_fields
     * @param array $array
     * @return array
     */
    protected function intersectFields($db_fields, $array)
    {

        if (___c($db_fields) > 0 && ___c($array) > 0)
            return array_values(array_intersect($db_fields, $array));
    }
    
    protected function setItemFieldNamesForAjaxUpdate(/** vars **/)
    {
        $array = (___c(func_get_arg(0)) > 0) ?  func_get_arg(0) : func_get_args();         
        $this->updatable_fieldname_items = $this->intersectFields($this->_fieldname_items, $array);
    }
    
    public function setItemFieldNamesForAjaxListing(/** vars **/)
    {
        $array = (___c(func_get_arg(0)) > 0) ?  func_get_arg(0) : func_get_args();         
        $this->ajaxfield_items = $this->intersectFields($this->_fieldname_items, $array);

    }
    //_________________________________________________________________________//

    public function getItemFieldNamesForAjaxListing()
    {
        return $this->ajaxfield_items;
    }
            
    //_________________________________________________________________________//	
    public function searchReplaceItems($field_name, $search, $replace, $case_sensitive = true)
    {
        global $SystemDB;

        $sanitized_field_name = alpha_numeric_with_dash_underscore($field_name); // yes, this could be buggy but you shouldn't use some weird characters for field names
        $sanitized_search = sanitize_string($search);
        $sanitized_replace = sanitize_string($replace);
        $sql = "UPDATE `{$this->table_items}` SET `{$sanitized_field_name}` = REPLACE(`{$sanitized_field_name}`, {$sanitized_search}, {$sanitized_replace});";
        $SystemDB->query($sql); //
    }

    //_________________________________________________________________________//
    public function getItemByID($id)
    {
        return $this->app->getItemByIDWithExtraData($id);
    }

    public function getItemByIDSingleObject($id)
    {
        return $this->app->getItemByID($id);
    }

    
    //_________________________________________________________________________//
    protected function setPreviewLinkForItemListingResult(array $items)
    {
        $field_id = $this->app->getFieldID();

        $item_count = ___c($items);
        if ($this->app->itemColumnExists('virtual_filename')) {
            for ($i = 0; $i < $item_count; $i++)
            {
                $oid = $items[$i][$field_id];
                $items[$i]['preview_link'] = $this->app->createFriendlyURL("action=viewitem&id={$oid}");
                $items[$i]['edit_link'] = $this->createFriendlyAdminURL("action=edititem&id={$oid}");
            }
        }
        return $items;
    }

    //_________________________________________________________________________//
    public function ajaxSearchObjects($keyword = '', $start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC')
    {
        $keyword = strtolower($keyword);
        $cleankeyword = sanitize_string("%{$keyword}%");
        $criteria = "LOWER({$this->search_field}) LIKE {$cleankeyword}";
        $item_searchresult = $category_searchresult = [];
        $normalized_item_fields = implode(',', quote_array_of_field_names_for_query($this->getItemFieldNamesForAjaxListing()));

        $total_item_count = $this->app->getTotalItemCount($criteria);
        $items_per_page = min(HARDCODE_MAX_ROWLIMIT, $end - $start);
        $item_searchresult = $this->app->getAllItems($normalized_item_fields, $criteria, $start, $end, $sortby, $sortdirection, true, false);
        $item_searchresult = $this->modifyAjaxSearchObjectsResult($keyword, $item_searchresult);

        return ajax_datasource_reply(200, $item_searchresult, $start, $end, $items_per_page, $total_item_count, $sortby, $sortdirection);
    }

    /**
     * Override search result
     * @param string $keyword
     * @param array $result
     * @return array
     */
    public function modifyAjaxSearchObjectsResult($keyword, $result)
    {
        return $result;
    }
    
    //_________________________________________________________________________//
    public function ajaxSaveItem($id)
    {
        $retval = $this->saveItem($id);
        if ($retval['status'] == SAVE_OK) {
            $answer = [
                'save_item_id' => $retval['id'], 
                'status' => $retval['status'], 
                'errors' => isset($retval['errors']) ? $retval['errors'] : null
                    ];
            return ajax_reply(200, $answer);
        }
        else {
            clear_schlix_alert();
            $error_txt = implode("\n", $retval['errors']);
            return ajax_reply(405, ___('Error while saving').': '.$error_txt);
        }
    }

    //_________________________________________________________________________//
    public function ajaxCopyObjects($mixed_items_to_copy, $destination = '')
    { // mixed item =  items
        global $SystemDB;

        if (!is_valid_csrf()) {
            return ajax_reply(400, ___('Invalid CSRF Verification Code'));
        }
        $mixed_items_array = explode(',', $mixed_items_to_copy);
        foreach ($mixed_items_array as $mixed_item)
        {
            $current_id = substr($mixed_item, 1); // 11 is the next string after
            $source_itemnumbers[] = $current_id;
        } // end foreach
        foreach ($source_itemnumbers as $source_item_id)
        {
            $item = $this->app->getItemByIDSingleObject($source_item_id);
            unset($item['id']);
            $item['title'].= '_copy';
            if (array_key_exists('guid', $item))
                $item['guid'] = new_uuid_v4();
            
            $SystemDB->simpleInsertInto($this->table_items, $item);            
        }
        return ajax_reply(200, ___c($source_itemnumbers));
    }

    //_________________________________________________________________________//

    public function ajaxGetAllItems($start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC')
    {
        global $SystemDB;

        if ((int) $start > (int) $end)
            return ajax_reply(400, 'Invalid Request');
        //$sortby = $SystemDB->escapeString($sortby);
        $sortby = $this->table_items->fieldExists($sortby) ? $sortby : $this->table_items->getPrimaryKeyFieldNamesAsArray()[0];
        $items_per_page = min(HARDCODE_MAX_ROWLIMIT, $end - $start);
        $fields = implode(',', quote_array_of_field_names_for_query($this->getItemFieldNamesForAjaxListing()));
        $total_item_count = $this->app->getTotalItemCount();
        $result_array_files = $this->app->getAllItems($fields, '', $start, $end, $sortby, $sortdirection, false);
        $result_array_files = $this->modifyAjaxGetAllItemsResult($result_array_files);
        return ajax_datasource_reply(200, $result_array_files, $start, $end, $items_per_page, $total_item_count, $sortby, $sortdirection);
    }

    public function modifyAjaxGetAllItemsResult($result)
    {
        return $result;
    }
    /**
     * Set additional variables for item editing before it's displayed
     * @param array $local_variables
     * @return array
     */
    protected function setAdditionalVariablesForEditItem($local_variables)            
    {
        return $local_variables;
    }
    
    /**
     * Edit item. Returns an array ['id' => id, 'errors' => list of errors]
     * @global \App\Users $CurrentUser
     * @param array $id
     */
    public function editItem($id)
    {
        global $CurrentUser;

        $hasWritePermission = true;
        $id = ($id == 'new') ? 'new' : intval($id);
        if ($id == 'new') {
            $this->setPageTitle(___('New Item'));
            $item['id'] = 'new';
                $item['date_created'] = get_current_datetime();
            $item['date_available'] = $item['date_created'];
            $item['date_modified'] = $item['date_created'];
        }
        else {
            $item = $this->app->getItemByIDWithExtraData($id);
            $this->setPageTitle(___('Edit Item').' #'.___h($id));
        }

        if ($id == 'new' || $item) {
            
            

            if ($item['id'] != 'new' && $this->app->itemColumnExists('permission_write')) {

                //$hasWritePermission = $CurrentUser->hasWritePermission($item['permission_write']);
                //if (!$hasWritePermission) echo H3(___('You do not have a write access to this'));
            }
            // Restore POST keys if there's any post errors
            if (is_postback() && $this->lastSaveResult != NULL && $this->lastSaveResult['status'] != SAVE_OK)
                foreach ($item as $key => $value)
                    if (array_key_exists($key, $_POST))
                        $item[$key] = is_string($_POST[$key]) ? trim($_POST[$key]) : $_POST[$key];
            
            $local_variables = compact(array_keys(get_defined_vars()));            
            
            $local_variables['__app__'] = $this;
            $local_variables['view'] = 'item';
            $local_variables = $this->setAdditionalVariablesForEditItem($local_variables);
            unset($local_variables['CurrentUser']);
            
            $edit_template_name = 'edit.item'; //  empty($this->schlix_subclass) ? 'edit.item' : "edit.{$this->schlix_subclass}.item";
            if (!$this->loadTemplateFile($edit_template_name, $local_variables, true))
            {                
                $this->viewErrorMessage(___('Cannot find the editor template for ').$this->app_name);
            }
        }
        else $this->viewErrorMessage(___('Item does not exist'));
            //echo \__HTML::H3(___('Item does not exist'));
    }
    
    protected function viewErrorMessage($message)
    {
        $errors = [];
        if (is_string($message))
            $errors[] = $message;
        else if (___c($message) > 0)
            $errors = $message;
        $local_variables = compact(array_keys(get_defined_vars()));
        if (!$this->loadTemplateFile('view.inline.error', $local_variables, true))
        {
            foreach ($errors as $error)
            {
                echo $error.\__HTML::BR();
            }
        }
        
    }

    //_________________________________________________________________________//

    public function duplicateItem($source_item_id, $destination_catnumber)
    {
        global $SystemDB;

        $item = $this->app->getItemByID($source_item_id);
        unset($item['id']);
        $item['title'].= '_copy';
        if ($this->app->itemColumnExists('guid'))
            $item['guid'] = new_uuid_v4();
        if ($this->app->itemColumnExists('virtual_filename'))
            $item['virtual_filename'] = $this->app->preventDuplicateValueInItemTable('virtual_filename', $item['virtual_filename'], 0);
        $SystemDB->simpleInsertInto($this->table_items, $item);            
        
    }

    //_________________________________________________________________________//
    public function checkIfThisItemInTheMenu($id)
    {
        global $SystemDB;

        $id = (int) $id;
        $app_name = sanitize_string($this->app_name);
        $sql = "SELECT * FROM gk_menu_items WHERE application = {$app_name} AND menuitem = 'i{$id}'";
        $item = $SystemDB->getQueryResultSingleRow($sql, false);
        return ($item != null);
    }
            
    /**
     * Validates $datavalues before saved and returns an error list if any,
     * otherwise return an empty array
     * @param array $datavalues
     */
    public function onGetAdminValidationErrorListBeforeSaveItem($datavalues)
    {
        return NULL;
    }
     /**
     * Save item hook that you can override. Must return array of modified
     * or unmodified $datavalues
     * @param array $datavalues
     * @return array
     */
    public function onModifyDataBeforeSaveItem($datavalues)
    {
        // workaround checkbox bug
        if (in_array('status', $this->app->getItemFieldNames()) && !array_key_exists('status', $datavalues))
            $datavalues['status'] = fpost_int('status');
        
        return $datavalues;
    }  
    /**
     * Save item hook that you can override. Must return array of modified
     * or unmodified $datavalues
     * @param array $datavalues
     * @param array $retval
     * @return array
     */
    public function onAfterSaveItem($datavalues, $original_datavalues, $previous_item, $retval)
    {
        $id = (int) $retval['id'];
        if ($id > 0)
        {
            $this->recordCurrentUserSaveItem($id);
            if ($this->checkIfThisItemInTheMenu($id))
                $this->forceRefreshMenuLinks();
        }
        return $retval;
    }
    /**
     * Saves Item
     * @global \App\Users $CurrentUser
     * @param int|string $id
     * @return boolean
     */
    public function saveItem($id)
    {
        check_csrf_halt_on_error();
        
        $retval = $this->app->saveItem($id);
        
        return $retval;
    }

    //_________________________________________________________________________//
    protected function recordCurrentUserSaveItem($id)
    {
        global $CurrentUser;

        $extra_info = '';
        if ($this->app->itemColumnExists('title')) {
            $item = $this->app->getItemByID($id);
            $extra_info = " with title '{$item['title']}'";
        }
        $CurrentUser->recordCurrentUserActivity("Saved item #{$id} for {$this->app_name} {$extra_info}");
    }

    //_________________________________________________________________________//
    protected function forceRefreshMenuLinks()
    {
        $this->app->refreshApplicationAlias(false);
        $menuadm = new \App\Core_Menu_Admin();        
        $menuadm->refreshMenuLinks(); // prana - may 24, 2010
    }

    //_________________________________________________________________________//
    function ajaxDeleteObjects($mixed_items_to_delete)
    {
        check_csrf_halt_on_error(true);

        $this->app->delete($mixed_items_to_delete);
        return ajax_reply(200, 'OK');
    }

    //_________________________________________________________________________//
    public function Hide($str)
    {
        
    }

    //_________________________________________________________________________//
    public function sortAll()
    {
        
    }

    //_________________________________________________________________________//    
    /*
     * returns TRUE if valid or error message if invalid
     */

    protected function validateUpdateItemField($id, $field, $value)
    {
        // don't allow it
        if (!empty ($value))
        {
            if (str_contains($value,'>') || 
                str_contains($value,'<') || 
                str_contains($value,'"'))
                    return ___('Only simple field values are allowed for AJAX field update');
        }        
        if ((int) $id > 0)
        {
            $item = $this->table_items->q()->select('*')->where(["{$this->field_id} = :id"])->getQueryResultArray(['id' => $id]);
            if ($item == null)
                return ('Existing item could not be found');
        }
        if (!in_array($field, $this->updatable_fieldname_items))
                return sprintf(___('Item field %s cannot be updated since it is not in the allowable list'), $field);
        if (empty($field))
            return ___('Field is empty');
        if (!$this->table_items->fieldExists($field))
            return ___('Field does not exist');
        
        return true;
    }

    //_________________________________________________________________________//
    /**
     * Ajax update a single item field with a specified ID.
     * @return array
     */
    public function ajaxUpdateField()
    {
        global $CurrentUser;
        
        check_csrf_halt_on_error(true);
        $thefield = fpost_string('field', 255);
        $thefield = alpha_numeric_with_dash_underscore($thefield);
    
        if (empty($thefield))
            return ajax_reply(401,'Field is empty');
        $value = fpost_string('value');
        $record_id = fpost_alphanumeric('id');
        $record_id_numtxt = substr($record_id, 1, strlen($record_id) - 1);
        $record_id_num = intval($record_id_numtxt);

        /*if (strpos($thefield, 'date_') !== false) {
            // This is incorrect and bad - while it's okay in the CMS itself, this should be fixed
            // pending change to mysqli from mysql. Flag: TODO
            $value = sanitize_string(date('Y-m-d H:i:s', strtotime(fpost_string('value'))));
        }*/
        $thecolumn = $this->field_id;
        $error_msg = $this->validateUpdateItemField(($record_id_numtxt == "new") ? "new" : $record_id_num, $thefield, fpost_string('value'));
        if ($error_msg === true) {
            $app_name =  $this->app->getFullApplicationAlias();
            $datavalues = [$thefield => $value];
            if ($record_id == "new")
            {
                if ($this->table_items->fieldExists('date_created'))
                {
                    $datavalues['date_created'] = get_current_datetime();                    
                }
                if ($this->table_items->fieldExists('guid'))
                {
                    $datavalues['guid'] = new_uuid_v4();
                }
                $this->table_items->quickInsert($datavalues);
                $CurrentUser->recordCurrentUserActivity("Inserted {$app_name} {$thecolumn}# {$record_id_num}");
            }
            else
            {
                if ($this->table_items->fieldExists('date_created'))
                {
                    $datavalues['date_modified'] = get_current_datetime();                    
                }                
                $this->table_items->quickUpdate($datavalues, "{$thecolumn} = {$record_id_num}" );
                $CurrentUser->recordCurrentUserActivity("Updated {$app_name} {$thecolumn}# {$record_id_num}");
            }                
            return ajax_reply(200, 'OK');
        } else {
            return ajax_reply(401, $error_msg);
        }
    }

    //_________________________________________________________________________//
    /**
     * Restore an item to an older version
     * @param int $id
     * @param double $version
     * @return type
     */
    public function ajaxRestoreItem($id, $version)
    {
        $id = (int) $id;
        $version = doubleval($version);

        check_csrf_halt_on_error(true);
        $archiving_result = $this->app->restoreItem($id, $version);

        if ($archiving_result)
            return ajax_reply(200, 'OK');
        else
            return ajax_reply(201, 'Restore Failed for item ID#'.$id.' and version '.$version);
    }
    /**
     * You can customize the response schema field here
     * @param array $response_schema
     * @return array
     */
    public function modifyCategoryResponseSchemaFields(array $response_schema)
    {
        return $response_schema;
    }    
    /**
     * You can customize the response schema field here
     * @param array $response_schema
     * @return array
     */
    public function modifyItemResponseSchemaFields(array $response_schema)
    {
        return $response_schema;
    }
    /**
     * Ajax reply of all data response schema from all table
     */
    public function ajaxGetAllDataResponseSchema()
    {
        $result = [];
        $result['item'] = $this->getItemsResponseSchema();
        return ajax_reply(200, $result);
    }
    
    /**
     * Returns a key/value for parser of table definition
     * @param array $table_fields
     * @param array $listing_fields
     * @return array
     */
    protected function getParserFromTableListingFields($table_fields, $listing_fields)
    {
        $result_fields = [];
        // get the key found in table definition
        if ($table_fields)        
        foreach ($table_fields as $table_field)
        {
            $field_name= $table_field['Field'];
            if (in_array($field_name, $listing_fields))
            {
                $field_parser = 'string';
                $field_type = $table_field['Type'];
                if (str_contains($field_type,'int') || str_contains($field_type,'decimal') || str_contains($field_type,'float'))
                        $field_parser = 'number';
                elseif (str_starts_with($field_type,'date') || str_starts_with($field_type,'timestamp'))
                        $field_parser = 'date';
                $result_fields[] = array('key' => $field_name, 'parser' => $field_parser);
                $key_tobe_deleted =  array_search($field_name, $listing_fields);
                unset($listing_fields[$key_tobe_deleted]);
            }
        }
        // is there a remainaing unspecified key? If so, then just declare as string
        if (___c($listing_fields) > 0)
        {
            foreach ($listing_fields as $listing_field)
            {
                $result_fields[] = array('key' => $listing_field, 'parser' => 'string');
            }
        }
        return $result_fields;
    }
    
   
    //________________________________________________________________________//
    /**
     * Returns the data response Schema for ajax Listing
     */
    /**
     * Returns a response schema from a table for datatable listing
     * @param string $tablename
     * @param array $restrict_listing_fields
     * @param string $fn_modifier
     * @return array
     */
   public function getDataTableResponseSchemaFromTable($tablename, $restrict_listing_fields, $fn_modifier)
    {
       $table = new \SCHLIX\cmsSQLTable($tablename);
       
        //$listing_fields = $this->getItemFieldNamesForAjaxListing();
        $table_fields = $table->getFields(); // $this->app->getItemTable()->getFields();
        $pks = $table->getPrimaryKeyFieldNames();
        
        $result_fields = $this->getParserFromTableListingFields($table_fields, $restrict_listing_fields);
        
        if (method_exists($this, $fn_modifier))
            $result_fields = call_user_func([$this, $fn_modifier], $result_fields); // $this->modifyItemResponseSchemaFields($result_fields);
        $response_result = array (
            'primary_key' => $pks[0], // $this->app->getFieldID(),
            'resultsList' => "data",
            'fields' => $result_fields,
            'metaFields' => array(
                  'totalRecords' =>  "totalRecords",
                  'recordsReturned' => "recordsReturned",
                  //'paginationRecordOffset' => "start",
                  'paginationRowsPerPage' => "itemsperpage",
                  'sortby' => "sortby",
                  'sortdirection' => "sortdirection",
                'start'=> "start",
                'end'=> "end"
                
                  )

        );
        return $response_result;
    }        
    //________________________________________________________________________//
    /**
     * Returns the data response Schema for ajax Listing
     */
   public function getItemsResponseSchema()
    {
       return $this->getDataTableResponseSchemaFromTable($this->app->getItemTableName(), $this->getItemFieldNamesForAjaxListing(), 'modifyItemResponseSchemaFields');      
    }        
    //________________________________________________________________________//
    /**
     * Returns the data response Schema for ajax Listing
    OLD - deprecated
   public function getItemsResponseSchema()
    {
        $listing_fields = $this->getItemFieldNamesForAjaxListing();
        $table_fields = $this->app->getItemTable()->getFields();
        $result_fields = $this->getParserFromTableListingFields($table_fields, $listing_fields);
        $result_fields = $this->modifyItemResponseSchemaFields($result_fields);
        $response_result = array (
            'primary_key' => $this->app->getFieldID(),
            'resultsList' => "data",
            'fields' => $result_fields,
            'metaFields' => array(
                  'totalRecords' =>  "totalRecords",
                  'recordsReturned' => "recordsReturned",
                  //'paginationRecordOffset' => "start",
                  'paginationRowsPerPage' => "itemsperpage",
                  'sortby' => "sortby",
                  'sortdirection' => "sortdirection",
                'start'=> "start",
                'end'=> "end"
                
                  )

        );
        return $response_result;
    }     */
    //________________________________________________________________________//
    /**
     * Save Configuration. You can override the app name if required
     * @global \SCHLIX\cmsConfigRegistry $SystemConfig
     * @global \App\Users $CurrentUser
     * @param string $override_app_name
     * @return array
     */
    public function saveConfig($override_app_name = '')
    {
        $result = parent::saveConfig($override_app_name);
        if ($result && ($result['status'] == SAVE_OK))
        {
            $reset_item_options = fpost_string('reset_item_options');
            if ($reset_item_options )
            {
                $app = null;
                if ($override_app_name)
                {
                    $the_app_name = '\\App\\'.$override_app_name;
                    $app = new $the_app_name();
                } else $app = $this;
                $app->resetAllItemsMetaOptionKeys();
            }
        }
        return $result; 
    }
    
    //________________________________________________________________________//
    /**
     * Runs admin command
     * @return boolean
     */
    public function Run()
    {
        switch (fget_alphanumeric('action'))
        {
            case 'newitem': 
                $this->lastSaveResult = NULL;
                $this->editItem('new');
                return RETURN_FULLPAGE;
                break;
            case 'edititem':
                $this->lastSaveResult = NULL;
                $this->editItem(fget_alphanumeric('id'));
                return RETURN_FULLPAGE;
                break;
            case 'ajaxsaveitem':
                return ajax_echo($this->ajaxSaveItem(fpost_alphanumeric('id')));                
                break;
            case 'delete': 
                return ajax_echo($this->ajaxDeleteObjects(fpost_string('items',255)));
                break;
            case 'updatefield': 
                return ajax_echo($this->ajaxUpdateField());
                break;
            case 'hide': 
                return ajax_echo($this->Hide(fpost_string('items')));
                break;
            case 'sort':
                return ajax_echo($this->sortAll());
                break;
            case 'restoreitem': 
                return ajax_echo($this->ajaxRestoreItem(fpost_alphanumeric('id'), fpost_double('version')));
                break;
            case 'saveitem': 

                $retval = $this->saveItem(fpost_alphanumeric($this->field_id));                
                $this->lastSaveResult = $retval;

                if ($this->lastSaveResult['status'] == SAVE_OK)
                    $this->returnToMainAdminApplication();
                else
                    $this->editItem(fpost_alphanumeric($this->field_id));
                return true;
                break;
            case 'getallitems': 
                return ajax_echo($this->ajaxGetAllItems(fget_int('start'), fget_int('end'), fget_string_noquotes_notags('sortby'), fget_string_noquotes_notags('sortdirection')));
                break;
            case 'search': 
                return ajax_echo($this->ajaxSearchObjects(fget_string('keyword',63), fget_int('start'), fget_int('end'), fget_string_noquotes_notags('sortby'), fget_string_noquotes_notags('sortdirection')));
                break;
            case 'copy': 
                return ajax_echo($this->ajaxCopyObjects(fpost_string('items'), fpost_string('destination')));
                break;
            case 'getdataresponseschemas' :

                return ajax_echo($this->ajaxGetAllDataResponseSchema());
                break;
            
            default: return parent::Run();
        }
    }

    //_________________________________________________________________________//
}

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
abstract class cmsAdmin_CategorizedList extends \SCHLIX\cmsAdmin_List implements interface_cmsAdmin_CategorizedList
{
    
    /**
     * The application
     * @var cmsApplication_CategorizedList
     */
     protected $app;
     /**
      * An array with the following key:
      * - nodeId => the name of the category field (e.g. cid)
      * - parentRef => the parent id fieldname (e.g. parent_id)
      * - translate => transform original fieldname into SCHLIX UI compatible field name
      * e.g. title is the one used as a label
      * @var array 
      */
     protected $tree_config;    
     /**
      * An array containing the list of category field names for ajax listing
      * @var array 
      */
     protected $ajaxfield_categories;
     
     /**
      * Category ID field
      * @var string 
      */
     protected $field_category_id;
     /**
      * Category field names
      * @var array 
      */
     protected $_fieldname_categories;
     /**
      * 
      * @var \SCHLIX\cmsSQLTable 
      */
     protected $table_categories;
    /**
     * Updatable category field names
     * @var array
     */
    protected $updatable_fieldname_categories;
    
    protected $default_category_options;
    
    protected $_ajax_treenode_prefix;
    

    protected $field_item_category_id = 'category_id';
     
    //_________________________________________________________________________//
    public function __construct( $data_type = null, $public_methods = null)
    {
        parent::__construct( $data_type, $public_methods);
        if (method_exists($this->app, 'getCategoryTableName')) { // June 15, 2013 - for backward compatibility
            $this->table_categories = $this->app->getCategoryTable();
            $this->_fieldname_categories = $this->app->getCategoryFieldNames();
            $this->field_category_id = $this->app->getFieldCategoryID();
            $this->default_category_options = $this->app->getDefaultCategoryMetaOptionKeys();        
        }
        $app_name = $this->app->getFullApplicationAlias();
        $this->_ajax_treenode_prefix = $app_name . SCHLIX_DEPRECATED_AJAX_TREENODEID_PREFIX;
        $field_cid = method_exists($this->app, 'getFieldCategoryID') ? $this->app->getFieldCategoryID() : 'cid';
        $this->setAjaxTreeViewConfig($field_cid, 'parent_id', 'title');
        $this->setCategoryFieldNamesForAjaxListing('cid', 'status', 'title', 'sort_order', 'virtual_filename', 'date_available', 'date_created', 'date_modified');
        $this->setCategoryFieldNamesForAjaxUpdate('status','sort_order', 'date_available','date_expiry');
        // Add item save hooks
        //if (is_a($this->app, '\\App\\cmsApplication_CategorizedList'))
        if (is_a($this->app, '\\SCHLIX\\cmsApplication_CategorizedList'))
        {
            $this->app->addBeforeSaveCategoryFunctionHook($this, 'onModifyDataBeforeSaveCategory');
            $this->app->addAfterSaveCategoryFunctionHook($this, 'onAfterSaveCategory');
            $this->app->addBeforeSaveCategoryValidationHook($this, 'onGetAdminValidationErrorListBeforeSaveCategory');
            $this->field_item_category_id = $this->app->getFieldItemCategoryID();
        }
        
    }

    /**
     * Set treeview config for AJAX listing
     * @param string $field_cid
     * @param string $field_parent_id
     * @param string $field_title
     */
    public function setAjaxTreeViewConfig($field_cid = 'cid', $field_parent_id = 'parent_id', $field_title = 'title')
    {
        $this->tree_config = [
          'nodeId' => $field_cid,  
          'parentRef' => $field_parent_id,
          'translate' => [ $field_title => 'label']
        ];
        
    }
    /**
     * Edit item. Returns an array ['id' => id, 'errors' => list of errors]
     * @global \App\Users $CurrentUser
     * @param array $id
     */
    public function editItem($id)
    {
        global $CurrentUser;

        $hasWritePermission = true;
        $id = ($id == 'new') ? 'new' : intval($id);
        if ($id == 'new') {
            $this->setPageTitle(___('New Item'));
            $item['id'] = 'new';
            $item['category_id'] = $this->getCurrentCategoryIDFromCookie();
            $item['date_created'] = get_current_datetime();
            $item['date_available'] = $item['date_created'];
            $item['date_modified'] = $item['date_created'];
        }
        else {
            $item = $this->app->getItemByIDWithExtraData($id);
            $this->setPageTitle(___('Edit Item').' #'.___h($id));
        }

        if ($id == 'new' || $item) {
            
            

            if ($item['id'] != 'new' && $this->app->itemColumnExists('permission_write')) {

                //$hasWritePermission = $CurrentUser->hasWritePermission($item['permission_write']);
                //if (!$hasWritePermission) echo H3(___('You do not have a write access to this'));
            }
            // Restore POST keys if there's any post errors
            if (is_postback() && $this->lastSaveResult != NULL && $this->lastSaveResult['status'] != SAVE_OK)
                foreach ($item as $key => $value)
                    if (array_key_exists($key, $_POST))
                        $item[$key] = is_string($_POST[$key]) ? trim($_POST[$key]) : $_POST[$key];
            
            $local_variables = compact(array_keys(get_defined_vars()));            
            
            $local_variables['__app__'] = $this;
            $local_variables['view'] = 'item';
            $local_variables = $this->setAdditionalVariablesForEditItem($local_variables);
            unset($local_variables['CurrentUser']);
            
            $edit_template_name = 'edit.item'; //  empty($this->schlix_subclass) ? 'edit.item' : "edit.{$this->schlix_subclass}.item";
            if (!$this->loadTemplateFile($edit_template_name, $local_variables, true))
            {
                echo ___('Cannot find the editor template for ').$this->app_name;
            }
        }
            else $this->viewErrorMessage('Item does not exist');
    }
    
    /**
     * Returns the default category parent ID from cookie for creating a new category
     * @return type
     */
    public function getDefaultCategoryParentIDFromCookie()
    {
        $name = str_replace( '.', '-', $this->app->getOriginalFullApplicationAlias());
        $cid = fcookie_int("{$name}_currentCategory");  
        $cat = $this->app->getCategoryByID($cid);
        return ($cid > 0) && $cat ? $cid : 0;
    }
    
    /**
     * Get current category ID from cookie (when navigated)
     * @return int
     */
    protected function getCurrentCategoryIDFromCookie()
    {
        $name = str_replace( '.', '-', $this->app->getOriginalFullApplicationAlias());
        $cid = fcookie_int("{$name}_currentCategory");         
        $cat = $this->app->getCategoryByID($cid);
        return ($cid > 0) && $cat ? $cid : $this->app->getDefaultCategoryID();
    }
    /**
     * Resets meta option keys for all items
     */    
    protected function resetAllCategoriesMetaOptionKeys()
    {
        global $SystemDB;
        
        if ($this->app->categoryColumnExists('options'))
        {
            $sanitized_item_opts = sanitize_string(@serialize($this->app->getDefaultCategoryMetaOptionKeys()));
            $SystemDB->query("UPDATE {$this->table_categories} SET `options` = {$sanitized_item_opts} ");
        }        
    }
    
    /**
     * Resets meta option keys for all items
     */    
    protected function resetAllCategoriesItemsPerPage()
    {
        global $SystemDB;
        
        if ($this->app->categoryColumnExists('items_per_page'))
        {
            $default_items_per_page = (int) $this->app->getDefaultCategoryItemsPerPage();
            $SystemDB->query("UPDATE {$this->table_categories} SET `items_per_page` = {$default_items_per_page}");
        }        
        
    }
    
    
    /**
     * Ajax reply of all data response schema from all table
     */
    public function ajaxGetAllDataResponseSchema()
    {
        $result = [];
        $result['item'] = $this->getItemsResponseSchema();
        if (method_exists($this->app,'getCategoryTable'))
            $result['category'] = $this->getCategoryTableResponseSchema();
        
        return ajax_reply(200, $result);
    }
    
    protected function setCategoryFieldNamesForAjaxUpdate(/** vars **/)
    {
        $array = (___c(func_get_arg(0)) > 0) ?  func_get_arg(0) : func_get_args();         
        $this->updatable_fieldname_categories = $this->intersectFields($this->_fieldname_categories, $array);
    }
        
    /**
     * Set category fieldn ames for ajax listing
     */
    public function setCategoryFieldNamesForAjaxListing(/** vars **/)
    {
        $array = (___c(func_get_arg(0)) > 0) ?  func_get_arg(0) : func_get_args();         
        $this->ajaxfield_categories = $this->intersectFields($this->_fieldname_categories, $array);
    }
    
    //_________________________________________________________________________//
    public function checkIfThisCategoryInTheMenu($cid)
    {
        global $SystemDB;

        $cid = (int) $cid;
        $app_name = sanitize_string($this->app_name);
        $sql = "SELECT * FROM gk_menu_items WHERE application = {$app_name} AND menuitem = 'c{$cid}'";
        $item = $SystemDB->getQueryResultSingleRow($sql, false);
        return ($item != null);
    }

    //_________________________________________________________________________//
    public function getFullPathByCategoryID($cat_id)
    {
        // TODO: path
    }

    /**
     * You can customize the response schema field here
     * @param array $response_schema
     * @return array
     */
    public function modifyItemResponseSchemaFields(array $response_schema)
    {
        $response_schema = parent::modifyItemResponseSchemaFields($response_schema);
        if (method_exists($this->app,'getCategoryTableName'))
        {
            $response_schema[] = array('key' => $this->app->getFieldCategoryID(), 'parser' => 'number'); 
        }
        return $response_schema;
    }
    /**
     * Returns the data response Schema for ajax Listing
     
   public function getItemsResponseSchema()
    {
        $listing_fields = $this->getItemFieldNamesForAjaxListing();
        $table_fields = $this->app->getItemTable()->getFields();

        
        $result_fields = $this->getParserFromTableListingFields($table_fields, $listing_fields);
        
        // Add this because in the datatable the cid is also displayed
        $result_fields[] = array('key' => $this->app->getFieldCategoryID(), 'parser' => 'number'); 
        $result_fields = $this->modifyItemResponseSchemaFields($result_fields);
        
        $response_result = array (
            'primary_key' => $this->app->getFieldID(),
            'resultsList' => "data",
            'fields' => $result_fields,
            'metaFields' => array(
                  'totalRecords' =>  "totalRecords",
                  'recordsReturned' => "recordsReturned",
                  //'paginationRecordOffset' => "start",
                  'start' => "start",
                  'end' => "end",
                  'paginationRowsPerPage' => "itemsperpage",
                  'sortby' => "sortby",
                  'sortdirection' => "sortdirection"
                    
                  )

        );
        return $response_result;
        //ajaxReply(200, $response_result);
    }        
    
*/
    /**
     * Returns the data response Schema for ajax Listing - category table
     */
    
   public function getTreeViewResponseSchemaFromTable($tablename, $restrict_listing_fields, $fn_modifier, $tree_config)
    {
       $result = $this->getDataTableResponseSchemaFromTable($tablename, $restrict_listing_fields, $fn_modifier);
       $result['config'] = $tree_config;
       return $result; 
       
    }        
    
    /**
     * Returns the data response Schema for ajax Listing - category table
     */
   public function getCategoryTableResponseSchema()
    {
       return $this->getTreeViewResponseSchemaFromTable($this->app->getCategoryTableName(), $this->getCategoryFieldNamesForAjaxListing(), 'modifyCategoryResponseSchemaFields', $this->tree_config);
    }
    //_________________________________________________________________________//

    public function getCategoryFieldNamesForAjaxListing()
    {
        return $this->ajaxfield_categories;
    }

    //_________________________________________________________________________//
    protected function setPreviewLinkForCategoryListingResult(array $categories)
    {
        $category_count = ___c($categories);
        $field_category_id = $this->app->getFieldCategoryID();
        if ($this->app->categoryColumnExists('virtual_filename')) {
            for ($i = 0; $i < $category_count; $i++)
            {
                $ocid = $categories[$i][$field_category_id];
                $categories[$i]['preview_link'] = $this->app->createFriendlyURL("action=viewcategory&cid={$ocid}");
                $categories[$i]['edit_link'] = $this->createFriendlyAdminURL("action=editcategory&id={$ocid}");
            }
        }
        return $categories;
    }

    //_________________________________________________________________________//
    public function ajaxGetItemsByCategoryID($id, $start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC')
    {
        global $SystemDB;

        $start = intval($start);
        $end = intval($end);
        $id = (int) $id;
        $category_sortby = '';
        $item_sortby = '';
        if ($start > $end)
            return ajax_reply(400, 'Invalid Request');
        $items_per_page = min(HARDCODE_MAX_ROWLIMIT, $end - $start);
        $total_item_count = $this->app->getTotalItemCountByCategoryID($id, false);
        $total_category_count = $this->app->getTotalCategoryCount();
        $normalized_item_fields = implode(',', quote_array_of_field_names_for_query($this->getItemFieldNamesForAjaxListing()));
        $normalized_category_fields = implode(',', quote_array_of_field_names_for_query($this->getCategoryFieldNamesForAjaxListing()));

        $result_array_directories = [];
        $result_array_files = [];
        $category_start = $start;
        // directory always at the top
        if ($id == 0) {  // just get the categories
            $result_array = $this->app->getAllCategories($normalized_category_fields, '', $start, $end, $this->field_category_id, $sortdirection);
            $result_array = $this->setPreviewLinkForCategoryListingResult($result_array);
        }
        else {
            $f = $this->app->getFieldItemCategoryID();
            $result_array = $this->app->getAllItems($normalized_item_fields, "{$f} = {$id}", $start, $end, $sortby, $sortdirection, false);
            $result_array = $this->setPreviewLinkForItemListingResult($result_array);
        }
        if ($id == 0)
            $total_count = $total_category_count;
        else
            $total_count = $total_item_count;
        $result_array = $this->modifyAjaxGetItemsByCategoryIDResult($id, $result_array);
        return ajax_datasource_reply(200, $result_array, $start, $end, $items_per_page, $total_count, $sortby, $sortdirection);
    }

    /**
     * Modify AJAX result before returned to user
     * @param int $id
     * @param array $result_array
     * @return array
     */
    public function modifyAjaxGetItemsByCategoryIDResult($id, $result_array)
    {
        return $result_array;
    }
    //_________________________________________________________________________//
    public function ajaxSaveCategory($id)
    {

        $retval = $this->saveCategory($id);
        if ($retval['status'] == SAVE_OK) {
            $answer = array('save_category_id' => $retval['id'], 'status' => $retval['status']);
            return ajax_reply(200, $answer);
        }
        else {
            clear_schlix_alert();
            $error_txt = implode("\n", $retval['errors']);
            return ajax_reply(405, ___('Error while saving').': '.$error_txt);
        }
    }

    //_________________________________________________________________________//
    protected function validateUpdateCategoryField($id, $field, $value)
    {
        if (!empty ($value))
        {
            if (str_contains($value,'>') || 
                str_contains($value,'<') || 
                str_contains($value,'"'))
                    return ___('Only simple field values are allowed for AJAX field update');
        }        
        if ((int) $id > 0)
        {
            $item = $this->table_categories->q()->select('*')->where(["{$this->field_category_id} = :id"])->getQueryResultArray(['id' => $id]);
            if ($item == null)
                return ('Existing item could not be found');
        }
        if (!in_array($field, $this->updatable_fieldname_items))
                return sprintf(___('Item field %s cannot be updated since it is not in the allowable list'), $field);
        if (empty($field))
            return ___('Field is empty');
        if (!$this->table_items->fieldExists($field))
            return ___('Field does not exist');
        
        return true;
    }

    //_________________________________________________________________________//
    public function ajaxUpdateField()
    {
        global $SystemDB;

        $record_id = fpost_alphanumeric('id');
        if (str_starts_with($record_id, 'i'))
            return parent::ajaxUpdateField(); // update item, e.g: i7

        $record_id_numtxt = substr($record_id, 1, strlen($record_id) - 1);
        $record_id_num = intval($record_id_numtxt);
        $thefield = fpost_string_noquotes_notags('field');
        $value = sanitize_string(fpost_string('value'));
        $pval = fpost_string('value');
        if (strpos($thefield, 'date') !== false) {
            $value = sanitize_string(date('Y-m-d H:i:s', strtotime($pval)));
        }

        $thetable = $this->table_categories;
        $thecolumn = $this->field_category_id;
        
        $error_msg = $this->validateUpdateCategoryField(($record_id_numtxt == "new") ? "new" : $record_id_num, $thefield, $pval);
        if ($error_msg === true) {
            if ($record_id == "new")
                $sql = "INSERT INTO {$thetable} ({$thefield}) VALUES({$value})";
            else
                $sql = "UPDATE {$thetable} SET {$thefield} = {$value} WHERE {$thecolumn} = {$record_id_num} ";
                
            $SystemDB->query($sql); //
            return ajax_reply(200, 'OK');
        } else {
            return ajax_reply(401, $error_msg);
        }
    }

    //_________________________________________________________________________//
    public function ajaxSearchObjects($keyword = '', $start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC')
    {
        global $SystemDB;

        $cleankeyword = sanitize_string("%{$keyword}%");
        $criteria = "title LIKE {$cleankeyword}";

        $item_searchresult = $category_searchresult = [];
        $normalized_item_fields = implode(',', quote_array_of_field_names_for_query($this->getItemFieldNamesForAjaxListing()));
        $normalized_category_fields = implode(',', quote_array_of_field_names_for_query($this->getCategoryFieldNamesForAjaxListing()));

        $total_item_count = $this->app->getTotalItemCount($criteria);
        $total_category_count = $this->app->getTotalCategoryCount($criteria);
        $items_per_page = min(HARDCODE_MAX_ROWLIMIT, $end - $start);
        if ($total_category_count > $start) {
            $category_end = $start + min($total_category_count - $start, $items_per_page);
            $category_searchresult = $this->app->getAllCategories($normalized_category_fields, $criteria, $start, $category_end, $sortby, $sortdirection, true, false);
        }
        if ($end - $total_category_count > 0) {
            $item_start = max(0, $start - $total_category_count);
            $item_end = $item_start + min($end - $total_category_count, $items_per_page);
            $item_searchresult = $this->app->getAllItems($normalized_item_fields, $criteria, $item_start, $item_end, $sortby, $sortdirection, true, false);
            $item_searchresult = $this->setPreviewLinkForItemListingResult($item_searchresult);
            
        }
        $searchresult = array_merge($category_searchresult, $item_searchresult);
        //$searchresult = $category_searchresult + $item_searchresult;
        $searchresult = $this->modifyAjaxSearchObjectsResult($keyword, $searchresult);
        
        return ajax_datasource_reply(200, $searchresult, $start, $end, $items_per_page, $total_category_count + $total_item_count, $sortby, $sortdirection);
    }
    /**
     * Returns a JSON-encoded list of all categories
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @param int $start
     * @param int $end
     * @param string $sortby
     * @param string $sortdirection
     * @return string
     */
    public function ajaxGetAllCategories($start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC')
    {
        global $SystemDB;
        $order_parent_id = '';

        $start = intval($start);
        $end = intval($end);
        $sortby = $SystemDB->escapeString($sortby);
        if ($start > $end)
            return ajax_reply(400, 'Invalid Request');
        if (empty($sortby))
            $sortby = $this->field_category_id;
        $field_names_for_category_listing = $this->getCategoryFieldNamesForAjaxListing();
        $normalized_field_names = implode(',', quote_array_of_field_names_for_query($field_names_for_category_listing));

        $category_array = $this->app->getAllCategories($normalized_field_names, '', $start, $end, $sortby, $sortdirection, false);
        $category_array = $this->modifyAjaxGetAllCategoriesResult($category_array);
        return ajax_reply(200, $category_array);
    }

    /**
     * Override the result of get all categories
     * @param array $category_array
     * @return array
     */
    public function modifyAjaxGetAllCategoriesResult($category_array)
    {
        return $category_array;
    }
    
    public function getCategoryByID($id)
    {
        return $this->app->getCategoryByIDWithExtraData($id);
    }

    /**
     * Override cmsAdmin_List's after save item
     * @param array $datavalues
     * @param array $retval
     */
    public function onAfterSaveItem($datavalues, $original_datavalues, $previous_item, $retval)
    {
        parent::onAfterSaveItem($datavalues, $original_datavalues, $previous_item, $retval);
        if (is_a($this->app, '\\SCHLIX\\cmsApplication_CategorizedList'))
        {
            if (fcookie_int($this->app_name . '_currentCategory')  == 0) {
                $cookie_key = $this->app_name . '_currentCategory';
                $cookie_val = strval($this->app->getDefaultCategoryID());
                //schlix_simple_set_cookie ($cookie_key, $cookie_val);
                $_COOKIE[$cookie_key] = $cookie_val;
                //setcookie(, );
                //setcookie($this->app_name . '_currentCategory', strval($this->app->getDefaultCategoryID()));
            }
        }
        return $retval;
    }
            
    /**
     * Validates $datavalues before saved and returns an error list if any,
     * otherwise return an empty array
     * @param array $datavalues
     */
    public function onGetAdminValidationErrorListBeforeSaveCategory($datavalues)
    {
        return [];
    }
     /**
     * Save item hook that you can override. Must return array of modified
     * or unmodified $datavalues
     * @param array $datavalues
     * @return array
     */
    public function onModifyDataBeforeSaveCategory($datavalues)
    {
        // status checkbox php bug
        
        if (in_array('status', $this->app->getCategoryFieldNames()))
            $datavalues['status'] = fpost_int('status');
        
        return $datavalues;
    }  
    /**
     * Save item hook that you can override. Must return array of modified
     * or unmodified $datavalues
     * @param array $datavalues
     * @param array $retval
     * @return array
     */
    public function onAfterSaveCategory($datavalues, $original_datavalues, $previous_category, $retval)
    {
        $id = (int) $retval['id'];
        if ($id > 0)
        {
            $this->recordCurrentUserSaveCategory($id);
            if ($this->checkIfThisCategoryInTheMenu($id))
                $this->forceRefreshMenuLinks();
        }
        return $retval;
    }
    //_________________________________________________________________________//

    public function saveCategory($id)
    {
        check_csrf_halt_on_error();
        $retval = $this->app->saveCategory($id);
        return $retval;
    }

    //_________________________________________________________________________//
    protected function recordCurrentUserSaveCategory($id)
    {
        global $CurrentUser;

        $extra_info = '';
        if ($this->app->categoryColumnExists('title')) {
            $category = $this->app->getCategoryByID($id);
            $extra_info = " with title '{$category['title']}'";
        }
        $CurrentUser->recordCurrentUserActivity("Saved category #{$id} for {$this->app_name} {$extra_info}");
    }


    //_________________________________________________________________________//

    public function editCategory($id)
    {
        global $CurrentUser;

        $hasWritePermission = true;
        if ($id == 'new') {
            $this->setPageTitle(___('New Category'));
            $category [$this->field_category_id] = 'new';
            $category ['parent_id'] = $this->getDefaultCategoryParentIDFromCookie();
            $category['date_created'] = get_current_datetime();
            $category['date_available'] = $category['date_created'];
            $category['date_modified'] = $category['date_created'];
        }
        else {
            $category = $this->app->getCategoryByIDWithExtraData($id);
            $this->setPageTitle(___('Edit Category').' #'.___h($id));
        }
        if ($id == 'new' || $category) {

            if ($category[$this->field_category_id] != 'new' && in_array('permission_write', $this->_fieldname_categories)) {
                $hasWritePermission = $CurrentUser->hasWritePermission($category['permission_write']);
                if (!$hasWritePermission)
                    echo \__HTML::H3(___('You do not have a write access to this'));
            }
            
            $local_variables = compact(array_keys(get_defined_vars()));            
            
            $local_variables['__app__'] = $this;
            $local_variables['view'] = 'category';
            
            unset($local_variables['CurrentUser']);
            
            $edit_template_name = 'edit.category'; //  empty($this->schlix_subclass) ? 'edit.item' : "edit.{$this->schlix_subclass}.item";
            if (!$this->loadTemplateFile($edit_template_name, $local_variables, true))
            {
                echo ___('Cannot find the editor template for ').$this->app_name;
            }
            
        }
        else
            $this->viewErrorMessage (___('Category does not exist'));
    }

    //_________________________________________________________________________//
    protected function getParentIDs($cat_id)
    {
        global $SystemDB;
        
        $all_parent_id = [];
        $current_id = $cat_id;
        $last_id = -1;

        while ($last_id != 0)
        {
            $sql = "SELECT parent_id FROM {$this->table_categories} where cid = '{$current_id}'";

            $id_r = $SystemDB->getQueryResultArray($sql);
            if (___c($id_r) === 0) 
                break;
            $last_id = $id_r [0]['parent_id'];
            $all_parent_id [] = $last_id;
            $current_id = $last_id;
        }
        return $all_parent_id;
    }

    //_________________________________________________________________________//
    public function ajaxMoveObjects($mixed_items_to_move, $destination)
    { // mixed item = categories + items
        //case 1: move file, case 2: move folder, case 3: move mixed files and folders
        //http://schlixcms/admin/index.php?page=html&ajax=1&action=ajax_move&item=c3&destination=c5
        global $SystemDB;

        check_csrf_halt_on_error(true);
        $mixed_items_to_move = str_replace($this->_ajax_treenode_prefix, 'c', $mixed_items_to_move);
        $mixed_items_to_move = str_replace(SCHLIX_DEPRECATED_AJAX_TREENODEID_PREFIX, 'c', $mixed_items_to_move); // backward compatibility

        $destination = str_replace($this->_ajax_treenode_prefix, 'c', $destination); // backward compatibility
        $destination = str_replace(SCHLIX_DEPRECATED_AJAX_TREENODEID_PREFIX, 'c', $destination);

        /* if ($mixed_items_to_move[0] = 'i' && $destination[0] == 'i')
          {
          ajaxReply(400, "Invalid move operation - cannot move an item to another item" );
          } */
        // Validation 1: Is the person trying to copy a category to another category
        if (empty($mixed_items_to_move) || empty($destination)) {
            return ajax_reply(400, ___('Invalid move operation - empty source and/or destination'));
        }

        $pos = strrpos($destination, "_");
        $destination_cat_id = substr($destination, $pos + 1, strlen($destination) - $pos);

        // Validation 2: Is the person trying to move categories
        if ((strpos($mixed_items_to_move, 'c') !== false)) {
            return ajax_reply(400, ___('Invalid move operation - cannot move categories in Simple Categories'));
        }
        // Validation 3: Is the person trying to move a category to another category
        if ((strpos($mixed_items_to_move, 'i') !== false) && ($destination_cat_id == 0)) {
            return ajax_reply(400, ___('Invalid move operation - cannot move an item to a non-existing category'));
        }

        $mixed_items_to_move_array = explode(',', $mixed_items_to_move);
        foreach ($mixed_items_to_move_array as $mixed_item)
            $source_id_array[] = substr($mixed_item, 1);
        // Case 1: If it's a duplicate category operation
        if (strpos($mixed_items_to_move, 'i') !== false) {
            $source_itemstrs = implode(",", $source_id_array);
            $sql = "UPDATE  {$this->table_items} SET category_id = '{$destination_cat_id}' where id IN  ({$source_itemstrs})";
            if ($sql)
                $SystemDB->query($sql);
            if (method_exists($this, 'forceRefreshMenuLinks'))
                $this->forceRefreshMenuLinks();
            
            return ajax_reply(200, 'OK');
        }


        /* 	// Find parents of the destinations first to avoid relaps
          $pos = strrpos($destination, "_");
          $destination_catnumber=substr($destination,$pos+1, strlen($destination)- $pos  );
          $parent_id_array = $this->getParentIDs ($destination_catnumber);

          // Now process the source
          if (strpos($mixed_items_to_move,'folder') > 0)
          {
          $pos = strrpos($mixed_items_to_move, "_");
          $source_catnumber=substr($mixed_items_to_move,$pos+1, strlen($mixed_items_to_move)- $pos);
          if (in_array($source_catnumber, $parent_id_array))
          print "Incorrect user operation - cannot move this folder to its subfolder";
          else
          $sql = "UPDATE {$this->table_categories} SET parent_id = '{$destination_catnumber}' where cid = '{$source_catnumber}'";
          if ($sql) $SystemDB->query($sql);

          }
          else if (strpos($mixed_items_to_move, 'article') > 0)
          {
          $pos = strrpos($mixed_items_to_move, "_");
          $source_itemnumber=substr($mixed_items_to_move,$pos+1, strlen($mixed_items_to_move)- $pos );
          $sql = "UPDATE  {$this->table_items} SET category_id = '{$destination_catnumber}' where id = '{$source_itemnumber}'";
          if ($sql) $SystemDB->query($sql);
          }
          else
          {
          // mixed stuff
          $mixed_items_array = explode(',', $mixed_items_to_move);
          foreach ($mixed_items_array as $mixed_item)
          {
          $current_id = substr($mixed_item,1); // 11 is the next string after
          if (strpos ($mixed_item, 'c') > -1)
          {
          $source_catnumbers[] = $current_id;
          } else // else if it's an item instead
          {
          $source_itemnumbers[] = $current_id;
          }
          } // end foreach
          // verify if there's a conflict
          $error = false;
          foreach ($source_catnumbers as $source_catnumber)
          if (in_array($source_catnumber, $parent_id_array)) $error = true;
          // now update parent_id

          if (!$error)
          {
          $source_catstrs = implode(",", $source_catnumbers);
          if ($source_catnumbers)
          {
          $sql = "UPDATE {$this->table_categories} SET parent_id = '{$destination_catnumber}' where cid in  ({$source_catstrs})";
          $SystemDB->query($sql);
          }
          // Now
          $source_itemstrs = implode(",", $source_itemnumbers);
          $sql = "UPDATE  {$this->table_items} SET category_id = '{$destination_catnumber}' where id in  ({$source_itemstrs})";
          $SystemDB->query($sql);

          } else print "Incorrect user operation - cannot move this folder to its subfolder";
          } // end mixed stuff */
    }

    //_________________________________________________________________________//
    function duplicateCategory($catid, $destination_catnumber)
    {
        global $SystemDB;

        if ($catid > 0) {
            // 1. duplicate main category
            $category = $this->app->getCategoryByID($catid);
            unset($category[$this->field_category_id]);
            $category['title'].= '_copy';
            if ($this->app->categoryColumnExists('guid'))
                $category['guid'] = new_uuid_v4();
            if ($this->app->categoryColumnExists('virtual_filename'))
                $category['virtual_filename'] = $this->app->preventDuplicateValueInCategory('virtual_filename', $category['virtual_filename'], 0);


            $SystemDB->simpleInsertInto($this->table_categories, $category);                 
            $last_inserted_id = $SystemDB->getLastInsertID();            
            $new_category_name = $this->app->preventDuplicateValueInCategory('title', $category['title'], $last_inserted_id);
            $new_virtual_file_name = $this->app->preventDuplicateValueInCategory('virtual_filename', $category['virtual_filename'], $last_inserted_id);            
            // must be separated, don't use || OR
            if ($new_category_name != $category['title']) {
                $new_category_name = sanitize_string($new_category_name);
                $sql = "UPDATE `{$this->table_categories}` SET `title`={$new_category_name} WHERE `{$this->field_category_id}` = {$last_inserted_id}";
                $SystemDB->query($sql);
            }
            if ($new_virtual_file_name != $category['virtual_filename']) {
                $new_virtual_file_name = sanitize_string($new_virtual_file_name);
                $sql = "UPDATE `{$this->table_categories}` SET `virtual_filename`={$new_virtual_file_name} WHERE `{$this->field_category_id}` = {$last_inserted_id}";
                $SystemDB->query($sql);
            }
            
            // 2. copy items - 0,0 means all
            $items_in_this_category = $this->app->getItemsByCategoryID($catid, '*', '', 0, 0, $this->app->getFieldID());
            foreach ($items_in_this_category as $item)
            {
                $this->duplicateItem($item['id'], $last_inserted_id);
            }
        }
    }

    //_________________________________________________________________________//

    public function duplicateItem($source_item_id, $destination_catnumber)
    {
        global $SystemDB;

        $destination_catnumber = (int) $destination_catnumber;
        //echo "Copy $source_item_id to $destination_catnumber\n";
        $item = $this->app->getItemByID($source_item_id);
        unset($item[$this->app->getFieldID()]);
        if ($this->app->itemColumnExists('guid'))
            $item['guid'] = new_uuid_v4();
        if ($this->app->itemColumnExists('virtual_filename'))
            $item['virtual_filename'] = $this->app->preventDuplicateValueInItemTableUnderCategory('virtual_filename', $item['virtual_filename'], 0, $destination_catnumber);

        $item['category_id'] = $destination_catnumber;
        $item[$this->app->getFieldItemTitle()].= '_copy';
        
        $SystemDB->simpleInsertInto($this->table_items, $item);        
    }
    
    /**
     * Generate parent URL's path
     * @param array $item
     * @return string
     */
    public function getItemParentURLPathPreviewLink($item)
    {
        $field_category_id = $this->app->getFieldCategoryID();

        $parent_category_text = ($item['category_id'] > 0) ? decode_path($this->app->createFriendlyURL("action=viewcategory&{$field_category_id}={$item['category_id']}")) : SCHLIX_SITE_HTTPBASE.'/'.  $this->app->getFullApplicationAlias().'/';
        return $parent_category_text;
    }
    
    /**
     * Generate parent URL's path
     * @param array $category
     * @return string
     */
    public function getCategoryParentURLPathPreviewLink($category)
    {
        $parent_category_text =  SCHLIX_SITE_HTTPBASE.'/'.$this->app->getFullApplicationAlias().'/';
        return $parent_category_text;
    }
    
    //_________________________________________________________________________//
    public function ajaxCopyObjects($mixed_items_to_copy, $destination = '')
    { // mixed item = categories + items
        global $SystemDB;

        check_csrf_halt_on_error(true);

        // Validation 1: Is the person trying to copy a category to another category
        if (empty($mixed_items_to_copy) || empty($destination)) {
            return ajax_reply(400, ___('Invalid copy operation - empty source and/or destination'));
        }

        $pos = strrpos($destination, "_");
        $destination_cat_id = substr($destination, $pos + 1, strlen($destination) - $pos);

        // Validation 2: Is the person trying to copy *both* items & categories
        if ((strpos($mixed_items_to_copy, 'c') !== false) && (strpos($mixed_items_to_copy, 'i') !== false)) {
            return ajax_reply(400, ___('Invalid copy operation - cannot copy multiple items and categories in Simple Categories'));
        }
        // Validation 3: Is the person trying to copy an item to root directory
        if ((strpos($mixed_items_to_copy, 'c') !== false) && ($destination_cat_id > 0)) {
            return ajax_reply(400, ___('Invalid copy operation - cannot copy a category to another category in Simple Categories'));
        }
        // Validation 4: Is the person trying to copy a category to another category
        if ((strpos($mixed_items_to_copy, 'i') !== false) && ($destination_cat_id == 0)) {
           return ajax_reply(400, ___('Invalid move operation - cannot move an item to a non-existing category'));
        }

        $mixed_items_to_copy_array = explode(',', $mixed_items_to_copy);
        foreach ($mixed_items_to_copy_array as $mixed_item)
            $source_id_array[] = substr($mixed_item, 1);
        // Case 1: If it's a duplicate category operation
        if ((strpos($mixed_items_to_copy, 'c') !== false) && (strpos($mixed_items_to_copy, 'i') === false)) {
            foreach ($source_id_array as $source_cat_id)
            {
                $this->duplicateCategory($source_cat_id, $destination_cat_id);
            }
            return ajax_reply(200, 'OK');
        }
        // Case 2: If it's copying items another category or to this category
        else if ((strpos($mixed_items_to_copy, 'c') === false) && (strpos($mixed_items_to_copy, 'i') !== false)) {
            foreach ($source_id_array as $source_item_id)
            {
                $this->duplicateItem($source_item_id, $destination_cat_id);
            }
            return ajax_reply(200, 'OK');
        }
        else 
            return ajax_reply(300,'Unknown error');
    }

    //_________________________________________________________________________//
    /**
     * Restore a category to a previous version
     * @param int $cid
     * @param float $version
     * @return array
     */
    public function ajaxRestoreCategory($cid, $version)
    {

        $cid = (int) $cid;
        $version = doubleval($version);

        check_csrf_halt_on_error(true);
        $archiving_result = $this->app->restoreCategory($cid, $version);

        if ($archiving_result)
            return ajax_reply(200, 'OK');
        else
            return ajax_reply('201', 'Restore Failed');
    }
    /**
     * Save Configuration. You can override the app name if required
     * @global \SCHLIX\cmsConfigRegistry $SystemConfig
     * @global \App\Users $CurrentUser
     * @param string $override_app_name
     * @return array
     */
    public function saveConfig($override_app_name = '')
    {
        $result = parent::saveConfig($override_app_name);
        if ($result && ($result['status'] == SAVE_OK))
        {
            $reset_category_options = fpost_string('reset_category_options');
            $reset_category_items_per_page = fpost_string('reset_category_items_per_page');
            if ($reset_category_options || $reset_category_items_per_page)
            {
                $app = null;
                if ($override_app_name)
                {
                    $the_app_name = '\\App\\'.$override_app_name;
                    $app = new $the_app_name();
                } else $app = $this;
                if ($reset_category_options)
                    $app->resetAllCategoriesMetaOptionKeys();
                if ($reset_category_items_per_page)
                    $app->resetAllCategoriesItemsPerPage();                
            }
        }
        return $result; 
    }

    //_________________________________________________________________________//
    /**
     * Runs admin command
     * @return bool
     */
    public function Run()
    {
        switch (fget_alphanumeric('action'))
        {
            case 'newcategory':                 
                $this->editCategory('new');
                return RETURN_FULLPAGE;
                break;
            case 'editcategory':
                $this->editCategory(fget_int('id'));
                return RETURN_FULLPAGE;
                break;
            case 'savecategory': 
                $retval = $this->saveCategory(fpost_alphanumeric($this->field_category_id));                
                $this->lastSaveResult = $retval;
                if ($this->lastSaveResult['status'] == SAVE_OK)
                    $this->returnToMainAdminApplication();
                else
                    $this->editCategory(fpost_alphanumeric('cid'));
                return RETURN_FULLPAGE;
                
                break;
            case 'ajaxsavecategory': 
                return ajax_echo($this->ajaxSaveCategory(fpost_alphanumeric('cid')));
                break;
            // For menu compatibility (fixed Feb 7, 2017)
            case 'getallparentsbycategoryid':
            case 'getcategoriesbyparentid': 
            // end fix
            case 'getallcategories': 
                return ajax_echo($this->ajaxGetAllCategories(fget_int('start'), fget_int('end'), fget_string_noquotes_notags('sortby'), fget_string_noquotes_notags('sortdirection')));
                break;
            case 'search': 
                return ajax_echo($this->ajaxSearchObjects(fget_string('keyword',63), fget_int('start'), fget_int('end'), fget_string_noquotes_notags('sortby'), fget_string_noquotes_notags('sortdirection')));
                break;
            case 'getitemsbycategory': 
                return ajax_echo($this->ajaxGetItemsByCategoryID(fget_int('id'), fget_int('start'), fget_int('end'), fget_string_noquotes_notags('sortby'), fget_string_noquotes_notags('sortdirection')));
                break;
            case 'move': 
                return ajax_echo($this->ajaxMoveObjects(fpost_string('items'), fpost_string('destination')));
                break;
            case 'setcurrentcategory': 
                return ajax_echo($this->setCurrentCategoryID(fget_int('id')));
                break;
            case 'getcurrentcategory': 
                return ajax_echo($this->getCurrentCategoryID());
                break;
            case 'restorecategory': 
                return ajax_echo($this->ajaxRestoreCategory(fpost_int('id'), fpost_double('version')));
                break;

            default: return parent::Run();
        }
    }

}

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//


class cmsAdmin_HierarchicalTree_List extends \SCHLIX\cmsAdmin_CategorizedList implements interface_cmsAdmin_HierarchicalTreeList
{
    /**
     * The application
     * @var cmsApplication_HierarchicalTree_List
     */
     protected $app;    
     
    protected $field_category_parent_id;
    //_________________________________________________________________________//
    public function __construct( $data_type = null, $public_methods = null)
    {
        parent::__construct( $data_type, $public_methods);
        $this->field_category_parent_id = $this->app->getFieldCategoryParentID();        
        $this->setCategoryFieldNamesForAjaxListing('cid', 'status', 'parent_id', 'title', 'sort_order', 'virtual_filename', 'date_available', 'date_created', 'date_modified');
    }
            
    /**
     * Ajax reply of all data response schema from all table
     */
    public function ajaxGetAllDataResponseSchema()
    {
        $result = [];
        $result['item'] = $this->getItemsResponseSchema();
        $result['category'] = $this->getCategoryTableResponseSchema();
        return ajax_reply(200, $result);
    }
    /**
     * Generate parent URL's path
     * @param array $category
     * @return string
     */
    public function getCategoryParentURLPathPreviewLink($category)
    {
        $field_category_id = $this->app->getFieldCategoryID();
        $parent_category_text = ($category['parent_id'] > 0) ? decode_path($this->app->createFriendlyURL("action=viewcategory&{$field_category_id}={$category['parent_id']}") ) : SCHLIX_SITE_HTTPBASE.'/'.$this->app->getFullApplicationAlias().'/';
        return $parent_category_text;
    }
    
    /**
     * Returns the data response Schema for ajax Listing - category table
     */
   public function getCategoryTableResponseSchema()
    {
        $listing_fields = $this->getCategoryFieldNamesForAjaxListing();
        $table_fields = $this->app->getCategoryTable()->getFields();
        
        $result_fields = $this->getParserFromTableListingFields($table_fields, $listing_fields);
        $result_fields[] = array('key' => '__child_count', 'parser' => 'number');
        $result_fields = $this->modifyCategoryResponseSchemaFields($result_fields);
        $response_result = array (
            'primary_key' => $this->app->getFieldCategoryID(),
            'config' => $this->tree_config,
            'resultsList' => "data",
            //'fields' => $result_fields,
            'metaFields' => array(
                  'totalRecords' =>  "totalRecords",
                  'recordsReturned' => "recordsReturned",
                  //'paginationRecordOffset' => "start",
                  'paginationRowsPerPage' => "itemsperpage",
                  'sortby' => "sortby",
                  'sortdirection' => "sortdirection",
                'start'=> "start",
                'end'=> "end"
                
                  )

        );
        return $response_result;
    }           
    //_________________________________________________________________________//
    public function ajaxGetItemsByCategoryID($id, $start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC')
    {
        global $SystemDB;
        $id = (int) $id;
        $start = intval($start);
        $end = intval($end);
        $sortby = $SystemDB->escapeString($sortby);
        if ($start > $end)
            return ajax_reply(400, 'Invalid Request');
        if (!empty($sortby) && !empty($sortdirection)) {
            if ($sortby == $this->field_id || $sortby == $this->field_category_id) {
                $category_sortby = $this->field_category_id; // to correct cid/id merge in listing
                $item_sortby = $this->field_id; // to correct cid/id merge in listing
            }
            else
                $item_sortby = $category_sortby = $sortby;
        }

        $items_per_page = min(HARDCODE_MAX_ROWLIMIT, $end - $start); // must not be over 1500 per page .. lol
        if ($items_per_page == 0)
            $items_per_page = DATATABLE_DEFAULT_ROWS_PERPAGE; // default 15, prevent division by zero
        $total_item_count = $this->app->getTotalItemCountByCategoryID($id);
        $total_category_count = $this->app->getTotalChildCategoryCountByCategoryID($id, false);
        $normalized_item_fields = implode(',', quote_array_of_field_names_for_query($this->getItemFieldNamesForAjaxListing()));
        $normalized_category_fields = implode(',', quote_array_of_field_names_for_query($this->getCategoryFieldNamesForAjaxListing()));
        $result_array_directories = [];
        $result_array_files = [];
        $category_start = $start;
        // directory always at the top
        if ($total_category_count > $start) {
            $cat_end_limit = $category_start + min($total_category_count - $category_start, $items_per_page);
            $result_array_directories = $this->app->getChildCategoriesByParentID($id, $normalized_category_fields, '', $category_start, $cat_end_limit, $category_sortby, $sortdirection);
            $result_array_directories = $this->setPreviewLinkForCategoryListingResult($result_array_directories);
        }
        if ($end - $total_category_count > 0) {
            $item_start = max(0, $start - $total_category_count);
            $item_limit = $item_start + min($end - $total_category_count, $items_per_page);

            $result_array_files = $this->app->getItemsByCategoryID($id, $normalized_item_fields, '', $item_start, $item_limit, $item_sortby, $sortdirection);
            $result_array_files = $this->setPreviewLinkForItemListingResult($result_array_files);
        }
        $result_array = array_merge($result_array_directories, $result_array_files);
        $result_array = $this->modifyAjaxGetItemsByCategoryIDResult($id, $result_array);
        return ajax_datasource_reply(200, $result_array, $start, $end, $items_per_page, $total_category_count + $total_item_count, $sortby, $sortdirection);
    }


    //_________________________________________________________________________//

    public function ajaxGetCategoriesByParentID($parent_id, $expanded_nodes='', $start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC')
    {
        global $SystemDB;
        $order_parent_id = '';

        $start = intval($start);
        $end = intval($end);
        if ($start > $end)
            return ajax_reply(400, ___('Invalid Request'));
        if (empty($sortby))
            $sortby = $this->field_category_id;
        $field_names_for_category_listing = $this->getCategoryFieldNamesForAjaxListing();
        $normalized_field_names = implode(',', quote_array_of_field_names_for_query($field_names_for_category_listing));

        $extra_criteria = '';
        /*$filtered_expanded_nodes = $expanded_nodes;
        if (!empty($filtered_expanded_nodes))
          $extra_criteria = "1 OR _parent.{$this->field_category_id} IN ({$filtered_expanded_nodes})";  */
        if ($this->app->categoryColumnExists('title'))            
            $sortby = 'title';
        $category_array = $this->app->getChildCategoriesByParentIDWithChildCount($parent_id, $normalized_field_names, $extra_criteria, $start, $end, $sortby, 'ASC', false);
        
        
        //echo ajaxReply(200,$category_array);
        $items_per_page = 0;
        $total_item_count = 0;
        
        return ajax_datasource_reply(200, $category_array, $start, $end, $items_per_page, $total_item_count, $sortby, $sortdirection);
    }
    //_________________________________________________________________________//
    public function ajaxGetAllParentsByCategoryID($current_category_id)
    {
        $all_parents = $this->app->getAllParentsByCategoryID($current_category_id);
        $all_parents = array_reverse($all_parents);
        return ajax_reply(200, $all_parents);        
    }
    
    
    //_________________________________________________________________________//
    protected function getParentIDs($cat_id)
    {
        global $SystemDB;
        $current_id = $cat_id;
        $last_id = -1;
        $all_parent_id = [];

        while ($last_id != 0)
        {
            $sql = "SELECT parent_id FROM {$this->table_categories} where cid = '{$current_id}'";

            $id_r = $SystemDB->getQueryResultArray($sql);
            if(!$id_r) break;
            $last_id = $id_r [0]['parent_id'];
            $all_parent_id [] = $last_id;
            $current_id = $last_id;
        }
        return $all_parent_id;
    }

    //_________________________________________________________________________//
    function duplicateCategory($catid, $destination_catnumber)
    {
        global $SystemDB;

        if ($catid > 0) {
            // 1. duplicate main category
            $category = $this->app->getCategoryByID($catid);
            unset($category[$this->field_category_id]);
            $category['parent_id'] = $destination_catnumber;
            $category['title'].= '_copy';
            if ($this->app->categoryColumnExists('guid'))
                $category['guid'] = new_uuid_v4();
            if ($this->app->categoryColumnExists('virtual_filename'))
                $category['virtual_filename'] = $this->app->preventDuplicateValueInCategoryTableUnderParentCategory('virtual_filename', $category['virtual_filename'], 0, $category[$this->app->getFieldCategoryParentID()]);
            
            $SystemDB->simpleInsertInto($this->table_categories, $category);            
            $last_inserted_id = $SystemDB->getLastInsertID();

            // 2. copy items
            $items_in_this_category = $this->app->getItemsByCategoryID($catid);

            foreach ($items_in_this_category as $item)
            {
//				echo "Copying {$item['title']} to {$last_inserted_id}";
                $this->duplicateItem($item['id'], $last_inserted_id);
            }
            // 3. find children
            $child_categories = $this->app->getChildCategoriesByParentID($catid);
            $i = 0;
            while ($i < sizeof($child_categories))
            {
                $current_id = $child_categories[$i][$this->field_category_id];
                $i++;
                $this->duplicateCategory($current_id, $last_inserted_id);
            }
        }
        //		return $categories;
    }

    //_________________________________________________________________________//
    public function getChildCategoriesByParentID($id, $start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC')
    {
        return $this->app->getChildCategoriesByParentID($id, '*', '', $start, $end, $sortby, $sortdirection);
    }

    //_________________________________________________________________________//
    public function ajaxCopyObjects($mixed_items_to_copy, $destination = '')
    { // mixed item = categories + items
        global $SystemDB;

        check_csrf_halt_on_error(true);
        // Find parents of the destinations first to avoid relaps
        $pos = strrpos($destination, "_");
        $destination_catnumber = substr($destination, $pos + 1, strlen($destination) - $pos);
        $parent_id_array = $this->getParentIDs($destination_catnumber);

        // mixed stuff
        $mixed_items_array = explode(',', $mixed_items_to_copy);
        foreach ($mixed_items_array as $mixed_item)
        {
            $current_id = substr($mixed_item, 1); // 11 is the next string after
            if (strpos($mixed_item, 'c') !== FALSE) {
                $source_catnumbers[] = (int) $current_id;
            }
            else { // else if it's an item instead
                $source_itemnumbers[] = (int) $current_id;
            }
        } // end foreach
        // verify if there's a conflict
        $error = false;
        if ($source_catnumbers)
        {
            foreach ($source_catnumbers as $source_catnumber)
                if (in_array($source_catnumber, $parent_id_array))
                    $error = true;
            if(in_array($destination_catnumber, $source_catnumbers))
                $error= true;
        }
        if (!$error) {
            // Copy folders

            if ($source_catnumbers) {
                foreach ($source_catnumbers as $source_cat_id)
                {
                    $this->duplicateCategory($source_cat_id, $destination_catnumber);
                }
            }
            // Copy items
            if ($source_itemnumbers) {
                foreach ($source_itemnumbers as $source_item_id)
                {
                    $this->duplicateItem($source_item_id, $destination_catnumber);
                }
            }
//			$sql = "UPDATE  {$this->table_items} SET category_id = '{$destination_catnumber}' where id in  ({$source_itemstrs})";
            //$SystemDB->query($sql);
            return ajax_reply(200, ___c($source_itemnumbers));
        }
        else
            return ajax_reply(400, ___("Incorrect user operation - cannot copy this folder to its subfolder"));
    }

    //_________________________________________________________________________//
    public function ajaxMoveObjects($mixed_items_to_move, $destination)
    { // mixed item = categories + items
        //case 1: move file, case 2: move folder, case 3: move mixed files and folders
        //http://schlixcms/admin/index.php?page=html&ajax=1&action=ajax_move&item=c3&destination=c5
        global $SystemDB;

        check_csrf_halt_on_error(true);
        // Find parents of the destinations first to avoid relaps
        $pos = strrpos($destination, "_");
        $destination_catnumber = substr($destination, $pos + 1, strlen($destination) - $pos);
        $parent_id_array = $this->getParentIDs($destination_catnumber);

        // Now process the source
        $sql = '';

        if ($destination[0] == 'i') {
            return ajax_reply(400, ___('Incorrect user operation - an item cannot be set as a destination for move operation'));
        }
        elseif (strpos($mixed_items_to_move, 'folder') > 0) {
            $pos = strrpos($mixed_items_to_move, "_");
            $source_catnumber = substr($mixed_items_to_move, $pos + 1, strlen($mixed_items_to_move) - $pos);
            if ($source_catnumber == $destination_catnumber) {
                return ajax_reply(400, ___('Incorrect user operation - cannot move this folder to the same folder'));
            }
            else

            if (array_search($source_catnumber, $parent_id_array, TRUE) !== false) // April 1, 2010
                return ajax_reply(400, ___('Incorrect user operation - cannot move this folder to its subfolder'));
            else
                $sql = "UPDATE {$this->table_categories} SET parent_id = :dest_cid where cid = :source_cid";
            if ($sql) {
                $SystemDB->query($sql,['dest_cid' => $destination_catnumber, 'source_cid' => $source_catnumber]);
                if (method_exists($this, 'forceRefreshMenuLinks'))
                    $this->forceRefreshMenuLinks();
                
                return ajax_reply(200, 'OK');
            }
        }
        else if (strpos($mixed_items_to_move, 'article') > 0) {
            $pos = strrpos($mixed_items_to_move, "_");
            $source_itemnumber = substr($mixed_items_to_move, $pos + 1, strlen($mixed_items_to_move) - $pos);
            $sql = "UPDATE  {$this->table_items} SET category_id = :dest_cid where id = :source_id";
                $SystemDB->query($sql,['dest_cid' => $destination_catnumber, 'source_id' => $source_itemnumber]);
        }
        else {
            // mixed stuff
            $mixed_items_array = explode(',', $mixed_items_to_move);
            $source_catnumbers = [];
            foreach ($mixed_items_array as $mixed_item)
            {
                $current_id = substr($mixed_item, 1); // 11 is the next string after
                if (strpos($mixed_item, 'c') > -1) {
                    $source_catnumbers[] = (int) $current_id;
                }
                else { // else if it's an item instead
                    $source_itemnumbers[] = (int) $current_id;
                }
            } // end foreach
            // verify if there's a conflict
            $error = false;
            if ($source_catnumbers)
                foreach ($source_catnumbers as $source_catnumber)
                    if (in_array($source_catnumber, $parent_id_array) || $source_catnumber == $destination_catnumber)
                        $error = true;
            // now update parent_id

            if (!$error) {
                if ($source_catnumbers) {
                    $source_catstrs = implode(",", $source_catnumbers);
                    $sql = "UPDATE {$this->table_categories} SET parent_id = '{$destination_catnumber}' where cid in  ({$source_catstrs})";
                    $SystemDB->query($sql);
                }
                // Fix - Dec 6, 2011 - forgot to add if
                if ($source_itemnumbers) {
                    $source_itemstrs = implode(",", $source_itemnumbers);
                    $sql = "UPDATE  {$this->table_items} SET category_id = '{$destination_catnumber}' where id in  ({$source_itemstrs})";
                    $SystemDB->query($sql);
                }
                if (method_exists($this, 'forceRefreshMenuLinks'))
                    $this->forceRefreshMenuLinks();

                return ajax_reply(200, 'OK');
            }
            else
                return ajax_reply(400, ___('Incorrect user operation - cannot move this folder to its subfolder'));
        } // end mixed stuff
    }

    //_________________________________________________________________________//

    public function ajaxGetAllCategories($start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC')
    {

        
        global $SystemDB;
        $order_parent_id = '';

        $start = intval($start);
        $end = intval($end);
        if ($start > $end)
            return ajax_reply(400, ___('Invalid Request'));
        if (empty($sortby))
            $sortby = $this->field_category_id;
        $field_names_for_category_listing = $this->getCategoryFieldNamesForAjaxListing();
        $normalized_field_names = implode(',', quote_array_of_field_names_for_query($field_names_for_category_listing));


        $category_array = $this->app->getAllCategories($normalized_field_names, '', $start, $end, $sortby, 'ASC', false);
        $category_array = $this->modifyAjaxGetAllCategoriesResult($category_array);
        $items_per_page = 9999;
        $total_item_count = 9999;
        // WHY IS THIS HERE ??
        //$category_array [] = $first_element;
        return ajax_datasource_reply(200, $category_array, $start, $end, $items_per_page, $total_item_count, $sortby, $sortdirection);
    } 
    //_________________________________________________________________________//

    public function Run()
    {
        switch (fget_alphanumeric('action'))
        {
            case 'getallparentsbycategoryid': // DO NOT USE fget_int in here for cid 
                return ajax_echo($this->ajaxGetAllParentsByCategoryID(fget_string_noquotes_notags('cid')));
                break;
            
            case 'getcategoriesbyparentid':  // DO NOT USE fget_int in here for parent_id                
                return ajax_echo($this->ajaxGetCategoriesByParentID(fget_string_noquotes_notags('parent_id'),fget_string_noquotes_notags('expandnodes'), fget_int('start'), fget_int('end'), fget_string_noquotes_notags('sortby'), fget_string_noquotes_notags('sortdirection')));
                break;            
            
            case 'getallcategories': 
                return ajax_echo($this->ajaxGetAllCategories(fget_int('start'), fget_int('end'), "parent_id,{$this->field_category_id}", 'ASC'));
                break;
            default: return parent::Run();
        }
    }

    //_________________________________________________________________________//
}

class cmsAdmin_ManyToMany extends \SCHLIX\cmsAdmin_HierarchicalTree_List implements interface_cmsAdmin_ManyToMany
{
    /**
     * App
     * @var \SCHLIX\cmsApplication_ManyToMany
     */
    protected $app;    

    protected $_fieldname_categories_items;
    protected $table_categories_items;
    //_________________________________________________________________________//
    public function __construct($data_type = null, $public_methods = null)
    {
        parent::__construct($data_type, $public_methods);
        $this->_fieldname_categories_items = $this->app->getItemsToCategoryFieldNames();
        $this->table_categories_items = $this->app->getItemsToCategoryTableName();
    }
            
    
    /**
     * Generate parent URL's path
     * @param array $item
     * @return string
     */
    public function getItemParentURLPathPreviewLink($item)
    {
        $field_category_id = $this->app->getFieldCategoryID();
        
        $categories = $this->app->getItemCategoriesByItemID($item[$this->field_id]);
        
        $parent_category_text = ($categories) ? $this->app->createFriendlyURL("action=viewcategory&{$field_category_id}={$categories[0][$field_category_id]}") : SCHLIX_SITE_HTTPBASE.'/'.  $this->app->getFullApplicationAlias().'/';
        return $parent_category_text;
    }            
    
    /**
     * Generate parent URL's path
     * @param array $item
     * @return array
     */
    public function getItemParentURLPathMultiplePreviewLink($item)
    {
        $field_category_id = $this->app->getFieldCategoryID();
        $parent_category_text = [];
        $categories = $this->app->getItemCategoriesByItemID($item[$this->field_id]);
        if ($categories)
        {
            foreach ($categories as $category)
            {
                $parent_category_text[] = decode_path($this->app->createFriendlyURL("action=viewcategory&{$field_category_id}={$category[$field_category_id]}"));
            }
        } else
        {
            $parent_category_text[] = SCHLIX_SITE_HTTPBASE.'/'.  $this->app->getFullApplicationAlias().'/';
        }
        return $parent_category_text;
    }            
    
    //_________________________________________________________________________//

    public function duplicateItem($source_item_id, $destination_catnumber)
    {
        global $SystemDB;
        $source_item_id = intval($source_item_id);
        $item = $this->app->getItemByID($source_item_id);
        unset($item[$this->app->getFieldID()]);
        $item[$this->app->getFieldItemTitle()].= '_copy';
        if ($item['guid'] != '')
            $item['guid'] = new_uuid_v4();
        if ($this->app->itemColumnExists('virtual_filename'))
            $item['virtual_filename'] = $this->app->preventDuplicateValueInItemTable('virtual_filename', $item['virtual_filename'], 0);
        $SystemDB->simpleInsertInto($this->table_items, $item);                    
        $new_id = $SystemDB->getLastInsertID();
        if (!empty($destination_catnumber) && $destination_catnumber > 0)
            $this->app->setItemCategory($new_id, $destination_catnumber, true);
    }

    //_________________________________________________________________________//
    public function ajaxMoveObjects($mixed_items_to_move, $destination)
    { // mixed item = categories + items
        //case 1: move file, case 2: move folder, case 3: move mixed files and folders
        //http://schlixcms/admin/index.php?page=html&ajax=1&action=ajax_move&item=c3&destination=c5
        global $SystemDB;

        check_csrf_halt_on_error(true);
        // Find parents of the destinations first to avoid relaps
        $pos = strrpos($destination, "_");
        $destination_catnumber = substr($destination, $pos + 1, strlen($destination) - $pos);
        $parent_id_array = $this->getParentIDs($destination_catnumber);

        // Now process the source

        if ($destination[0] == 'i') {
            return ajax_reply(400, ___('Incorrect user operation - an item cannot be set as a destination for move operation'));
        }
        elseif (strpos($mixed_items_to_move, 'folder') > 0) {
            $pos = strrpos($mixed_items_to_move, "_");
            $source_catnumber = substr($mixed_items_to_move, $pos + 1, strlen($mixed_items_to_move) - $pos);
            if ($source_catnumber == $destination_catnumber) {
                return ajax_reply(400, ___('Incorrect user operation - cannot move this folder to the same folder'));
            }
            else

            if (array_search($source_catnumber, $parent_id_array, TRUE) !== false) // April 1, 2010
                return ajax_reply(400, ___('Incorrect user operation - cannot move this folder to its subfolder'));
            else
            {
                $source_catnumber = (int) $source_catnumber;
                $sql = "UPDATE {$this->table_categories} SET parent_id = '{$destination_catnumber}' where cid = '{$source_catnumber}'";
            }
            if ($sql) {
                $SystemDB->query($sql);
                return ajax_reply(200, 'OK');
            }
        }
        else if (strpos($mixed_items_to_move, 'article') > 0) {
            $pos = strrpos($mixed_items_to_move, "_");
            $source_itemnumber = (int) substr($mixed_items_to_move, $pos + 1, strlen($mixed_items_to_move) - $pos);
            $destination_catnumber = (int) $destination_catnumber;
            $sql = "UPDATE  {$this->table_categories_items} SET {$this->field_category_id} = '{$destination_catnumber}' where {$this->field_id} = '{$source_itemnumber}'";
            if ($sql)
                $SystemDB->query($sql);
        }
        else {
            // mixed stuff
            $mixed_items_array = explode(',', $mixed_items_to_move);
            foreach ($mixed_items_array as $mixed_item)
            {
                $current_id = substr($mixed_item, 1); // 11 is the next string after
                if (strpos($mixed_item, 'c') > -1) {
                    $source_catnumbers[] =  (int) $current_id;
                }
                else { // else if it's an item instead
                    $source_itemnumbers[] =  (int) $current_id;
                }
            } // end foreach
            // verify if there's a conflict
            $error = false;
            if ($source_catnumbers)
                foreach ($source_catnumbers as $source_catnumber)
                    if (in_array($source_catnumber, $parent_id_array) || $source_catnumber == $destination_catnumber)
                        $error = true;
            // now update parent_id

            if (!$error) {
                if ($source_catnumbers) {
                    $source_catstrs = implode(",", $source_catnumbers);
                    $destination_catnumber = (int) $destination_catnumber;
                    $sql = "UPDATE {$this->table_categories} SET parent_id = '{$destination_catnumber}' where {$this->field_category_id} in  ({$source_catstrs})";
                    $SystemDB->query($sql);
                }
                // Fix - Dec 6, 2011 - forgot to add if
                if ($source_itemnumbers) {
                    $current_cat_id = $this->getCurrentCategoryIDFromCookie();
                    
                    $source_itemstrs = implode(",", $source_itemnumbers);
                    foreach ($source_itemnumbers as $itm)
                    {
                        
                        $dst_exists = $SystemDB->getQueryResultSingleRow("SELECT * FROM  {$this->table_categories_items} WHERE  {$this->field_id} = :id AND {$this->field_category_id} = :cid", ['id' => $itm, 'cid' => $destination_catnumber]);
                        
                        $src_exists = $SystemDB->getQueryResultSingleRow("SELECT * FROM  {$this->table_categories_items} WHERE  {$this->field_id} = :id AND {$this->field_category_id} = :cid", ['id' => $itm, 'cid' => $current_cat_id]);
                        
                        
                        if ($src_exists && !$dst_exists)
                        {
                            //$SystemLog->Record("Move item ID {$itm} from current category ID {$current_cat_id} to {$destination_catnumber})";
                            $SystemDB->query("UPDATE {$this->table_categories_items} SET {$this->field_category_id} = :dst_cat_id where {$this->field_id} = :id AND  {$this->field_category_id} = :current_category", ['dst_cat_id' => $destination_catnumber, 'id' => $itm, 'current_category' => $current_cat_id]);
                        }
                    }
                     
                }
            if (method_exists($this, 'forceRefreshMenuLinks'))
                $this->forceRefreshMenuLinks();

               return ajax_reply(200, 'OK');
            }
            else
              return  ajax_reply(400, ___('Incorrect user operation - cannot move this folder to its subfolder'));
        } // end mixed stuff
        
    }

    //_________________________________________________________________________//
    public function ajaxGetItemCategoriesByID($id)
    {
        $cats_array = $this->app->getItemCategoryIDsByItemID($id);
        return ajax_reply(200, $cats_array);
    }

    //_________________________________________________________________________//
    public function ajaxSetItemCategory($id, $cid, $state)
    {
        $status = $this->app->setItemCategory($id, $cid, $state == 'true');
        return ajax_reply(200, $status);
    }

    /**
     * Set item categories
     * @param int $id
     * @param array $cid_array
     * @return type
     */
    public function setItemCategories($id, $cid_array)
    {
          return $this->app->setItemCategories($id, $cid_array);
    }
    
    /**
     * Set the primary category of an item
     * @global \SCHLIX\cmsDatabase $SystemDB
     * @param int $id
     * @param int $primary_cid
     * @param string $field_name
     * @return bool
     */
    public function setItemPrimaryCategory($id, $primary_cid)
    {
        return $this->app->setItemPrimaryCategory($id, $primary_cid);
    }
    /**
     * Internal helper function to render category tree in the item editor window
     * @internal
     * @param array $item
     * @param array $datas
     * @param int $parent
     * @param int $depth
     * @param string $ul_css_class
     * @param string $li_css_class
     * @return string
     */
    function viewCategoryTreeList($item, $datas, $parent = 0, $depth = 0, $ul_css_class = '', $li_css_class = '') {
        if ($depth > 100)
            return ''; // limit recursion
        if ($depth > 0)
            $ul_css_class.= ' dropdown-ul';

        $subtree = '';
        $menu_count = ___c($datas);
        for ($i = 0; $i < $menu_count; $i++) {
            if ($datas[$i]['parent_id'] == $parent) {
                
                $childnodes = $this->viewCategoryTreeList($item, $datas, $datas[$i][$this->field_category_id], $depth + 1);
                if ($childnodes)
                    $li_css_class.= ' dropdown-li';
                $subtree .= "<li class=\"{$li_css_class}\">\n";
                $subtree .= $this->viewCategoryTreeList_Item($item, $datas[$i]); //\__HTML::A($datas[$i]['title'], $link, $link_attr);
                $subtree .= $childnodes;
                $subtree .= '</li>' . "\n";
            }
        }
        if ($subtree)
        {
            $tree = \__HTML::UL_start(array('class' => $ul_css_class)) . "\n";
            $tree.= $subtree;
            $tree .= \__HTML::UL_end() . "\n";
        }
        return $tree;
    }
    /**
     * Internal helper function that you can override to display the 
     * individual category in the item editor window     
     * @param array $item
     * @param array $data
     * @return string
     */
    public function viewCategoryTreeList_Item($item, $data)
    {        
        
        $cid = (int) $data[$this->field_category_id];
        $checked = $this->app->isItemInCategoryID($item[$this->field_id], $cid);
        $input = \INPUT::CHECKBOX('__category_ids[]',$cid , $checked, array('data-required-one'=>'required'));
        $icon = '<i class="fa fa-folder" style="color:orange"></i>&nbsp;';
        $text = ___h($data['title']); 
        return \__HTML::DIV_start(array('class'=>'checkbox')).\__HTML::LABEL($icon.$text, $input, false). \__HTML::DIV_end();
    }
    //_________________________________________________________________________//
    public function Run()
    {
        switch (fget_alphanumeric('action'))
        {
            case 'setcategory':
                return ajax_echo($this->ajaxSetItemCategory(fpost_alphanumeric('id'), fpost_alphanumeric('cid'), fpost_bool('state')));
                break;
            case 'getitemcategories': 
                return ajax_echo($this->ajaxGetItemCategoriesByID(intval(fget_int('id'))));
                break;
            default: return parent::Run();
        }
    }

    //_________________________________________________________________________//
}

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
