<?php
if (!defined('SCHLIX_VERSION'))
    die('No Access');

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC, Inc.
// http://www.schlix.com
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

$dt = get_current_datetime();

$date_formats = array(
  'Y-m-d', 'Y/m/d','Y.m.d','Y M d','Y F d',
  'd-m-Y', 'd/m/Y','d.m.Y','d M Y','d F Y','D, d M Y',  'l, d F, Y', 
  'm-d-Y', 'm/d/Y','m.d.Y','M d Y','F d Y','D, M d Y',  'l, F d, Y', 
  );
$time_formats = array(
  'H:i:s','H:i',
  'h:i:s a','h:i a',
  'h:i:s A', 'h:i A');

$opt_date_formats = array();
$opt_time_formats = array();

foreach ($date_formats as $date_format)
    $opt_date_formats[$date_format] = date($date_format);

foreach ($time_formats as $time_format)
    $opt_time_formats[$time_format] = date($time_format);


$mydir = '/macros/displayarticlemeta/';
$view_date_created_filename = CURRENT_THEME_URL_PATH.$mydir.'view.date.created.template.php';
$view_date_modified_filename = CURRENT_THEME_URL_PATH.$mydir.'view.date.modified.template.php';
$view_created_by_filename = CURRENT_THEME_URL_PATH.$mydir.'view.created.by.template.php';
$view_modified_by_filename = CURRENT_THEME_URL_PATH.$mydir.'view.modified.by.template.php';
$view_count_filename = CURRENT_THEME_URL_PATH.$mydir.'view.count.template.php';
?>
<p><?= ___('This macro displays article meta data (date created/modified, created/modified by).') ?></p>
        <!-- begin tabs -->
        <div class="schlixui-tabcontainer">
            <!-- tab navigation -->
            <ul class="schlixui-tabheader">
                <li  class="selected"><a href="#tab1"><em><i class="far fa-clock"></i> <?= ___('Date Created') ?></em></a></li>                
                <li><a href="#tab2"><em><i class="fa fa-user"></i> <?= ___('Created By') ?></em></a></li>
                <li><a href="#tab3"><em><i class="far fa-clock"></i> <?= ___('Date Modified') ?></em></a></li>
                <li><a href="#tab4"><em><i class="fa fa-user"></i> <?= ___('Modified By') ?></em></a></li>
                <li><a href="#tab5"><em><i class="fa fa-calculator"></i> <?= ___('View Count') ?></em></a></li>
                <li><a href="#tab6"><em><i class="fa fa-bullseye"></i> <?= ___('Read More button') ?></em></a></li>
                <li><a href="#tab7"><em><i class="fas fa-link"></i> <?= ___('Permission/Error Checks') ?></em></a></li>
            </ul>
            <!-- end tab navigation -->
            <!-- tab ocntent -->
            <div class="schlixui-tabcontent">
                <!-- tab -->
                <div id ="tab1">
                    <!-- tab content -->
                    <p><?= ___('Display the date/time of when the article was created.') ?></p>
                    <p><?= sprintf(___('You can customize the view template by creating a file in %s'), $view_date_created_filename) ?></p>
                    <div class="row">
                        <div class="col-md-4"><schlix-config:checkbox config-key="bool_date_created_enabled"  label="<?=   ___('Enabled') ?>" /></div>
                        <div class="col-md-4">
                            <schlix-config:dropdownlist  config-key="int_date_created_sort_order" label="<?= ___('Display position order') ?>"   style="max-width:200px" >
                                <?php for ($i = 1; $i <= 6; $i++): ?>
                                    <schlix-config:option value="<?= $i ?>"><?= $i ?></schlix-config:option>
                                <?php endfor; ?>
                            </schlix-config:dropdownlist>                                                         
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4"><schlix-config:textbox config-key="str_date_created_prefix"   label="<?=  ___('Prefix') ?> (<?= ___('e.g.') ?> <?= ___('Created on') ?>)" /></div>
                        <div class="col-md-4"><schlix-config:textbox config-key="str_date_created_css_class"   label="<?=  ___('CSS Class') ?>" config-default-value="article-meta-date-created" /></div>
                        <div class="col-md-4">
                            <schlix-config:dropdownlist  config-key="str_date_created_separator" label="<?= ___('Time and date separator') ?>"  >
                                <schlix-config:option value=" "><?= ___('(space)') ?></schlix-config:option>
                                <schlix-config:option value="/">/</schlix-config:option>
                                <schlix-config:option value="@">@</schlix-config:option>
                                <schlix-config:option value="at"><?= ___('at') ?></schlix-config:option>
                            </schlix-config:dropdownlist>                                                         
                            
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <!-- content -->
                            <schlix-config:radiogroup  config-key="int_date_created_output_position" label="<?= ___('Output Position') ?>" >
                                <schlix-config:option value="0"><?= ___('Before Article') ?></schlix-config:option>
                                <schlix-config:option value="1"><?= ___('After Article') ?></schlix-config:option>
                            </schlix-config:radiogroup>                             
                            <!-- end content -->                            
                        </div>
                        <div class="col-md-4">
                            <!-- content -->
                            <schlix-config:radiogroup  config-key="str_date_created_date_format" label="<?= ___('Date format') ?>" required="required">
                                <?php foreach ($opt_date_formats as $date_format => $description): ?>
                                <schlix-config:option value="<?= ___h($date_format) ?>"><?= ___h($description) ?></schlix-config:option>
                                <?php endforeach ?>
                            </schlix-config:radiogroup> 
                            <!-- end content -->
                        </div>
                        <div class="col-md-4">
                            <!-- content -->
                            <schlix-config:radiogroup  config-key="str_date_created_time_format" label="<?= ___('Time format') ?>" required="required" >
                                <?php foreach ($opt_time_formats as $time_format => $description): ?>
                                <schlix-config:option value="<?= ___h($time_format) ?>"><?= ___h($description) ?></schlix-config:option>
                                <?php endforeach ?>
                            </schlix-config:radiogroup> 
                            <schlix-config:checkbox config-key="bool_date_created_display_time"  label="<?=   ___('Display time') ?>" />
                            
                            <!-- end content -->  
                            
                        </div>
                    </div>
                    <!-- end tab content -->                    
                </div>
                
                <!-- tab -->
                <div id ="tab2">
                    <!-- tab content -->
                    <p><?= ___('Display the original author of an article.') ?></p>
                    <p><?= sprintf(___('You can customize the view template by creating a file in %s'), $view_created_by_filename) ?></p>
                    <div class="row">
                        <div class="col-md-4"><schlix-config:checkbox config-key="bool_created_by_enabled"  label="<?=   ___('Enabled') ?>" /></div>
                        <div class="col-md-4">
                            <schlix-config:dropdownlist  config-key="int_created_by_sort_order" label="<?= ___('Display position order') ?>"   style="max-width:200px" >
                                <?php for ($i = 1; $i <= 6; $i++): ?>
                                    <schlix-config:option value="<?= $i ?>"><?= $i ?></schlix-config:option>
                                <?php endfor; ?>
                            </schlix-config:dropdownlist>                                                         
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-3"><schlix-config:textbox config-key="str_created_by_prefix"   label="'<?=  ___('Prefix') ?> (<?= ___('e.g.') ?> <?= ___('Created by') ?>)'" /></div>
                        <div class="col-md-3"><schlix-config:textbox config-key="str_created_by_css_class"   label="<?=   ___('CSS Class') ?>" config-default-value="article-meta-created-by" /></div>
                        <div class="col-md-3">
                            <schlix-config:checkbox config-key="bool_created_by_display_link"  label="<?=  ___("Display user profile link") ?>" />
                            <schlix-config:checkbox config-key="bool_created_by_display_avatar"  label="<?=  ___("Display user bio (intro) and avatar") ?>" />
                            <p class="small"><?= ___('Please note that if you choose to display the user bio and avatar, it is recommended to adjust the ordering and output position to separate it from the rest of the display') ?></p>
                        </div>
                    </div>
                    
                    <schlix-config:radiogroup config-key="int_created_by_output_position" label="<?= ___('Output Position') ?>" >
                        <schlix-config:option value="0"><?= ___('Before Article') ?></schlix-config:option>
                        <schlix-config:option value="1"><?= ___('After Article') ?></schlix-config:option>
                    </schlix-config:radiogroup>
                    <!-- end tab content -->
                </div>
                <!-- tab -->
                <div id ="tab3">
                    <!-- tab content -->
                    <p><?= ___('Display the date/time of when the article was modified.') ?></p>
                    <p><?= sprintf(___('You can customize the view template by creating a file in %s'), $view_date_modified_filename) ?></p>
                    <div class="row">
                        <div class="col-md-4"><schlix-config:checkbox config-key="bool_date_modified_enabled"  label="<?=   ___('Enabled') ?>" /></div>
                        <div class="col-md-4">
                            <schlix-config:dropdownlist  config-key="int_date_modified_sort_order" label="<?= ___('Display position order') ?>"   style="max-width:200px" >
                                <?php for ($i = 1; $i <= 6; $i++): ?>
                                    <schlix-config:option value="<?= $i ?>"><?= $i ?></schlix-config:option>
                                <?php endfor; ?>
                            </schlix-config:dropdownlist>                                                         
                        </div>
                    </div>
                    

                    <div class="row">
                        <div class="col-md-4"><schlix-config:textbox config-key="str_date_modified_prefix"   label="'<?=  ___('Prefix') ?> (<?= ___('e.g.') ?> <?= ___('Modified on') ?>)'" /></div>
                        <div class="col-md-4"><schlix-config:textbox config-key="str_date_modified_css_class"   label="<?=   ___('CSS Class') ?>" config-default-value="article-meta-date-modified" /></div>
                        <div class="col-md-4"><schlix-config:textbox config-key="str_date_modified_separator"   size="10" maxlength="10" label="<?=   ___('Time and date separator ') ?>" style="width:100px" /></div>
                    </div>
                    


                    <div class="row">
                        <div class="col-md-4">
                            <!-- content -->                           
                            <schlix-config:radiogroup  config-key="int_date_modified_output_position" label="<?= ___('Output Position') ?>" >
                                <schlix-config:option value="0"><?= ___('Before Article') ?></schlix-config:option>
                                <schlix-config:option value="1"><?= ___('After Article') ?></schlix-config:option>
                            </schlix-config:radiogroup> 
                            <!-- content -->
                        </div>
                        <div class="col-md-4">
                            <!-- content -->
                            <schlix-config:radiogroup  config-key="str_date_modified_date_format" label="<?= ___('Date format') ?>" required="required">
                                <?php foreach ($opt_date_formats as $date_format => $description): ?>
                                <schlix-config:option value="<?= ___h($date_format) ?>"><?= ___h($description) ?></schlix-config:option>
                                <?php endforeach ?>
                            </schlix-config:radiogroup> 
                            <!-- end content -->
                        </div>
                        <div class="col-md-4">
                            <!-- content -->
                            <schlix-config:radiogroup  config-key="str_date_modified_time_format" label="<?= ___('Time format') ?>" required="required">
                                <?php foreach ($opt_time_formats as $time_format => $description): ?>
                                <schlix-config:option value="<?= ___h($time_format) ?>"><?= ___h($description) ?></schlix-config:option>
                                <?php endforeach ?>
                            </schlix-config:radiogroup> 
                            <schlix-config:checkbox config-key="bool_date_modified_display_time"  label="<?=   ___('Display time') ?>" />                            
                            <!-- end content -->        
                        </div>
                    </div>
                    
                    <!-- end tab content -->
                </div>
                <!-- tab -->
                <div id ="tab4">
                    <!-- tab content -->
                    <p><?= ___('Display the last author of an article.') ?></p>
                    <p><?= sprintf(___('You can customize the view template by creating a file in %s'), $view_modified_by_filename) ?></p>
                    <div class="row">
                        <div class="col-md-4"><schlix-config:checkbox config-key="bool_modified_by_enabled"  label="<?=   ___('Enabled') ?>" /></div>
                        <div class="col-md-4">
                            <schlix-config:dropdownlist  config-key="int_modified_by_sort_order" label="<?= ___('Display position order') ?>"   style="max-width:200px" >
                                <?php for ($i = 1; $i <= 6; $i++): ?>
                                    <schlix-config:option value="<?= $i ?>"><?= $i ?></schlix-config:option>
                                <?php endfor; ?>
                            </schlix-config:dropdownlist>                                                         
                        </div>
                    </div>
                    
                    <div class="row">
                        
                        <div class="col-md-4"><schlix-config:textbox config-key="str_modified_by_prefix"   label="'<?=  ___('Prefix') ?> (<?= ___('e.g.') ?> <?= ___('Modified by') ?>)'" /></div>
                        <div class="col-md-4"><schlix-config:textbox config-key="str_modified_by_css_class"   label="<?=   ___('CSS Class') ?>" config-default-value="article-meta-modified-by" /></div>
                        <div class="col-md-4">
                            <schlix-config:checkbox config-key="bool_modified_by_display_link"  label="<?=  ___("Display user profile link") ?>" />
                            <schlix-config:checkbox config-key="bool_modified_by_display_avatar"  label="<?=  ___("Display user bio (intro) and avatar") ?>" />                            
                            <p class="small"><?= ___('Please note that if you choose to display the user bio and avatar, it is recommended to adjust the ordering and output position to separate it from the rest of the display') ?></p>
                        </div>
                    </div>
                    
                    <schlix-config:radiogroup config-key="int_modified_by_output_position" label="<?= ___('Output Position') ?>" >
                        <schlix-config:option value="0"><?= ___('Before Article') ?></schlix-config:option>
                        <schlix-config:option value="1"><?= ___('After Article') ?></schlix-config:option>
                    </schlix-config:radiogroup>                    
                    <!-- end tab content -->
                </div>
                <!-- tab -->
                <div id ="tab5">
                    <!-- tab content -->
                    <p><?= ___('Display the view count of an article.') ?></p>
                    <p><?= sprintf(___('You can customize the view template by creating a file in %s'), $view_count_filename) ?></p>
                    <div class="row">
                        <div class="col-md-4"><schlix-config:checkbox config-key="bool_view_count_enabled"  label="<?=   ___('Enabled') ?>" /></div>
                        <div class="col-md-4">
                            <schlix-config:dropdownlist  config-key="int_view_count_sort_order" label="<?= ___('Display position order') ?>"   style="max-width:200px" >
                                <?php for ($i = 1; $i <= 6; $i++): ?>
                                    <schlix-config:option value="<?= $i ?>"><?= $i ?></schlix-config:option>
                                <?php endfor; ?>
                            </schlix-config:dropdownlist>                                                         
                        </div>
                    </div>
                    <schlix-config:textbox config-key="str_view_count_prefix"   label="'<?=  ___('Prefix') ?> (<?= ___('e.g.') ?> <?= ___('View Count') ?>)'" style="width:300px" />
                    <schlix-config:textbox config-key="str_view_count_css_class"   label="<?=   ___('CSS Class') ?>" config-default-value="article-meta-view-count" />
                    <schlix-config:radiogroup config-key="int_output_position" label="<?= ___('Output Position') ?>" >
                        <schlix-config:option value="0"><?= ___('Before Article') ?></schlix-config:option>
                        <schlix-config:option value="1"><?= ___('After Article') ?></schlix-config:option>
                        <schlix-config:option value="2"><?= ___('Top of the article') ?></schlix-config:option>
                        <schlix-config:option value="3"><?= ___('Bottom of the article') ?></schlix-config:option>
                    </schlix-config:radiogroup>                    
                    <!-- end tab content -->
                    
                </div>
                <!-- tab -->
                <div id ="tab6">
                    <!-- tab content -->
                    <p><?= ___('Displays read more button to an article in a listing.') ?></p>                    
                    <div class="row">
                        <div class="col-md-4"><schlix-config:checkbox config-key="bool_readmore_enabled"  label="<?=   ___('Enabled') ?>" /></div>
                        <div class="col-md-4">
                            <schlix-config:dropdownlist  config-key="int_read_more_sort_order" label="<?= ___('Display position order') ?>"   style="max-width:200px" >
                                <?php for ($i = 1; $i <= 6; $i++): ?>
                                    <schlix-config:option value="<?= $i ?>"><?= $i ?></schlix-config:option>
                                <?php endfor; ?>
                            </schlix-config:dropdownlist>                                                         
                        </div>
                    </div>
                    <schlix-config:textbox config-key="str_readmore_css_class"   label="<?=   ___('CSS Class') ?>" config-default-value="btn btn-primary" />
                    <label><?=  ___('Button Font Icon') ?><br />
                    <schlix-config:fonticon config-key="str_readmore_button_icon" class="btn btn-default"  />                 
                    </label>
                    <schlix-config:textbox config-key="str_readmore_button_text"   label="<?=  ___('Button Text. e.g. Read More ') ?>" style="width:300px" />                    
                    <!-- end tab content -->
                </div>
                <!-- tab -->
                <div id ="tab7">
                    <!-- tab content -->
                    <p><?= ___('This is the CSS wrapper class used by to highlight errors (e.g. invalid article view permission, expired articles, unpublished articles, etc)') ?></p>
                    <schlix-config:textbox config-key="str_permission_css_class"   label="<?=   ___('CSS Class') ?>" config-default-value="alert alert-danger" />
                    
                    <!-- end tab content -->                    
                </div>
                <!-- tab -->
            </div>
        </div>

        