<?php
if (!defined('SCHLIX_VERSION')) die('No Access'); // this protection line must exist in all template files
/**
 * Company Profile - theme
 * 
 * This is an example of company profile theme for SCHLIX CMS v2.2.x.

The view templates inside the apps and blocks  folder in this theme provide  you with ample amount of customization.
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package companyprofile
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */

// this will retrieve the custom header image
$header_img = \App\Core_MediaHeader::getCustomHeaderByGUID($this, $category['guid']);
?>
<?php 
    $field_cid = $this->getFieldCategoryID();
    $field_id = $this->getFieldID();
?>
<div class="app-page-category app-<?= $this->app_name; ?>" id="app-<?= $this->app_name; ?>-category-<?= $category[$field_cid]; ?>" >   
    <?= isset($category['macro_processed_text_outside_article_top']) ? $category['macro_processed_text_outside_article_top'] : null ?>    
    <!-- ########################################################################### -->
    <!-- ####################### main info of this category  ####################### -->
    <!-- ########################################################################### -->
    <article class="main category">
	<?php if ($category_meta_options['display_pagetitle']): ?>
        <!-- Page Title with custom background image -->
        <div class="media-header-full-width " style="background-image: url('<?= $header_img ?>');">
            <div class="media-header-title container d-flex h-100">
                <div class="row align-self-center w-100">
                    <div class="col-8 mx-auto">
                        <div class="text-center">
                            <h1 class="item title" itemprop="headline"><?= ___h($category['title']); ?></h1>
                        </div>
                    </div>
                </div>                
            </div>
        </div>
        <!-- End Page Title -->
        <!-- breadcrumb -->
        <!-- the breadcrumb has been moved from the main theme template file to the individual app's as an example of different variation -->
        <div class="breadcrumb-bg">
            <div class="container">
                <?= \SCHLIX\cmsPageOutput::BreadCrumbs(); ?>
            </div>
        </div>
        <!-- end breadcrumb -->
        
        <?php endif; ?>
        <?php if ($category['macro_processed_text_before_article']): ?>        
        <!-- Macro - Pre -->            
            <div class="meta before-article">        
            <?= $category['macro_processed_text_before_article'] ?>            
            </div>
        <!-- End Macro - Pre -->        
        <?php endif ?>
        <div class="text">
            <?= $category['summary'].$category['description'] ?>
        </div>
        <?php if (isset($category['macro_processed_text_after_article'])): ?>
        <!-- Macro - Post -->                
            <div class="meta after-article">
                <?= $category['macro_processed_text_after_article'] ?>
            </div>
        <?php endif ?>
        <!-- End Macro - Post -->                
    </article>
    <!-- ########################################################################### -->
    <!-- ######################## end info of this category  ####################### -->
    <!-- ########################################################################### -->

    <?php if ($child_categories && $category_meta_options['display_child_categories']): ?>
    <!-- ########################################################################### -->
    <!-- ################## child categories / subfolder ########################### -->
    <!-- ########################################################################### -->
        <div class="category child categories">
            <?php foreach ($child_categories as $child_category): ?>
                <?php if ($child_category['status'] > 0): ?>            
                <section class="child-category">
                    <?= $child_category['macro_processed_text_outside_article_top'] ?>
                    <?php 
                        $child_category_id = $child_category[$field_cid];
                        $this->processDataOutputWithMacro($child_category, 'viewChildCategory', array('parent_category_meta_options' => $category_meta_options));
                        $link = $this->createFriendlyURL("action=viewcategory&cid={$child_category_id}");
                        $child_category_title = ___h($child_category['title']);
                        $child_category_title_text = ($child_category!= null) && ($category_meta_options['display_child_category_read_more_link']==false || $category_meta_options['display_link_title']==true) ? 
                            \__HTML::A($child_category_title,$link) : $child_category_title;
                        
                    ?>
                    <?php if ($child_category_title_text): ?>
                        <h2 class="category title"><i class="fas fa-folder"></i> <?= $child_category_title_text; ?></h2>
                    <?php endif ?>
                    <!-- Macro - Pre -->
                    <?php if ($child_category['macro_processed_text_before_article']): ?>        
                        <div class="meta before-article">        
                            <?= $child_category['macro_processed_text_before_article'] ?>            
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Pre -->

                    <!-- text -->
                    <?php if ($category_meta_options['display_child_category_summary']): ?>
                        <div class="text">
                            <?= $child_category['summary'] ?>
                        </div>
                    <?php endif; ?>
                    <!-- end text -->

                    <!-- Macro - Post -->   
                    <?php if ($child_category['macro_processed_text_after_article']): ?>                
                        <div class="meta after-article">
                            <?= $child_category['macro_processed_text_after_article'] ?>
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Post -->                
                    <?= $child_category['macro_processed_text_outside_article_bottom'] ?>
                </section>
                <?php endif ?>
            <?php endforeach ?>       
        </div>
    <!-- ########################################################################### -->
    <!-- ################## end child categories / subfolder ####################### -->
    <!-- ########################################################################### -->
    <?php endif; ?>

    <?php if ($items && $category_meta_options['display_items']):  ?>
    <!-- ########################################################################### -->
    <!-- ########################## child items #################################### -->
    <!-- ########################################################################### -->
       <div class="category child items">
            <?php foreach ($items as $child_item): ?>
                <?php if ($child_item['status'] > 0): ?>            
                <section class="child-item" itemscope="1" itemtype="http://schema.org/<?= $this->schema_org_type_item; ?>">    
                    <?= isset($child_item['macro_processed_text_outside_article_top']) ? $child_item['macro_processed_text_outside_article_top'] : null ?>
                    <?php 
                        $child_item_id = $child_item[$field_id];
                        $this->processDataOutputWithMacro($child_item, 'viewChildItem', array('parent_category_meta_options' => $category_meta_options));
                        $link = $this->createFriendlyURL("action=viewitem&id={$child_item_id}");
                        $child_item_title = ___h($child_item['title']);
                        $child_item_title_text = ($child_item != null) && ($category_meta_options['display_child_item_read_more_link']==false || $category_meta_options['display_link_title']==true) ? 
                            \__HTML::A($child_item_title,$link) : $child_item_title;
                        
                    ?>
                    <?php if ($child_item_title_text): ?>
                        <h2 class="item title" itemprop="headline"><i class="fas fa-file"></i> <?= $child_item_title_text; ?></h2>
                    <?php endif ?>
                    <!-- Macro - Pre -->
                    <?php if ($child_item['macro_processed_text_before_article']): ?>        
                        <div class="meta before-article">        
                            <?= $child_item['macro_processed_text_before_article'] ?>            
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Pre -->

                    <!-- text -->
                    <?php if ($category_meta_options['display_item_summary']): ?>
                        <div class="text">
                            <?= $child_item['summary'] ?>
                        </div>
                    <?php endif; ?>
                    <!-- end text -->

                    <!-- Macro - Post -->   
                    <?php if (isset($child_item['macro_processed_text_after_article'])): ?>                
                        <div class="meta after-article">
                            <?= $child_item['macro_processed_text_after_article'] ?>
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Post -->     
                    <?= $child_item['macro_processed_text_outside_article_bottom'] ?>
                </section>
                <?php endif ?>
            <?php endforeach ?>       
        </div>     
    <!-- ########################################################################### -->
    <!-- ####################### end child items ################################### -->
    <!-- ########################################################################### -->
    <?php endif; ?>
    <!-- pagination -->
    <?php $pagination_str = $this->displayItemPagination($pg,$pagination['total'],"action=viewcategory&cid={$category['cid']}"); ?>
    <?php if ($pagination_str && ($category_meta_options['display_child_categories'] || $category_meta_options['display_items'])): ?>
        <div class="pagination"><?= $pagination_str; ?></div>
    <?php endif?>
    <!-- end pagination -->
    <?= $category['macro_processed_text_outside_article_bottom'] ?>
</div>