<?php
if (!defined('SCHLIX_VERSION')) die('No Access'); // this protection line must exist in all template files
/**
 * beritanews - theme for SCHLIX CMS
 *
 * License: MIT
 *  
 * @copyright 2020 SCHLIX Web Inc
 * @license MIT
 * @version 1.0
 * @link    https://www.schlix.com
 */

if (!defined('SCHLIX_VERSION'))
  die('No Access');

  global $CurrentUser;
?>


<section id="<?= $this->block_name; ?>" class="section-row news-section">
  <div class="container">
    <div class="news-block">
      <div class="news-block__heading">
        <h3><?= $block_title; ?></h3>
      </div>
      <div class="news-block__content">
        <div class="row">
          <?php for ($i = 0; $i < $max_entries; $i++): ?>
            <?php
            $item = $items[$i];

            $entry = $item['date_created'];
            // you can customize your own stuff here
            $link = $blog->createFriendlyURL("action=viewitem&id={$item['id']}");
            $entrydate = date("j.M.Y", strtotime($item['date_created']));
            $entrytitle = $item['title'];
            /* <li><?= $entrydate; ?><br /><a href="<?= $link; ?>"><?= ___h($entrytitle); ?></a></li> */

            $secondary_headline = $this->getArticleExcerptFromObjectArray($item, 'summary_secondary_headline', 'summary', 240);

            //$thumb_filename = $item['summary_intro_image'] ? $blog->getDataFileURLPath('image_small', $item['summary_intro_image']) : '';
            $thumb_filename = $blog->getBlogImage('image_small', $item['summary_intro_image']);

            $caption_text = empty($item['summary_intro_image_caption']) ? $item['title'] : $item['summary_intro_image_caption'];
            
            ?>

            <?php if ($item['status'] == 1 && $CurrentUser->hasReadPermission($item['permission_read']) && ( $item['date_expiry'] == NULL || $item['date_expiry'] == NULL_DATE || days_difference_from_today($item['date_expiry']) > 0 )): ?>
              <div class="col-xs-12 col-sm-6 <?= $this->css_class_div ?  $this->css_class_div : 'col-md-4' ?>">
                <div class="news-row news-row--col">

                  <div class="news-row__images overlay-images">
                      <a href="<?= $link ?>" title="<?= ___h($caption_text) ?>">
                    <img src="<?= $thumb_filename ?>" title="<?= ___h($caption_text) ?>" alt="<?= ___h($caption_text) ?>" />
                    </a>
                  </div>
                  <div class="news-row__title">
                      <h4><a href="<?= ___h($link) ?>" title="<?= ___h($entrytitle) ?>"><?= ___h($entrytitle) ?></a></h4>
                  </div>
                  <div class="news-row__text">
                    <p>
                      <?= $secondary_headline ?>
                    </p>
                  </div>
                </div>
              </div>
            <?php endif; ?>
          <?php endfor; ?>
        </div>
      </div>
    </div>
  </div>
</section>
