<?php
//    MyDMS. Document Management System
//    Copyright (C) 2002-2005  Markus Westphal
//    Copyright (C) 2006-2008 Malcolm Cowe
//    Copyright (C) 2010 Matteo Lucarelli
//    Copyright (C) 2011-2013 Uwe Steinmann
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//    Translators: Admin (2547), archonwang (3), dgrutsch (9), netixw (14)

$text = array(
'2_factor_auth' => '2-factor authentication',
'2_factor_auth_code' => '2nd factor',
'2_factor_auth_info' => 'This system enforces 2 factor authentication. You will need an Authenticator on your mobile phone. Below you see two QR codes. The right one is your current secret. On the left you can set a new secret. If you set a new secret make sure to rescan it with your preffered authenticator, e.g. andOTP.',
'2_fact_auth_current_secret' => 'Current secret',
'2_fact_auth_new_secret' => 'New secret',
'2_fact_auth_secret' => 'Secret',
'abbr_day' => 'd',
'abbr_hour' => 'h',
'abbr_minute' => 'min',
'abbr_month' => 'M',
'abbr_second' => 's',
'abbr_week' => 'wk',
'abbr_year' => 'Y',
'accept' => 'Accept',
'access_control' => 'Access control',
'access_control_is_off' => 'Advanced access control is turned off',
'access_denied' => 'Access denied.',
'access_inheritance' => 'Access Inheritance',
'access_mode' => 'Access mode',
'access_mode_all' => 'All permissions',
'access_mode_none' => 'No access',
'access_mode_read' => 'Read permissions',
'access_mode_readwrite' => 'Read-Write permissions',
'according_settings' => 'according settings',
'action' => 'Action',
'actions' => 'Actions',
'action_approve' => 'Approve',
'action_complete' => 'Complete',
'action_is_complete' => 'Is complete',
'action_is_not_complete' => 'Is not complete',
'action_reject' => 'Reject',
'action_review' => 'Review',
'action_revise' => 'Revise',
'add' => 'Add',
'add_approval' => 'Add approval',
'add_attrdefgroup' => 'Add new attribute group',
'add_document' => 'Add document',
'add_document_link' => 'Add link',
'add_document_notify' => 'Assign notification',
'add_doc_reviewer_approver_warning' => 'N.B. Documents are automatically marked as released if no reviewer or approver is assigned.',
'add_doc_workflow_warning' => 'N.B. Documents are automatically marked as released if no workflow is assigned.',
'add_event' => 'Add event',
'add_group' => 'Add new group',
'add_member' => 'Add a member',
'add_multiple_documents' => 'Add multiple documents',
'add_multiple_files' => 'Add multiple files (will use filename as document name)',
'add_receipt' => 'Acknowledge reception',
'add_review' => 'Add review',
'add_revision' => 'Add revision',
'add_role' => 'Add new role',
'add_subfolder' => 'Add subfolder',
'add_task' => 'Add new task for this class',
'add_to_clipboard' => 'Add to clipboard',
'add_to_transmittal' => 'Add to transmittal',
'add_transmittal' => 'Add transmittal',
'add_user' => 'Add new user',
'add_user_to_group' => 'Add user to group',
'add_workflow' => 'Add new workflow',
'add_workflow_action' => 'Add new workflow action',
'add_workflow_state' => 'Add new workflow state',
'admin' => 'Administrator',
'admin_tools' => 'Admin tools',
'all' => 'All',
'all_categories' => 'All categories',
'all_documents' => 'All Documents',
'all_pages' => 'All',
'all_users' => 'All users',
'already_subscribed' => 'Already subscribed',
'and' => 'and',
'any_value_set' => 'any value',
'apikey' => 'API key',
'apply' => 'Apply',
'approvals_accepted' => '[no_approvals] approvals already accepted',
'approvals_accepted_latest' => '(being [no_approvals] in latest version)',
'approvals_and_reviews_accepted' => '[no_approvals] approvals and [no_reviews] reviews already accepted',
'approvals_and_reviews_not_touched' => '[no_approvals] approvals and [no_reviews] reviews not being touched',
'approvals_and_reviews_rejected' => '[no_approvals] approvals and [no_reviews] reviews already rejected',
'approvals_not_touched' => '[no_approvals] approvals not being touched',
'approvals_not_touched_latest' => '(being [no_approvals] in latest version)',
'approvals_rejected' => '[no_approvals] approvals already rejected',
'approvals_rejected_latest' => '(being [no_approvals] in latest version)',
'approvals_without_group' => 'Approvals without group',
'approvals_without_user' => 'Approvals without user',
'approval_deletion_email' => 'Approval request deleted',
'approval_deletion_email_body' => 'Approval request deleted

Document: [name]
Version: [version]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'approval_deletion_email_body_html' => '<p>Approval request deleted</p>

<p>Document: [name]<br />
Version: [version]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'approval_deletion_email_subject' => '[sitename]: [name] - Approval request deleted',
'approval_file' => 'File',
'approval_group' => 'Approval Group',
'approval_log' => 'Approval log',
'approval_request_email' => 'Approval request',
'approval_request_email_body' => 'Approval request

Document: [name]
Version: [version]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'approval_request_email_body_html' => '<p>Approval request</p>

<p>Document: [name]<br />
Version: [version]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'approval_request_email_subject' => '[sitename]: [name] - Approval request',
'approval_status' => 'Approval Status',
'approval_submit_email' => '',
'approval_submit_email_body' => 'Approval of document

Document: [name]
Version: [version]
Parent folder: [folder_path]
Status: [status]
Comment: [comment]
User: [username]
URL: [url]',
'approval_submit_email_body_html' => '<p>Approval of document</p>

<p>Document: [name]<br />
Version: [version]<br />
Parent folder: [folder_path]<br />
Status: [status]<br />
Comment: [comment]<br />
User: [username]<br />
URL: [url]</p>',
'approval_submit_email_subject' => '[sitename]: [name] - Approval submitted',
'approval_summary' => 'Approval Summary',
'approval_update_failed' => 'Error updating approval status. Update failed.',
'approvers' => 'Approvers',
'approver_already_assigned' => 'User is already assigned as an approver.',
'approver_already_removed' => 'Approver has already been removed from approval process or has already submitted an approval.',
'april' => 'April',
'archive' => 'Archive',
'archive_creation' => 'Archive creation',
'archive_creation_warning' => 'With this operation you can create archive containing the files of entire DMS folders. After the creation the archive will be saved in the data folder of your server.<br>WARNING: an archive created as human readable will be unusable as server backup.',
'ar_EG' => 'Arabic',
'assign_approvers' => 'Assign Approvers',
'assign_recipients' => 'Assign Recipients',
'assign_reviewers' => 'Assign Reviewers',
'assign_user_property_to' => 'Assign user\'s properties to',
'assumed_released' => 'Assumed released',
'attrdefgroup_management' => 'Attribute groups managament',
'attrdefgrp_show_detail' => 'Details',
'attrdefgrp_show_list' => 'List',
'attrdefgrp_show_search' => 'Search',
'attrdefgrp_show_searchlist' => 'Search result',
'attrdef_exists' => 'Attribute definition already exists',
'attrdef_info' => 'Information',
'attrdef_invalid_regex' => 'Invalid regular expression',
'attrdef_in_use' => 'Attribute definition still in use',
'attrdef_management' => 'Attribute definition management',
'attrdef_maxvalues' => 'Max. number of values',
'attrdef_minvalues' => 'Min. number of values',
'attrdef_minvalues_help' => 'Minimum number of values. Set to 1 if attribute must be set.',
'attrdef_min_greater_max' => 'Minimum number of values is larger than maximum number of values',
'attrdef_multiple' => 'Allow multiple values',
'attrdef_multiple_but_doc_or_folder' => 'Attributes of type document or folder cannot have multiple values.',
'attrdef_multiple_needs_valueset' => 'Attribute definition with multiple values needs value set.',
'attrdef_must_be_multiple' => 'Attribute must have more than one value, but is not set multiple value',
'attrdef_name' => 'Name',
'attrdef_noname' => 'Missing name for attribute definition',
'attrdef_objtype' => 'Object type',
'attrdef_regex' => 'Regular expression',
'attrdef_regex_help' => 'Regular expression which must match the attribute value if type is string.',
'attrdef_type' => 'Type',
'attrdef_type_boolean' => 'Boolean',
'attrdef_type_date' => 'Date',
'attrdef_type_document' => 'Document',
'attrdef_type_email' => 'Email',
'attrdef_type_float' => 'Float',
'attrdef_type_folder' => 'Folder',
'attrdef_type_group' => 'Group',
'attrdef_type_int' => 'Integer',
'attrdef_type_string' => 'String',
'attrdef_type_url' => 'URL',
'attrdef_type_user' => 'User',
'attrdef_valueset' => 'Set of values',
'attrdef_valueset_help' => 'A list of values separated by an arbitrary char, which also must be the first char of this string, e.g. #yes#no#maybe',
'attributes' => 'Attributes',
'attribute_changed_email_body' => 'Attribute changed

Document: [name]
Version: [version]
Attribute: [attribute_name]
Old value: [attribute_old_value]
New value: [attribute_new_value]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'attribute_changed_email_body_html' => '<p>Attribute changed</p>

<p>Document: [name]<br />
Version: [version]<br />
Attribute: [attribute_name]<br />
Old value: [attribute_old_value]<br />
New value: [attribute_new_value]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'attribute_changed_email_subject' => '[sitename]: [name] - Attribute changed',
'attribute_count' => 'Number of uses',
'attribute_value' => 'Value of attribute',
'attribute_value_not_in_valueset' => 'Value not in value set',
'attr_malformed_boolean' => 'The attribute value \'[value]\' of attribute \'[attrname]\' is not a valid boolean.',
'attr_malformed_date' => 'The attribute value \'[value]\' of attribute \'[attrname]\' is not a valid date.',
'attr_malformed_email' => 'The attribute value \'[value]\' of attribute \'[attrname]\' is not a valid email.',
'attr_malformed_float' => 'The attribute value \'[value]\' of attribute \'[attrname]\' is not a valid float.',
'attr_malformed_int' => 'The attribute value \'[value]\' of attribute \'[attrname]\' is not a valid integer.',
'attr_malformed_url' => 'The attribute value \'[value]\' of attribute \'[attrname]\' is not a valid URL.',
'attr_max_values' => 'The maximum number of required values for attribute [attrname] is exceeded.',
'attr_min_values' => 'The minimum number of required values for attribute [attrname] is not reached.',
'attr_not_in_valueset' => 'The attribute value \'[value]\' for attribute \'[attrname]\' is not contained in the valueset.',
'attr_no_regex_match' => 'The attribute value \'[value]\' for attribute \'[attrname]\' does not match the regular expression \'[regex]\'',
'attr_validation_error' => 'The value \'[value]\' of attribute \'[attrname]\' is invalid.',
'at_least_n_users_of_group' => 'At least [number_of_users] users of [group]',
'august' => 'August',
'authentication' => 'Authentication',
'authentication_failed' => 'Authentication failed',
'author' => 'Author',
'automatic_status_update' => 'Automatic status change',
'back' => 'Go back',
'backup_list' => 'Existing backups',
'backup_log_management' => 'Backup/Logging',
'backup_remove' => 'Remove backup file',
'backup_tools' => 'Backup tools',
'batch_add_approver' => 'Add approver',
'batch_add_approver_msg' => 'Added approver \'[name]\' to [count] documents.',
'batch_add_category_msg' => 'Added a new category \'[catname]\' to [count] documents.',
'batch_add_reviewer' => 'Add reviewer',
'batch_add_reviewer_msg' => 'Added reviewer \'[name]\' to [count] documents.',
'batch_change_category' => 'Change category',
'batch_change_owner' => 'Change owner',
'batch_export' => 'Export',
'batch_new_owner_msg' => 'The owner of [count] documents has been changed.',
'batch_operation' => 'Batch operation',
'batch_operation_result' => 'Result of batch operation',
'batch_remove_category' => 'Remove category',
'batch_remove_category_msg' => 'Removed category \'[catname]\' from [count] documents.',
'between' => 'between',
'bg_BG' => 'Bulgarian',
'browse' => 'Browse',
'calendar' => 'Calendar',
'calendar_events_mail_subject' => 'Upcomming events',
'calendar_week' => 'Calendar week',
'cancel' => 'Cancel',
'cancel_checkout' => 'Cancel checkout',
'cancel_checkout_document' => 'Cancel checkout',
'cancel_checkout_warning' => 'The check out can be canceled thought the checked out file has been changed. In that case the file will be deleted from the check out space and your modification will be lost.',
'cannot_assign_invalid_state' => 'Cannot modify an obsolete or rejected document',
'cannot_change_final_states' => 'Warning: You cannot alter status for document rejected, expired or with pending review or approval',
'cannot_delete_user' => 'Cannot delete user',
'cannot_delete_yourself' => 'Cannot delete yourself',
'cannot_move_root' => 'Error: Cannot move root folder.',
'cannot_retrieve_approval_snapshot' => 'Unable to retrieve approval status snapshot for this document version.',
'cannot_retrieve_review_snapshot' => 'Unable to retrieve review status snapshot for this document version.',
'cannot_revapp_expired_docs' => 'The document cannot be reviewer or approved anymore, because it already expired.',
'cannot_rm_root' => 'Error: Cannot delete root folder.',
'cannot_transfer_your_objects' => 'You cannot transfer your own objects',
'categories' => 'Categories',
'categories_loading' => 'Please wait, until the list of categories is loaded …',
'category' => 'Category',
'category_exists' => 'Category already exists.',
'category_filter' => 'Categories',
'category_info' => 'Information',
'category_in_use' => 'This category is currently used by documents.',
'category_noname' => 'No category name given.',
'ca_ES' => 'Catalan',
'changelog_loading' => 'Please wait, until the change log is loaded …',
'change_assignments' => 'Set reviewer/approver',
'change_password' => 'Change password',
'change_password_message' => 'Your password has been changed.',
'change_recipients' => 'Set recipients',
'change_revisors' => 'Set revisors',
'change_status' => 'Change Status',
'charts' => 'Charts',
'chart_docsaccumulated_title' => 'Number of documents',
'chart_docspercategory_title' => 'Documents per category',
'chart_docspermimetype_title' => 'Documents per mime-type',
'chart_docspermonth_title' => 'New documents per month',
'chart_docsperstatus_title' => 'Documents per status',
'chart_docsperuser_title' => 'Documents per user',
'chart_foldersperuser_title' => 'Folders per user',
'chart_selection' => 'Select chart',
'chart_sizepermonth_title' => 'Disk space per month',
'chart_sizeperuser_title' => 'Disk space per user',
'checkedout_file_has_different_version' => 'The checked out version is not identical to the current version. Check in will not update the document.',
'checkedout_file_has_disappeared' => 'The file of the checked out document has disappeared. Check in will not be possible.',
'checkedout_file_is_unchanged' => 'The file of the checked out document is still unchanged. Check in will not be possible. If you do not plan any modifications, you can reset the check out status.',
'checkin_document' => 'Check In',
'checkoutpath_does_not_exist' => 'Checkout path does not exists',
'checkout_cancel_confirm' => 'Confirm to cancel checkout',
'checkout_document' => 'Check out',
'checkout_is_disabled' => 'Check out of documents is disabled in the configuration.',
'check_directory_layout' => 'Check directory layout',
'check_failed' => 'failed',
'check_notification_filter' => 'Check notification filter',
'check_passed' => 'passed',
'check_secure_installation' => 'Check for a secure installation',
'choose_attrdef' => 'Please choose attribute definition',
'choose_attrdefgroup' => 'Choose attribute group',
'choose_category' => 'Please choose',
'choose_group' => 'Choose group',
'choose_link_type' => 'Choose link type',
'choose_role' => 'Choose role',
'choose_target_category' => 'Choose category',
'choose_target_document' => 'Choose document',
'choose_target_file' => 'Choose file',
'choose_target_folder' => 'Choose folder',
'choose_user' => 'Choose user',
'choose_workflow' => 'Choose workflow',
'choose_workflow_action' => 'Choose workflow action',
'choose_workflow_state' => 'Choose workflow state',
'class_finfo_missing' => 'The class finfo will be used when files are uploading for determine the mimetype.',
'class_name' => 'Name of class',
'clear_cache' => 'Clear cache',
'clear_clipboard' => 'Clear clipboard',
'clear_password' => 'Clear password',
'click_to_expand_filter_results' => 'Click to expand filter check',
'clipboard' => 'Clipboard',
'close' => 'Close',
'color' => 'Color',
'command' => 'Command',
'comment' => 'Comment',
'comment_changed_email' => '',
'comment_for_current_version' => 'Version comment',
'configure_extension' => 'Configure extension',
'confirm_add_approver' => 'Please confirm adding the approver to the selected documents.',
'confirm_add_reviewer' => 'Please confirm adding the reviewer to the selected documents.',
'confirm_change_category' => 'Please confirm changing the category of the selected documents.',
'confirm_change_owner' => 'Please confirm changing the owner of the selected objects.',
'confirm_clear_cache' => 'Would you really like to clear the cache? This will remove all precalculated preview images, javascript and other files.',
'confirm_create_fulltext_index' => 'Yes, I would like to recreate the fulltext index!',
'confirm_move_document' => 'Please confirm moving the document.',
'confirm_move_folder' => 'Please confirm moving the folder.',
'confirm_pwd' => 'Confirm Password',
'confirm_rm_attr_value' => 'Do you really want to delete the attribute value?',
'confirm_rm_backup' => 'Do you really want to remove the file "[arkname]"?<br>Be careful: This action cannot be undone.',
'confirm_rm_document' => 'Do you really want to remove the document \'[documentname]\'?<br>Be careful: This action cannot be undone.',
'confirm_rm_dump' => 'Do you really want to remove the file "[dumpname]"?<br>Be careful: This action cannot be undone.',
'confirm_rm_event' => 'Do you really want to remove event "[name]"?<br>Be careful: This action cannot be undone.',
'confirm_rm_file' => 'Do you really want to remove file "[name]" of document "[documentname]"?<br>Be careful: This action cannot be undone.',
'confirm_rm_folder' => 'Do you really want to remove the folder \'[foldername]\' and its content?<br>Be careful: This action cannot be undone.',
'confirm_rm_folder_files' => 'Do you really want to remove all the files of the folder "[foldername]" and of its subfolders?<br>Be careful: This action cannot be undone.',
'confirm_rm_group' => 'Do you really want to remove the group "[groupname]"?<br>Be careful: This action cannot be undone.',
'confirm_rm_log' => 'Do you really want to remove log file "[logname]"?<br>Be careful: This action cannot be undone.',
'confirm_rm_task' => 'Please confirm the removal of this task.',
'confirm_rm_transmittal' => 'Please confirm the deletion of the transmittal.',
'confirm_rm_transmittalitem' => 'Confirm removal',
'confirm_rm_user' => 'Do you really want to remove the user "[username]"?<br>Be careful: This action cannot be undone.',
'confirm_rm_user_from_processes' => 'Do you really want to remove the user "[username]" from all processes?<br>Be careful: This action can lead to the release of documents if the user was the only or last approver.',
'confirm_rm_version' => 'Do you really want to remove version [version] of document "[documentname]"?<br>Be careful: This action cannot be undone.',
'confirm_transfer_link_document' => 'Select if you would like to link the dragged document or transfer its content to the target document as a new version. Only documents with excactly one version can be transferred. The dragged document will be removed afterwards.',
'confirm_transfer_objects' => 'Do you really want to transfer the documents, folders, etc. of the user "[username]"?<br>Be careful: This action cannot be undone.',
'confirm_update_transmittalitem' => 'Confirm update',
'content' => 'Content',
'continue' => 'Continue',
'converter_new_cmd' => 'Command',
'converter_new_mimetype' => 'New mimetype',
'copied_to_checkout_as' => 'File copied by [username] to checkout space as \'[filename]\' on [date]',
'created' => 'Created',
'createSubFolderForImportedFiles' => 'Create imported folder',
'createSubFolderForImportedFiles_desc' => 'If enabled, the folder being imported will be created as well.',
'create_download_link' => '',
'create_fulltext_index' => 'Create fulltext index',
'create_fulltext_index_warning' => 'You are about to recreate the fulltext index. This can take a considerable amount of time and reduce your overall system performance. If you really want to recreate the index, please confirm your operation.',
'creation_date' => 'Created',
'cs_CZ' => 'Czech',
'current_filter' => 'Applied filter',
'current_password' => 'Current Password',
'current_quota' => 'The current system wide quota is set [quota].',
'current_state' => 'Current state',
'current_version' => 'Current version',
'daily' => 'Daily',
'dashboard' => 'Dashboard',
'databasesearch' => 'Database',
'database_schema_version' => 'Version of database schema',
'data_loading' => 'Please wait, until the data is loaded …',
'date' => 'Date',
'days' => 'days',
'debug' => 'Debug',
'december' => 'December',
'default_access' => 'Default Access Mode',
'default_keywords' => 'Available keywords',
'definitions' => 'Definitions',
'delete' => 'Delete',
'details' => 'Details',
'details_version' => 'Details for version: [version]',
'de_DE' => 'German',
'directory_check' => 'Check',
'directory_check_cache_exists' => 'Check, if directory for cache exists',
'directory_check_cache_writable' => 'Check, if directory for cache is writable',
'directory_check_conf_writable' => 'Check, if directory for configuration is writable',
'directory_check_data_below_root' => 'Check, if data directory is not below web directory',
'directory_check_data_exists' => 'Check, if directory for data exists',
'directory_check_data_writable' => 'Check, if directory for data is writable',
'directory_check_ext_below_docroot' => 'Check, if directory for extensions is below web directory',
'directory_check_ext_exists' => 'Check, if directory for extensions exists',
'directory_check_ext_writable' => 'Check, if directory for extensions is writable',
'directory_check_index_exists' => 'Check, if directory for fulltext index exists',
'directory_check_index_writable' => 'Check, if directory for fulltext index is writable',
'directory_check_result' => 'Result',
'disable_extension' => 'Disable extension',
'disclaimer' => 'This is a classified area. Access is permitted only to authorized personnel. Any violation will be prosecuted according to the national and international laws.',
'discspace' => 'Disc space',
'docs_in_reception_disabled' => 'Documents with reception by diabled users',
'docs_in_reception_no_access' => 'Documents with reception without access by recipient',
'docs_in_revision_disabled' => 'Documents with revision by disabled user',
'docs_in_revision_no_access' => 'Documents in revision without access by revisor',
'docs_with_missing_revision_date' => 'Documents withoug date of revision',
'document' => 'Document',
'documentcontent' => 'Document content',
'documents' => 'Documents',
'documents_checked_out_by_you' => 'Documents checked out by you',
'documents_expired' => 'Expired documents',
'documents_in_process' => 'Documents In Process',
'documents_locked' => 'Locked documents',
'documents_locked_by_you' => 'Documents locked by you',
'documents_only' => 'Documents only',
'documents_rejected' => 'Rejected',
'documents_to_approve' => 'Documents awaiting your approval',
'documents_to_correct' => 'Documents that need correction',
'documents_to_process' => 'Documents that need processing',
'documents_to_receipt' => 'Documents awaiting to confirm the receipt',
'documents_to_review' => 'Documents awaiting your review',
'documents_to_revise' => 'Documents awaiting your revision',
'documents_to_trigger_workflow' => 'Documents in workflow',
'documents_user_draft' => 'Drafts',
'documents_user_expiration' => 'Expired documents',
'documents_user_needs_correction' => 'Documents that need to be corrected',
'documents_user_no_reception' => 'Documents without reception',
'documents_user_obsolete' => 'Obsolete documents',
'documents_user_reception' => 'Documents awaiting reception',
'documents_user_rejected' => 'Documents rejected',
'documents_user_requiring_attention' => 'Documents owned by you that require attention',
'documents_with_notification' => 'Documents with notification',
'document_access_permission_changed_email' => 'Permission changed',
'document_access_permission_changed_email_body' => 'Permission changed

Document: [name]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'document_access_permission_changed_email_body_html' => '<p>Permission changed</p>

<p>Document: [name]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'document_access_permission_changed_email_subject' => '[sitename]: [name] - Permission changed',
'document_already_checkedout' => 'This document is already checked out',
'document_already_locked' => 'This document is already locked',
'document_attribute_added_email_body' => 'Attribute added

Document: [name]
Attribute: [attribute_name]
Value: [attribute_value]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'document_attribute_added_email_body_html' => '<p>Attribute added</p>

<p>Document: [name]<br />
Attribute: [attribute_name]<br />
Value: [attribute_value]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'document_attribute_added_email_subject' => '[sitename]: [name] - Attribute added',
'document_attribute_changed_email_body' => 'Attribute changed

Document: [name]
Attribute: [attribute_name]
Old value: [attribute_old_value]
New value: [attribute_new_value]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'document_attribute_changed_email_body_html' => '<p>Attribute changed</p>

<p>Document: [name]<br />
Attribute: [attribute_name]<br />
Old value: [attribute_old_value]<br />
New value: [attribute_new_value]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'document_attribute_changed_email_subject' => '[sitename]: [name] - Attribute changed',
'document_comment_changed_email' => 'Comment changed',
'document_comment_changed_email_body' => 'Comment changed

Document: [name]
Old comment: [old_comment]
New Comment: [new_comment]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'document_comment_changed_email_body_html' => '<p>Comment changed</p>

<p>Document: [name]<br />
Old comment: [old_comment]<br />
New Comment: [new_comment]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'document_comment_changed_email_subject' => '[sitename]: [name] - Comment changed',
'document_content_missing' => 'Document content missing',
'document_count' => 'Number of documents',
'document_deleted' => 'Document deleted',
'document_deleted_email' => 'Document deleted',
'document_deleted_email_body' => 'Document deleted

Document: [name]
Parent folder: [folder_path]
User: [username]',
'document_deleted_email_body_html' => '<p>Document deleted</p>

<p>Document: [name]<br />
Parent folder: [folder_path]<br />
User: [username]</p>',
'document_deleted_email_subject' => '[sitename]: [name] - Document deleted',
'document_duplicate_name' => 'Duplicate document name',
'document_files' => 'Attachments',
'document_has_no_workflow' => 'Document has no workflow',
'document_infos' => 'Document Information',
'document_in_revision_no_date' => 'The document is currently in revision. A new revision date can be set when the revision was finished.',
'document_is_checked_out' => '',
'document_is_checked_out_remove' => 'Document is currently checked out. If you delete the document, the checked out version can not be added anymore and remains in the checkout area.',
'document_is_checked_out_update' => 'Document is currently checked out. If you upload a new version, then the checked out version cannot be checked back in anymore.',
'document_is_not_locked' => 'This document is not locked',
'document_links' => 'Document links',
'document_link_by' => 'Linked by',
'document_link_public' => 'Public',
'document_moved_email' => 'Document moved',
'document_moved_email_body' => 'Document moved

Document: [name]
Old folder: [old_folder_path]
New folder: [new_folder_path]
User: [username]
URL: [url]',
'document_moved_email_body_html' => '<p>Document moved</p>

<p>Document: [name]<br />
Old folder: [old_folder_path]<br />
New folder: [new_folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'document_moved_email_subject' => '[sitename]: [name] - Document moved',
'document_notify_added_email' => 'You\'ve been added to notify list',
'document_notify_added_email_body' => 'Added to notification list.

Name: [name]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'document_notify_added_email_body_html' => '<p>Added to notification list.</p>
<p>Name: [name]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'document_notify_added_email_subject' => '[sitename]: [name] - Added to notification list',
'document_notify_deleted_email' => 'You\'ve been removed from notify list',
'document_notify_deleted_email_body' => 'Removed from notification list

Name: [name]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'document_notify_deleted_email_body_html' => '<p>Removed from notification list</p>
<p>Name: [name]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'document_notify_deleted_email_subject' => '[sitename]: [name] - Removed from notification list',
'document_not_checkedout' => 'Document is not checked out.',
'document_ownership_changed_email' => 'Owner changed',
'document_ownership_changed_email_body' => 'Owner changed

Document: [name]
Parent folder: [folder_path]
Old owner: [old_owner]
New owner: [new_owner]
User: [username]
URL: [url]',
'document_ownership_changed_email_body_html' => '<p>Owner changed</p>

<p>Document: [name]<br />
Parent folder: [folder_path]<br />
Old owner: [old_owner]<br />
New owner: [new_owner]<br />
User: [username]<br />
URL: [url]</p>',
'document_ownership_changed_email_subject' => '[sitename]: [name] - Owner changed',
'document_renamed_email' => 'Document renamed',
'document_renamed_email_body' => 'Document name changed

Document: [name]
Parent folder: [folder_path]
Old name: [old_name]
User: [username]
URL: [url]',
'document_renamed_email_body_html' => '<p>Document name changed</p>

<p>Document: [name]<br />
Parent folder: [folder_path]<br />
Old name: [old_name]<br />
User: [username]<br />
URL: [url]</p>',
'document_renamed_email_subject' => '[sitename]: [name] - Document renamed',
'document_status_changed_email' => 'Document status changed',
'document_status_changed_email_body' => 'Document status changed

Document: [name]
Old status: [old_status]
New status: [status]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'document_status_changed_email_body_html' => '<p>Document status changed</p>

<p>Document: [name]<br />
Old status: [old_status]<br />
New status: [status]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'document_status_changed_email_subject' => '[sitename]: [name] - Document status changed',
'document_title' => 'Document \'[documentname]\'',
'document_transfered_email_body' => 'Document transfer to other user

Document: [name]
New owner: [newuser]
Old owner: [olduser]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'document_transfered_email_body_html' => '<p>Document transfer to other user</p>

<p>Document: [name]<br />
New owner: [newuser]<br />
Old owner: [olduser]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'document_transfered_email_subject' => '[sitename]: [name] - Transfer Document',
'document_updated_email' => 'Document updated',
'document_updated_email_body' => 'Document updated

Document: [name]
Version: [version]
Parent folder: [folder_path]
User: [username]
Comment: [comment]
Version comment: [version_comment]
URL: [url]',
'document_updated_email_body_html' => '<p>Document updated</p>

<p>Document: [name]<br />
Version: [version]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
Comment: [comment]<br />
Version comment: [version_comment]<br />
URL: [url]</p>',
'document_updated_email_subject' => '[sitename]: [name] - Document updated',
'document_versions' => 'Document versions',
'does_not_expire' => 'Does not expire',
'does_not_inherit_access_msg' => 'Inherit access',
'download' => 'Download',
'download_extension' => 'Download extension as zip file',
'download_header_approval_comment' => 'Approval comment',
'download_header_approval_date' => 'Approval date',
'download_header_approval_state' => 'Approval status',
'download_header_approver' => 'Approver',
'download_header_document_name' => 'Document name',
'download_header_document_no' => 'Document no',
'download_header_filename' => 'File name',
'download_header_folder_name' => 'Folder name',
'download_header_folder_no' => 'Folder no.',
'download_header_internal_version' => 'Int. version',
'download_header_reviewer' => 'Reviewer',
'download_header_review_comment' => 'Review comment',
'download_header_review_date' => 'Review date',
'download_header_review_state' => 'Review state',
'download_header_state' => 'State',
'download_links' => 'Download links',
'download_link_email_body' => '',
'download_link_email_subject' => '',
'do_no_transfer_to_user' => 'Do not transfer processes to user',
'do_object_repair' => 'Repair all folders and documents.',
'do_object_setchecksum' => 'Set checksum',
'do_object_setfilesize' => 'Set file size',
'do_object_setfiletype' => 'Set file type',
'do_object_unlink' => 'Delete document version',
'draft' => 'Draft',
'draft_pending_approval' => 'pending approval',
'draft_pending_review' => 'pending review',
'drag_icon_here' => 'Drag folder or document here!',
'dropfolderdir_missing' => 'Your personal drop folder does not exist on the server! Please ask your administrator to create it.',
'dropfolder_file' => 'File from drop folder',
'dropfolder_folder' => 'Folder from drop folder',
'dropfolder_metadata' => 'Metadata of files to be imported',
'dropupload' => 'Fast upload',
'drop_files_here' => 'Drop files here!',
'drop_files_here_or_click' => 'Drop files here or click to upload!',
'dump_creation' => 'DB dump creation',
'dump_creation_warning' => 'With this operation you can create a dump file of your database content. After the creation the dump file will be saved in the data folder of your server.',
'dump_list' => 'Existings dump files',
'dump_remove' => 'Remove dump file',
'duplicates' => 'Duplicates',
'duplicate_content' => 'Duplicate Content',
'duplicate_sequences' => 'Duplicate sequence numbers in a folder',
'edit' => 'Edit',
'edit_attributes' => 'Edit attributes',
'edit_comment' => 'Edit comment',
'edit_default_keywords' => 'Edit keywords',
'edit_document_access' => 'Access rights',
'edit_document_notify' => 'Document Notification List',
'edit_document_props' => 'Edit document',
'edit_event' => 'Edit event',
'edit_existing_access' => 'Edit Access List',
'edit_existing_attribute_groups' => 'Edit attribute groups',
'edit_existing_notify' => 'Edit notification list',
'edit_folder_access' => 'Access rights',
'edit_folder_attrdefgrp' => 'Edit attribute groups',
'edit_folder_notify' => 'Folder Notification List',
'edit_folder_props' => 'Edit folder',
'edit_group' => 'Edit group',
'edit_online' => 'Edit online',
'edit_online_not_allowed' => 'You are not allowed to edit this file because you have not created the latest version. Just upload a new version of the document.',
'edit_online_warning' => 'Saving your changes will overwrite the content of the current version, instead of creating a new version.',
'edit_task' => 'Edit task',
'edit_transmittal_props' => 'Edit transmittal properties',
'edit_user' => 'Edit user',
'edit_user_details' => 'Edit User Details',
'edit_version' => 'Edit version',
'el_GR' => 'Greek',
'email' => 'Email',
'email_error_title' => 'No email entered',
'email_footer' => 'You can always change your e-mail settings using \'My Account\' functions',
'email_footer_html' => '<p>You can always change your e-mail settings using \'My Account\' functions</p>',
'email_header' => 'This is an automatic message from the DMS server.',
'email_header_html' => '<p>This is an automatic message from the DMS server.</p>',
'email_not_given' => 'Please enter a valid email address.',
'empty_attribute_group_list' => 'No attribute groups',
'empty_folder_list' => 'No documents or folders',
'empty_list' => 'No entries',
'empty_notify_list' => 'No entries',
'enable_extension' => 'Enable extension',
'enddate' => 'End date',
'en_GB' => 'English (GB)',
'equal_transition_states' => 'Start and end state are equal',
'error' => 'Error',
'error_add_aro' => 'Error while adding access request object',
'error_add_permission' => 'Error while add permission',
'error_cleared_cache' => 'Error while clearing cache',
'error_document_indexed' => 'Error indexing document',
'error_edit_task' => 'Error when saving task',
'error_extension_getlist' => 'Error getting extension list from repository',
'error_importfs' => 'Error while importing form file system',
'error_no_document_selected' => 'No document selected',
'error_no_folder_selected' => 'No folder selected',
'error_occured' => 'An error has occurred',
'error_remove_document' => 'Error while deleting document',
'error_remove_folder' => 'Error while deleting folder',
'error_remove_permission' => 'Error while remove permission',
'error_rm_user_processes' => 'Error when removing user from all processes',
'error_rm_user_processes_no_docs' => 'No documents selected',
'error_rm_workflow' => 'Error when removing workflow',
'error_rm_workflow_action' => 'Error when removing workflow action',
'error_rm_workflow_state' => 'Error when removing workflow state',
'error_toogle_permission' => 'Error while changing permission',
'error_transfer_document' => 'Error while transfering document',
'error_trigger_workflow' => 'Error while triggering transition of workflow',
'error_update_document' => 'Error while updating document',
'error_uploading_reviewer_only' => 'Error when creating the document. The document has a reviewer, but no approver.',
'es_ES' => 'Spanish',
'event' => 'event',
'event_details' => 'Event details',
'exclude_items' => 'Exclude items',
'expired' => 'Expired',
'expired_at_date' => 'Expired at [datetime]',
'expired_docs_mail_subject' => 'Expired documents',
'expired_documents' => 'Expired documents',
'expires' => 'Expires',
'expire_by_date' => 'Expires by date',
'expire_in_1d' => 'Expires in 1 day',
'expire_in_1h' => 'Expires in 1h',
'expire_in_1m' => 'Expires in 1 month',
'expire_in_1w' => 'Expires in 1 week',
'expire_in_1y' => 'Expires in 1 year',
'expire_in_24h' => 'Expires in 24h',
'expire_in_2h' => 'Expires in 2h',
'expire_in_2y' => 'Expires in 2 years',
'expire_in_3y' => 'Expires in 3 years',
'expire_today' => 'Expires today',
'expire_tomorrow' => 'Expires tomorrow',
'expiry_changed_email' => 'Expiry date changed',
'expiry_changed_email_body' => 'Expiry date changed

Document: [name]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'expiry_changed_email_body_html' => '<p>Expiry date changed</p>

<p>Document: [name]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'expiry_changed_email_subject' => '[sitename]: [name] - Expiry date changed',
'export' => 'Export',
'export_user_list_csv' => 'Export users as CSV',
'extension_archive' => 'Extension',
'extension_changelog' => 'Changelog',
'extension_config' => 'Settings',
'extension_info' => 'Extensions',
'extension_is_off_now' => 'Extension off now',
'extension_is_on_now' => 'Extension now enabled',
'extension_loading' => 'Loading extensions ...',
'extension_manager' => 'Manage extensions',
'extension_mgr_error_upload' => 'Error while uploading the extension.',
'extension_mgr_installed' => 'Installed',
'extension_mgr_no_toggle' => 'Extensions cannot be enabled/disabled because the configuration file is not writable.',
'extension_mgr_no_upload' => 'Uploading new extensions is not possible because the extentension directory is not writable.',
'extension_mgr_no_zipfile' => 'The uploaded extension is not a zip file',
'extension_mgr_repository' => 'Available',
'extension_mgr_upload_disabled' => 'Uploading new extensions is not possible because it is disabled in the configuraton.',
'extension_missing_name' => 'No extension name given',
'extension_readme' => 'Readme',
'extension_toggle_error' => 'Could not toggle extension',
'extension_version_list' => 'Versions',
'facetfullsearch' => 'Full text (facetts)',
'february' => 'February',
'file' => 'File',
'files' => 'Files',
'filesize' => 'File size',
'files_deletion' => 'Files deletion',
'files_deletion_warning' => 'With this option you can delete all files of entire DMS folders. The versioning information will remain visible.',
'files_loading' => 'Please wait, until the list of files is loaded …',
'filetype' => 'File type',
'filter_for_documents' => 'Additional filter for documents',
'filter_for_documents_and_folders' => 'Additional filter for folders and documents',
'filter_for_folders' => 'Additional filter for folders',
'finished_workflow_log' => 'Finished workflows',
'folder' => 'Folder',
'folders' => 'Folders',
'folders_and_documents_statistic' => 'Contents overview',
'folders_with_notification' => 'Folders with notification',
'folder_access_permission_changed_email_body' => 'Permission changed

Folder: [name]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'folder_access_permission_changed_email_body_html' => '<p>Permission changed</p>

<p>Folder: [name]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'folder_access_permission_changed_email_subject' => '[sitename]: [name] - Permission changed',
'folder_attribute_added_email_body' => 'Attribute added

Folder: [name]
Attribute: [attribute_name]
Value: [attribute_value]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'folder_attribute_added_email_body_html' => '<p>Attribute changed</p>

<p>Folder: [name]<br />
Attribute: [attribute_name]<br />
Value: [attribute_value]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'folder_attribute_added_email_subject' => '[sitename]: [name] - Attribute added',
'folder_attribute_changed_email_body' => 'Attribute changed

Folder: [name]
Attribute: [attribute_name]
Old value: [attribute_old_value]
New value: [attribute_new_value]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'folder_attribute_changed_email_body_html' => '<p>Attribute changed</p>

<p>Folder: [name]<br />
Attribute: [attribute_name]<br />
Old value: [attribute_old_value]<br />
New value: [attribute_new_value]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'folder_attribute_changed_email_subject' => '[sitename]: [name] - Attribute changed',
'folder_comment_changed_email' => 'Comment changed',
'folder_comment_changed_email_body' => 'Comment changed

Folder: [name]
Old comment: [old_comment]
New Comment: [new_comment]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'folder_comment_changed_email_body_html' => '<p>Comment changed</p>

<p>Folder: [name]<br />
Old comment: [old_comment]<br />
New Comment: [new_comment]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'folder_comment_changed_email_subject' => '[sitename]: [name] - Comment changed',
'folder_contents' => 'Folder Contents',
'folder_deleted_email' => 'Folder deleted',
'folder_deleted_email_body' => 'Folder deleted

Folder: [name]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'folder_deleted_email_body_html' => '<p>Folder deleted</p>

<p>Folder: [name]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'folder_deleted_email_subject' => '[sitename]: [name] - Folder deleted',
'folder_infos' => 'Folder Information',
'folder_moved_email' => 'Folder moved',
'folder_moved_email_body' => 'Folder move

Folder: [name]
Old folder: [old_folder_path]
New folder: [new_folder_path]
User: [username]
URL: [url]',
'folder_moved_email_body_html' => '<p>Folder move</p>

<p>Folder: [name]<br />
Old folder: [old_folder_path]<br />
New folder: [new_folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'folder_moved_email_subject' => '[sitename]: [name] - Folder moved',
'folder_notify_added_email' => '',
'folder_notify_added_email_body' => 'Added to notification list.

Name: [name]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'folder_notify_added_email_body_html' => '<p>Added to notification list.</p>
<p>Name: [name]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'folder_notify_added_email_subject' => '[sitename]: [name] - Added to notification list',
'folder_notify_deleted_email_body' => 'Removed from notification list

Name: [name]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'folder_notify_deleted_email_body_html' => '<p>Removed from notification list</p>
<p>Name: [name]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'folder_notify_deleted_email_subject' => '[sitename]: [name] - Removed from notification list',
'folder_ownership_changed_email_body' => 'Owner changed

Folder: [name]
Parent folder: [folder_path]
Old owner: [old_owner]
New owner: [new_owner]
User: [username]
URL: [url]',
'folder_ownership_changed_email_body_html' => '<p>Owner changed</p>

<p>Folder: [name]<br />
Parent folder: [folder_path]<br />
Old owner: [old_owner]<br />
New owner: [new_owner]<br />
User: [username]<br />
URL: [url]</p>',
'folder_ownership_changed_email_subject' => '[sitename]: [name] - Owner changed',
'folder_renamed_email' => 'Folder renamed',
'folder_renamed_email_body' => 'Folder renamed

Folder: [name]
Parent folder: [folder_path]
Old name: [old_name]
User: [username]
URL: [url]',
'folder_renamed_email_body_html' => '<p>Folder renamed</p>

<p>Folder: [name]<br />
Parent folder: [folder_path]<br />
Old name: [old_name]<br />
User: [username]<br />
URL: [url]</p>',
'folder_renamed_email_subject' => '[sitename]: [name] - Folder renamed',
'folder_title' => 'Folder \'[foldername]\'',
'foot_note' => '',
'force_update' => 'Update',
'friday' => 'Friday',
'friday_abbr' => 'Fr',
'from' => 'From',
'fr_FR' => 'French',
'fullsearch' => 'Full text',
'fullsearch_hint' => 'Use fulltext index',
'fulltextsearch_disabled' => 'Fulltext index is disabled',
'fulltext_converters' => 'Index document conversion',
'fulltext_info' => 'Fulltext index info',
'func_proc_open_missing' => 'proc_open is required for indexing the content of documents. Without this function only the metadata will be indexed.',
'global_attributedefinitiongroups' => 'Attribute groups',
'global_attributedefinitions' => 'Attributes',
'global_default_keywords' => 'Global keywords',
'global_document_categories' => 'Categories',
'global_link_types' => 'Link Types',
'global_workflows' => 'Workflows',
'global_workflow_actions' => 'Workflow Actions',
'global_workflow_states' => 'Workflow States',
'group' => 'Group',
'groups' => 'Groups',
'group_approval_summary' => 'Group approval summary',
'group_exists' => 'Group already exists.',
'group_info' => 'Group information',
'group_is_mandatory_approver' => 'Group is mandatory approver',
'group_is_mandatory_reviewer' => 'Group is mandatory reviewer',
'group_management' => 'Groups management',
'group_members' => 'Group members',
'group_previously_removed_from_approvers' => 'Group was previously removed as a approver.',
'group_previously_removed_from_recipients' => 'Group was previously removed as a revisor.',
'group_previously_removed_from_reviewers' => 'Group was previously removed as a reviewer.',
'group_previously_removed_from_revisors' => 'Group was previously removed as a revisor.',
'group_receipt_summary' => 'Group receipt summary',
'group_review_removed' => 'Change of status, because review of group [name] was removed.',
'group_review_summary' => 'Group review summary',
'group_revision_summary' => 'Group revision summary',
'guest_login' => 'Login as guest',
'guest_login_disabled' => 'Guest login is disabled.',
'hash' => 'Hash',
'help' => 'Help',
'home_folder' => 'Home folder',
'hook_name' => 'Name of hook',
'hourly' => 'Hourly',
'hours' => 'hours',
'hr_HR' => 'Croatian',
'human_readable' => 'Human readable archive',
'hu_HU' => 'Hungarian',
'id' => 'ID',
'identical_version' => 'New version is identical to current version.',
'id_ID' => 'Indonesian',
'import' => 'Import',
'importfs' => 'Import from Filesystem',
'import_extension' => 'Import extension',
'import_fs' => 'Import from filesystem',
'import_fs_warning' => 'This will only work for folders in the drop folder. The operation recursively imports all folders and files. Files will be released immediately.',
'import_users' => 'Import users',
'import_users_addnew' => 'Add new users',
'import_users_no_column_mapping' => 'Please upload a user list',
'import_users_update' => 'Update existing users',
'include_content' => 'Include content',
'include_documents' => 'Include documents',
'include_subdirectories' => 'Include subdirectories',
'indexing_tasks_in_queue' => 'Indexing tasks in queue',
'index_converters' => '',
'index_document_added' => 'Document added',
'index_document_unchanged' => 'Document unchanged',
'index_document_updated' => 'Document updated',
'index_done' => 'Done',
'index_error' => 'Error',
'index_folder' => 'Index folder',
'index_folder_added' => 'Folder added',
'index_folder_unchanged' => 'Folder unchanged',
'index_folder_updated' => 'Folder updated',
'index_no_content' => 'Did not index content',
'index_pending' => 'Pending',
'index_processing' => 'Processing ...',
'index_waiting' => 'Waiting',
'individuals' => 'Individuals',
'individuals_in_groups' => 'Members of a group',
'ind_review_removed' => 'Change of status, because review of user [name] was removed.',
'info_recipients_tab_not_released' => 'Acknowledgment of reception for this document version is not possible, because the version is not released.',
'info_rm_user_from_processes_none' => 'The user has currently no tasks.',
'info_rm_user_from_processes_user' => 'Only tasks not being touched can be transferred to another user. Task which has been taken care of, will just add an item in the history, as if the user was deleted.',
'inherited' => 'inherited',
'inherits_access_copy_msg' => 'Copy inherited access list',
'inherits_access_empty_msg' => 'Start with empty access list',
'inherits_access_msg' => 'Access is being inherited.',
'insecure_installation' => 'Your SeedDMS installation has serious vulnerabilities, because the configuration and/or the uploaded files can be read via the web server. Please read the section \'Security considerations\' in doc/README.Install.md',
'installed_apache_extensions' => 'Installed apache Extensions',
'installed_php_extensions' => 'Installed php extensions',
'internal_error' => 'Internal error',
'internal_error_exit' => 'Internal error. Unable to complete request.',
'invalid_access_mode' => 'Invalid Access Mode',
'invalid_action' => 'Invalid Action',
'invalid_approval_status' => 'Invalid Approval Status',
'invalid_create_date_end' => 'Invalid end date for creation date range.',
'invalid_create_date_start' => 'Invalid start date for creation date range.',
'invalid_doc_id' => 'Invalid Document ID',
'invalid_dropfolder_folder' => 'Invalid folder in drop folder',
'invalid_expiration_date' => 'Invalid expiration date',
'invalid_expiration_date_end' => 'Invalid end date for expiration date range.',
'invalid_expiration_date_start' => 'Invalid start date for expiration date range.',
'invalid_file_id' => 'Invalid file ID',
'invalid_folder_id' => 'Invalid Folder ID',
'invalid_group_id' => 'Invalid Group ID',
'invalid_link_id' => 'Invalid link identifier',
'invalid_request_token' => 'Invalid Request Token',
'invalid_review_status' => 'Invalid Review Status',
'invalid_sequence' => 'Invalid sequence value',
'invalid_status' => 'Invalid Document Status',
'invalid_target_doc_id' => 'Invalid Target Document ID',
'invalid_target_folder' => 'Invalid Target Folder ID',
'invalid_user_id' => 'Invalid User ID',
'invalid_version' => 'Invalid Document Version',
'in_folder' => 'In',
'in_revision' => 'In revision',
'in_workflow' => 'In workflow',
'iptc_metadata' => 'IPTC Data',
'is_disabled' => 'Disable account',
'is_hidden' => 'Hide from users list',
'it_IT' => 'Italian',
'january' => 'January',
'js_confirm_cancel_checkout' => 'Please check to confirm',
'js_form_error' => 'The form still contains # error.',
'js_form_errors' => 'The form still contains # errors.',
'js_invalid_email' => 'The email address is invalid',
'js_no_approval_group' => 'Please select a approval group',
'js_no_approval_status' => 'Please select the approval status',
'js_no_comment' => 'There is no comment',
'js_no_currentpwd' => 'Please enter your current password',
'js_no_document' => 'Please select a document',
'js_no_email' => 'Type in your Email-address',
'js_no_file' => 'Please select a file',
'js_no_folder' => 'Please select a folder',
'js_no_keywords' => 'Specify some keywords',
'js_no_login' => 'Please type in a username',
'js_no_name' => 'Please type in a name',
'js_no_override_status' => 'Please select the new status',
'js_no_pwd' => 'You need to type in your password',
'js_no_query' => 'Type in a query',
'js_no_review_group' => 'Please select a review group',
'js_no_review_status' => 'Please select the review status',
'js_pwd_not_conf' => 'Password and passwords-confirmation are not equal',
'js_select_user' => 'Please select an user',
'js_select_user_or_group' => 'Select at least a user or a group',
'js_unequal_passwords' => 'The passwords are not equal',
'july' => 'July',
'june' => 'June',
'keep' => 'Do not change',
'keep_doc_status' => 'Keep document status',
'keywords' => 'Keywords',
'keywords_loading' => 'Please wait, until the list of keywords is loaded …',
'keyword_exists' => 'Keyword already exists',
'ko_KR' => 'Korean',
'language' => 'Language',
'lastaccess' => 'Last access',
'last_update' => 'Last Update',
'latest_newdocuments' => 'Recently added documents',
'latest_statuschange' => 'Documents with recent status change',
'latest_updateddocuments' => 'Recently updated documents',
'legend' => 'Legend',
'librarydoc' => 'Document from library',
'linked_document' => 'Linked document',
'linked_documents' => 'Related Documents',
'linked_files' => 'Attachments',
'linked_to_current_version' => 'Linked to current version',
'linked_to_document' => 'Linked to document',
'linked_to_this_version' => 'Linked to this version',
'link_alt_updatedocument' => 'If you would like to upload files bigger than the current maximum upload size, please use the alternative <a href="%s">upload page</a>.',
'link_document' => 'Link document',
'link_to_version' => 'Attach to version',
'list_access_rights' => 'List all access rights ...',
'list_contains_no_access_docs' => 'The list contains more documents you have no access to and are not displayed.',
'list_conversion_overview' => 'Existing mime types and conversion services',
'list_conversion_services' => 'List of conversion services',
'list_hooks' => 'List of hooks',
'list_notification_services' => 'List of notification services',
'list_of_recipients_has_disabled_users' => 'List of recipients contains disabled users.',
'list_tasks' => 'List tasks',
'local_file' => 'Local file',
'locked_by' => 'Locked by',
'lock_document' => 'Lock',
'lock_message' => 'This document is locked by [username]. Only authorized users can unlock this document.',
'lock_status' => 'Status',
'logfile' => 'Log file',
'logfile_loading' => 'Pleae wait, until log file is loaded …',
'login' => 'Login',
'login_disabled_text' => 'Your account is disabled, probably because of too many failed logins.',
'login_disabled_title' => 'Account is disabled',
'login_error_text' => 'Error signing in. User ID or password incorrect.',
'login_error_title' => 'Sign in error',
'login_not_given' => 'No username has been supplied',
'login_ok' => 'Sign in successful',
'login_restrictions_apply' => 'Login failed due to restrictions',
'logout' => 'Logout',
'log_management' => 'Log files management',
'lo_LA' => 'Laotian',
'malformed_expiration_date' => 'Malformed expiration date',
'manager' => 'Manager',
'manager_of_group' => 'You are the manager of this group',
'mandatory_approvergroups' => 'Mandatory Groups of approvers',
'mandatory_approvergroup_no_access' => 'Mandatory group of approvers \'[group]\' has insufficient access rights.',
'mandatory_approvers' => 'Mandatory approvers',
'mandatory_approver_no_access' => 'Mandatory approver \'[user]\' has insufficient access rights or is not allowed as an approver.',
'mandatory_reviewergroups' => 'Mandatory group of reviewers',
'mandatory_reviewergroup_no_access' => 'Mandatory group of reviewers \'[group]\' has insufficient access rights.',
'mandatory_reviewers' => 'Mandatory reviewers',
'mandatory_reviewer_no_access' => 'Mandatory reviewer \'[user]\' has insufficient access rights or is not allowed as a reviewer.',
'march' => 'March',
'mark_document' => 'Mark document for batch operation',
'mark_folder' => 'Mark folder for batch operation',
'max_upload_size' => 'Maximum upload size',
'may' => 'May',
'menu_dropfolder' => 'Drop folder',
'menu_upload_from_dropfolder' => 'Import this file',
'message' => 'Message',
'mimetype' => 'Mime type',
'minutes' => 'minutes',
'misc' => 'Misc',
'missing_checksum' => 'Missing checksum',
'missing_file' => 'Missing file',
'missing_filesize' => 'Missing file size',
'missing_func_class_note' => 'Note',
'missing_php_class' => 'PHP class [classname] missing',
'missing_php_extension' => 'PHP extension [extname] missing',
'missing_php_extensions' => 'Check for missing php extensions',
'missing_php_function' => 'PHP function [funcname] missing',
'missing_php_functions_and_classes' => 'Check for missing php functions and classes',
'missing_reception' => 'Missing reception',
'missing_request_object' => 'Missing request object',
'missing_transition_user_group' => 'Missing user/group for transition',
'modification_date' => 'Modified',
'modified' => 'Modified',
'monday' => 'Monday',
'monday_abbr' => 'Mo',
'monthly' => 'Monthly',
'month_view' => 'Month view',
'more_objects_loading' => 'More objects loading ...',
'move' => 'Move',
'move_clipboard' => 'Move clipboard',
'move_document' => 'Move document',
'move_folder' => 'Move Folder',
'move_into_rootfolder' => 'Move into root folder',
'must_drop_one_file' => 'You may not drop more than one file',
'my_account' => 'My Account',
'my_documents' => 'My Documents',
'my_transmittals' => 'My Transmittals',
'name' => 'Name',
'nav_brand_admin_tools' => 'Admin tools',
'nav_brand_calendar' => 'Calendar',
'nav_brand_my_account' => 'My Account',
'nav_brand_my_documents' => 'My documents',
'nav_brand_view_document' => 'Document',
'nav_brand_view_folder' => 'Folder',
'nb_NO' => 'Norwegian (Bokmål)',
'needs_correction' => 'Needs correction',
'needs_workflow_action' => 'This document requires your attention. Please check the workflow tab.',
'network_drive' => 'Network drive',
'never' => 'never',
'new' => 'New',
'new_attrdef' => 'Add attribute definition',
'new_default_keywords' => 'Add keyword',
'new_default_keyword_category' => 'Add category',
'new_documents' => 'New documents',
'new_documents_today' => 'New documents today',
'new_documents_yesterday' => 'New documents yesterday',
'new_document_category' => 'Add category',
'new_document_email' => 'New document',
'new_document_email_body' => 'New document

Name: [name]
Parent folder: [folder_path]
Comment: [comment]
Version comment: [version_comment]
User: [username]
URL: [url]',
'new_document_email_body_html' => '<p>New document</p>

<p>Name: [name]<br />
Parent folder: [folder_path]<br />
Comment: [comment]<br />
Version comment: [version_comment]<br />
User: [username]<br />
URL: [url]</p>',
'new_document_email_subject' => '[sitename]: [folder_name] - New document',
'new_file_email' => 'New attachment',
'new_file_email_body' => 'New attachment

Name: [name]
Document: [document]
Comment: [comment]
User: [username]
URL: [url]',
'new_file_email_body_html' => '<p>New attachment</p>

<p>Name: [name]<br />
Document: [document]<br />
Comment: [comment]<br />
User: [username]<br />
URL: [url]</p>',
'new_file_email_subject' => '[sitename]: [document] - New attachment',
'new_folder' => 'New folder',
'new_link_type' => 'Add link type',
'new_password' => 'New password',
'new_subfolder_email' => 'New folder',
'new_subfolder_email_body' => 'New folder

Name: [name]
Parent folder: [folder_path]
Comment: [comment]
User: [username]
URL: [url]',
'new_subfolder_email_body_html' => '<p>New folder</p>

<p>Name: [name]<br />
Parent folder: [folder_path]<br />
Comment: [comment]<br />
User: [username]<br />
URL: [url]</p>',
'new_subfolder_email_subject' => '[sitename]: [name] - New folder',
'new_user_image' => 'New image',
'next_revision_abbr' => 'Next Rev.',
'next_state' => 'New state',
'nl_NL' => 'Dutch',
'no' => 'No',
'notification' => 'Notification',
'notification_msg_tmpl' => 'Template',
'notification_recvtype' => 'Type of receiver',
'notification_recv_any' => 'Any',
'notification_recv_approver' => 'Approver',
'notification_recv_notification' => 'Notifier',
'notification_recv_owner' => 'Owner',
'notification_recv_reviewer' => 'Reviewer',
'notification_recv_uploader' => 'Uploader',
'notification_recv_workflow' => 'Workflow',
'notification_service_no_filter' => 'This notification services does not have a filter.',
'notification_tmpl' => 'Template',
'not_subscribed' => 'Not subscribed',
'november' => 'November',
'now' => 'now',
'no_action' => 'No action required',
'no_approval_needed' => 'No approval pending.',
'no_attached_files' => 'No attached files',
'no_attributes_defined' => 'You have not created any custom attributes.',
'no_attribute_definitions' => 'There are currently no attribute definitions',
'no_backup_dir' => 'Backup directory is not set.',
'no_current_version' => 'You are running an old version of SeedDMS. The latest available version is [latestversion].',
'no_default_keywords' => 'No keywords available',
'no_docs_checked_out' => 'No documents checked out',
'no_docs_draft' => '',
'no_docs_expired' => 'No expired documents',
'no_docs_locked' => 'No documents locked.',
'no_docs_needs_correction' => 'No documents, that need to be corrected',
'no_docs_obsolete' => '',
'no_docs_rejected' => 'No documents rejected.',
'no_docs_to_approve' => 'There are currently no documents that require approval.',
'no_docs_to_look_at' => 'No documents that need attention.',
'no_docs_to_receipt' => 'No document receipts required',
'no_docs_to_review' => 'There are currently no documents that require review.',
'no_docs_to_revise' => 'There are currently no documents that need to be revised.',
'no_email_or_login' => 'Login and email must be entered',
'no_fulltextindex' => 'No fulltext index available',
'no_groups' => 'No groups',
'no_group_members' => 'This group has no members',
'no_linked_files' => 'No linked files',
'no_mimetype' => 'No mimetype',
'no_previous_versions' => 'No other versions found',
'no_receipt_needed' => 'There are currently no documents requiring a receipt confirmation.',
'no_review_needed' => 'No review pending.',
'no_revision_date' => 'Date of revision missing',
'no_revision_needed' => 'No revision pending.',
'no_revision_planed' => 'No revision of document scheduled',
'no_update_cause_locked' => 'You can therefore not update this document. Please contact the locking user.',
'no_user_image' => 'No image found',
'no_value_set' => 'No value set',
'no_version_check' => 'Checking for a new version of SeedDMS has failed! This could be caused by allow_url_fopen being set to 0 in your php configuration.',
'no_version_modification' => 'No version modification',
'no_workflows' => 'You have not created a workflow yet',
'no_workflow_available' => 'No workflow available',
'number_count' => 'number',
'objectcheck' => 'Folder/Document check',
'objects_without_attribute' => 'Objects without this attribute',
'object_check_critical' => 'Critical errors',
'object_check_warning' => 'Warnings',
'objtype_unknown' => 'unknown',
'obsolete' => 'Obsolete',
'october' => 'October',
'old' => 'Old',
'only_jpg_user_images' => 'Only .jpg-images may be used as user-images',
'operation_disallowed' => 'Operation not permitted',
'orderby' => 'Order by',
'orderby_date_asc' => 'by date (ascending)',
'orderby_date_desc' => 'by date (descending)',
'orderby_id_asc' => 'by id (ascending)',
'orderby_id_desc' => 'by id (descending)',
'orderby_name_asc' => 'by name (ascending)',
'orderby_name_desc' => 'by name (descending)',
'orderby_relevance' => 'by relevance',
'orderby_unsorted' => 'unsorted',
'order_by_sequence_off' => 'Ordering by sequence is turned off in the settings. If you want this parameter to have effect, you will have to turn it back on.',
'original_filename' => 'Original filename',
'overall_indexing_progress' => 'Overall indexing progress',
'owner' => 'Owner',
'parent_folder' => 'Parent folder',
'password' => 'Password',
'password_already_used' => 'Password already used',
'password_expiration' => 'Password expiration',
'password_expiration_text' => 'Your password has expired. Please choose a new one before you can proceed using SeedDMS.',
'password_expired' => 'Password expired',
'password_expires_in_days' => 'Password expires in %s days.',
'password_forgotten' => 'Password forgotten',
'password_forgotten_email_body' => 'Dear user of SeedDMS,

we have received a request to change your password.

This can be done by clicking on the following link:

[url_prefix]out/out.ChangePassword.php?hash=[hash]

If you still have problems to login, then please contact your administrator.',
'password_forgotten_email_body_html' => '<p>Dear user of SeedDMS,</p>

<p>we have received a request to change your password.</p>

<p>This can be done by clicking on the following link:</p>

<p>[url_prefix]out/out.ChangePassword.php?hash=[hash]</p>

<p>If you still have problems to login, then please contact your administrator.</p>',
'password_forgotten_email_subject' => '[sitename]: Password forgotten',
'password_forgotten_invalid_hash' => 'Invalid hash',
'password_forgotten_invalid_hash_title' => 'Invalid hash',
'password_forgotten_send_hash' => 'Instructions on how to proceed has been send to the user\'s email address',
'password_forgotten_text' => 'Fill out the form below and follow the instructions in the email, which will be sent to you.',
'password_forgotten_title' => 'Password sent',
'password_mismatch_error' => 'Passwords mismatch',
'password_mismatch_error_title' => 'Passwords mismatch',
'password_repeat' => 'Repeat password',
'password_send' => 'Password send',
'password_send_text' => 'Your new password has been send to the given email address, if the login and email matches an existing user. If you do not receive an email within the next minutes, then make sure both login and email are correct and restart the process again.',
'password_strength' => 'Password strength',
'password_strength_insuffient' => 'Insufficient password strength',
'password_wrong' => 'Wrong password',
'pdf_converters' => 'PDF converters',
'pending_approvals' => 'Pending approvals',
'pending_receipt' => 'Pending receipts',
'pending_reviews' => 'Pending reviews',
'pending_revision' => 'Pending revisions',
'pending_workflows' => 'Pending workflows',
'personal_default_keywords' => 'Personal keywordlists',
'php_info' => 'Information about PHP',
'pl_PL' => 'Polish',
'possible_substitutes' => 'Substitutes',
'preset_expires' => 'Preset expiration',
'preview' => 'Preview',
'preview_converters' => 'Preview document conversion',
'preview_images_text' => 'Preview images and text content',
'preview_markdown' => 'Markdown',
'preview_pdf' => 'Preview as PDF',
'preview_plain' => 'Text',
'preview_png' => 'Preview images',
'preview_txt' => 'Preview text',
'previous_state' => 'Previous state',
'previous_versions' => 'Previous versions',
'process' => 'Process',
'process_without_user_group' => 'Processes without user/group',
'pt_BR' => 'Portugese (BR)',
'quota' => 'Quota',
'quota_exceeded' => 'Your disk quota is exceeded by [bytes].',
'quota_is_disabled' => 'Quota support is currently disabled in the settings. Setting a user quota will have no effect until it is enabled again.',
'quota_warning' => 'Your maximum disc usage is exceeded by [bytes]. Please remove documents or previous versions.',
'readme_loading' => 'Pleae wait, until the Readme is loaded ...',
'receipts_accepted' => '[no_receipts] receipts already accepted',
'receipts_accepted_latest' => '(being [no_receipts] in latest version)',
'receipts_not_touched' => '[no_receipts] receipts not being touched',
'receipts_not_touched_latest' => '(being [no_receipts] in latest version)',
'receipts_rejected' => '[no_receipts] receipts already rejected',
'receipts_rejected_latest' => '(being [no_receipts] in latest version)',
'receipts_without_group' => 'Receipts without group',
'receipts_without_user' => 'Receipts without user',
'receipt_deletion_email_body' => 'User has been removed from the list of recipients.

Document: [name]
Version: [version]
Parent folder: [folder_path]
Recipient: [recipient]
User: [username]
URL: [url]',
'receipt_deletion_email_body_html' => '<p>User has been removed from the list of recipients.</p>

<p>Document: [name]<br />
Version: [version]<br />
Parent folder: [folder_path]<br />
Recipient: [recipient]<br />
User: [username]<br />
URL: [url]</p>',
'receipt_deletion_email_subject' => '[sitename]: [name] - Recipient removed',
'receipt_log' => 'Reception Log',
'receipt_request_email_body' => 'Reception request

Document: [name]
Version: [version]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'receipt_request_email_body_html' => '<p>Reception request</p>

<p>Document: [name]<br />
Version: [version]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'receipt_request_email_subject' => '[sitename]: [name] - Reception request',
'receipt_status' => 'Status',
'receipt_submit_email_body' => 'Submitted receipt

Document: [name]
Version: [version]
Status: [status]
Comment: [comment]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'receipt_submit_email_body_html' => '<p>Submitted receipt</p>

<p>Document: [name]<br />
Version: [version]<br />
Status: [status]<br />
Comment: [comment]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'receipt_submit_email_subject' => '[sitename]: [name] - Submitted receipt',
'receipt_summary' => 'Receipt summary',
'receipt_update_failed' => 'Acknowledging reception failed',
'recentchanges_mail_subject' => 'Recent changes',
'recent_uploads' => 'Recent Uploads',
'reception' => 'Reception',
'reception_acknowleged' => 'Reception acknowledged',
'reception_noaction' => 'No action',
'reception_rejected' => 'Reception rejected',
'recipients' => 'Recipients',
'recipient_already_removed' => 'Recipient has already been removed or aknowledged recepiton.',
'record_type' => 'Type',
'redraw' => 'Redraw',
'refresh' => 'Refresh',
'rejected' => 'Rejected',
'released' => 'Released',
'removed_approver' => 'has been removed from the list of approvers.',
'removed_file_email' => 'Removed attachment',
'removed_file_email_body' => 'Removed attachment

Document: [document]
User: [username]
URL: [url]',
'removed_file_email_body_html' => '<p>Removed attachment</p>

<p>Document: [document]<br />
User: [username]<br />
URL: [url]</p>',
'removed_file_email_subject' => '[sitename]: [document] - Removed attachment',
'removed_recipient' => 'has been removed from the list of recipients.',
'removed_reviewer' => 'has been removed from the list of reviewers.',
'removed_revisor' => 'has been removed from the list of revisors.',
'removed_workflow_email_body' => 'Removed workflow from document version.

Document: [name]
Version: [version]
Workflow: [workflow]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'removed_workflow_email_body_html' => '<p>Removed workflow from document version.</p>

<p>Document: [name]<br />
Version: [version]<br />
Workflow: [workflow]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'removed_workflow_email_subject' => '[sitename]: [name] - Removed workflow from document version',
'removeFolderFromDropFolder' => 'Remove folder after import',
'removeFolderFromDropFolder_desc' => 'Enable this if you want the folder which was imported to be removed from the drop folder.',
'remove_approval_log' => 'Remove approval',
'remove_from_clipboard' => 'Remove from clipboard',
'remove_marked_files' => 'Remove marked files',
'remove_review_log' => 'Remove review',
'remove_task' => 'Remove task',
'reorder' => 'Reorder',
'repaired' => 'repaired',
'repairing_objects' => 'Repairing documents and folders.',
'replace_content_email_body' => 'The last version of the document has been replaced.

Document: [name]
Version: [version]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'replace_content_email_body_html' => '<p>The last version of the document has been replaced.</p>

<p>Document: [name]<br />
Version: [version]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'replace_content_email_subject' => '[sitename]: [name] - Document content replaced',
'request_workflow_action_email_body' => 'The workflow has reached a state which requires your action.

Document: [name]
Version: [version]
Workflow: [workflow]
Current state: [current_state]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'request_workflow_action_email_body_html' => '<p>The workflow has reached a state which requires your action.</p>

<p>Document: [name]<br />
Version: [version]<br />
Workflow: [workflow]<br />
Current state: [current_state]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'request_workflow_action_email_subject' => '[sitename]: [name] - Workflow action required',
'reset_checkout' => 'Finish Check out',
'restrict_access' => 'No access to',
'results_page' => 'Results Page',
'return_from_subworkflow' => 'Return from sub workflow',
'return_from_subworkflow_email_body' => 'Return from subworkflow

Document: [name]
Version: [version]
Workflow: [workflow]
Subworkflow: [subworkflow]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'return_from_subworkflow_email_body_html' => '<p>Return from subworkflow</p>

<p>Document: [name]<br />
Version: [version]<br />
Workflow: [workflow]<br />
Subworkflow: [subworkflow]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'return_from_subworkflow_email_subject' => '[sitename]: [name] - Return from subworkflow',
'reverse_links' => 'Documents, which have a link to the current document',
'reviewers' => 'Reviewers',
'reviewer_already_assigned' => 'User is already assigned as a reviewer',
'reviewer_already_removed' => 'Reviewer has already been removed from review process or has already submitted a review',
'reviews_accepted' => '[no_reviews] reviews already accepted',
'reviews_accepted_latest' => '(being [no_reviews] in latest version)',
'reviews_not_touched' => '[no_reviews] reviews not being touched',
'reviews_not_touched_latest' => '(being [no_reviews] in latest version)',
'reviews_rejected' => '[no_reviews] reviews already rejected',
'reviews_rejected_latest' => '(being [no_reviews] in latest version)',
'reviews_without_group' => 'Reviews without group',
'reviews_without_user' => 'Reviews without user',
'review_deletion_email' => 'Review request deleted',
'review_deletion_email_body' => 'Review request deleted

Document: [name]
Version: [version]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'review_deletion_email_body_html' => '<p>Review request deleted</p>

<p>Document: [name]<br />
Version: [version]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'review_deletion_email_subject' => '[sitename]: [name] - Review request deleted',
'review_file' => 'File',
'review_group' => 'Review group',
'review_log' => 'Review log',
'review_request_email' => 'Review request',
'review_request_email_body' => 'Review request

Document: [name]
Version: [version]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'review_request_email_body_html' => '<p>Review request</p>

<p>Document: [name]<br />
Version: [version]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'review_request_email_subject' => '[sitename]: [name] - Review request',
'review_status' => 'Review status',
'review_submit_email' => 'Submitted review',
'review_submit_email_body' => 'Submitted review

Document: [name]
Version: [version]
Status: [status]
Comment: [comment]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'review_submit_email_body_html' => '<p>Submitted review</p>

<p>Document: [name]<br />
Version: [version]<br />
Status: [status]<br />
Comment: [comment]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'review_submit_email_subject' => '[sitename]: [name] - Submitted review',
'review_summary' => 'Review Summary',
'review_update_failed' => 'Error updating review status. Update failed.',
'revise_document' => 'Revise document',
'revise_document_on' => 'Next revision of document version on [date]',
'revision' => 'Revision',
'revisions_accepted' => '[no_revisions] revisions already accepted',
'revisions_accepted_latest' => '(being [no_revisions] in latest version)',
'revisions_not_touched' => '[no_revisions] revisions not being touched',
'revisions_not_touched_latest' => '(being [no_revisions] in latest version)',
'revisions_pending' => '[no_revisions] revisions due in future',
'revisions_pending_latest' => '(being [no_revisions] in latest version)',
'revisions_rejected' => '[no_revisions] revisions already rejected',
'revisions_rejected_latest' => '(being [no_revisions] in latest version)',
'revisions_without_group' => 'Revisions without group',
'revisions_without_user' => 'Revisions without user',
'revision_date' => 'Date of revision',
'revision_deletion_email_body' => '<p>Revision request deleted</p>

<p>Document: [name]<br />
Version: [version]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'revision_deletion_email_subject' => '[sitename]: [name] - Revision request removed',
'revision_log' => 'Revision log',
'revision_request_email_body' => 'Revision request

Document: [name]
Version: [version]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'revision_request_email_body_html' => '<p>Revision request</p>

<p>Document: [name]<br />
Version: [version]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'revision_request_email_subject' => '[sitename]: [name] - Revision request',
'revision_status' => 'Status',
'revision_submit_email_body' => 'Submitted revision

Document: [name]
Version: [version]
Status: [status]
Comment: [comment]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'revision_submit_email_body_html' => '<p>Submitted revision</p>

<p>Document: [name]<br />
Version: [version]<br />
Status: [status]<br />
Comment: [comment]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'revision_submit_email_subject' => '[sitename]: [name] - Submitted revision',
'revision_summary' => 'Revision summary',
'revisors' => 'Revisors',
'revisor_already_assigned' => 'User is already assigned as an revisor.',
'revisor_already_removed' => 'Revisor has already been removed from revision process or has already revised the document.',
'rewind_workflow' => 'Rewind workflow',
'rewind_workflow_email_body' => 'Workflow was rewinded

Document: [name]
Version: [version]
Workflow: [workflow]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'rewind_workflow_email_body_html' => '<p>Workflow was rewinded</p>

<p>Document: [name]<br />
Version: [version]<br />
Workflow: [workflow]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'rewind_workflow_email_subject' => '[sitename]: [name] - Workflow was rewinded',
'rewind_workflow_warning' => 'If you rewind a workflow to its initial state, then the whole workflow log for this document will be deleted and cannot be recovered.',
'rm_attrdef' => 'Remove attribute definition',
'rm_attrdefgroup' => 'Remove this attribute group',
'rm_attr_value' => 'Remove value',
'rm_default_keyword_category' => 'Remove category',
'rm_document' => 'Remove document',
'rm_document_category' => 'Remove category',
'rm_event' => 'Remove event',
'rm_file' => 'Remove file',
'rm_folder' => 'Remove folder',
'rm_from_clipboard' => 'Remove from clipboard',
'rm_group' => 'Remove this group',
'rm_role' => 'Delete this role',
'rm_task' => 'Remove task',
'rm_transmittal' => 'Remove transmittal',
'rm_transmittalitem' => 'Remove item',
'rm_user' => 'Remove user',
'rm_user_from_processes' => 'Remove user from processes',
'rm_version' => 'Remove version',
'rm_workflow' => 'Remove Workflow',
'rm_workflow_action' => 'Remove Workflow Action',
'rm_workflow_state' => 'Remove Workflow State',
'rm_workflow_warning' => 'You are about to remove the workflow from the document. This cannot be undone.',
'role' => 'Role',
'role_admin' => 'Administrator',
'role_guest' => 'Guest',
'role_info' => 'Information',
'role_management' => 'Role management',
'role_name' => 'Name',
'role_type' => 'Type of role',
'role_user' => 'User',
'ro_RO' => 'Romanian',
'run_subworkflow' => 'Run sub workflow',
'run_subworkflow_email_body' => 'Subworkflow was started

Document: [name]
Version: [version]
Workflow: [workflow]
Subworkflow: [subworkflow]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'run_subworkflow_email_body_html' => '<p>Subworkflow was started</p>

<p>Document: [name]<br />
Version: [version]<br />
Workflow: [workflow]<br />
Subworkflow: [subworkflow]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'run_subworkflow_email_subject' => '[sitename]: [name] - Subworkflow was started',
'ru_RU' => 'Russian',
'saturday' => 'Saturday',
'saturday_abbr' => 'Sa',
'save' => 'Save',
'scheduler_class' => 'Class',
'scheduler_class_description' => 'Description',
'scheduler_class_parameter' => 'Parameter',
'scheduler_class_tasks' => 'Tasks of class',
'scheduler_task_mgr' => 'Scheduler',
'search' => 'Search',
'search_fulltext' => 'Search in fulltext',
'search_in' => 'Search in',
'search_mode' => 'Search mode',
'search_mode_and' => 'all words',
'search_mode_documents' => 'Documents only',
'search_mode_folders' => 'Folders only',
'search_mode_or' => 'at least one word',
'search_no_results' => 'There are no documents that match your search',
'search_query' => 'Search for',
'search_query_placeholder' => 'Search in title, comments, keywords, content',
'search_report' => 'Found [doccount] documents and [foldercount] folders in [searchtime] sec.',
'search_report_fulltext' => 'Found [doccount] documents',
'search_resultmode' => 'Search result',
'search_resultmode_both' => 'Documents and folders',
'search_results' => 'Search results',
'search_results_access_filtered' => 'Search results may contain content to which access has been denied.',
'search_time' => 'Elapsed time: [time] sec.',
'seconds' => 'seconds',
'seeddms_info' => 'Information about SeedDMS',
'seeddms_version' => 'Version of SeedDMS',
'selection' => 'Selection',
'select_attrdef' => 'Select attribute definition',
'select_attrdefgrp_show' => 'Choose when to show',
'select_attribute_value' => 'Select attribute value',
'select_category' => 'Click to select category',
'select_created' => 'Click to select date of creation',
'select_documents_for_process' => 'Select documents',
'select_folder' => 'Select folder',
'select_group' => 'Select group',
'select_groups' => 'Click to select groups',
'select_grp_approvers' => 'Click to select group approver',
'select_grp_ind_approvers' => 'Click to select group',
'select_grp_ind_notification' => 'Click to select group',
'select_grp_ind_recipients' => 'Click to select group',
'select_grp_ind_reviewers' => 'Click to select group',
'select_grp_ind_revisors' => 'Click to select group',
'select_grp_notification' => 'Click to select group notification',
'select_grp_recipients' => 'Click to select group of recipients',
'select_grp_reviewers' => 'Click to select group reviewer',
'select_grp_revisors' => 'Click to select group of revisors',
'select_ind_approvers' => 'Click to select individual approver',
'select_ind_notification' => 'Click to select individual notification',
'select_ind_recipients' => 'Click to select individual recipients',
'select_ind_reviewers' => 'Click to select individual reviewer',
'select_ind_revisors' => 'Click to select individual revisors',
'select_mimetype' => 'Click to select mimetype',
'select_modified' => 'Click to select date of modification',
'select_one' => 'Select one',
'select_option' => 'Select option',
'select_owner' => 'Click to select owner',
'select_record_type' => 'Choose type',
'select_status' => 'Click to select document status',
'select_user' => 'Select user',
'select_users' => 'Click to select users',
'select_value' => 'Select value',
'select_workflow' => 'Select workflow',
'send_email' => 'Send email',
'send_login_data' => 'Send login data',
'send_login_data_body' => 'Login data

Login: [login]
Name: [username]

[comment]

If you did not receive a password, please use the password forgotten function on the login page to set a new password.',
'send_login_data_subject' => '[sitename]: [login] - Your login data',
'send_notification' => 'Send notification',
'send_test_mail' => 'Send test mail',
'september' => 'September',
'sequence' => 'Sequence',
'seq_after' => 'After "[prevname]"',
'seq_end' => 'At the end',
'seq_keep' => 'Keep Position',
'seq_start' => 'First position',
'service_has_filter' => 'Service has filter',
'service_list_from' => 'From',
'service_list_info' => 'Information',
'service_list_to' => 'To',
'service_name' => 'Name of service',
'sessions' => 'Users online',
'setDateFromFile' => 'Take over date from imported file',
'setDateFromFile_desc' => 'Take over the date of the imported file as the date of the document in SeedDMS',
'setDateFromFolder' => 'Take over date from imported folder',
'setDateFromFolder_desc' => 'Take over the date of the imported directory as the date of the folder in SeedDMS',
'settings' => 'Settings',
'settings_activate_module' => 'Activate module',
'settings_activate_php_extension' => 'Activate PHP extension',
'settings_addManagerAsApprover' => 'Add group manager as approver',
'settings_addManagerAsApprover_desc' => 'All uploaded documents of a user will be approved by the managers of the users\'s groups.',
'settings_addManagerAsReviewer' => 'Add group manager as reviewer',
'settings_addManagerAsReviewer_desc' => 'All uploaded documents of a user will be reviewed by the managers of the users\'s groups.',
'settings_adminIP' => 'Admin IP',
'settings_adminIP_desc' => 'If set, admin can login only by specified IP address. Leave empty to avoid lose of access. NOTE: works only with local authentication (no LDAP)',
'settings_Advanced' => 'Advanced',
'settings_advancedAcl' => 'Advanced Access control',
'settings_advancedAcl_desc' => 'Advanced access controll will allow to turn on/off certain modules of the software. It can not be used for access rights on documents and folders.',
'settings_allowChangeRevAppInProcess' => 'Allow changing reviewer/approver after process started',
'settings_allowChangeRevAppInProcess_desc' => 'By default the reviewers and approvers cannot be changed anymore once a review or approval has been submitted. This option will allow administrators to do this as long as the document is not released or rejected.',
'settings_allowReviewerOnly' => 'Allow to set reviewer only',
'settings_allowReviewerOnly_desc' => 'Enable this, if it shall be allow to set just a reviewer but no approver in traditional workflow mode.',
'settings_alwaysShowClipboard' => 'Always show clipboard in main menu',
'settings_alwaysShowClipboard_desc' => 'Show the entry for the clipboard in the main menu, even if the clipboard is empty.',
'settings_alwaysShowMenuTasks' => 'Always show tasks in main menu',
'settings_alwaysShowMenuTasks_desc' => 'Shows the menu item in the main menu for the tasks, even if there are no tasks due.',
'settings_apache_mod_rewrite' => 'Apache - Module Rewrite',
'settings_apiKey' => 'Authentification key for REST api',
'settings_apiKey_desc' => 'This key is used a alternative authentication for the REST api. Choose a 32 char long string.',
'settings_apiOrigin' => 'Allowed origin of api calls',
'settings_apiOrigin_desc' => 'A list of addresses separated by semicolon. Each address has the form <protocol>://<domain>[:<port>]. The port can be omitted. If this field is left empty, no restrictions will apply.',
'settings_apiUserId' => 'User for REST api',
'settings_apiUserId_desc' => 'This user will be used by the REST api, if authentication was done with the configured api key.',
'settings_Authentication' => 'Authentication settings',
'settings_autoLoginUser' => 'Automatic login',
'settings_autoLoginUser_desc' => 'Use this user id for accesses if the user is not already logged in. Such an access will not create a session.',
'settings_available_languages' => 'Available languages',
'settings_available_languages_desc' => 'Only the selected languages will be loaded and show up in the language selector. The default language will always be loaded.',
'settings_backupDir' => 'Backup directory',
'settings_backupDir_desc' => 'Directory where the backup tool saves backups. If this directory is not set or cannot be accessed, then the backups will be saved in the content directory.',
'settings_baseUrl' => 'Base URL',
'settings_baseUrl_desc' => 'This is the URL without the HTTP root dir. Usually, this is determined by SeedDMS. Behind a proxy this can fail and in this case set it manually.',
'settings_batchOperations' => 'Allowed batch operations',
'settings_batchOperations_desc' => 'Allow only these batch operations on a search result. Except for exporting, all other batch operations require admin rights.',
'settings_cacheDir' => 'Cache directory',
'settings_cacheDir_desc' => 'Where the preview images are stored (best to choose a directory that is not accessible through your web-server)',
'settings_Calendar' => 'Calendar settings',
'settings_calendarDefaultView' => 'Calendar Default View',
'settings_calendarDefaultView_desc' => 'Calendar default view',
'settings_cannot_disable' => 'File ENABLE_INSTALL_TOOL could not deleted',
'settings_checkOutDir' => 'Directory for checked out documents',
'settings_checkOutDir_desc' => 'This is the directory where the latest content of a document is copied if the document is checked out. If you make this directory accessible for users, they can edit the file and check it back in when finished.',
'settings_cmdTimeout' => 'Timeout for external commands',
'settings_cmdTimeout_desc' => 'This duration in seconds determines when an external command (e.g. for creating the full text index) will be terminated.',
'settings_conf_field_not_editable' => 'This value is not editable',
'settings_contentDir' => 'Content directory',
'settings_contentDir_desc' => 'Where the uploaded files are stored (best to choose a directory that is not accessible through your web-server)',
'settings_contentOffsetDir' => 'Content Offset Directory',
'settings_contentOffsetDir_desc' => 'To work around limitations in the underlying file system, a new directory structure has been devised that exists within the content directory (Content Directory). This requires a base directory from which to begin. Usually leave this to the default setting, 1048576, but can be any number or string that does not already exist within (Content Directory)',
'settings_convertToPdf' => 'Convert document to PDF for preview',
'settings_convertToPdf_desc' => 'If a document cannot be natively displayed by the browser, a converted version to pdf will be shown.',
'settings_cookieLifetime' => 'Cookie Life time',
'settings_cookieLifetime_desc' => 'The life time of a cookie in seconds. If set to 0 the cookie will be removed when the browser is closed.',
'settings_coreDir' => 'Core SeedDMS directory',
'settings_coreDir_desc' => 'Path to SeedDMS_Core (optional). Leave this empty if you have installed SeedDMS_Core at a place where it can be found by PHP, e.g. Extra PHP Include-Path',
'settings_createCheckOutDir' => 'Create check out directory',
'settings_createCheckOutDir_desc' => 'Create checkout dir if it does not exists',
'settings_createdatabase' => 'Create database tables',
'settings_createdirectory' => 'Create directory',
'settings_currentvalue' => 'Current value',
'settings_Database' => 'Database settings',
'settings_dateformat' => 'Date format',
'settings_dateformat_desc' => 'This date format uses the syntax of php\'s date() function',
'settings_datetimeformat' => 'Date/Time format',
'settings_datetimeformat_desc' => 'This date format uses the syntax of php\'s date() function',
'settings_daysPastDashboard' => 'Days in past on dashboard',
'settings_daysPastDashboard_desc' => 'Take this number of days in the past into account when listing documents on the dashboard.',
'settings_dbDatabase' => 'Database',
'settings_dbDatabase_desc' => 'The name for your database entered during the installation process. Do not edit this field unless necessary, if for example the database has been moved.',
'settings_dbDriver' => 'Database Type',
'settings_dbDriver_desc' => 'The type of database in use entered during the installation process. Do not edit this field unless you are having to migrate to a different type of database perhaps due to changing hosts. Type of DB-Driver used by adodb (see adodb-readme)',
'settings_dbHostname' => 'Server name',
'settings_dbHostname_desc' => 'The hostname for your database entered during the installation process. Do not edit field unless absolutely necessary, for example transfer of the database to a new Host.',
'settings_dbPass' => 'Password',
'settings_dbPass_desc' => 'The password for access to your database entered during the installation process.',
'settings_dbUser' => 'Username',
'settings_dbUser_desc' => 'The username for access to your database entered during the installation process. Do not edit field unless absolutely necessary, for example transfer of the database to a new Host.',
'settings_dbVersion' => 'Database schema too old',
'settings_defaultAccessDocs' => 'Default access for new documents',
'settings_defaultAccessDocs_desc' => 'When a new document is created, this will be the default access right.',
'settings_defaultDocPosition' => 'Position of document when created',
'settings_defaultDocPosition_desc' => 'This is the default position within a folder when a new document is created.',
'settings_defaultDocPosition_val_end' => 'end',
'settings_defaultDocPosition_val_start' => 'start',
'settings_defaultFolderPosition' => 'Position of folder when created',
'settings_defaultFolderPosition_desc' => 'This is the default position within a folder when a new folder is created.',
'settings_defaultSearchMethod' => 'Default search method',
'settings_defaultSearchMethod_desc' => 'Default search method, when a search is started by the search form in the main menu.',
'settings_defaultSearchMethod_valdatabase' => 'database',
'settings_defaultSearchMethod_valfulltext' => 'fulltext',
'settings_delete_install_folder' => 'In order to use SeedDMS, you must delete the file ENABLE_INSTALL_TOOL in the configuration directory',
'settings_disableChangePassword' => 'Disallow changing own password',
'settings_disableChangePassword_desc' => 'If checked the user cannot change his/her password. Turn this on if LDAP authentication is used. It prevents setting a database password and circumvent LDAP authentication.',
'settings_disableReceiptComment' => 'Disable comment for reception',
'settings_disableReceiptComment_desc' => 'Turning this on will disable comments for receptions.',
'settings_disableSelfEdit' => 'Disable Self Edit',
'settings_disableSelfEdit_desc' => 'If checked user cannot edit his own profile',
'settings_disable_install' => 'Delete file ENABLE_INSTALL_TOOL if possible',
'settings_Display' => 'Display settings',
'settings_dropFolderDir' => 'Directory for drop folder',
'settings_dropFolderDir_desc' => 'This directory can be used for dropping files on the server\'s file system and importing them from there instead of uploading via the browser. The directory must contain a sub directory for each user who is allowed to import files this way.',
'settings_Edition' => 'Edition settings',
'settings_editOnlineFileTypes' => 'Edit Online File Types',
'settings_editOnlineFileTypes_desc' => 'Files with one of the following endings or mime types can be edited online (USE ONLY LOWER CASE CHARACTERS)',
'settings_enable2FactorAuthentication' => 'Enable 2-factor authentication',
'settings_enable2FactorAuthentication_desc' => 'Enable/disable 2 factor authentication. The users will need the Google Authenticator on its mobile phone.',
'settings_enableAcknowledgeWorkflow' => '',
'settings_enableAcknowledgeWorkflow_desc' => '',
'settings_enableAdminReceipt' => 'Allow reception of documents for admins',
'settings_enableAdminReceipt_desc' => 'Enable this if you want administrators to be listed as recipients of documents.',
'settings_enableAdminRevApp' => 'Allow review/approval for admins',
'settings_enableAdminRevApp_desc' => 'Enable this if you want administrators to be listed as reviewers/approvers and for workflow transitions.',
'settings_enableCalendar' => 'Enable Calendar',
'settings_enableCalendar_desc' => 'Enable/disable calendar',
'settings_enableCancelCheckout' => 'Allow to cancel check outs',
'settings_enableCancelCheckout_desc' => 'If checked, a checked out document which has already been modified can be discarded.',
'settings_enableClipboard' => 'Enable Clipboard',
'settings_enableClipboard_desc' => 'Enable/disable the clipboard on the \'View Folder\' page',
'settings_enableConverting' => 'Enable Converting',
'settings_enableConverting_desc' => 'Enable/disable converting of files',
'settings_enableDebugMode' => 'Debug mode',
'settings_enableDebugMode_desc' => 'Enable this to turn on debug mode which adds a new menu in the admin tools',
'settings_enableDropFolderList' => 'Enable list of files in drop folder in menu',
'settings_enableDropFolderList_desc' => 'Turn on a list of files in the drop folder. The list is shown in the main menu.',
'settings_enableDropUpload' => 'Enable Fast Upload',
'settings_enableDropUpload_desc' => 'Enable/Disable the drop area on the \'View Folder\' page for uploading files by Drag&Drop.',
'settings_enableDuplicateDocNames' => 'Allow duplicate document names',
'settings_enableDuplicateDocNames_desc' => 'Allows to have duplicate document names in a folder.',
'settings_enableDuplicateSubFolderNames' => 'Allow duplicate subfolder names',
'settings_enableDuplicateSubFolderNames_desc' => 'Allows to have duplicate subfolder names in a folder.',
'settings_enableEmail' => 'Enable E-mail Notification',
'settings_enableEmail_desc' => 'Enable/disable automatic email notification',
'settings_enableExtensionDownload' => 'Allow download of extensions',
'settings_enableExtensionDownload_desc' => 'Enable this to allow downloading extensions in the extension manager.',
'settings_enableExtensionImport' => 'Allow import of extensions',
'settings_enableExtensionImportFromRepository' => 'Allow import of extension from repository',
'settings_enableExtensionImportFromRepository_desc' => 'Enable this if extension may be imported from the repository.',
'settings_enableExtensionImport_desc' => 'If set, extension may be imported by uploading it in the extension manager.',
'settings_enableFilterReceipt' => 'Filter out owner, reviewer, ... from reception list',
'settings_enableFilterReceipt_desc' => 'Enable, in order to filter out some recipients from a reception list if members of a group are selected.',
'settings_enableFolderTree' => 'Enable Folder Tree',
'settings_enableFolderTree_desc' => 'Enable/Disable the folder tree on the \'View Folder\' page',
'settings_enableFullSearch' => 'Enable Full text search',
'settings_enableFullSearch_desc' => 'Enable Full text search',
'settings_enableGuestAutoLogin' => 'Enable auto login for guest',
'settings_enableGuestAutoLogin_desc' => 'If a guest login and auto login is enabled, the guest will be logged in automatically.',
'settings_enableGuestLogin' => 'Enable Guest Login',
'settings_enableGuestLogin_desc' => 'If you want anybody to login as guest, check this option. Note: guest login should be used only in a trusted environment',
'settings_enableHelp' => 'Enable Help',
'settings_enableHelp_desc' => 'Enable/disable the link to the help screens in the menu',
'settings_enableHiddenReceipt' => 'Allow reception of documents by hidden users',
'settings_enableHiddenReceipt_desc' => 'Enable this if you want hidden users to be listed as recipients of a document.',
'settings_enableHiddenRevApp' => 'Allow review/approval by hidden users',
'settings_enableHiddenRevApp_desc' => 'Enable this if you want hidden users to be listed as reviewers/approvers and for workflow transitions.',
'settings_enableLanguageSelector' => 'Enable Language Selector',
'settings_enableLanguageSelector_desc' => 'Show selector for user interface language after being logged in.',
'settings_enableLargeFileUpload' => 'Enable large file upload',
'settings_enableLargeFileUpload_desc' => 'If set, file upload is also available through a java applet called jumploader without a file size limit set by the browser. It also allows to upload several files in one step. Turning this on will turn off http only cookies.',
'settings_enableLoginByEmail' => 'Enable login by email',
'settings_enableLoginByEmail_desc' => 'If enabled, the user maya also use the email address for login. This will not disable login with the username. This setting may not be regarded by all authentication methods. Because the email is not unique, authentication may fail, even if the user enters a right password.',
'settings_enableMemcached' => 'Use memcached (experimental)',
'settings_enableMemcached_desc' => 'Use memcached for accelerating some database operations. This should not be be turned on in production.',
'settings_enableMenuTasks' => 'Enable task list in menu',
'settings_enableMenuTasks_desc' => 'Enable/Disable the menu item which contains all tasks for the user. This contains documents, that need to be reviewed, approved, etc.',
'settings_enableMenuTransmittals' => 'Enable transmittals in menu',
'settings_enableMenuTransmittals_desc' => 'Enable/Disable the menu item which contains all transmittals of the user.',
'settings_enableMultiUpload' => 'Allow upload of multiple files',
'settings_enableMultiUpload_desc' => 'When creating a new document, multiple files can be uploaded. Each will create a new document.',
'settings_enableNotificationAppRev' => 'Enable reviewer/approver notification',
'settings_enableNotificationAppRev_desc' => 'Check to send a notification to the reviewer/approver when a new document version is added',
'settings_enableNotificationWorkflow' => 'Send notification to users in next workflow transition',
'settings_enableNotificationWorkflow_desc' => 'If this option is enabled, the users and groups which need to take action in the next workflow transition will be notified. Even if they have not added a notification for the document.',
'settings_enableOwnerNotification' => 'Enable owner notification by default',
'settings_enableOwnerNotification_desc' => 'Check for adding a notification for the owner if a document when it is added.',
'settings_enableOwnerReceipt' => 'Allow reception of documents by owner',
'settings_enableOwnerReceipt_desc' => 'Enable this if you want the owner of a document to be listed as a recipient.',
'settings_enableOwnerRevApp' => 'Allow review/approval for owner',
'settings_enableOwnerRevApp_desc' => 'Enable this if you want the owner of a document to be listed as reviewers/approvers and for workflow transitions.',
'settings_enablePasswordForgotten' => 'Enable Password forgotten',
'settings_enablePasswordForgotten_desc' => 'If you want to allow user to set a new password and send it by mail, check this option.',
'settings_enableReceiptReject' => 'Enable rejection of receptions',
'settings_enableReceiptReject_desc' => 'Enable, to turn on the rejection of receptions.',
'settings_enableReceiptWorkflow' => 'Enable acknowledge of document reception',
'settings_enableReceiptWorkflow_desc' => 'Enable, to turn on the workflow to acknowledge document reception.',
'settings_enableRecursiveCount' => 'Enable recursive document/folder count',
'settings_enableRecursiveCount_desc' => 'If turned on, the number of documents and folders in the folder view will be determined by counting all objects by recursively processing the folders and counting those documents and folders the user is allowed to access.',
'settings_enableRemoveRevApp' => 'Allow removal of existing review/approval',
'settings_enableRemoveRevApp_desc' => 'Enable this, if admins may remove an review/approval. This will not delete the review/approval from the database, but add a new entry in the review/approval log setting status to its initial state.',
'settings_enableRevisionOneVoteReject' => 'Reject by one revisor',
'settings_enableRevisionOneVoteReject_desc' => 'If enabled, the document status will be set to \'needs correction\' once the first revisor rejects the document. If disabled, the document status will not change until all revisors have finished their revision.',
'settings_enableRevisionOnVoteReject' => '',
'settings_enableRevisionOnVoteReject_desc' => '',
'settings_enableRevisionWorkflow' => 'Enable revision of documents',
'settings_enableRevisionWorkflow_desc' => 'Enable, to be able to run the workflow for revising a document after a given period of time.',
'settings_enableSelfReceipt' => 'Allow reception of documents for logged in user',
'settings_enableSelfReceipt_desc' => 'Enable this if you want the currently logged in user to be listed as recipient for a document.',
'settings_enableSelfRevApp' => 'Allow review/approval by logged in user',
'settings_enableSelfRevApp_desc' => 'Enable this if you want the currently logged in user to be listed as reviewers/approvers and for workflow transitions.',
'settings_enableSessionList' => 'Enable list of users online in menu',
'settings_enableSessionList_desc' => 'Enable list of currently logged in users in menu.',
'settings_enableThemeSelector' => 'Theme selection',
'settings_enableThemeSelector_desc' => 'Turns on/off the theme selector on the login page.',
'settings_enableUpdateReceipt' => 'Allow editing of existing reception',
'settings_enableUpdateReceipt_desc' => 'Enable this, if the user who has made a reception may change the decission.',
'settings_enableUpdateRevApp' => 'Allow editing of existing review/approval',
'settings_enableUpdateRevApp_desc' => 'Enable this, if the user who has made a review/approval may change the decission as long as the current workflow step has not been finished.',
'settings_enableUserImage' => 'Enable User Image',
'settings_enableUserImage_desc' => 'Enable users images',
'settings_enableUsersView' => 'Enable Users View',
'settings_enableUsersView_desc' => 'Enable/disable group and user view for all users',
'settings_enableVersionDeletion' => 'Enable deletion of previous versions',
'settings_enableVersionDeletion_desc' => 'Enable/disable deletion of previous document versions by regular users. Admin may always delete old versions.',
'settings_enableVersionModification' => 'Enable modification of versions',
'settings_enableVersionModification_desc' => 'Enable/disable modification of a document versions by regular users after a version was uploaded. Admin may always modify the version after upload.',
'settings_enableWebdavReplaceDoc' => 'Replace document when saving',
'settings_enableWebdavReplaceDoc_desc' => 'If enabled, saving a new version of a document will replace the old document instead of creating a new version. This will only apply if the user, mimetype and filename are equal to the last version. This can be usefull when applications are auto saving a document in fixed intervals.',
'settings_enableXsendfile' => 'Use apache xsendfile module',
'settings_enableXsendfile_desc' => 'If this option is set and the apache module xsendfile is installed, it will be used for delivering images.',
'settings_encryptionKey' => 'Encryption key',
'settings_encryptionKey_desc' => 'This string is used for creating a unique identifier being added as a hidden field to a form in order to prevent CSRF attacks.',
'settings_error' => 'Error',
'settings_excludeFoldersDashboard' => 'Exclude folders from dashboard',
'settings_excludeFoldersDashboard_desc' => 'This folders will not be checked for documents shown on the dashboard. This can be useful for archived documents or documents in the trash.',
'settings_expandFolderTree' => 'Expand Folder Tree',
'settings_expandFolderTree_desc' => 'Expand Folder Tree',
'settings_expandFolderTree_val0' => 'start with tree hidden',
'settings_expandFolderTree_val1' => 'start with tree shown and first level expanded',
'settings_expandFolderTree_val2' => 'start with tree shown fully expanded',
'settings_ExtensionMgr' => 'Extension manager settings',
'settings_Extensions' => 'Extensions',
'settings_extraPath' => 'Extra PHP include Path',
'settings_extraPath_desc' => 'Path to additional software. This is the directory containing e.g. the adodb directory or additional pear packages',
'settings_firstDayOfWeek' => 'First day of the week',
'settings_firstDayOfWeek_desc' => 'First day of the week',
'settings_footNote' => 'Foot Note',
'settings_footNote_desc' => 'Message to display at the bottom of every page',
'settings_fullSearchEngine' => 'Fulltext engine',
'settings_fullSearchEngine_desc' => 'Set the method used for the fulltext search.',
'settings_fullSearchEngine_vallucene' => 'Zend Lucene',
'settings_fullSearchEngine_valsqlitefts' => 'SQLiteFTS',
'settings_globalApprover' => 'Add approver for all documents',
'settings_globalApprover_desc' => 'This users will be added to each uploaded document as mandatory approvers.',
'settings_globalGroupApprover' => 'Add group approver for all documents',
'settings_globalGroupApprover_desc' => 'This groups will be added to each uploaded document as mandatory approvers.',
'settings_globalGroupReviewer' => 'Add group reviewer for all documents',
'settings_globalGroupReviewer_desc' => 'This groups will be added to each uploaded document as mandatory reviewers.',
'settings_globalReviewer' => 'Add reviewer for all documents',
'settings_globalReviewer_desc' => 'This users will be added to each uploaded document as mandatory reviewers.',
'settings_global_approver_is_admin' => 'Approver \'[login]\' for all documents is administrator, but administrators may not approve.',
'settings_global_reviewer_is_admin' => 'Reviewer \'[login]\' for all documents is administrator, but administrators may not review.',
'settings_guestID' => 'Guest user',
'settings_guestID_desc' => 'ID of guest-user used when logged in as guest (mostly no need to change)',
'settings_guestid_is_admin' => 'Guest user is an administrator',
'settings_guestid_is_disabled' => 'Guest user is disabled',
'settings_httpRoot' => 'Http Root',
'settings_httpRoot_desc' => 'The relative path in the URL, after the domain part. Do not include the http:// prefix or the web host name. e.g. If the full URL is http://www.example.com/seeddms/, set \'/seeddms/\'. If the URL is http://www.example.com/, set \'/\'',
'settings_incItemsPerPage' => 'Number of entries loaded at end of page',
'settings_incItemsPerPage_desc' => 'If the number of folders and documents is limited, this will set the number of additionally loaded objects, when scrolling down to the bottom of the view folder page. Setting this to 0, will load the same number of objects as has been loaded initially.',
'settings_initialDocumentStatus' => 'Initial document status',
'settings_initialDocumentStatus_desc' => 'This status will be set when a document is added.',
'settings_initialDocumentStatus_draft' => 'Draft',
'settings_initialDocumentStatus_released' => 'released',
'settings_inlineEditing' => 'Inline editing',
'settings_inlineEditing_desc' => 'If enable, it will be possibly to edit the document name on the details page.',
'settings_installADOdb' => 'Install ADOdb',
'settings_install_disabled' => 'File ENABLE_INSTALL_TOOL was deleted. You can now log into SeedDMS and do further configuration.',
'settings_install_pear_package_log' => 'Install Pear package \'Log\'',
'settings_install_pear_package_webdav' => 'Install Pear package \'HTTP_WebDAV_Server\', if you intend to use the webdav interface',
'settings_install_success' => 'The installation has been successfully completed.',
'settings_install_welcome_text' => '<p>Before you start to install SeedDMS make sure you have created a file \'ENABLE_INSTALL_TOOL\' in your configuration directory, otherwise the installation will not work. On Unix-System this can easily be done with \'touch conf/ENABLE_INSTALL_TOOL\'. After you have finished the installation delete the file.</p><p>SeedDMS has very minimal requirements. You will need a mysql database or sqlite support and a php enabled web server. The pear package Log has to be installed too. For the lucene full text search, you will also need the Zend framework installed on disc where it can be found by php. For the WebDAV server you will also need the HTTP_WebDAV_Server. The path to it can later be set during installation.</p><p>If you like to create the database before you start installation, then just create it manually with your favorite tool, optionally create a database user with access on the database and import one of the database dumps in the configuration directory. The installation script can do that for you as well, but it will need database access with sufficient rights to create databases.</p>',
'settings_install_welcome_title' => 'Welcome to the installation of SeedDMS',
'settings_install_zendframework' => 'Install Zend Framework, if you intend to use the zend based full text search engine. Otherwise, ignore this message and continue the installation.',
'settings_invalid_guestid' => 'Invalid guest user',
'settings_language' => 'Default language',
'settings_language_desc' => 'Default language (name of a subfolder in folder "languages")',
'settings_libraryFolder' => 'Library folder',
'settings_libraryFolder_desc' => 'Folder where documents can be copied to create new documents.',
'settings_logFileEnable' => 'Log File Enable',
'settings_logFileEnable_desc' => 'Enable/disable log file',
'settings_logFileMaxLevel' => 'Maximum log level',
'settings_logFileMaxLevel_desc' => 'All messages up to this level will be logged',
'settings_logFileRestApiMaxLevel' => 'Rest Api maximum log level',
'settings_logFileRestApiMaxLevel_desc' => 'All messages of the Rest Api up to this level will be logged',
'settings_logFileRotation' => 'Log File Rotation',
'settings_logFileRotation_desc' => 'The log file rotation',
'settings_loginFailure' => 'Login failure',
'settings_loginFailure_desc' => 'Disable account after n login failures.',
'settings_logLevelAlert' => 'Alert',
'settings_logLevelCritical' => 'Critical',
'settings_logLevelDebug' => 'Debug',
'settings_logLevelEmergency' => 'Emergency',
'settings_logLevelError' => 'Error',
'settings_logLevelInfo' => 'Information',
'settings_logLevelNotice' => 'Notice',
'settings_logLevelWarning' => 'Warning',
'settings_luceneClassDir' => 'Lucene SeedDMS directory',
'settings_luceneClassDir_desc' => 'Path to SeedDMS_Lucene (optional). Leave this empty if you have installed SeedDMS_Lucene at a place where it can be found by PHP, e.g. Extra PHP Include-Path',
'settings_luceneDir' => 'Directory for full text index',
'settings_luceneDir_desc' => 'Path to Lucene index',
'settings_manager_approver_is_admin' => 'Manager ist adminstrator and a mandatory approver, but administrators may not approve.',
'settings_manager_reviewer_is_admin' => 'Manager ist adminstrator and a mandatory reviewer, but administrators may not review.',
'settings_markdownComments' => 'Parse comments as markdown',
'settings_markdownComments_desc' => 'Enable this, if comments of folders, documents and versions are interpreted as markdown.',
'settings_maxDirID' => 'Max Directory ID',
'settings_maxDirID_desc' => 'Maximum number of sub-directories per parent directory. Do not change this value unless you know what you do! Default: 0.',
'settings_maxExecutionTime' => 'Max Execution Time (s)',
'settings_maxExecutionTime_desc' => 'This sets the maximum time in seconds a script is allowed to run before it is terminated by the parse',
'settings_maxItemsPerPage' => 'Max. number of entries on a page',
'settings_maxItemsPerPage_desc' => 'Restricts the number of folders and documents shown on the view folder page. Further objects will be loaded when scrolling to the end of the page. Set to 0 to always show all objects.',
'settings_maxRecursiveCount' => 'Max. number of recursive document/folder count',
'settings_maxRecursiveCount_desc' => 'This is the maximum number of documents or folders that will be checked for access rights, when recursively counting objects. If this number is exceeded, the number of documents and folders in the folder view will be estimated.',
'settings_maxSizeForFullText' => 'Maximum file size for instant indexing',
'settings_maxSizeForFullText_desc' => 'All new document version smaller than the configured size will be fully indexed right after uploading. In all other cases only the metadata will be indexed.',
'settings_maxUploadSize' => 'Maxium size for uploaded files',
'settings_maxUploadSize_desc' => 'This is the maximum size for uploaded files. It will take affect for document versions and attachments.',
'settings_more_settings' => 'Configure more settings. Default login: admin/admin',
'settings_noDocumentFormFields' => 'Do not show this fields (documents)',
'settings_noDocumentFormFields_desc' => 'This fields will not be shown when adding or edition a document. Existing values will be kept.',
'settings_noFolderFormFields' => 'Do not show this fields (folder)',
'settings_noFolderFormFields_desc' => 'This fields will not be shown when adding or edition a folder. Existing values will be kept.',
'settings_notfound' => 'Not found',
'settings_Notification' => 'Notification settings',
'settings_notwritable' => 'The configuration cannot be saved because the configuration file is not writable.',
'settings_no_content_dir' => 'Content directory',
'settings_onePageMode' => 'One page mode',
'settings_onePageMode_desc' => 'One page mode will turn on javascript code on the ViewFolder page, which updates the folder/document list, navigation, etc. when clicking on a folder or changing the sort parameter.',
'settings_overrideMimeType' => 'Override MimeType',
'settings_overrideMimeType_desc' => 'Override the MimeType delivered by the browser, if a file is uploaded. The new MimeType is determined by SeedDMS itself.',
'settings_overrideTheme' => 'Override theme',
'settings_overrideTheme_desc' => 'Enable this for overriding the theme store in the user record with the theme configured in this configuration.',
'settings_partitionSize' => 'Partial file size',
'settings_partitionSize_desc' => 'Size of partial files in bytes, uploaded by jumploader. Do not set a value larger than the maximum upload size set by the server.',
'settings_passwordExpiration' => 'Password expiration',
'settings_passwordExpiration_desc' => 'The number of days after which a password expireѕ and must be reset. 0 turns password expiration off.',
'settings_passwordHistory' => 'Password history',
'settings_passwordHistory_desc' => 'The number of passwords a user must have been used before a password can be reused. 0 turns the password history off.',
'settings_passwordStrength' => 'Min. password strength',
'settings_passwordStrengthAlgorithm' => 'Algorithm for password strength',
'settings_passwordStrengthAlgorithm_desc' => 'The algorithm used for calculating the password strength. The \'simple\' algorithm just checks for at least eight chars total, a lower case letter, an upper case letter, a number and a special char. If those conditions are met the returned score is 100 otherwise 0.',
'settings_passwordStrengthAlgorithm_valadvanced' => 'advanced',
'settings_passwordStrengthAlgorithm_valsimple' => 'simple',
'settings_passwordStrength_desc' => 'The minimum password strength is an integer value from 0 to 100. Setting it to 0 will turn off checking for the minimum password strength.',
'settings_pear_log' => 'Pear package : Log',
'settings_pear_webdav' => 'Pear package : HTTP_WebDAV_Server',
'settings_perms' => 'Permissions',
'settings_php_dbDriver' => 'PHP extension : php_\'see current value\'',
'settings_php_gd2' => 'PHP extension : php_gd2',
'settings_php_mbstring' => 'PHP extension : php_mbstring',
'settings_php_version' => 'PHP version',
'settings_presetExpirationDate' => 'Preset expiration date',
'settings_presetExpirationDate_desc' => 'All new uploaded documents will have an expiration date set to this value. The date entered can be specified as understood by PHP\'s strtotime() function, e.g. +5 weeks.',
'settings_previewWidthDetail' => 'Width of preview images (detail)',
'settings_previewWidthDetail_desc' => 'Width of preview image shown on details page',
'settings_previewWidthDropFolderList' => 'Width of preview images (dropfolder list)',
'settings_previewWidthDropFolderList_desc' => 'Width of preview images shown in list when selecting a file from the drop folder.',
'settings_previewWidthList' => 'Width of preview images (list)',
'settings_previewWidthList_desc' => 'Width of preview images shown in lists',
'settings_previewWidthMenuList' => 'Width of preview images (menu list)',
'settings_previewWidthMenuList_desc' => 'Width of preview images shown as items in drop folder menu.',
'settings_printDisclaimer' => 'Print Disclaimer',
'settings_printDisclaimer_desc' => 'If enabled, the disclaimer message will be printed on the bottom of every page',
'settings_proxyUPassword' => 'Password for proxy',
'settings_proxyUPassword_desc' => 'Password for authentication at the proxy',
'settings_proxyUrl' => 'URL of proxy',
'settings_proxyUrl_desc' => 'URL of proxy used for accessing the extension repository.',
'settings_proxyUser' => 'User name used for proxy',
'settings_proxyUser_desc' => 'User name used for authentication with the proxy',
'settings_quota' => 'User\'s quota',
'settings_quota_desc' => 'The maximum number of bytes a user may use on disk. Set this to 0 for unlimited disk space. This value can be overridden for each user in his profile.',
'settings_removeFromDropFolder' => 'Remove file from drop folder after successful upload',
'settings_removeFromDropFolder_desc' => 'Enable this, if a file taken from the drop folder shall be deleted after successful upload.',
'settings_repositoryUrl' => 'URL of repository',
'settings_repositoryUrl_desc' => 'URL of repository for extensions',
'settings_restricted' => 'Restricted access',
'settings_restricted_desc' => 'Only allow users to log in if they have an entry in the local database (irrespective of successful authentication with LDAP)',
'settings_rootDir' => 'Root directory',
'settings_rootDir_desc' => 'Path to where SeedDMS is located',
'settings_rootFolderID' => 'Root Folder ID',
'settings_rootFolderID_desc' => 'ID of root-folder (mostly no need to change)',
'settings_SaveError' => 'Configuration file save error',
'settings_Server' => 'Server settings',
'settings_showFullPreview' => 'Show complete document',
'settings_showFullPreview_desc' => 'Enable/disable a full preview of the document on the details page, if the browser is capable to do so.',
'settings_showMissingTranslations' => 'Show missing translations',
'settings_showMissingTranslations_desc' => 'List all missing translations on the page at the bottom of the page. The logged in user will be able to submit a proposal for a missing translation which will be saved in a csv file. Do not turn this function on if in a production environment!',
'settings_showSingleSearchHit' => 'Jump straight to a single search hit',
'settings_showSingleSearchHit_desc' => 'If the search results into just one hit, then it will be displayed right away instead of the result list.',
'settings_Site' => 'Site',
'settings_siteDefaultPage' => 'Site Default Page',
'settings_siteDefaultPage_desc' => 'Default page on login. If empty defaults to out/out.ViewFolder.php',
'settings_siteName' => 'Site Name',
'settings_siteName_desc' => 'Name of site used in the page titles. Default: SeedDMS',
'settings_SMTP' => 'SMTP Server settings',
'settings_smtpForceFrom' => 'Force from email',
'settings_smtpForceFrom_desc' => 'Use address from \'Send from\' for all outgoing mail.',
'settings_smtpLazySSL' => 'Lazy SSL checking',
'settings_smtpLazySSL_desc' => 'Turn off checking for a valid SSL certificate. This can be useful if self signed certificates are used or a certificate has expired. Turning this on can be dangerous, if you do not know the potential risks.',
'settings_smtpPassword' => 'SMTP Server password',
'settings_smtpPassword_desc' => 'SMTP Server password',
'settings_smtpPort' => 'SMTP Server port',
'settings_smtpPort_desc' => 'SMTP Server port, default 25',
'settings_smtpSendFrom' => 'Send from',
'settings_smtpSendFrom_desc' => 'Send from',
'settings_smtpSendTestMail' => 'Send test mail',
'settings_smtpSendTestMail_desc' => 'Sends a test mail, for checking the current email configuration.',
'settings_smtpServer' => 'SMTP Server hostname',
'settings_smtpServer_desc' => 'SMTP Server hostname',
'settings_smtpUser' => 'SMTP Server user',
'settings_smtpUser_desc' => 'SMTP Server user',
'settings_sortFoldersDefault' => 'Default sort method',
'settings_sortFoldersDefault_desc' => 'This sets the sort methods for folders and documents in the folder view.',
'settings_sortFoldersDefault_val_name' => 'by name',
'settings_sortFoldersDefault_val_sequence' => 'by sequence',
'settings_sortFoldersDefault_val_unsorted' => 'unsorted',
'settings_sortUsersInList' => 'Sort users in list',
'settings_sortUsersInList_desc' => 'Sets if users in selection menus are ordered by login or by its full name',
'settings_sortUsersInList_val_fullname' => 'Sort by full name',
'settings_sortUsersInList_val_login' => 'Sort by login',
'settings_stagingDir' => 'Directory for partial uploads',
'settings_stagingDir_desc' => 'The directory where jumploader places the parts of a file upload before it is put back together.',
'settings_start_install' => 'Start installation',
'settings_stopWordsFile' => 'Path to stop words file',
'settings_stopWordsFile_desc' => 'If fulltext search is enabled, this file will contain stop words not being indexed',
'settings_strictFormCheck' => 'Strict Form Check',
'settings_strictFormCheck_desc' => 'Strict form checking. If set to true, then all fields in the form will be checked for a value. If set to false, then (most) comments and keyword fields become optional. Comments are always required when submitting a review or overriding document status',
'settings_suggestionvalue' => 'Suggestion value',
'settings_suggestTerms' => 'Suggest terms',
'settings_suggestTerms_desc' => 'If enabled, the search field in the header will not just list documents and folders, but also possible search terms',
'settings_System' => 'System',
'settings_tasksInMenu' => 'Selected tasks',
'settings_tasksInMenu_approval' => 'Approvals',
'settings_tasksInMenu_checkedout' => 'Checked out',
'settings_tasksInMenu_desc' => 'Select those tasks which are to be counted. If none is selected, then all tasks will be counted.',
'settings_tasksInMenu_needscorrection' => 'Correction needed',
'settings_tasksInMenu_receipt' => 'Receipts',
'settings_tasksInMenu_rejected' => 'Rejected',
'settings_tasksInMenu_review' => 'Reviews',
'settings_tasksInMenu_revision' => 'Revisions',
'settings_tasksInMenu_workflow' => 'Workflow',
'settings_theme' => 'Default theme',
'settings_theme_desc' => 'Default style (name of a subfolder in folder "styles")',
'settings_titleDisplayHack' => 'Title Display Hack',
'settings_titleDisplayHack_desc' => 'Workaround for page titles that go over more than 2 lines.',
'settings_undelUserIds' => 'Undeletable User IDs',
'settings_undelUserIds_desc' => 'Comma separated list of user ids, that cannot be deleted.',
'settings_updateDatabase' => 'Run schema update scripts on database',
'settings_updateNotifyTime' => 'Update Notify Time',
'settings_updateNotifyTime_desc' => 'Users are notified about document-changes that took place within the last \'Update Notify Time\' seconds',
'settings_upgrade_php' => 'Upgrade PHP to at least version 5.6.38',
'settings_uploadedAttachmentIsPublic' => 'New attachments are public',
'settings_uploadedAttachmentIsPublic_desc' => 'New attachments, which are either uploaded by form or drag&drop are by default public.',
'settings_useHomeAsRootFolder' => 'Use home folder as root folder',
'settings_useHomeAsRootFolder_desc' => 'Enable this if the user\'s home folder (no admin) shall be used as the root folder (experimental)',
'settings_versioningFileName' => 'Versioning FileName',
'settings_versioningFileName_desc' => 'The name of the versioning info file created by the backup tool',
'settings_versiontolow' => 'Version to low',
'settings_viewOnlineFileTypes' => 'View Online File Types',
'settings_viewOnlineFileTypes_desc' => 'Files with one of the following endings can be viewed online (USE ONLY LOWER CASE CHARACTERS)',
'settings_webdav' => 'WebDAV',
'settings_workflowMode' => 'Workflow mode',
'settings_workflowMode_desc' => 'The advanced workflow allows to specify your own release workflow for document versions.',
'settings_workflowMode_valadvanced' => 'advanced',
'settings_workflowMode_valnone' => 'none',
'settings_workflowMode_valtraditional' => 'traditional',
'settings_workflowMode_valtraditional_only_approval' => 'traditional (without review)',
'settings_zendframework' => 'Zend Framework',
'set_expiration_date_help' => 'The document expires with the start of the day.',
'set_expiry' => 'Set Expiration',
'set_owner' => 'Set Owner',
'set_owner_error' => 'Error setting owner',
'set_password' => 'Set Password',
'set_workflow' => 'Set Workflow',
'show_extension_changelog' => 'Show Changelog',
'show_extension_readme' => 'Show Readme',
'show_extension_version_list' => 'Show list of versions',
'signed_in_as' => 'Signed in as',
'sign_in' => 'Sign in',
'sign_out' => 'Sign out',
'sign_out_user' => 'Sign out user',
'site_brand' => '',
'skip_default_export_cols' => 'Skip default columns',
'sk_SK' => 'Slovak',
'sort_by_date' => 'Sort by date',
'sort_by_expiration_date' => 'Sort by date of expiration',
'sort_by_name' => 'Sort by name',
'sort_by_sequence' => 'Sort by sequence',
'space_used_on_data_folder' => 'Space used on data folder',
'splash_added_to_clipboard' => 'Added to clipboard',
'splash_add_access' => 'New Access right added',
'splash_add_attribute' => 'New attribute added',
'splash_add_category' => 'New category added',
'splash_add_group' => 'New group added',
'splash_add_group_member' => 'New group member added',
'splash_add_keyword' => 'New keyword added',
'splash_add_keyword_category' => 'New list of keywords added',
'splash_add_notify' => 'Added new notification',
'splash_add_role' => 'Added new role',
'splash_add_task' => 'Added new task',
'splash_add_to_transmittal' => 'Added to transmittal',
'splash_add_transmittal' => 'Added new transmittal',
'splash_add_user' => 'Added new user',
'splash_cancel_checkout' => 'Checkout canceled',
'splash_checked_in' => 'Document checked in',
'splash_cleared_cache' => 'Cache cleared',
'splash_cleared_clipboard' => 'Clipboard cleared',
'splash_delete_access' => 'Access right deleted',
'splash_document_added' => 'Document added',
'splash_document_checkedout' => 'Document checked out',
'splash_document_deleted' => 'Document deleted',
'splash_document_edited' => 'Document saved',
'splash_document_indexed' => 'Document \'[name]\' indexed.',
'splash_document_locked' => 'Document locked',
'splash_document_name_changed' => 'Document name changed',
'splash_document_unlocked' => 'Document unlocked',
'splash_document_updated' => 'Document updated',
'splash_edit_access' => 'Access right changed',
'splash_edit_attribute' => 'Attribute saved',
'splash_edit_category' => 'Category saved',
'splash_edit_event' => 'Event saved',
'splash_edit_group' => 'Group saved',
'splash_edit_keyword' => 'Keyword saved',
'splash_edit_keyword_category' => 'Name of keyword list changed',
'splash_edit_role' => 'Role saved',
'splash_edit_task' => 'Task saved',
'splash_edit_transmittal' => 'Transmittal saved',
'splash_edit_user' => 'User saved',
'splash_error_add_to_transmittal' => 'Error while adding document to transmittal',
'splash_error_checkin_ended' => 'Ended checkin and discarded changes',
'splash_error_rm_download_link' => 'Error when removing download link',
'splash_error_saving_file' => 'Error while saving file',
'splash_error_send_download_link' => 'Error while sending download link',
'splash_expiration_date_cleared' => 'Cleared expiration date',
'splash_expiration_date_set' => 'Set expiration date on [date]',
'splash_extension_getlist' => 'Updated list of extensions from repository',
'splash_extension_import' => 'Extension installed',
'splash_extension_refresh' => 'Refreshed list of extensions',
'splash_extension_upload' => 'Extension installed',
'splash_folder_added' => 'Folder added',
'splash_folder_deleted' => 'Folder deleted',
'splash_folder_edited' => 'Save folder changes',
'splash_importfs' => 'Imported [docs] documents and [folders] folders',
'splash_inherit_access' => 'Access right will be inherited',
'splash_invalid_folder_id' => 'Invalid folder ID',
'splash_invalid_searchterm' => 'Invalid search term',
'splash_invalid_search_service' => 'Invalid search service',
'splash_link_document' => 'Link added',
'splash_mimetype_changed' => 'Mimetype changed successfully',
'splash_moved_clipboard' => 'Clipboard moved into current folder',
'splash_move_document' => 'Document moved',
'splash_move_folder' => 'Folder moved',
'splash_notinherit_access' => 'Access rights no longer inherited',
'splash_receipt_update_success' => 'Reception added successfully',
'splash_removed_from_clipboard' => 'Removed from clipboard',
'splash_rm_attribute' => 'Attribute removed',
'splash_rm_attr_value' => 'Attribute value removed',
'splash_rm_category' => 'Category removed',
'splash_rm_document' => 'Document removed',
'splash_rm_download_link' => 'Removed download link',
'splash_rm_folder' => 'Folder deleted',
'splash_rm_group' => 'Group removed',
'splash_rm_group_member' => 'Member of group removed',
'splash_rm_keyword' => 'Keyword removed',
'splash_rm_keyword_category' => 'List of keywords removed',
'splash_rm_notify' => 'Notification deleted',
'splash_rm_role' => 'Role deleted',
'splash_rm_transmittal' => 'Transmittal deleted',
'splash_rm_user' => 'User removed',
'splash_rm_user_processes' => 'User removed from all processes',
'splash_rm_workflow' => 'Workflow removed',
'splash_rm_workflow_action' => 'Workflow action removed',
'splash_rm_workflow_state' => 'Workflow state removed',
'splash_saved_file' => 'Version saved',
'splash_save_user_data' => 'User data saved',
'splash_send_download_link' => 'Download link sent by email.',
'splash_send_login_data' => 'Login data sent',
'splash_setowner' => 'Set new owner',
'splash_settings_saved' => 'Settings saved',
'splash_set_default_access' => 'Default access right set',
'splash_substituted_user' => 'Substituted user',
'splash_switched_back_user' => 'Switched back to original user',
'splash_toogle_group_manager' => 'Group manager toogled',
'splash_transfer_content' => 'Content transferred',
'splash_transfer_document' => 'Document transferred',
'splash_transfer_objects' => 'Objects transferred',
'splash_trigger_workflow' => 'Triggered transition of workflow',
'startdate' => 'Start date',
'state_and_next_state' => 'State/Next state',
'statistic' => 'Statistic',
'statistics_mail_subject' => 'Statistics',
'status' => 'Status',
'status_approval_rejected' => 'rejected',
'status_approved' => 'Approved',
'status_approver_removed' => 'Approver removed from process',
'status_change' => 'Status change',
'status_needs_correction' => 'Needs correction',
'status_not_approved' => 'Not approved',
'status_not_receipted' => 'Not receipted yet',
'status_not_reviewed' => 'Not reviewed',
'status_not_revised' => 'not revised',
'status_receipted' => 'Receipted',
'status_receipt_rejected' => 'Rejected',
'status_recipient_removed' => 'Recipient removed from list',
'status_reviewed' => 'Reviewed',
'status_reviewer_rejected' => 'rejected',
'status_reviewer_removed' => 'Reviewer removed from process',
'status_revised' => 'revised',
'status_revision_rejected' => 'Rejected',
'status_revision_sleeping' => 'pending',
'status_revisor_removed' => 'Revisor removed from list',
'status_unknown' => 'Unknown',
'storage' => 'Storage',
'storage_size' => 'Storage size',
'subfolder_duplicate_name' => 'Duplicate subfolder name',
'submit_2_fact_auth' => 'Save secret',
'submit_approval' => 'Submit approval',
'submit_login' => 'Sign in',
'submit_password' => 'Set new password',
'submit_password_forgotten' => 'Start process',
'submit_receipt' => 'Submit receipt',
'submit_review' => 'Submit review',
'submit_revision' => 'Add Revision',
'submit_userinfo' => 'Submit info',
'submit_webauthn_login' => 'Login with webauthn',
'submit_webauthn_register' => 'Register',
'subsribe_timelinefeed' => 'Subscribe to time line feed',
'substitute_to_user' => 'Switch to \'[username]\'',
'substitute_user' => 'Substitute User',
'success_add_aro' => 'Access request object added',
'success_add_permission' => 'Added permission',
'success_remove_permission' => 'Removed permission',
'success_toogle_permission' => 'Permission changed',
'sunday' => 'Sunday',
'sunday_abbr' => 'Su',
'sv_SE' => 'Swedish',
'switched_to' => 'Switched to',
'takeOverAttributeValue' => 'Take over attribute value from last version',
'takeOverGrpApprover' => 'Take over group of approvers from last version.',
'takeOverGrpApprovers' => 'Take Over Group Approvers',
'takeOverGrpReviewer' => 'Take over group of reviewers from last version.',
'takeOverGrpReviewers' => 'Take Over Group Reviewers',
'takeOverIndApprover' => 'Take over individual approver from last version.',
'takeOverIndApprovers' => 'Take Over Individual Approvers',
'takeOverIndReviewer' => 'Take over individual reviewer from last version.',
'takeOverIndReviewers' => 'Take Over Individual Reviewers',
'target_equals_source_folder' => 'Target folder equals source folder',
'tasks' => 'Tasks',
'task_core_expireddocs_days' => 'Days',
'task_core_expireddocs_dryrun' => 'Dry run',
'task_core_expireddocs_email' => 'Email',
'task_core_expireddocs_peruser' => 'Per user',
'task_core_importdropfolder_dryrun' => 'Dry run',
'task_core_importdropfolder_dryrun_desc' => 'If this is enabled, no files will be imported and deleted from the drop folder, but all actions are logged.',
'task_core_importdropfolder_keepfile' => 'Keep file in drop folder',
'task_core_importdropfolder_keepfile_desc' => 'If enabled, the imported file will not be deleted from the drop folder.',
'task_core_importdropfolder_recursive' => 'Recursive',
'task_core_importdropfolder_targetfolder' => 'Target folder',
'task_core_importdropfolder_targetfolder_desc' => 'The files in the drop folder will be imported into this SeedDMS folder.',
'task_core_importdropfolder_users' => 'Users',
'task_core_indexingdocs_recreate' => 'Recreate index',
'task_core_recentchanges_days' => 'Days',
'task_core_recentchanges_lists' => 'Lists',
'task_core_recentchanges_users' => 'Users',
'task_core_statistic_users' => 'Users',
'task_description' => 'Description',
'task_disabled' => 'Disabled',
'task_failures' => 'failed runs',
'task_frequency' => 'Frequency',
'task_frequency_placeholder' => 'm h d m dow, or @daily, @hourly',
'task_last_run' => 'Last run',
'task_name' => 'Name',
'task_next_run' => 'Next run',
'temp_jscode' => 'Temporary javascript code',
'testmail_body' => 'This mail is just for testing the mail configuration of SeedDMS

URL: [url]
Sitename: [sitename]
Version: [version]
SMTP Server: [smtpserver]
SMTP Port: [smtpport]
No SSL Check: [lazyssl]
Use Sender from: [forcefrom]',
'testmail_subject' => 'Test mail',
'theme' => 'Theme',
'thursday' => 'Thursday',
'thursday_abbr' => 'Th',
'timeline' => 'Timeline',
'timeline_add_file' => 'New Attachment',
'timeline_add_version' => 'New version [version]',
'timeline_full_add_file' => '[document]<br />New Attachment',
'timeline_full_add_version' => '[document]<br />New version [version]',
'timeline_full_scheduled_revision' => '[document]<br />Revision of version [version]',
'timeline_full_status_change' => '[document]<br />Version [version]: [status]',
'timeline_scheduled_revision' => 'Revision of version [version]',
'timeline_selected_item' => 'Selected document',
'timeline_skip_add_file' => 'attachment added',
'timeline_skip_scheduled_revision' => 'Scheduled revision',
'timeline_skip_status_change_-1' => 'rejected',
'timeline_skip_status_change_-2' => 'obsolete',
'timeline_skip_status_change_-3' => 'expired',
'timeline_skip_status_change_0' => 'pending review',
'timeline_skip_status_change_1' => 'pending approval',
'timeline_skip_status_change_2' => 'released',
'timeline_skip_status_change_3' => 'in workflow',
'timeline_skip_status_change_4' => 'in revision',
'timeline_skip_status_change_5' => 'draft',
'timeline_status_change' => 'Version [version]: [status]',
'title' => 'title',
'to' => 'To',
'toggle_manager' => 'Toggle manager',
'toggle_qrcode' => 'Show/hide QR code',
'total' => 'Total',
'to_before_from' => 'End date may not be before start date',
'transfer_content' => 'Transfer content',
'transfer_document' => 'Transfer document',
'transfer_no_read_access' => 'The user does not have read access in the folder',
'transfer_no_users' => 'There are currently no users the document can be transferred to.',
'transfer_no_write_access' => 'The user does not have write access in the folder',
'transfer_objects' => 'Transfer objects',
'transfer_objects_to_user' => 'New owner',
'transfer_processes_to_user' => 'Transfer processes to user',
'transfer_process_to_user' => 'Transfer process to user',
'transfer_to_user' => 'Transfer to user',
'transition_triggered_email' => 'Workflow transition triggered',
'transition_triggered_email_body' => 'Workflow transition triggered

Document: [name]
Version: [version]
Comment: [comment]
Workflow: [workflow]
Previous state: [previous_state]
Current state: [current_state]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'transition_triggered_email_body_html' => '<p>Workflow transition triggered</p>

<p>Document: [name]<br />
Version: [version]<br />
Comment: [comment]<br />
Workflow: [workflow]<br />
Previous state: [previous_state]<br />
Current state: [current_state]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'transition_triggered_email_subject' => '[sitename]: [name] - Workflow transition triggered',
'transmittal' => 'Transmittal',
'transmittalitem_removed' => 'Transmittal item removed',
'transmittalitem_updated' => 'Document updated to latest version',
'transmittals' => 'Transmittals',
'transmittal_comment' => 'Comment',
'transmittal_name' => 'Name',
'transmittal_size' => 'Size',
'tree_loading' => 'Please wait, until the document tree is loaded …',
'trigger_workflow' => 'Workflow',
'tr_TR' => 'Turkish',
'tuesday' => 'Tuesday',
'tuesday_abbr' => 'Tu',
'types_generic' => 'Generic types',
'type_of_hook' => 'Type',
'type_to_filter' => 'Type to filter list',
'type_to_search' => 'Type to search',
'uk_UA' => 'Ukrainian',
'undefined' => 'undefined',
'under_folder' => 'In Folder',
'unknown_attrdef' => 'Unknown attribute definition',
'unknown_command' => 'Command not recognized.',
'unknown_document_category' => 'Unknown category',
'unknown_group' => 'Unknown group id',
'unknown_id' => 'unknown id',
'unknown_keyword_category' => 'Unknown category',
'unknown_owner' => 'Unknown owner id',
'unknown_status' => 'Unknown status',
'unknown_user' => 'Unknown user id',
'unlinked_content' => 'Unlinked content',
'unlinked_documents' => 'Unlinked documents',
'unlinked_folders' => 'Unlinked folders',
'unlinking_objects' => 'Unlinking content',
'unlock_cause_access_mode_all' => 'You can still update it because you have access-mode "all". Locking will automatically be removed.',
'unlock_cause_locking_user' => 'You can still update it because you are also the one that locked it. Locking will automatically be removed.',
'unlock_document' => 'Unlock',
'update' => 'Update',
'updated' => 'updated',
'updated_documents' => 'Updated documents',
'update_approvers' => 'Update List of Approvers',
'update_document' => 'Update document',
'update_fulltext_index' => 'Update fulltext index',
'update_fulltext_messages' => 'Messages',
'update_info' => 'Update Information',
'update_locked_msg' => 'This document is locked.',
'update_recipients' => 'Update list of recipients',
'update_reviewers' => 'Update list of Reviewers',
'update_revisors' => 'Update list of revisors',
'update_transmittalitem' => 'Update to latest document version',
'uploaded_by' => 'Uploaded by',
'uploading_failed' => 'Uploading one of your files failed. Please check your maximum upload file size.',
'uploading_maxsize' => 'The uploaded file exceeds the maximum upload file size.',
'uploading_postmaxsize' => 'The post request exceeds the maximum size.',
'uploading_zerosize' => 'Uploading an empty file. Upload is canceled.',
'used_discspace' => 'Used disk space',
'user' => 'User',
'userdata_file' => 'User data file',
'userid_groupid' => 'User id/Group id',
'users' => 'Users',
'users_and_groups' => 'Users/Groups',
'users_done_work' => 'Users done work',
'user_exists' => 'User already exists.',
'user_group' => 'User/Group',
'user_group_management' => 'Users/Groups management',
'user_image' => 'Image',
'user_info' => 'User Information',
'user_is_mandatory_approver' => 'User is mandatory approver',
'user_is_mandatory_reviewer' => 'User is mandatory reviewer',
'user_list' => 'List of Users',
'user_login' => 'User ID',
'user_management' => 'Users management',
'user_name' => 'Full name',
'user_previously_removed_from_approvers' => 'User was previously removed as a approver.',
'user_previously_removed_from_recipients' => 'User was previously removed as a revisor.',
'user_previously_removed_from_reviewers' => 'User was previously removed as a reviewer.',
'user_previously_removed_from_revisors' => 'User was previously removed as a revisor.',
'use_comment_of_document' => 'Use comment of document',
'use_default_categories' => 'Use predefined categories',
'use_default_keywords' => 'Use predefined keywords',
'valid_till' => 'Valid till',
'version' => 'Version',
'versioning_file_creation' => 'Versioning file creation',
'versioning_file_creation_warning' => 'With this operation you can create a file for each document containing the versioning information of that document. After the creation every file will be saved inside the document folder. Those files are not needed for the regular operation of the dms, but could be of value if the complete repository shall be transferred to an other system.',
'versioning_info' => 'Versioning info',
'versiontolow' => 'Version to low',
'version_comment' => 'Comment of version',
'version_comment_changed_email_body' => 'Comment changed

Document: [name]
Version: [version]
Old comment: [old_comment]
New Comment: [new_comment]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'version_comment_changed_email_body_html' => '<p>Comment changed</p>

<p>Document: [name]<br />
Version: [version]<br />
Old comment: [old_comment]<br />
New Comment: [new_comment]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'version_comment_changed_email_subject' => '[sitename]: [name] - Comment changed',
'version_deleted_email' => 'Version deleted',
'version_deleted_email_body' => 'Version deleted

Document: [name]
Version: [version]
Parent folder: [folder_path]
User: [username]
URL: [url]',
'version_deleted_email_body_html' => '<p>Version deleted</p>

<p>Document: [name]<br />
Version: [version]<br />
Parent folder: [folder_path]<br />
User: [username]<br />
URL: [url]</p>',
'version_deleted_email_subject' => '[sitename]: [name] - Version deleted',
'version_info' => 'Version Information',
'view' => 'View',
'view_document' => 'View document details',
'view_folder' => 'View folder details',
'view_online' => 'View online',
'warning' => 'Warning',
'warning_remove_approval_log' => 'Removing a single approval cannot not be undone and will not be reported. The reviewer must redo the review.',
'warning_remove_review_log' => 'Removing a single review cannot not be undone and will not be reported. The reviewer must redo the review.',
'webauthn' => 'Webauthn',
'webauthn_auth' => 'WebAuthn Authentification',
'webauthn_crossplatform_info' => 'Use cross-platform \'Yes\' when you have a removable device, like a Yubico key, which you would want to use to login on different computers; say \'No\' when your device is attached to the computer. The choice affects which device(s) are offered by the browser and/or computer security system.',
'webauthn_info' => 'WebAuthn is a password less authentification using public key cryptography. A private-public keypair (known as a credential) is created for a website. The private key is stored securely on the user’s device; a public key and randomly generated credential ID is sent to the server for storage. The server can then use that public key to prove the user’s identity. The private key is usually stored on a hardware token. The token must be registered before it can be used for authentication.',
'webauthn_login_test' => 'Login test',
'webauthn_registration' => 'Registration',
'webauth_crossplatform' => 'Crossplatform',
'wednesday' => 'Wednesday',
'wednesday_abbr' => 'We',
'weeks' => 'weeks',
'week_view' => 'Week view',
'workflow' => 'Workflow',
'workflows_involded' => 'Involved in workflow',
'workflow_actions_management' => 'Workflow actions management',
'workflow_action_in_use' => 'This action is currently used by workflows.',
'workflow_action_name' => 'Name',
'workflow_editor' => 'Workflow Editor',
'workflow_group_summary' => 'Group summary',
'workflow_has_cycle' => 'Workflow has cycle',
'workflow_initstate' => 'Initial state',
'workflow_in_use' => 'This workflow is currently used by documents.',
'workflow_layoutdata_saved' => 'Layout data saved',
'workflow_log' => 'Workflow protocol',
'workflow_management' => 'Workflow management',
'workflow_name' => 'Name',
'workflow_no_doc_rejected_state' => 'The document will not be rejected in a workflow state!',
'workflow_no_doc_released_state' => 'The document will not be released in a workflow state!',
'workflow_no_initial_state' => 'None of the transitions starts with the initial state of the workflow!',
'workflow_no_states' => 'You must first define workflow states, before adding a workflow.',
'workflow_save_layout' => 'Save layout',
'workflow_state' => 'workflow state',
'workflow_states_management' => 'Workflow states management',
'workflow_state_docstatus' => 'Document status',
'workflow_state_in_use' => 'This state is currently used by workflows.',
'workflow_state_name' => 'Name',
'workflow_summary' => 'Workflow summary',
'workflow_title' => '',
'workflow_transition_without_user_group' => 'At least one of the transitions has neither a user nor a group!',
'workflow_user_summary' => 'User summary',
'wrong_checksum' => 'Wrong checksum',
'wrong_filetype' => 'Wrong file type',
'x_more_objects' => '[number] more objects',
'year_view' => 'Year View',
'yes' => 'Yes',
'zh_CN' => 'Chinese (CN)',
'zh_TW' => 'Chinese (TW)',
);
?>
