implementations]

    * <code>concat()</code> function: Stringify all arguments before concatenating.

    * <code>string()</code> function: Support context node.

    * <code>string()</code> function: Support processing instruction node.

    * Support <code>"*:#{ELEMENT_NAME}"</code> syntax in XPath 2.0.

  [Fixed some XPath implementations]

    * <code>"//#{ELEMENT_NAME}[#{POSITION}]"</code> case

    * <code>string()</code> function: Fix <code>function(document)</code>
      returns nodes that are out of root elements.

    * <code>"/ #{ELEMENT_NAME} "</code> case

    * <code>"/ #{ELEMENT_NAME} [ #{PREDICATE} ]"</code> case

    * <code>"/ #{AXIS}::#{ELEMENT_NAME}"</code> case

    * <code>"#{N}-#{M}"</code> case: One or more white spaces were required
      before <code>"-"</code>

    * <code>"/child::node()"</code> case

    * <code>"#{FUNCTION}()/#{PATH}"</code> case

    * <code>"@#{ATTRIBUTE}/parent::"</code> case

    * <code>"name(#{NODE_SET})"</code> case

[CSV]

  * Upgrade to 3.0.9.
    See https://github.com/ruby/csv/blob/master/NEWS.md.

[Date]

  * Date.jisx0301, Date#jisx0301, and Date.parse provisionally support the
    new Japanese era as an informal extension, until the new JIS X 0301 is
    issued.  [Feature #15742]

[RSS]

  [New options]

    * RSS::Parser.parse now accepts options as Hash. +:validate+ ,
      +:ignore_unknown_element+ , +:parser_class+ options are available.

[RubyGems]

  * Upgrade to RubyGems 3.0.1

  * https://blog.rubygems.org/2018/12/19/3.0.0-released.html

  * https://blog.rubygems.org/2018/12/23/3.0.1-released.html

[Set]

  [Aliased methods]

    * Set#filter! is a new alias for Set#select!.  [Feature #13784]

[URI]

  [New constant]

    * Add URI::File to handle the file URI scheme.  [Feature #14035]

=== Compatibility issues (excluding feature bug fixes)

[Dir]

  * Dir.glob with <code>'\0'</code>-separated pattern list will be deprecated,
    and is now warned.  [Feature #14643]

[File]

  * File.read, File.binread, File.write, File.binwrite, File.foreach, and
    File.readlines do not invoke external commands even if the path starts
    with the pipe character <code>'|'</code>. [Feature #14245]

[Object]

  * Object#=~ is deprecated.  [Feature #15231]

=== Stdlib compatibility issues (excluding feature bug fixes)

* These standard libraries have been promoted to default gems.

  * e2mmap
  * forwardable
  * irb
  * logger
  * matrix
  * mutex_m
  * ostruct
  * prime
  * rexml
  * rss
  * shell
  * sync
  * thwait
  * tracer

[BigDecimal]

  * The following methods are removed.

    * BigDecimal.allocate
    * BigDecimal.ver

  * Every BigDecimal object is frozen. [Feature #13984]

  * BigDecimal() parses the given string similar to Float().

  * String#to_d parses the receiver string similar to String#to_f.

  * BigDecimal.new will be removed in version 2.0.

[Pathname]

  * Pathname#read, Pathname#binread, Pathname#write, Pathname#binwrite,
    Pathname#each_line and Pathname#readlines do not invoke external
    commands even if the path starts with the pipe character <code>'|'</code>.
    This follows [Feature #14245].

=== C API updates

=== Implementation improvements

* Speedup Proc#call because we don't need to care about <code>$SAFE</code>
  any more. [Feature #14318]

  With +lc_fizzbuzz+ benchmark which uses Proc#call many times we can
  measure x1.4 improvements.  [Bug #10212]

* Speedup block.call where +block+ is passed block parameter. [Feature #14330]

  Ruby 2.5 improves block passing performance. [Feature #14045]

  Additionally, Ruby 2.6 improves the performance of passed block calling.

* Introduce an initial implementation of a JIT (Just-in-time) compiler. [Feature #14235] [experimental]

  * <tt>--jit</tt> command line option is added to enable JIT. <tt>--jit-verbose=1</tt>
    is good for inspection.  See <tt>ruby --help</tt> for others.
  * To generate machine code, this JIT compiler uses the C compiler used for building
    the interpreter. Currently GCC, Clang, and Microsoft Visual C++ are supported for it.
  * <tt>--disable-mjit-support</tt> option is added to configure. This is added for JIT debugging,
    but if you get an error on building a header file for JIT, you can use this option to skip
    building it as a workaround.
  * rb_waitpid reimplemented on Unix-like platforms to maintain
    compatibility with processes created for JIT [Bug #14867]

* VM generator script renewal; makes the generated VM more optimized. [GH-1779]

* Thread cache enabled for pthreads platforms (for Thread.new and
  Thread.start).  [Feature #14757]

* timer thread is eliminated for platforms with POSIX timers. [Misc #14937]

* Transient Heap (theap) is supported. [Bug #14858] [Feature #14989]

  theap is a managed heap for short-living memory objects. For example,
  making a small and short-living Hash object is x2 faster. With rdoc benchmark,
  we measured 6-7% performance improvement.

* Native implementations (arm32, arm64, ppc64le, win32, win64, x86, amd64) of
  coroutines to improve performance of Fiber significantly. [Feature #14739]

=== Miscellaneous changes

* On macOS, shared libraries no longer include a full version number of Ruby
  in their names.  This eliminates the burden of each teeny upgrade on the
  platform that users need to rebuild every extension library.

  [Before]
    * libruby.2.6.0.dylib
    * libruby.2.6.dylib -> libruby.2.6.0.dylib
    * libruby.dylib -> libruby.2.6.0.dylib

  [After]
    * libruby.2.6.dylib
    * libruby.dylib -> libruby.2.6.dylib

* Extracted misc/*.el files to https://github.com/ruby/elisp
                       doc/alt-ruby26/README.ja.md                                                                         0000644                 00000020077 15040312176 0011075 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       [![Build Status](https://travis-ci.org/ruby/ruby.svg?branch=trunk)](https://travis-ci.org/ruby/ruby)
[![Build status](https://ci.appveyor.com/api/projects/status/0sy8rrxut4o0k960/branch/trunk?svg=true)](https://ci.appveyor.com/project/ruby/ruby/branch/trunk)
[![wercker status](https://app.wercker.com/status/e5e7e1704f62b76525022aa424aef6ef/s/trunk "wercker status")](https://app.wercker.com/project/byKey/e5e7e1704f62b76525022aa424aef6ef)

# Rubyとは

Rubyはシンプルかつ強力なオブジェクト指向スクリプト言語です． Rubyは純粋なオブジェクト指向言語として設計されているので，
オブジェクト指向プログラミングを手軽に行う事が出来ます．もちろん普通の手続き型のプログラミングも可能です．

Rubyはテキスト処理関係の能力などに優れ，Perlと同じくらい強力です．さらにシンプルな文法と，
例外処理やイテレータなどの機構によって，より分かりやすいプログラミングが出来ます．

## Rubyの特長

*   シンプルな文法
*   普通のオブジェクト指向機能(クラス，メソッドコールなど)
*   特殊なオブジェクト指向機能(Mixin, 特異メソッドなど)
*   演算子オーバーロード
*   例外処理機能
*   イテレータとクロージャ
*   ガーベージコレクタ
*   ダイナミックローディング (アーキテクチャによる)
*   移植性が高い．多くのUnix-like/POSIX互換プラットフォーム上で動くだけでなく，Windows， macOS，
    Haikuなどの上でも動く cf.
    https://github.com/ruby/ruby/blob/trunk/doc/contributing.rdoc#platform-maintainers


## 入手法

サードパーティーツールを使った方法を含むRubyのインストール方法の一覧は

https://www.ruby-lang.org/ja/downloads/

を参照してください．

### Subversionで

開発先端のソースコードは次のコマンドで取得できます．

    $ svn co https://svn.ruby-lang.org/repos/ruby/trunk/ ruby

他に開発中のブランチの一覧は