tching the version specifier\. If not, bundler will print a warning\.
.IP "" 4
.nf
gem "rails", "2\.3\.8", git: "https://github\.com/rails/rails\.git"
# bundle install will fail, because the \.gemspec in the rails
# repository's master branch specifies version 3\.0\.0
.fi
.IP "" 0
.P
If a git repository does \fBnot\fR have a \fB\.gemspec\fR for the gem you attached it to, a version specifier \fBMUST\fR be provided\. Bundler will use this version in the simple \fB\.gemspec\fR it creates\.
.P
Git repositories support a number of additional options\.
.TP
\fBbranch\fR, \fBtag\fR, and \fBref\fR
You \fBMUST\fR only specify at most one of these options\. The default is \fBbranch: "master"\fR\. For example:
.IP
gem "rails", git: "https://github\.com/rails/rails\.git", branch: "5\-0\-stable"
.IP
gem "rails", git: "https://github\.com/rails/rails\.git", tag: "v5\.0\.0"
.IP
gem "rails", git: "https://github\.com/rails/rails\.git", ref: "4aded"
.TP
\fBsubmodules\fR
For reference, a git submodule \fIhttps://git\-scm\.com/book/en/v2/Git\-Tools\-Submodules\fR lets you have another git repository within a subfolder of your repository\. Specify \fBsubmodules: true\fR to cause bundler to expand any submodules included in the git repository
.P
If a git repository contains multiple \fB\.gemspecs\fR, each \fB\.gemspec\fR represents a gem located at the same place in the file system as the \fB\.gemspec\fR\.
.IP "" 4
.nf
|~rails                   [git root]
| |\-rails\.gemspec         [rails gem located here]
|~actionpack
| |\-actionpack\.gemspec    [actionpack gem located here]
|~activesupport
| |\-activesupport\.gemspec [activesupport gem located here]
|\|\.\|\.\|\.
.fi
.IP "" 0
.P
To install a gem located in a git repository, bundler changes to the directory containing the gemspec, runs \fBgem build name\.gemspec\fR and then installs the resulting gem\. The \fBgem build\fR command, which comes standard with Rubygems, evaluates the \fB\.gemspec\fR in the context of the directory in which it is located\.
.SS "GIT SOURCE"
A custom git source can be defined via the \fBgit_source\fR method\. Provide the source's name as an argument, and a block which receives a single argument and interpolates it into a string to return the full repo address:
.IP "" 4
.nf
git_source(:stash){ |repo_name| "https://stash\.corp\.acme\.pl/#{repo_name}\.git" }
gem 'rails', stash: 'forks/rails'
.fi
.IP "" 0
.P
In addition, if you wish to choose a specific branch:
.IP "" 4
.nf
gem "rails", stash: "forks/rails", branch: "branch_name"
.fi
.IP "" 0
.SS "GITHUB"
\fBNOTE\fR: This shorthand should be avoided until Bundler 2\.0, since it currently expands to an insecure \fBgit://\fR URL\. This allows a man\-in\-the\-middle attacker to compromise your system\.
.P
If the git repository you want to use is hosted on GitHub and is public, you can use the :github shorthand to specify the github username and repository name (without the trailing "\.git"), separated by a slash\. If both the username and repository name are the same, you can omit one\.
.IP "" 4
.nf
gem "rails", github: "rails/rails"
gem "rails", github: "rails"
.fi
.IP "" 0
.P
Are both equivalent to
.IP "" 4
.nf
gem "rails", git: "https://github\.com/rails/rails\.git"
.fi
.IP "" 0
.P
Since the \fBgithub\fR method is a specialization of \fBgit_source\fR, it accepts a \fB:branch\fR named argument\.
.P
You can also directly pass a pull request URL:
.IP "" 4
.nf
gem "rails", github: "https://github\.com/rails/rails/pull/43753"
.fi
.IP "" 0
.P
Which is equivalent to:
.IP "" 4
.nf
gem "rails", github: "rails/rails", branch: "refs/pull/43753/head"
.fi
.IP "" 0
.SS "GIST"
If the git repository you want to use is hosted as a GitHub Gist and is public, you can use the :gist shorthand to specify the gist identifier (without the trailing "\.git")\.
.IP "" 4
.nf
gem "the_hatch", gist: "4815162342"
.fi
.IP "" 0
.P
Is equivalent to:
.IP "" 4
.nf
gem "the_hatch", git: "https://gist\.github\.com/4815162342\.git"
.fi
.IP "" 0
.P
Since the \fBgist\fR method is a specialization of \fBgit_source\fR, it accepts a \fB:branch\fR named argument\.
.SS "BITBUCKET"
If the git repository you want to use is hosted on Bitbucket and is public, you can use the :bitbucket shorthand to specify the bitbucket username and repository name (without the trailing "\.git"), separated by a slash\. If both the username and repository name are the same, you can omit one\.
.IP "" 4
.nf
gem "rails", bitbucket: "rails/rails"
gem "rails", bitbucket: "rails"
.fi
.IP "" 0
.P
Are both equivalent to
.IP "" 4
.nf
gem "rails", git: "https://rails@bitbucket\.org/rails/rails\.git"
.fi
.IP "" 0
.P
Since the \fBbitbucket\fR method is a specialization of \fBgit_source\fR, it accepts a \fB:branch\fR named argument\.
.SS "PATH"
You can specify that a gem is located in a particular location on the file system\. Relative paths are resolved relative to the directory containing the \fBGemfile\fR\.
.P
Similar to the semantics of the \fB:git\fR option, the \fB:path\fR option requires that the directory in question either contains a \fB\.gemspec\fR for the gem, or that you specify an explicit version that bundler should use\.
.P
Unlike \fB:git\fR, bundler does not compile C extensions for gems specified as paths\.
.IP "" 4
.nf
gem "rails", path: "vendor/rails"
.fi
.IP "" 0
.P
If you would like to use multiple local gems directly from the filesystem, you can set a global \fBpath\fR option to the path containing the gem's files\. This will automatically load gemspec files from subdirectories\.
.IP "" 4
.nf
path 'components' do
  gem 'admin_ui'
  gem 'public_ui'
end
.fi
.IP "" 0
.SH "BLOCK FORM OF SOURCE, GIT, PATH, GROUP and PLATFORMS"
The \fB:source\fR, \fB:git\fR, \fB:path\fR, \fB:group\fR, and \fB:platforms\fR options may be applied to a group of gems by using block form\.
.IP "" 4
.nf
source "https://gems\.example\.com" do
  gem "some_internal_gem"
  gem "another_internal_gem"
end

git "https://github\.com/rails/rails\.git" do
  gem "activesupport"
  gem "actionpack"
end

platforms :ruby do
  gem "ruby\-debug"
  gem "sqlite3"
end

group :development, optional: true do
  gem "wirble"
  gem "faker"
end
.fi
.IP "" 0
.P
In the case of the