licenses/alt-ruby32/BSDL                                                                            0000644                 00000002413 15040313423 0010717 0                                                                                                    ustar 00                                                                                                                                                                                                                                                        for <tt>Early Hints</tt> responses (status code 103).
  #
  # The <tt>Early Hints</tt> indicates that the server has received
  # and is processing the request, and contains certain headers;
  # the final response is not available yet.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/103].
  # - {RFC 8297}[https://www.rfc-editor.org/rfc/rfc8297.html#section-2].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#103].
  #
  class HTTPEarlyHints < HTTPInformation
    HAS_BODY = false
  end

  # Response class for +OK+ responses (status code 200).
  #
  # The +OK+ response indicates that the server has received
  # a request and has responded successfully.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/200].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-200-ok].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#200].
  #
  class HTTPOK < HTTPSuccess
    HAS_BODY = true
  end

  # Response class for +Created+ responses (status code 201).
  #
  # The +Created+ response indicates that the server has received
                                                                                                                                                                                                                                                      licenses/alt-ruby32/COPYING                                                                         0000644                 00000004573 15040313423 0011314 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       loper.mozilla.org/en-US/docs/Web/HTTP/Status/202].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-202-accepted].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#202].
  #
  class HTTPAccepted < HTTPSuccess
    HAS_BODY = true
  end

  # Response class for <tt>Non-Authoritative Information</tt> responses (status code 203).
  #
  # The <tt>Non-Authoritative Information</tt> response indicates that the server
  # is a transforming proxy (such as a Web accelerator)
  # that received a 200 OK response from its origin,
  # and is returning a modified version of the origin's response.
  #
  # :include: doc/net-http/included_getters.rdoc
  #
  # References:
  #
  # - {Mozilla}[https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/203].
  # - {RFC 9110}[https://www.rfc-editor.org/rfc/rfc9110.html#name-203-non-authoritative-infor].
  # - {Wikipedia}[https://en.wikipedia.org/wiki/List_of_HTTP_status_codes#203].
  #
  cl