oat < Numeric
  # call-seq:
  #     float.to_d             -> bigdecimal
  #     float.to_d(precision)  -> bigdecimal
  #
  # Returns the value of +float+ as a BigDecimal.
  # The +precision+ parameter is used to determine the number of
  # significant digits for the result. When +precision+ is set to +0+,
  # the number of digits to represent the float being converted is determined
  # automatically.
  # The default +precision+ is +0+.
  #
  #     require 'bigdecimal'
  #     require 'bigdecimal/util'
  #
  #     0.5.to_d         # => 0.5e0
  #     1.234.to_d       # => 0.1234e1
  #     1.234.to_d(2)    # => 0.12e1
  #
  # See also BigDecimal::new.
  #
  def to_d(precision=0)
    BigDecimal(self, precision)
  end
end


class String
  # call-seq:
  #     str.to_d  -> bigdecimal
  #
  # Returns the result of interpreting leading characters in +str+
  # as a BigDecimal.
  #
  #     require 'bigdecimal'
  #     require 'bigdecimal/util'
  #
  #     "0.5".to_d             # => 0.5e0
  #     "123.45e1".to_d        # => 0.12345e4
  #     "45.67 degrees".to_d   # => 0.4567e2
  #
  # See also BigDecimal::new.
  #
  def to_d
    BigDecimal.interpret_loosely(self)
  en                                                                                                                                                                                                                                                                                                                                                                       gems/gems/bigdecimal-3.1.3/lib/bigdecimal/jacobian.rb                                               0000644                 00000004161 15040313253 0016071 0                                                                                                    ustar 00                                                                                                                                                                                                                                                        a BigDecimal.
  #
  # The required +precision+ parameter is used to determine the number of
  # significant digits for the resul