user << f
          else
            files_not_readable_or_writable << f
          end
        elsif File.stat(f).uid != Process.uid
          files_not_owned_by_current_user_but_still_rw << f
        end
      end

      ok = true

      if broken_symlinks.any?
        Bundler.ui.warn "Broken links exist in the Bundler home. Please report them to the offending gem's upstream repo. These files are:\n - #{broken_symlinks.join("\n - ")}"

        ok = false
      end

      if files_not_owned_by_current_user_but_still_rw.any?
        Bundler.ui.warn "Files exist in the Bundler home that are owned by another " \
          "user, but are still readable/writable. These files are:\n - #{files_not_owned_by_current_user_but_still_rw.join("\n - ")}"

        ok = false
      end

      if files_not_rw_and_owned_by_different_user.any?
        Bundler.ui.warn "Files exist in the Bundler home that are owned by another " \
          "user, and are not readable/writable. These files are:\n - #{files_not_rw_and_owned_by_different_user.join("\n - ")}"

        ok = false
      end

      if files_not_readable_or_writable.any?
        Bundler.ui.warn "Files exist in the Bundler home that are not " \
          "readable/writable by the current user. These files are:\n - #{files_not_readable_or_writable.join("\n - ")}"

        ok = false
      end

      ok
    end
  end
end
                                                                                                                                                            gems/gems/bundler-2.4.19/lib/bundler/cli/check.rb                                                   0000644                 00000002431 15040313327 0015166 0                                                                                                    ustar 00                         