# frozen_string_literal: true

module Bundler
  class CLI::Open
    attr_reader :options, :name,                                                                                                                                                                                                                                                                                                                                                                                                                                gems/gems/bundler-2.4.19/lib/bundler/cli/plugin.rb                                                  0000644                 00000003343 15040313332 0015406 0                                                                                                    ustar 00                                                                                                                                                                                                                                                         Bundler.with_original_env do
            system(*command)
          end || Bundler.ui.info("Could not run '#{command.join(" ")}'")
        end
      end
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                   gems/gems/bundler-2.4.19/lib/bundler/cli/issue.rb                                                   0000644                 00000002506 15040313334 0015242 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require "rbconfig"

module Bundler
  class CLI::Issue
    def run
      Bundler.ui.info <<-EOS.gsub(/^ {8}/, "")
        Did you find an issue with Bundler? Before filing a new issue,
        be sure to check out these resources:

        1. Check out our troubleshooting guide for quick fixes to common issues:
        https://github.com/rubygems/rubygems/blob/master/bundler/doc/TROUBLESHOOTING.md

        2. Instructions for common Bundler uses can be found on the documentation
        site: https://bundler.io/

        3. Information about each Bundler command can be found in the Bundler
        man pages: https://bundler.io/man/bundle.1.html

        Hopefully the troubleshooting steps above resol                                                                                                                                                                                                                                                                                             gems/gems/bundler-2.4.19/lib/bundler/cli/viz.rb                                                     0000644                 00000002112 15040313333 0014712 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       gems/gems/bundler-2.4.19/lib/bundler/cli/common.rb                                                  0000644                 00000011127 15040313335 0015402 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Bundler
  module CLI::Common
    def self.output_post_install_messages(messages)
      return if Bundler.settings["ignore_messages"]
      messages.to_a.each do |name, msg|
        print_post_install_message(name, msg) unless Bundler.settings["ignore_messages.#{name}"]
      end
    end

    def self.print_post_install_message(name, msg)
      Bundler.ui.confirm "Post-install message from #{name}:"
      Bundler.ui.info msg
    end

    def self.output_fund_metadata_summary
      return if Bundler.settings["ignore_funding_requests"]
      def             