ecs[name].first
          unless new_spec
            unless locked_spec.match_platform(Bundler.local_platform)
              Bundler.ui.warn "Bundler attempted to update #{name} but it was not considered because it is for a different platform from the current one"
            end

            next
          end

          locked_source = locked_info[:source]
          new_source = new_spec.source.identifier
          next if locked_source != new_source

          new_version = new_spec.version
          locked_version = locked_info[:version]
          if new_version < locked_version
            Bundler.ui.warn "Note: #{name} version regressed from #{locked_version} to #{new_version}"
          elsif new_version == locked_version
            Bundler.ui.warn "Bundler attempted to update #{name} but its version stayed the same"
          end
        end
      end

      Bundler.ui.confirm "Bundle updated!"
      Bundler::CLI::Common.output_without_groups_message(:update)
      Bundler::CLI::Common.output_post_install_messages installer.post_install_messages

      Bundler::CLI::Common.output_fund_metadata_summary
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                     gems/gems/bundler-2.4.19/lib/bundler/cli/cache.rb                                                   0000644                 00000002151 15040                                                                                                                                                                                                                                                                                                                                                                                   gems/gems/bundler-2.4.19/lib/bundler/cli/update.rb                                                  0000644                 00000010173 15040313337 0015376 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       settings[:path] if options[:path]

      Bundler.settings.temporary(:cache_all_platforms => options["all-platforms"]) do
        Bundler.load.cache(custom_path)
      end
    end

    private

    def install
      require_relative "install"
      options = self.options.dup
      options["local"] = false if Bundler.settings[:cache_all_platforms]
      options["no-cache"] = true
      Bundler::CLI::Install.new(options).run
    end

    def setup_cache_all
      all = options.fetch(:all, Bundler.feature_flag.cache_all? || nil)

      Bundler.settings.set_command_option_if_given :cache_all, all
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                       gems/gems/bundler-2.4.19/lib/bundler/cli/config.rb                                                  0000644                 00000014022 15040313340 0015350 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Bundler
  class CLI::Config < Thor
    class_option :parseable, :type => :boolean, :banner => "Use minimal formatting for more parseable output"

    def self.scope_options
      method_option :global, :type => :boolean, :banner => "Only change the global config"
      method_option :local, :type => :boolean, :banner => "Only change the local config"
    end
    private_class_method :scope_options

    desc "base NAME [VALUE]", "The Bundler 1 config interface", :hide => true
    scope_options
    method_option :delete, :type => :boolean, :banner => "delete"
    def base(name = nil, *value)
      new_args =
        if ARGV.size == 1
          ["config", "list"]
        elsif ARGV.include?("--delete")
          ARGV.map {|arg| arg == "--delete" ? "unset" : arg }
        elsif ARGV.include?("--global") || ARGV.include?("--local") || ARGV.size == 3
          ["config", "set", *ARGV[1..-1]]
        else
          ["config", "get", ARGV[1]]
        end

      SharedHelpers.major_deprecation 3,
        "Using the `config` command without a subcommand [list, get, set, unset] is deprecated and will be removed in the future. Use `bundle #{new_args.join(" ")}` instead."

      Base.new(options, name, value, self).run
    end

    desc "list", "List out all configured settings"
    def list
      Base.new(options, nil, nil, self).run
    end

    desc "get NAME", "Returns the value for the given key"
    def get(name)
      Base.new(options, name, nil, self).run
    end

    desc "set NAME VALUE", "Sets the given value for the given key"
    scope_options
    def set(name, value, *value_)
      Base.new(options, name, value_.unshift(value), self).run
    end

    desc "unset NAME", "Unsets the value for the given key"
    scope_options
    def unset(name)
      options[:delete] = true
      Base.new(options, name, nil, self).run
    end

    default_task :base

    class Base
      attr_reader :name, :value, :options, :scope, :thor

      def initialize(options, name, value, thor)
        @options = optio