linter_template = false
        end
      end

      if Bundler.settings["gem.linter"].nil?
        Bundler.settings.set_global("gem.linter", linter_template)
      end

      # Once gem.linter safely set, unset the deprecated gem.rubocop
      unless Bundler.settings["gem.rubocop"].nil?
        Bundler.settings.set_global("gem.rubocop", nil)
      end

      if options[:linter] == Bundler.settings["gem.linter"]
        Bundler.ui.info "#{options[:linter]} is already configured, ignoring --linter flag."
      end

      linter_template
    end

    def deprecated_rubocop_option
      if !options[:rubocop].nil?
        if options[:rubocop]
          Bundler::SharedHelpers.major_deprecation 2, "--rubocop is deprecated, use --linter=rubocop"
          "rubocop"
        else
          Bundler::SharedHelpers.major_deprecation 2, "--no-rubocop is deprecated, use --linter"
          false
        end
      elsif !Bundler.settings["gem.rubocop"].nil?
        Bundler::SharedHelpers.major_deprecation 2,
          "config gem.rubocop is deprecated; we've updated your config to use gem.linter instead"
        Bundler.settings["gem.rubocop"] ? "rubocop" : false
      end
    end

    def bundler_dependency_version
      v = Gem::Version.new(Bundler::VERSION)
      req = v.segments[0..1]
      req << "a" if v.prerelease?
      req.join(".")
    end

    def ensure_safe_gem_name(name, constant_array)
      if /^\d/.match?(name)
        Bundler.ui.error "Invalid gem name #{name} Please give a name which does not start with numbers."
        exit 1
      end

      constant_name = constant_array.join("::")

      existing_constant = constant_array.inject(Object) do |c, s|
        defined = begin
          c.const_defined?(s)
        rescue NameError
          Bundler.ui.error "Invalid gem name #{name} -- `#{constant_name}` is an invalid constant name"
          exit 1
        end
        (defined && c.const_get(s)) || break
      end

      return unless existing_constant
      Bundler.ui.error "Invalid gem name #{name} constant #{constant_name} is already in use. Please choose another gem name."
      exit 1
    end

    def open_editor(editor, file)
      thor.run(%(#{editor} "#{file}"))
    end

    def rust_builder_required_rubygems_version
      "3.3.11"
    end

    def required_ruby_version
      "2.6.0"
    end

    def rubocop_version
      "1.21"
    end

    def standard_version
      "1.3"
    end

    # TODO: remove at next minor release
    def travis_removal_info
      if options[:ci] == "travis"
        Bundler.ui.error "Support for Travis CI was removed from gem skeleton generator."
        exit 1
      end

      if Bundler.settings["gem.ci"] == "travis"
        Bundler.ui.error "Support for Travis CI was removed from gem skeleton generator, but it is present in bundle config. Please configure another provider using `bundle config set gem.ci SERVICE` (where SERVICE is one of github/gitlab/circle) or unset configuration using `bundle config unset gem.ci`."
        exit 1
      end
    end

    def validate_rust_builder_rubygems_version
      if Gem::Version.new(rust_builder_required_rubygems_version) > Gem.rubygems_version
        Bundler.ui.error "Your RubyGems version (#{Gem.rubygems_version}) is too old to build Rust extension. Please update your RubyGems using `gem update --system` or any other way and try again."
        exit 1
      end
    end
  end
end
                                                                                                                                                                 gems/gems/bundler-2.4.19/lib/bundler/cli/doctor.rb                                                  0000644                 00000010544 15040313326 0015406 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require "rbconfig"
require "shellwords"
require "fiddle"

module Bundler
  class CLI::Doctor
    DARWIN_REGEX = /\s+(.+) \(compatibility /.freeze
    LDD_REGEX = /\t\S+ => (\S+) \(\S+\)/.freeze

    attr_reader :options

    def initialize(options)
      @options = options
    end

    def otool_available?
      Bundler.whi