# frozen_string_literal: true

module Bundler
  class CLI::Info
    attr_reader :gem_name, :options
    def initialize(options, gem_name)
      @options = options
      @gem_name = gem_name
    end

    def run
      Bundler.ui.silence do
        Bundler.definition.validate_runtime!
        Bundler.load.lock
      end

      spec = spec_for_gem(gem_name)                                                                                                                                                            gems/gems/bundler-2.4.19/lib/bundler/cli/check.rb                                                   0000644                 00000002431 15040313327 0015166 0                                                                                                    ustar 00                                                                                                                                                                                                                                                           raise GemNotFound, Bundler::CLI::Common.gem_not_found_message(gem_name, Bundler.definition.dependencies)
    end

    def print_gem_version(spec)
      Bundler.ui.info spec.version.to_s
    end

    def print_gem_path(spec)
      name = spec.name
      if name == "bundler"
        path = File.expand_path("../../..", __dir__)
      else
        path = spec.full_gem_path
        if spec.deleted_gem?
          return Bundler.ui.warn "The gem #{name} has been deleted. It was installed at: #{path}"
        end
      end

      Bundler.ui.info path
    end

    def print_gem_info(spec)
      metadata = spec.metadata
      name = spec.name
      gem_info = String.new
      gem_info << "  * #{name} (#{spec.version}#{spec.git_version})\n"
      gem_info << "\tSummary: #{spec.summary}\n" if spec.summary
      gem_info << "\tHomepage: #{spec.homepage}\n" if spec.homepage
      gem_info << "\tDocumentation: #{metadata["documentation_uri"]}\n" if metadata.key?("documentation_uri")
      gem_info << "\tSource Code: #{metadata["source_code_uri"]}\n" if metadata.key?("source_code_uri")
      gem_info << "\tFunding: #{metadata["funding_uri"]}\n" if metadata.key?("funding_uri")
      gem_info << "\tWiki: #{metadata["wiki_uri"]}\n" if metadata.key?("wiki_uri")
      gem_info << "\tChangelog: #{metad                                                                         