version_promoter(Bundler.definition, options) if options[:update]

      options["remove-platform"].each do |platform|
        definition.remove_platform(platform)
      end

      options["add-platform"].each do |platform_string|
        platform = Gem::Platform.new(platform_string)
        if platform.to_s == "unknown"
          Bundler.ui.warn "The platform `#{platform_string}` is unknown to RubyGems " \
            "and adding it will likely lead to resolution errors"
        end
        definition.add_platform(platform)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              gems/gems/bundler-2.4.19/lib/bundler/cli/inject.rb                                                  0000644                 00000004167 15040313341 0015371 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       gems/gems/bundler-2.4.19/lib/bundler/cli/add.rb                                                     0000644                 00000002736 15040313341 0014645 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Bundler
  class CLI::Add
    attr_reader :gems, :options, :version

    def initialize(options, gems)
      @gems = gems
      @options = options
      @options[:group] = options[:group].split(",").map(&:strip) unless options[:group].nil?
      @version = options[:version].split(",").map(&:strip) unless options[:version].nil?
    end

    def run
      validate_options!
      inject_dependencies
      perform_bundle_install unless options["skip-install"]
    end

    private

    def perform_bundle_install
      Installer.install(Bundler.root, Bundler.definition)
      Bundler.load.cache if Bundler.app_cache.exist?
    end

    def inject_dependencies
      dependencies = gems.map {|g| Bundler::Dependency.new(g, version, options) }

      Injector.inject(dependencies,
        :conservative_versioning => options[:version].nil?, # Perform conservative versioning only when version is not specified
        :optimistic => options[:optimistic],
        :strict => options[:strict])
    end

    def validate_options!
      raise InvalidOption, "You can not specify `--strict` and `--optimistic` at the same time." if options[:strict] && options[:optimistic]

      # raise error when no gems are specified
      raise InvalidOption, "Please specify gems to add." if gems.empty?

      version.to_a.each do |v|
        raise InvalidOption, "Invalid gem requirement pattern '#{v}'" unless Gem::Requirement::PATTERN.match?(v.to_s)
      end
    end
  end
end
                                  gems/gems/bundler-2.4.19/lib/bundler/cli/install.rb                                                 0000644                                                                                                                                                                                                                                                                                                                                                                                                                     gems/gems/bundler-2.4.19/lib/bundler/cli/lock.rb                                                    0000644                 00000004023 15040313341 0015034 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       

      check_for_options_conflicts

      check_trust_policy

      if options[:deployment] || options[:frozen] || Bundler.frozen_bundle?
        unless Bundler.default_lockfile.exist?
          flag   = "--deployment flag" if options[:deployment]
          flag ||= "--frozen flag"     if options[:frozen]
          flag ||= "deployment setting"
          raise ProductionError, "The #{flag} requires a #{Bundler.default_lockfile.relative_path_from(SharedHelpers.pwd)}. Please make " \
                                 "sure you have checked your #{Bundler.default_lockfile.relative_path_from(SharedHelpers.pwd)} into version control " \
                                 "before deploying."
        end

        options[:local] = true if Bundler.app_cache.exist?

        Bundler.settings.set_command_option :deployment, true if options[:deployment]
        Bundler.settings.set_command_option :frozen, true if options[:frozen]
      end

      # When install is called with --no-deployment, disable deployment mode
      if options[:deployment] == false
        Bundler.settings.set_command_option :frozen, nil
        options[:system] = true
      end

      normalize_settings

      Bundler::Fetcher.disable_endpoint = options["full-index"]

      if options["binstubs"]
        Bundler::SharedHelpers.major_deprecation 2,
          "The --binstubs option will be removed in favor of `bundle binstubs --all`"
      end

      Plugin.gemfile_install(Bundler.default_gemfile) if Bundler.feature_flag.plugins?

      definition = Bundler.definition
      definition.validate_runtime!

      installer = Installer.install(Bundler.root, definition, options)

      Bundler.settings.temporary(:cache_all_platforms => options[:local] ? false : Bundler.settings[:cache_all_platforms]) do
        Bundler.load.cache(nil, options[:local]) if Bundler.app_cache.exist? && !options["no-cache"] && !Bundler.frozen_bundle?
      end

      Bundler.ui.confirm "Bundle complete! #{dependencies_count_for(definition)}, #{gems_installed_for(definition)}."
      Bundler::CLI::Comm                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             gems/gems/bundler-2.4.19/lib/bundler/cli/add.rb                                                     0000644                 00000002736 15040313341 0014645 0                                                                                                    ustar 00                                                                                                                                                                                         