# frozen_string_literal: true

module Bundler
  class CLI::Viz
    attr_reader :options, :gem_name
    def initialize(options)
      @options = options
    end

    def run
      # make sure we get the right `graphviz`. There is also a `graphviz`
      # gem we're not built to support
      gem "ruby-graphviz"
      require "graphviz"

      options[:without] = options[:without].join(":").tr(" ", ":").split(":")
      output_file = File.expand_path(options[:file])

      graph = Graph.new(Bundler.load, output_file, options[:version], options[:requirements], op                                                                                                                                                                                                                                                                                                                                                                                                                                                                          gems/gems/bundler-2.4.19/lib/bundler/cli/clean.rb                                                   0000644                 00000001140 15040313331 0015162 0                                                                                                    ustar 00                                                             