.name].first
        if spec.metadata.key?("funding_uri")
          arr << "* #{spec.name} (#{spec.version})\n  Funding: #{spec.metadata["funding_uri"]}"
        end
      end

      if fund_info.empty?
        Bundler.ui.info "None of the installed gems                                                                                                                                                                                                                                                                  gems/gems/bundler-2.4.19/lib/bundler/cli/init.rb                                                    0000644                 00000002437 15040313324 0015057 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Bundler
  class CLI::List
    def initialize(options)
      @options = options
      @without_group = options["without-group"].map(&:to_sym)
      @only_group = options["only-group"].map(&:to_sym)
    end

    def run
      raise InvalidOption, "The `--only-group` and `--without-group` options cannot be used together" if @only_group.any? && @without_group.any?

      raise InvalidOption, "The `--name-only` and `--paths` options cannot be used together" if @options["name-only"] && @options[:paths]

      specs = if @only_group.any? || @without_group.any?
        filtered_specs_by_groups
      else
        begin
          Bundler.load.specs
        rescue GemNotFound => e
          Bundler.ui.error e.message
          Bundler.ui.warn "Install missing gems with `bundle install`."
          exit 1
        end
      end.reject {|s| s.name == "bundler" }.sort_by(&:name)

      return Bundler.ui.info "No gems in the Gemfile" if specs.empty?

      return specs.each {|s| Bundler.ui.info s.name } if @options["name-only"]
      return specs.each {|s| Bundler.ui.info s.full_gem_path } if @options["paths"]

      Bundler.ui.info "Gems included by the bundle:"

      specs.each {|s| Bundler.ui.info "  * #{s.name} (#{s.version}#{s.git_version})" }

      Bundler.ui.i                                                                                                                                                                                                                                 gems/gems/bundler-2.4.19/lib/bundler/cli/platform.rb                                                0000644                 00000002422 15040313324 0015732 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       d
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    gems/gems/bundler-2.4.19/lib/bundler/cli/outdated.rb                                                0000644                 00000022241 15040313324 0015720 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Bundler
  class CLI::Outdated
    attr_reader :options, :gems, :options_include_groups, :filter_options_patch, :sources, :strict
    attr_accessor :outdated_gems

    def initialize(options, gems)
      @options = options
      @gems =                                                                                                                                                                                                                                               gems/gems/bundler-2.4.19/lib/bundler/cli/fund.rb                                                    0000644                 00000001604 15040313324 0015043 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       _dependencies = Bundler.ui.silence do
        Bundler.load.dependencies.map {|dep| [dep.name, dep] }.to_h
      end

      definition = if gems.empty? && sources.empty?
        # We're doing a full update
        Bundler.definition(true)
      else
        Bundler.definition(:gems => gems, :sources => sources)
      end

      Bundler::CLI::Common.configure_gem_version_promoter(
        Bundler.definition,
        options.merge(:strict => @strict)
      )

      definition_resolution = proc do
        options[:local] ? definition.resolve_with_cache! : definition.resolve_remotely!
      end

      if options[:parseable]
        Bundler.ui.silence(&definition_resolution)
      else
        definition_resolution.call
      end

      Bundler.ui.info ""

      # Loop through the current specs
      gemfile_specs, dependency_specs = current_specs.partition do |spec|
        current_dependenci                                                                                                                            gems/gems/bundler-2.4.19/lib/bundler/cli/list.rb                                                    0000644                 00000004014 15040313324 0015060 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       gem_outdated || (current_spec.git_version != active_spec.git_version)

        dependency = current_dependencies[current_spec.name]
        groups = ""
        if dependency && !options[:parseable]
          groups = dependency.groups.join(", ")
        end

        outdated_gems << {
          :active_spec => active_spec,
          :current_spec => current_spec,
          :dependency => dependency,
          :groups => groups,
        }
      end

      if outdated_gems.empty?
        unless options[:parseable]
          Bundler.ui.info(nothing_outdated_message)
        end
      else
        if options_include_groups
          relevant_outdated_gems = outdated_gems.group_by {|g| g[:groups] }.sort.flat_map do |groups, gems|
            contains_group = groups.split(", ").include?(options[:group])
            next unless options[:groups] || contains_group

            gems
          end.compact

          if options[:parseable]
            print_gems(relevant_outdated_gems)
          else
            print_gems_table(relevant_outdated_gems)
          end
        elsif options[:parseable]
          print_gems(outdated_gems)
        else
          print_gems_table(outdated_gems)
        end

        exit 1
      end
    end

    private

    def loaded_from_for(spec)
      return unless spec.respond_to?(:loaded_from)

      spec.loaded_from
    end

    def groups_text(group_text, groups)
      "#{group_text}#{groups.split(",").size > 1 ? "s" : ""} \"#{groups}\""
    end

    def nothing_outdated_message
      if filter_options_patch.any?
        display = filter_options_patch.map do |o|
          o.sub("filter-", "")
        end.join(" or ")

        "No #{display} updates to display.\n"
      else
        "Bundle up to date!\n"
      end
    end

    def retrieve_active_spec(definition, current_spec)
      active_spec = definition.resolve.find_by_name_and_platform(current_spec.name, current_spec.platform)
      return unless active_spec

      return active_spec if strict

      active_specs = active_spec.source.specs.search                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    gems/gems/bundler-2.4.19/lib/bundler/cli/outdated.rb                                                0000644                 00000022241 15040313324 0015720 0    