# frozen_string_literal: false

module Bundler
  VERSION = "2.4.19".freeze

  def self.bundler_major_version
    @bundler_major_version ||= VERSION.split(".").first.to_i
  end

  def self.gem_version
    @gem_version ||= Gem::Version.create(VERSION)
  end
end
                                                                                                                                                                                                                                                            gems/gems/bundler-2.4.19/lib/bundler/ui.rb                                                          0000644                 00000000377 15040313323 0013762 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Bundler
  module UI
    autoload :RGProxy, File.expand_path("ui/rg_proxy", __dir__)
    autoload :Shell,   File.expand_path("ui/shell", __dir__)
    autoload :Silent,  File.expand_path("ui/silent", __dir__)
  end
end
                   