gems/gems/bundler-2.4.19/lib/bundler/cli/common.rb                                                  0000644                 00000011127 15040313335 0015402 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Bundler
  class CLI::Remove
    def initialize(gems, options)
      @gems = gems
      @options = options
    end

    def run
      raise InvalidOption, "Please specify gems to remove." if @gems.empty?

      Injector.remove(@gems, {})
      Installer.install(Bundler.root, Bundler.definition)
    end
  end
end
                                                                                                                                                                 gems/gems/bundler-2.4.19/lib/bundler/cli/pristine.rb                                                0000644                 00000003215 15040313337 0015750 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Bundler
  class CLI::Pristine
    def initialize(gems)
      @gems = gems
    end

    def run
      CLI::Common.ensure_all_gems_in_lockfile!(@gems)
      definition = Bundler.definition
      definition.validate_runtime!
      installer = Bundler::Installer.new(Bundler.root, definition)

      Bundler.load.specs.each do |spec|
        next if spec.name == "bundler" # Source::Rubygems doesn't install bundler
        next if !@gems.empty? && !@gems.include?(spec.name)

        gem_name = "#{spec.name} (#{spec.version}#{spec.git_version})"
        gem_name += " (#{spec.platform})" if !spec.platform.nil? && spec.platform != Gem::Platform::RUBY

        case source = spec.source
        when Source::Rubygems
          cached_gem = spec.cache_file
          unless File.exist?(cached_gem)
            Bundler.ui.error("Failed to pristine #{gem_name}. Cached gem #{cached_gem} does not exist.")
            next
          end

          FileUtils.rm_rf spec.full_gem_path
        when Source::Git
          if source.local?
            Bundler.ui.warn("Cannot pristine #{gem_name}. Gem is locally overridden.")
            next
          end

          source.remote!
          if extension_cache_path = source.extension_cache_path(spec)
            FileUtils.rm_rf extension_cache_path
          end
          FileUtils.rm_rf spec.extension_dir
          FileUtils.rm_rf spec.full_gem_path
        else
          Bundler.ui.warn("Cannot pristine #{gem_name}. Gem is sourced from local path.")
          next
        end

        Bundler::GemInstaller.new(spec, installer, false, 0, true).install_from_spec
      end
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                                                   gems/gems/bundler-2.4.19/lib/bundler/cli/update.rb                                                  0000644                 00000010173 15040313337 0015376 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Bundler
  class CLI::Update
    attr_reader :options, :gems
    def initialize(option