pendency(d) } : []
          requirements = requirements ? requirements.map {|d| parse_dependency(d) } : []
          [version, platform, dependencies, requirements]
        end

        private

        def parse_dependency(string)
          dependency = string.split(":")
          dependency[-1] = dependency[-1].split("&") if dependency.size > 1
          dependency
        end
      end
    end
  end
end
                                                                                                     gems/gems/bundler-2.4.19/lib/bundler/compact_index_client/cache.rb                                  0000644                 00000004635 15040313361 0020566 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "gem_parser"

module Bundler
  class CompactIndexClient
    class Cache
      attr_reader :directory

      def initialize(directory)
        @directory = Pathname.new(directory).expand_path
        info_roots.each do |dir|
          SharedHelpers.filesystem_access(dir) do
            FileUtils.mkdir_p(dir)
                                                                                                                                                           gems/gems/bundler-2.4.19/lib/bundler/inline.rb                                                      0000644                 00000004745 15040313361 0014630 0                                                                                                    ustar 00                                                                                                                                                                                                                                                                else
              version = version.split("-", 2).unshift(name)
              versions_by_name[name] << version
            end
          end
        end

        [versions_by_name, info_checksums_by_name]
      end

      def versions_path
        directory.join("versions")
      end

      def checksums
        checksums = {}

        lines(versions_path).each do |line|
          name, _, checksum = line.split(" ", 3)
          checksums[name] = checksum
        end

        checksums
      end

      def dependencies(name)
        lines(info_path(name)).map do |line|
          parse_gem(line)
        end
      end

      def info_path(name)
        name = name.to_s
        if /[^a-z0-9_-]/.match?(name)
          name += "-#{SharedHelpers.digest(:MD5).hexdigest(name).downcase}"
          info_roots.last.join(name)
        else
          info_roots.first.join(name)
        end
      end

      private

      def lines(path)
        return [] unless path.file?
        lines = SharedHelpers.filesystem_access(path, :read, &:read).split("\n")
        header = lines.index("---")
        header ? lines[header + 1..-1] : lines
      end

      def parse_gem(line)
        @dependency_parser ||= GemParser.new
        @dependency_parser.parse(line)
      end

      def info_roots
        [
          directory.join("info"),
          directory.join("info-special-characters"),
        ]
      end
    end
  end
end
                                                                                                   gems/gems/bundler-2.4.19/lib/bundler/compact_index_client/updater.rb                                000