    def handle_argument_error?(instance, error, caller)
      not_debugging?(instance) && (error.message =~ /wrong number of arguments/ || error.message =~ /given \d*, expected \d*/) && begin
        saned = sans_backtrace(error.backtrace, caller)
        saned.empty? || saned.size == 1
      end
    end

    def handle_no_method_error?(instance, error, caller)
      not_debugging?(instance) &&
        error.message =~ /^undefined method `#{name}' for #{Regexp.escape(instance.to_s)}$/
    end
  end
  Task = Command

  # A command that is hidden in help messages but still invocable.
  class HiddenCommand < Command
    def hidden?
      true
    end
  end
  HiddenTask = HiddenCommand

  # A dynamic command that handles method missing scenarios.
  class DynamicCommand < Command
    def initialize(name, options = nil)
      super(name.to_s, "A dynamically-generated command", name.to_s, name.to_s, options)
    end

    def run(instance, args = [])
      if (instance.methods & [name.to_s, name.to_sym]).empty?
        super
      else
        instance.class.handle_no_command_error(name)
      end
    end
  end
  DynamicTask = DynamicCommand
end
                                                                                                                                                                                                                                                                                                                                                                                            gems/gems/bundler-2.4.19/lib/bundler/vendor/thor/lib/thor/command.rb                                0000644                 00000011204 15040313404 0020745 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       class Bundler::Thor
  class NestedContext
    def initialize
      @depth = 0
    end

    def enter
      push

      yield
    ensure
      pop
    end

    def entered?
      @depth > 0
    end

    private

    def push
      @depth += 1
    end

    def pop
      @depth -= 1
    end
  end
end
                                                                                                                                                                                                                     gems/gems/bundler-2.4.19/lib/bundler/vendor/thor/lib/thor/parser.rb                                 0000644                 00000000212 15040313404 0020620 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       require_relative "parser/argument"
require_relative "parser/arguments"
require_relative "parser/option"
require_r