te anything like an
    # `Installer` that'll keep a reference to the old one instead.
    def auto_install
      return unless Bundler.settings[:auto_install]

      begin
        Bundler.definition.specs
      rescue GemNotFound
        Bundler.ui.info "Automatically installing missing gems."
        Bundler.reset!
        invoke :install, []
        Bundler.reset!
      end
    end

    def current_command
      _, _, config = @_initializer
      config[:current_command]
    end

    def print_command
      return unless Bundler.ui.debug?
      cmd = current_command
      command_name = cmd.name
      return if PARSEABLE_COMMANDS.include?(command_name)
      command = ["bundle", command_name] + args
      options_to_print = options.dup
      options_to_print.delete_if do |k, v|
        next unless o = cmd.options[k]
        o.default == v
      end
      command << Thor::Options.to_switches(options_to_print.sort_by(&:first)).strip
      command.reject!(&:empty?)
      Bundler.ui.info "Running `#{command * " "}` with bundler #{Bundler::VERSION}"
    end

    def warn_on_outdated_bundler
      return if Bundler.settings[:disable_version_check]

      command_name = current_command.name
      return if PARSEABLE_COMMANDS.include?(command_name)

      return unless SharedHelpers.md5_available?

      latest = Fetcher::CompactIndex.
               new(nil, Source::Rubygems::Remote.new(Bundler::URI("https://rubygems.org")), nil).
               send(:compact_index_client).
               instance_variable_get(:@cache).
               dependencies("bundler").
               map {|d| Gem::Version.new(d.first) }.
               max
      return unless latest

      current = Gem::Version.new(VERSION)
      return if current >= latest

      Bundler.ui.warn \
        "The latest bundler is #{latest}, but you are currently running #{current}.\n" \
        "To update to the most recent version, run `bundle update --bundler`"
    rescue RuntimeError
      nil
    end

    def remembered_negative_flag_deprecation(name)
      positive_name = name.gsub(/\Ano-/, "")
      option = current_command.options[positive_name]
      flag_name = "--no-" + option.switch_name.gsub(/\A--/, "")

      flag_deprecation(positive_name, flag_name, option)
    end

    def remembered_flag_deprecation(name)
      option = current_command.options[name]
      flag_name = option.switch_name

      flag_deprecation(name, flag_name, option)
    end

    def flag_deprecation(name, flag_name, option)
      name_index = ARGV.find {|arg| flag_name == arg.split("=")[0] }
      return unless name_index

      value = options[name]
      value = value.join(" ").to_s if option.type == :array

      Bundler::SharedHelpers.major_deprecation 2,
        "The `#{flag_name}` flag is deprecated because it relies on being " \
        "remembered across bundler invocations, which bundler will no longer " \
        "do in future versions. Instead please use `bundle config set --local #{name.tr("-", "_")} " \
        "'#{value}'`, and stop using this flag"
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              gems/gems/bundler-2.4.19/lib/bundler/endpoint_specification.rb                                      0000644                 00000007232 15040313342 002006