  = engine&.to_s || "ruby"
      @engine_versions    = (engine_version && Array(engine_version)) || @versions
      @engine_gem_version = Gem::Requirement.create(@engine_versions.first).requirements.first.last
      @patchlevel         = patchlevel || (@gem_version.prerelease? ? "-1" : nil)
    end

    def to_s(versions = self.versions)
      output = String.new("ruby #{versions_string(versions)}")
      output << "p#{patchlevel}" if patchlevel && patchlevel != "-1"
      output << " (#{engine} #{versions_string(engine_versions)})" unless engine == "ruby"

      output
    end

    # @private
    PATTERN = /
      ruby\s
      (\d+\.\d+\.\d+(?:\.\S+)?) # ruby version
      (?:p(-?\d+))? # optional patchlevel
      (?:\s\((\S+)\s(.+)\))? # optional engine info
    /xo.freeze

    # Returns a RubyVersion from the given string.
    # @param [String] the version string to match.
    # @return [RubyVersion,Nil] The version if the string is a valid RubyVersion
    #         description, and nil otherwise.
    def self.from_string(string)
      new($1, $2, $3, $4) if string =~ PATTERN
    end

    def single_version_string
      to_s(gem_version)
    end

    def ==(other)
      versions == other.versions &&
        engine == other.engine &&
        engine_versions == other.engine_versions &&
        patchlevel == other.patchlevel
    end

    def host
      @host ||= [
        RbConfig::CONFIG["host_cpu"],
        RbConfig::CONFIG["host_vendor"],
        RbConfig::CONFIG["host_os"],
      ].join("-")
    end

    # Returns a tuple of these things:
    #   [diff, this, other]
    #   The priority of attributes are
    #   1. engine
    #   2. ruby_version
    #   3. engine_version
    def diff(other)
      raise ArgumentError, "Can only diff with a RubyVersion, not a #{other.class}" unless other.is_a?(RubyVersion)
      if engine != other.engine && @input_engine
        [:engine, engine, other.engine]
      elsif versions.empty? || !matches?(versions, other.gem_version)
        [:version, versions_string(versions), versions_string(other.versions)]
      elsif @input_engine && !matches?(engine_versions, other.engine_gem_version)
        [:engine_version, versions_string(engine_versions), versions_string(other.engine_versions)]
      elsif patchlevel && (!patchlevel.is_a?(String) || !other.patchlevel.is_a?(String) || !matches?(patchlevel, other.patchlevel))
        [:patchlevel, patchlevel, other.patchlevel]
      end
    end

    def versions_string(versions)
      Array(versions).join(", ")
    end

    def self.system
      ruby_engine = RUBY_ENGINE.dup
      ruby_version = Gem.ruby_version.to_s
      ruby_engine_version = RUBY_ENGINE == "ruby" ? ruby_version : RUBY_ENGINE_VERSION.dup
      patchlevel = RUBY_PATCHLEVEL.to_s

      @system ||= RubyVersion.new(ruby_version, patchlevel, ruby_engine, ruby_engine_version)
    end

    private

    def matches?(requirements, version)
      # Handles RUBY_PATCHLEVEL of -1 for instances like ruby-head
      return requirements == version if requirements.to_s == "-1" || version.to_s == "-1"

      Array(requirements).all? do |requirement|
        Gem::Requirement.create(requirement).satisfied_by?(Gem::Version.create(version))
      end
    end
  end
end
                                                                                                                                                                                                                                                                                                                                               gems/gems/bundler-2.4.19/lib/bundler/errors.rb                                                      0000644                 00000012251 15040313343 0014655 0                                                                                                                                                                                                                                                                                                                                                                   gems/gems/bundler-2.4.19/lib/bundler/ruby_version.rb                                                0000644                 00000010261 15040313343 0016066 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       mfileError < BundlerError; status_code(4); end
  class InstallError < BundlerError; status_code(5); end

  # Internal error, should be rescued
  class SolveFailure < BundlerError; status_code(6); end

  class GemNotFound < BundlerError; status_code(7); end
  class InstallHookError < BundlerError; status_code(8); end
  class GemfileNotFound < BundlerError; status_code(10); end
  class GitError < BundlerError; status_code(11); end
  class DeprecatedError < BundlerError; status_code(12); end
  class PathError < BundlerError; status_code(13); end
  class GemspecError < BundlerError; status_code(14); end
  class InvalidOption < BundlerError; status_code(15); end
  class Product