 File.write(target, checksum + "\n")
      Bundler.ui.confirm "#{name} #{version} checksum written to checksums/#{file_name}."
    end

    protected

    def rubygem_push(path)
      cmd = [*gem_command, "push", path]
      cmd << "--key" << gem_key if gem_key
      cmd << "--host" << allowed_push_host if allowed_push_host
      sh_with_input(cmd)
      Bundler.ui.confirm "Pushed #{name} #{version} to #{gem_push_host}"
    end

    def built_gem_path
      Gem::Util.glob_files_in_dir("#{name}-*.gem", base).sort_by {|f| File.mtime(f) }.last
    end

    def git_push(remote = nil)
      remote ||= default_remote
      sh("git push #{remote} refs/heads/#{current_branch}".shellsplit)
      sh("git push #{remote} refs/tags/#{version_tag}".shellsplit)
      Bundler.ui.confirm "Pushed git commits and release tag."
    end

    def default_remote
      remote_for_branch, status = sh_with_status(%W[git config --get branch.#{current_branch}.remote])
      return "origin" unless status.success?

      remote_for_branch.strip
    end

    def current_branch
      # We can replace this with `git branch --show-current` once we drop support for git < 2.22.0
      sh(%w[git rev-parse --abbrev                                                                                                                                                                                                                                                                                                                                                    gems/gems/bundler-2.4.19/lib/bundler/gem_helper.rb                                                  0000644                 00000015613 15040313352 0015455 0                                                                                                    ustar 00                                                                                                                                                                                                                                                           end

    def tag_version
      sh %W[git tag -m Version\ #{version} #{version_tag}]
      Bundler.ui.confirm "Tagged #{version_tag}."
      yield if block_given?
    rescue RuntimeError
      Bundler.ui.error "Untagging #{version_tag} due to error."
      sh_with_status %W[git tag -d #{version_tag}]
      raise
    end

    def version
      gemspec.version
    end

    def version_tag
      "#{@tag_prefix}v#{version}"
    end

    def name
      gemspec.name
    end

    def sh_with_input(cmd)
      Bundler.ui.debug(cmd)
      SharedHelpers.chdir(base) do
        abort unless Kernel.system(*cmd)
      end
    end

    def sh(cmd, &block)
      out, status = sh_with_status(cmd, &block)
      unless status.success?
        raise("Running `#{cmd.shelljoin}` failed with the following output:\n\n#{out}\n")
      end
      out
    end

    def sh_with_status(cmd, &block)
      Bundler.ui.debug(cmd)
      SharedHelpers.chdir(base) do
        outbuf = IO.popen(cmd, :err => [:child, :out], &:read)
        status = $?
        block&.call(outbuf) if status.success?
        [outbuf, status]
      end
    end

    def gem_key
      Bundler.settings["gem.push_key"].to_s.downcase if Bundler.settings["gem.push_key"]
    end

    def gem_push?
      !%w[n no nil false off 0].include?(ENV["gem_push"].to_s.downcase)
    end

    def gem_command
      ENV["GEM_COMMAND"]&.shellsplit || ["gem"]
    end
  end
end
                                                                                                                     gems/gems/bundler-2.4.19/lib/bundler/fetcher.rb                                                     0000644                 00000026277 15040313352 0014776 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "vendored_persistent"
require "cgi"
require "securerandom"
require "zlib"
require "rubygems/request"

module Bundler
  # Handles all the fetching with the rubygems server
  class Fetcher
    autoload :CompactIndex, File.expand_path("fetcher/compact_index", __dir__)
    autoload :Downloader, File.expand_path("fetcher/downloader", __dir__)
    autoload :Dependency, File.expand_path("fetcher/dependency", __dir__)
    autoload :Index, File.expand_path("fetcher/index", __dir__)

    # This error is raised when it looks like the network is down
    class NetworkDownError < HTTPError; end
    # This error is raised if we should rate limit our requests to the API
    class TooManyRequestsError < HTTPError; end
    # This error is raised if the API returns a 413 (only printed in verbose)
    class FallbackError < HTTPError; end

    # This is the error raised if OpenSSL fails the cert verification
    class CertificateFailureError < HTTPError
      def initialize(remote_uri)
        remote_uri = filter_uri(remote_uri)
        super "Could not verify the SSL certificate for #{remote_uri}.\nThere" \
          " is a chance you are experiencing a man-in-the-middle attack, but" \
          " most likely your system doesn't have the CA certificates needed" \
          " for verification. For information about OpenSSL certificates, see" \
          " https://railsapps.github.io/openssl-certificate-verify-failed.html."
      end
    end

    # This is the error raised when a source is HTTPS and OpenSSL didn't load
    class SSLError < HTTPError
      def initialize(msg = nil)
        super msg || "Could not load OpenSSL.\n" \
            "You must recompile Ruby with OpenSSL support."
      end
    end

    # This error is raised if HTTP authentication is required, but not provided.
    class AuthenticationRequiredError < HTTPError
      def initialize(remote_uri)
        remote_uri = filter_uri(remote_uri)
        super "Authentication is required for #{remote_uri}.\n" \
          "Please supply credentials for this source. You can do this by running:\n" \
          "`bundle config set --global #{remote_uri} username:password`\n" \
          "or by storing the credentials in the `#{Settings.key_for(remote_uri)}` environment variable"
      end
    end

    # This error is raised if HTTP authentication is provided, but incorrect.
    class BadAuthenticationError < HTTPError
      def initialize(remote_uri)
        remote_uri = filter_uri(remote_uri)
        super "Bad username or password for #{remote_uri}.\n" \
          "Please double-check your credentials and correct them."
      end
    end

    # This error is raised if HTTP authentication is correct, but lacks
    # necessary permissions.
    class AuthenticationForbiddenError < HTTPError
      def initialize(remote_uri)
        remote_uri = filter_uri(remote_uri)
        super "Access token could not be authenticated for #{remote_uri}.\n" \
          "Make sure it's valid and has the necessary scopes configured."
      end
    end

    # Exceptions classes that should bypass retry attempts. If your password didn't work the
    # first time, it's not going to the third time.
    NET_ERRORS = [:HTTPBadGateway, :HTTPBadRequest, :HTTPFailedDependency,
                  :HTTPForbidden, :HTTPInsufficientStorage, :HTTPMethodNotAllowed,
                  :HTTPMovedPermanently, :HTTPNoContent, :HTTPNotFound,
                  :HTTPNotImplemented, :HTTPPreconditionFailed, :HTTPRequestEntityTooLarge,
                  :HTTPRequestURITooLong, :HTTPUnauthorized, :HTTPUnprocessableEntity,
                  :HTTPUnsupportedMediaType, :HTTPVersionNotSupported].freeze
    FAIL_ERRORS = begin
      fail_errors = [AuthenticationRequiredError, BadAuthenticationError, AuthenticationForbiddenError, FallbackError]
      fail_errors << Gem::Requirement::BadRequirementError
      fail_errors.concat(NET_ERRORS.map {|e| Net.const_get(e) })
    end.freeze

    class << self
      attr_accessor :disable_endpoint, :api_timeout, :redirect_limit, :max_retries
    end

    self.redirect_limit = Bundler.settings[:redirect] # How many redirects to allow in one request
    self.api_timeout    = Bundler.settings[:timeout] # How long to wait for each API call
    self.max_retries    = Bundler.settings[:retry] # How many retries for the API call

    def initialize(remote)
      @remote = remote

      Socket.do_not_reverse_lookup = true
      connection # create persistent connection
    end

    def uri
      @remote.anonymized_uri
    end

    # fetch a gem specification
    def fetch_spec(spec)
      spec -= [nil, "ruby", ""]
      spec_file_name = "#{spec.join "-"}.gemspec"

      uri = Bundler::URI.parse("#{remote_uri}#{Gem::MARSHAL_SPEC_DIR}#{spec_file_name}.rz")
      if uri.scheme == "file"
        path = Bundler.rubygems.correct_for_windows_path(uri.path)
        Bundler.safe_load_marshal Bundler.rubygems.inflate(Gem.read_binary(path))
      elsif c                                                                                                                     gems/gems/bundler-2.4.19/lib/bundler/fetcher.rb                                                     0000644                 00000026277 15040313352 0014776 0                                                                                                    ustar 00                                                                                                                                                                                                                                                        the specs in the bundler format as an index
    def specs(gem_names, source)
      index = Bundler::Index.new

      if Bundler::Fetcher.disable_endpoint
        @use_api = false
        specs = fetchers.last.specs(gem_names)
      else
        specs = []
        @fetchers = fetchers.drop_while do |f|
          !f.available? || (f.api_fetcher? && !gem_names) || !specs = f.specs(gem_names)
        end
        @use_api = false if fetchers.none?(&:api_fetcher?)
      end

      specs.each do |name, version, platform, dependencies, metadata|
        spec = if dependencies
          EndpointSpecification.new(name, version, platform, self, dependencies, metadata)
        else
          RemoteSpecification.new(name, version, platform, self)
        end
        spec.source = source
        spec.remote = @remote
        index << spec
      end

      index
    rescue CertificateFailureError
      Bundler.ui.info "" if gem_names && use_api # newline after dots
      raise
    end

    def use_api
      return @use_api if defined?(@use_api)

      fetchers.shift until fetchers.first.available?

      @use_api = if remote_uri.scheme == "file" || Bundler::Fetcher.disable_endpoint
        false
      else
        fetchers.first.api_fetcher?
      end
    end

    def user_agent
      @user_agent ||= begin
        ruby = Bundler::RubyVersion.system

        agent = String.new("bundler/#{Bundler::VERSION}")
        agent << " rubygems/#{Gem::VERSION}"
        agent << " ruby/#{ruby.versions_string(ruby.versions)}"
        agent << " (#{ruby.host})"
        agent << " command/#{ARGV.first}"

        if ruby.engine != "ruby"
          # engine_version raises on unknown engines
          engine_version = begin
     