gems/gems/bundler-2.4.19/lib/bundler/compact_index_client.rb                                        0000644                 00000006561 15040313351 0017522 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       TTPForbidden
          raise AuthenticationForbiddenError, uri.host
        when Net::HTTPNotFound
          raise FallbackError, "Net::HTTPNotFound: #{filtered_uri}"
        else
          raise HTTPError, "#{response.class}#{": #{response.body}" unless response.body.empty?}"
        end
      end

      def request(uri, headers)
        validate_uri_scheme!(uri)

        filtered_uri = URICredentialsFilter.credential_filtered_uri(uri)

        Bundler.ui.debug "HTTP GET #{filtered_uri}"
        req = Net::HTTP::Get.new uri.request_uri, headers
        if uri.user
          user = CGI.unescape(uri.user)
          password = uri.password ? CGI.unescape(uri.password) : nil
          req.basic_auth(user, password)
        end
        connection.request(uri, req)
      rescue OpenSSL::SSL::SSLError
        raise CertificateFailureError.new(uri)
      rescue *HTTP_ERRORS => e
        Bundler.ui.trace e
        if e.is_a?(SocketError) || e.message.to_s.include?("host down:")
          raise NetworkDownError, "Could not reach host #{uri.host}. Check your network " \
            "connection and try again."
        else
          raise HTTPError, "Network error while fetching #{filtered_uri}" \
            " (#{e})"
        end
      end

      private

      def validate_uri_scheme!(uri)
        return if /\Ahttps?\z/.match?(uri.scheme)
        raise InvalidOption,
          "The request uri `#{uri}` has an invalid scheme (`#{uri.scheme}`). " \
          "Did you mean `http` or `https`?"
      end
    end
  end
end
  gems/gems/bundler-2.4.19/lib/bundler/fetcher/base.rb                                                0000644                 00000001663 15040313351 0015677 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Bundler
  class Fetcher
    class Base
      attr_reader :downloader
      attr_reader :display_uri
      attr_reader :remote

      def initialize(downloader, remote, display_uri)
        raise "Abstract class" if self.class == Base
        @downloader = downloader
        @remote = remote
        @display_uri = display_uri
      end

      def remote_uri
        @remote.uri
      end

      def fetch_uri
        @fetch_uri ||= if remote_uri.host == "rubygems.org"
          uri = remote_uri.dup
          uri.host = "index.rubygems.org"
          uri
        else
          remote_uri
        end
      end

      def available?
        true
      end

      def api_fetcher?
        false
      end

      private

      def log_specs(debug_msg)
        if Bundler.ui.debug?
          Bundler.ui.debug debug_msg
        else
          Bundler.ui.info ".", false
        end
      end
    end
  end
end
                                                                             gems/gems/bundler-2.4.19/lib/bundler/fetcher/compact_index.rb                                       0000644                 00000010326 15040313351 0017576 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       gems/gems/bundler-2.4.19/lib/bundler/fetcher/downloader.rb                                          0000644                 00000005776 15040313351 0017134 0                                                         