  def api_fetcher?
        true
      end

      private

      def compact_index_client
        @compact_index_client ||=
          SharedHelpers.filesystem_access(cache_path) do
            CompactIndexClient.new(cache_path, client_fetcher)
          end
      end

      def parallel_compact_index_client
        compact_index_client.execution_mode = lambda do |inputs, &blk|
          func = lambda {|object, _index| blk.call(object) }
          worker = bundle_worker(func)
          inputs.each {|input| worker.enq(input) }
          inputs.map { worker.deq }
        end

        compact_index_client
      end

      def serial_compact_index_client
        compact_index_client.sequential_execution_mode!
        compact_index_client
      end

      def bundle_worker(func = nil)
        @bundle_worker ||= begin
          worker_name = "Compact Index (#{display_uri.host})"
          Bundler::Worker.new(Bundler.settings.processor_count, worker_name, func)
        end
        @bundle_worker.tap do |worker|
      gems/gems/bundler-2.4.19/lib/bundler/fetcher/base.rb                                                0000644                 00000001663 15040313351 0015677 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       l? && headers["If-None-Match"]
          ui.warn "Using the cached data for the new index because of a network error: #{e}"
          Net::HTTPNotModified.new(nil, nil, nil)
        end
      end
    end
  end
end
                                                                                                                                                                                                                                                                                                          gems/gems/bundler-2.4.19/lib/bundler/fetcher/index.rb                                               0000644                 00000001360 15040313351 0016066 0                                                                                                    ustar 00                                                                                                                                             