pute_source_requirements_for_indirect_dependencies?
        all_requirements = source_map.all_requirements
        all_requirements = pin_locally_available_names(all_requirements) if @prefer_local
        { :default => default_source }.merge(all_requirements)
      else
        { :default => Source::RubygemsAggregate.new(sources, source_map) }.merge(source_map.direct_requirements)
      end
      source_requirements.merge!(source_map.locked_requirements) unless @remote
      metadata_dependencies.each do |dep|
        source_requirements[dep.name] = sources.metadata_source
      end

      default_bundler_source = source_requirements["bundler"] || default_source

      if @unlocking_bundler
        default_bundler_source.add_dependency_names("bundler")
      else
        source_requirements[:default_bundler] = default_bundler_source
        source_requirements["bundler"] = sources.metadata_source # needs to come last to override
      end

      verify_changed_sources!
      source_requirements
    end

    def default_source
      sources.default_source
    end

    def verify_changed_sources!
      @specs_that_changed_sources.each do |s|
        if s.source.specs.search(s.name).empty?
          raise GemNotFound, "Could not find gem '#{s.name}' in #{s.source}"
        end
      end
    end

    def requested_groups
      values = groups - Bundler.settings[:without] - @optional_groups + Bundler.settings[:with]
      values &= Bundler.settings[:only] unless Bundler.settings[:only].empty?
      values
    end

    def lockfiles_equal?(current, proposed, preserve_unknown_sections)
      if preserve_unknown_sections
        sections_to_ignore = LockfileParser.sections_to_ignore(@locked_bundler_version)
        sections_to_ignore += LockfileParser.unknown_sections_in_lockfile(current)
        sections_to_ignore << LockfileParser::RUBY
        sections_to_ignore << LockfileParser::BUNDLED unless @unlocking_bundler
        pattern = /#{Regexp.union(sections_to_ignore)}\n(\s{2,}.*\n)+/
        whitespace_cleanup = /\n{2,}/
        current = current.gsub(pattern, "\n").gsub(whitespace_cleanup, "\n\n").strip
        proposed = proposed.gsub(pattern, "\n").gsub(whitespace_cleanup, "\n\n").strip
      end
      current == proposed
    end

    def additional_base_requirements_for_resolve(resolution_packages, last_resolve)
      return resolution_packages unless @locked_gems && !sources.expired_sources?(@locked_gems.sources)
      converge_specs(@originally_locked_specs - last_resolve).each do |locked_spec|
        next if locked_spec.source.is_a?(Source::Path)
        resolution_packages.base_requirements[locked_spec.name] = Gem::Requirement.new(">= #{locked_spec.version}")
      end
      resolution_packages
    end

    def remove_ruby_from_platforms_if_necessary!(dependencies)
      return if Bundler.frozen_bundle? ||
                Bundler.local_platform == Gem::Platform::RUBY ||
                !platforms.include?(Gem::Platform::RUBY) ||
                (@new_platform && platforms.last == Gem::Platform::RUBY) ||
                @path_changes ||
                @dependency_changes ||
                !@originally_locked_specs.incomplete_ruby_specs?(dependencies)

      remove_platform(Gem::Platform::RUBY)
      add_current_platform
    end

    def source_map
      @source_map ||= SourceMap.new(sources, dependencies, @locked_specs)
    end
  end
end
                                                                                                                                                                                   gems/gems/bundler-2.4.19/lib/bundler/friendly_errors.rb                                             0000644                 00000007402 15040313404 0016551 0                                                                                                    u