rn autorequire if autorequire == "false"
      autorequire.inspect
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                                           gems/gems/bundler-2.4.19/lib/bundler/source_map.rb                                                  0000644                 00000004254 15040313352 0015502 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Bundler
  class SourceMap
    attr_reader :sources, :dependencies, :locked_specs

    def initialize(sources, dependencies, locked_specs)
      @sources = sources
      @dependencies = dependencies
      @locked_specs = locked_specs
    end

    def pinned_spec_names(skip = nil)
      direct_requirements.reject {|_, source| source == skip }.keys
    end

    def all_requirements
      requirements = direct_requirements.dup

      unmet_deps = sources.non_default_explicit_sources.map do |source|
        (source.spec_names - pinned_spec_names).each do |indirect_dependency_name|
          previous_source = requirements[indirect_dependency_name]
          if previous_source.nil?
            requirements[indirect_dependency_name] = source
          else
            no_ambiguous_sources = Bundler.feature_flag.bundler_3_mode?

            msg = ["The gem '#{indirect_dependency_name}' was found in multiple relevant sources."]
            msg.concat [previous_source, source].map {|s| "  * #{s}" }.sort
            msg << "You #{no_ambiguous_sources ? :must : :should} add this gem to the source block for the source you wish it to be installed from."
            msg = msg.join("\n")

            raise SecurityError, msg if no_ambiguous_sources
            Bundler.ui.warn "Warning: #{msg}"
          end
        end

        source.unmet_deps
      end

      sources.default_source.add_dependency_names(unmet_deps.flatten - requirements.keys)

      requirements
    end

    def direct_requirements
      @direct_requirements ||= begin
        requirements = {}
        default = sources.default_source
        dependencies.each do |dep|
          dep_source = dep.source || default
          dep_source.add_dependency_names(dep.name)
          requirements[dep.name] = dep_source
        end
        requirements
      end
    end

    def locked_requirements
      @locked_requirements ||= begin
        requirements = {}
        locked_specs.each do |locked_spec|
          source = locked_spec.source
          source.add_dependency_names(locked_spec.name)
          requirements[locked_spec.name] = source
        end
        requirements
      end
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                    gems/gems/bundler-2.4.19/lib/bundler/gem_helper.rb                                                  0000644                 00000015613 15040313352 0015455 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "../bundler"
require "shellwords"

module Bundler
  class GemHelper
    include Rake::DSL if defined? Rake::DSL

    class << self
      # set when install'd.
      attr_accessor :instance

      def install_tasks(opts = {})
        new(opts[:dir], opts[:name]).install
      end

      def tag_prefix=(prefix)
        instance.tag_prefix = prefix
      end

      def gemspec(&block)
        gemspec = instance.gemspec
        block&.call(gemspec)
        gemspec
      end
    end

    attr_reader :spec_path, :base, :gemspec

    attr_writer :tag_prefix

    def initialize(base = nil, name = nil)
      @base = File.expand_path(base || SharedHelpers.pwd)
      gemspecs = name ? [File.join(@base, "#{name}.gemspec")] : Gem::Util.glob_files_in_dir("{,*}.gemspec", @base)
      raise "Unable to determine name from existing gemspec. Use :name => 'gemname' in #install_tasks to manually set it." unless gemspecs.size == 1
      @spec_path = gemspecs.first
      @gemspec = Bundler.load_gemspec(@spec_path)
      @tag_prefix = ""
    end

    def install
      built_gem_path = nil

      desc "Build #{name}-#{version}.gem into the pkg directory."
      task "build" do
        built_gem_path = build_gem
      end

      desc "Generate SHA512 checksum if #{name}-#{version}.gem into the checksums directory."
      task "build:checksum" => "build" do
        build_checksum(built_gem_path)
      end

      desc "Build and install #{name}-#{version}.gem into system gems."
      task "install" => "build" do
        install_gem(built_gem_path)
      end

      desc "Buil                                                                                                                                                                                                                                                                                                                                                                                                                                           gems/gems/bundler-2.4.19/lib/bundler/source_map.rb                                                  0000644                 00000004254 15040313352 0015502 0                                                                                                    ustar 00                                                                                                                                                                                                                                                         sh([*gem_command, "build", "-V", spec_path]) do
        file_name = File.basename(built_gem_path)
        SharedHelpers.filesystem_access(File.join(base, "pkg")) {|p| FileUtils.mkdir_p(p) }
        FileUtils.mv(built_gem_path, "pkg")
        Bundler.ui.confirm "#{name} #{version} built to pkg/#{file_name}."
      end
      File.join(base, "pkg", file_name)
    end

    def install_gem(built