gems/gems/bundler-2.4.19/lib/bundler/fetcher/dependency.rb                                          0000644                 00000004626 15040313351 0017105 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       gems/gems/bundler-2.4.19/lib/bundler/digest.rb                                                      0000644                 00000004237 15040313352 0014625 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

# This code was extracted from https://github.com/Solistra/ruby-digest which is under public domain
module Bundler
  module Digest
    # The initial constant values for the 32-bit constant words A, B, C, D, and
    # E, respectively.
    SHA1_WORDS = [0x67452301, 0xEFCDAB89, 0x98BADCFE, 0x10325476, 0xC3D2E1F0].freeze

    # The 8-bit field used for bitwise `AND` masking. Defaults to `0xFFFFFFFF`.
    SHA1_MASK = 0xFFFFFFFF

    class << self
      def sha1(string)
        unless string.is_a?(String)
          raise TypeError, "can't convert #{string.class.inspect} into String"
        end

        buffer = string.b

        words = SHA1_WORDS.dup
        generate_split_buffer(buffer) do |chunk|
          w = []
          chunk.each_slice(4) do |a, b, c, d|
            w << (((a << 8 | b) << 8 | c) << 8 | d)
          end
          a, b, c, d, e = *words
          (16..79).each do |i|
            w[i] = SHA1_MASK & rotate((w[i-3] ^ w[i-8] ^ w[i-14] ^ w[i-16]), 1)
          end
          0.upto(79) do |i|
            case i
            when  0..19
              f = ((b & c) | (~b & d))
              k = 0x5A827999
            when 20..39
              f = (b ^ c ^ d)
              k = 0x6ED9EBA1
            when 40..59
              f = ((b & c) | (b & d) | (c & d))
              k = 0x8F1BBCDC
            when 60..79
              f = (b ^ c ^ d)
              k = 0xCA62C1D6
            end
            t = SHA1_MASK & rotate(a, 5) + f + e + k + w[i]
            a, b, c, d, e = t, a, SHA1_MASK & rotate(b, 30), c, d # rubocop:disable Style/ParallelAssignment
          end
          mutated = [a, b, c, d, e]
          words.map!.with_index {|word, index| SHA1_MASK & (word + mutated[index]) }
        end

        words.pack("N*").unpack("H*").first
      end

      private

      def generate_split_buffer(string, &block)
        size   = string.bytesize * 8
        buffer = string.by                                                                                                          gems/gems/bundler-2.4.19/lib/bundler/lockfile_generator.rb                                          0000644                 00000004273 15040313352 0017204 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       gems/gems/bundler-2.4.19/lib/bundler/injector.rb                                                    0000644                 00000024125 15040313352 0015161 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Bundler
  class Injector
    INJECTED_GEMS = "injected gems"

    def self.inject(new_deps, options = {})
      injector = new(new_deps, options)
      injector.inject(Bundler.default_gemfile, Bundler.default_lockfile)
    end

    def self.remove(gems, options = {})
      injector = new(gems, options)
      injector.remove(Bundler.default_gemfile, Bundler.default_lockfile)
    end

    def initialize(deps, options = {})
      @deps = deps
      @options = options
    end

    # @param [Pathname] gemfile_path The Gemfile in which to inject the new dependency.
    # @param [Pathname] lockfile_path The lockfile in which to inject the new dependency.
    # @return [Array]
    def inject(gemfile_path, lockfile_path)
      if Bundler.frozen_bundle?
        # ensure the lock and Gemfile are synced
        Bundler.definition.ensure_equivalent_gemfile_and_lockfile(true)
      end

      # temporarily unfreeze
      Bundler.settings.temporary(:deployment => false, :frozen => false) do
        # evaluate the Gemfile we have now
        builder = Dsl.new
        builder.eval_gemfile(gemfile_path)

        # don't inject any gems that are already in the Gemfile
        @deps -= builder.dependencies

        # add new deps to the end of the in-memory Gemfile
        # Set conservative versioning to false because
        # we want to let the resolver resolve the version first
        builder.eval_gemfile(INJECTED_GEMS, build_gem_lines(false)) if @deps.any?

        # resolve to see if the new deps broke anything
        @definition = builder.to_definition(lockfile_path, {})
        @definition.resolve_remotely!

        # since nothing broke, we can add those gems to the                                                                                                                                                                                                                                                                                                                                     gems/gems/bundler-2.4.19/lib/bundler/digest.rb                                                      0000644                 00000004237 15040313352 0014625 0                                                                                                    ustar 00                                                                                                                                                                                                                                                               deps.each {|dep| Bundler.ui.confirm "#{SharedHelpers.pretty_dependency(dep)} was removed." }
      end

      # Invalidate the cached Bundler.definition.
      # This prevents e.g. `bundle remove ...` from using outdated information.
      Bundler.reset_paths!
    end

    private

    def conservative_version(spec)
      version = spec.version
      return ">= 0" if version.nil?
      segments = version.segments
      seg_end_index = version >= Gem::Version.new("1.0") ? 1 : 2

      prerelease_suffix = version.to_s.gsub(version.release.to_s, "") if version.prerelease?
      "#{version_prefix}#{segments[0..seg_end_index].join(".")}#{prerelease_suffix}"
    end

    def version_prefix
      if @options[:strict]
        "= "
      elsif @options[:optimistic]
        ">= "
      else
        "~> "
      end
    end

    def build_gem_lines(conservative_versioning)
      @deps.map do |d|
        name = d.name.dump

        requirement = if conservative_versioning
          ", \"#{conservative_version(@definition.specs[d.name][0])}\""
        else
          ", #{d.requirement.as_list.map(&:dump).join(", ")}"
        end

        if d.groups != Array(:default)
          group = d.groups.size == 1 ? ", :group => #{d.groups.first.inspect}" : ", :groups => #{d.groups.inspect}"
        end

        source = ", :source => \"#{d.source}\"" unless d.source.nil?
        path = ", :path => \"#{d.path}\"" unless d.path.nil?
        git = ", :git => \"#{d.git}\"" unless d.git.nil?
        github = ", :github => \"#{d.github}\"" unless d.github.nil?
        branch = ", :branch => \"#{d.branch}\"" unless d.branch.nil?
        ref = ", :ref => \"#{d.ref}\"" unless d.ref.nil?
        require_path = ", :require => #{convert_autorequire(d.autorequire)}" unless d.autorequire.nil?

        %(gem #{name}#{requirement}#{group}#{source}#{path}#{git}#{github}#{branch}#{ref}#{require_path})
      end.join("\n")
    end

    def append_to(gemfile_path, new_gem_lines)
      gemfile_path.open("a") do |f|
        f.puts
        f.puts new_gem_lines
      end
    end

    # evaluates a gemfile to remove the specified gem
    # from it.
    def remove_deps(gemfile_path)
      initial_gemfile = Fi                                                                                                                                                                                                                                                                                                                                                                 gems/gems/bundler-2.4.19/lib/bundler/injector.rb                                                    0000644                 00000024125 15040313352 0015161 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       le.
    # @param [Array]    gems Array of names of gems to be removed.
    # @param [Pathname] gemfile_path Path of the Gemfile.
    # @return [Array]   Array of removed dependencies.
    def remove_gems_from_dependencies(builder, gems, gemfile_path)
      removed_deps = []

      gems.each do |gem_name|
        deleted_dep = builder.dependencies.find {|d| d.name == gem_name }

        if deleted_dep.nil?
          raise GemfileError, "`#{gem_name}` is not specified in #{gemfile_path} so it could not be removed."
        end

        builder.dependencies.delete(deleted_dep)

        removed