# frozen_string_literal: true

require_relative "shared_helpers"
Bundler::SharedHelpers.major_deprecation 2, "Bundler no longer integrates with " \
  "Capistrano, but Capistrano provides its own integration with " \
  "Bundler via the capistrano-bundler gem. Use it instead."

module Bundler
  class Deployment
    def self.define_task(context, task_method = :task, opts = {})
      if defined?(Capistrano) && context.is_a?(Capistrano::Configuration)
        context_name = "capistrano"
        role_default = "{:except => {:no_release => true}}"
        error_type = ::Capistrano::CommandError
      else
        context_name = "vlad"
        role_default = "[:app]"
        error_type = ::Rake::CommandFailedError
      end

      roles = context.fetch(:bundle_roles, false)
      opts[:roles] = roles if roles

      context.send :namespace, :bundle do
        send :desc, <<-DESC
          Install the current Bundler environment. By default, gems will be \
          installed to the shared/bundle path. Gems in the development and \
          test group will not be installed. The install command is executed \
          with the --deployment and --quiet flag                                                                                                                                                                                                                                                                                                                                                                                   gems/gems/bundler-2.4.19/lib/bundler/worker.rb                                                      0000644                 00000005550 15040313370 0014656 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       pp, :batch]
        DESC
        send task_method, :install, opts do
          bundle_cmd     = context.fetch(:bundle_cmd, "bundle")
          bundle_flags   = context.fetch(:bundle_flags, "--deployment --quiet")
          bundle_dir     = context.fetch(:bundle_dir, File.join(context.fetch(:shared_path), "bundle"))
          bundle_gemfile = context.fetch(:bundle_gemfile, "Gemfile")
          bundle_without = [*context.fetch(:bundle_without, [:development, :test])].compact
          bundle_with    = [*context.fetch(:bundle_with, [])].compact
          app_path = context.fetch(:latest_release)
          if app_path.to_s.empty?
            raise error_type.new("Cannot detect current release path - make sure you have deployed at least once.")
          end
          args = ["--gemfile #{File.join(app_path, bundle_gemfile)}"]
          args << "--path #{bundle_dir}" unless bundle_dir.to_s.empty?
          args << bundle_flags.to_s
          args << "--without #{bundle_without.join(" ")}" unless bundle_without.empty?
          args << "--with #{bundle_with.join(" ")}" unless bundle_with.empty?

          run "cd #{app_path} && #{bundle_cmd} install #{args.join(" ")}"
        end
      end
    end
  end
end
                                                                                                                                                                                                                                                                                                                           gems/gems/bundler-2.4.19/lib/bundler/lazy_specification.rb                                          0000644                 00000012544 15040313371 0017226 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "force_platform"

module Bundler
  class LazySpecification
    include MatchPlatform
    include ForcePlatform

    attr_reader :name, :version, :dependencies, :platform
    attr_accessor :source, :remote, :force_ruby_platform

    def initialize(name, version, platform, source = nil)
      @name          = name
      @version       = version
      @dependencies  = []
      @platform      = platform || Gem::Platform::RUBY
      @source        = source
      @force_ruby_platform = default_force_ruby_platform
    end

    def full_name
      @full_name ||= if platform == Gem::Platform::RUBY
        "#{@name}-#{@version}"
      else
        "#{@name}-#{@version}-#{platform}"
      end
    end

    def ==(other)
      full_name == other.full_name
    end

    def eql?(other)
      full_name.eql?(other.full_name)
                                                                                                                                                            gems/gems/bundler-2.4.19/lib/bundler/deployment.rb                                                  0000644                 00000006305 15040313371 0015525 0                                                                                                    ustar 00                                                                                           