
        when /403/
          raise AuthenticationForbiddenError, remote_uri
        else
          raise HTTPError, "Could not fetch specs from #{display_uri} due to underlying error <#{e.message}>"
        end
      end
    end
  end
end
                                                                                                                                                                                                                                                                                gems/gems/bundler-2.4.19/lib/bundler/fetcher/dependency.rb                                          0000644                 00000004626 15040313351 0017105 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "base"
require "cgi"

module Bundler
  class Fetcher
    class Dependency < Base
      def available?
        @available ||= fetch_uri.scheme != "file" && downloader.fetch(dependency_api_uri)
      rescue NetworkDownError => e
        raise HTTPError, e.message
      rescue AuthenticationRequiredError
        # Fail since we got a 401 from the server.
        raise
      rescue HTTPError
        false
      end

      def api_fetcher?
        true
      end

      def specs(gem_names, full_dependency_list = [], last_spec_list = [])
        query_list = gem_names.uniq - full_dependency_list

        log_specs "Query List: #{query_list.inspect}"

        return last_spec_list if query_list.empty?

        spec_list, deps_list = Bundler::Retry.new("dependency api", FAIL_ERRORS).attempts do
          dependency_specs(query_list)
        end

        returned_gems = spec_list.map(&:first).uniq
        specs(deps_list, full_dependency_list + returned_gems, spec_list + last_spec_list)
      rescue MarshalError, HTTPError, GemspecError
        Bundler.ui.info "" unless Bundler.ui.debug? # new line now that the dots are over
        Bundler.ui.debug "cou