    def gemspec_cached_path(spec_file_name)
      paths = Bundler.rubygems.spec_cache_dirs.map {|dir| File.join(dir, spec_file_name) }
      paths.find {|path| File.file? path }
    end

    HTTP_ERRORS = [
      Timeout::Error, EOFError, SocketError, Errno::ENETDOWN, Errno::ENETUNREACH,
      Errno::EINVAL, Errno::ECONNRESET, Errno::ETIMEDOUT, Errno::EAGAIN,
      Net::HTTPBadResponse, Net::HTTPHeaderSyntaxError, Net::ProtocolError,
      PersistentHTTP::Error, Zlib::BufError, Errno::EHOSTUNREACH
    ].freeze

    def bundler_cert_store
      store = OpenSSL::X509::Store.new
      ssl_ca_cert = Bundler.settings[:ssl_ca_cert] ||
                    (Gem.configuration.ssl_ca_cert if
                      Gem.configuration.respond_to?(:ssl_ca_cert))
      if ssl_ca_cert
        if File.directory? ssl_ca_cert
          store.add_path ssl_ca_cert
        else
          store.add_file ssl_ca_cert
        end
      else
        store.set_default_paths
        Gem::Request.get_cert_files.each {|c| store.add_file c }
      end
      store
    end

    def remote_uri
      @remote.uri
    end

    def downloader
      @downloader ||= Downloader.new(connection, self.class.redirect_limit)
    end
  end
end
                                                                                                                                                                                                                                                                                                                                 gems/gems/bundler-2.4.19/lib/bundler/constants.rb                                                   0000644                 00000000340 15040313352 0015351 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Bundler
  WINDOWS = RbConfig::CONFIG["host_os"] =~ /(msdos|mswin|djgpp|mingw)/
  FREEBSD = RbConfig::CONFIG["host_os"].to_s.include?("bsd")
  NULL    = WINDOWS ? "NUL" : "/dev/null"
end
                                                                                                                                                                                                                                                                                                gems/gems/bundler-2.4.19/lib/bundler/match_metadata.rb                                              0000644                 00000000442 15040313352 0016274 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Bundler
  module MatchMetadata
    def matches_current_ruby?
      @required_ruby_version.satisfied_by?(Gem.ruby_version)
    end

    def matches_current_rubygems?
      @required_rubygems_version.satisfied_by?(Gem.rubygems_version)
    end
  end
end
                                                                                                                                                                                                                              gems/gems/bundler-2.4.19/lib/bundler/plugin.rb                                                      0000644                 00000026374 15040313352 0014652 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "plugin/api"

module Bundler
  module Plugin
    autoload :DSL,        File.expand_path("plugin/dsl", __dir__)
    autoload :Events,     File.expand_path("plugin/events", __dir__)
    autoload :Index,      File.expand_path("plugin/index", __dir__)
    autoload :Installer,  File.expand_path("plugin/installer", __dir__)
    autoload :SourceList, File.expand_path("plugin/source_list", __dir__)

    class MalformattedPlugin < PluginError; end
    class UndefinedCommandError < PluginError; end
    class UnknownSourceError < PluginError; end
    class PluginInstallError < PluginError; end

    PLUGIN_FILE_NAME = "plugins.rb"

    module_function

    def reset!
      instance_variables.each {|i| remove_instance_variable(i) }

      @sources = {}
      @commands = {}
      @hooks_by_event = Hash.new {|h, k| h[k] = [] }
      @loaded_plugin_names = []
    end

    reset!

    # Installs a new plugin by the given name
    #
    # @param [Array<String>] names the name of plugin to be installed
    # @param [Hash] options various parameters as described in description.
    #               Refer to cli/plugin for available options
    def install(names, options)
      raise InvalidOption, "You cannot specify `--branch` and `--ref` at the same time." if options["branch"] && options["ref"]

      specs = Installer.new.install(names, options)

      save_plugins names, specs
    rescue PluginError
      specs_to_delete = specs.select {|k, _v| names.include?(k) && !index.commands.values.include?(k) }
      specs_to_delete.each_value {|spec| Bundler.rm_rf(spec.full_gem_path) }

      raise
    end

    # Uninstalls plugins by the given names
    #
    # @param [Array<String>] names the names of plugins to be uninstalled
    def uninstall(names, options)
      if names.empty? && !options[:all]
        Bundler.ui.error "No plugins to uninstall. Specify at least 1 plugin to uninstall.\n"\
          "Use --all option to uninstall all the installed plugins."
        return
      end

      names = index.installed_plugins if options[:all]
      if names.any?
        names.each do |name|
          if index.installed?(name)
            Bundler.rm_rf(index.plugin_path(name))
            index.unregister_plugin(name)
            Bundler.ui.info "Uninstalled plugin #{name}"
          else
            Bundler.ui.error "Plugin #{name} is not installed \n"
          end
        end
      else
        Bundler.ui.info "No plugins installed"
      end
    end

    # List installed plugins and commands
    #
    def list
      installed_plugins = index.installed_plugins
      if installed_plugins.any?
        output = String.new
        installed_plugins.each do |plugin|
          output <                                                                                                                                                                                                                                                                                                                                 gems/gems/bundler-2.4.19/lib/bundler/constants.rb                                                   0000644                 00000000340 15040313352 0015351 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       
        definition = builder.to_definition(nil, true)

        return if definition.dependencies.empty?

        plugins = definition.dependencies.map(&:name).reject {|p| index.installed? p }
        installed_specs = Insta                                                                                                                                                                                                                                                                                                gems/gems/bundler-2.4.19/lib/bundler/match_metadata.rb                                              0000644                 00000000442 15040313352 0016274 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       in("plugin")
    end

    # The global directory root for all plugin related data
    def global_root
      Bundler.user_bundle_path("plugin")
    end

    # The cache directory for plugin stuffs
    def cache
      @cache ||= root.join("cache")
    end

    # To be called via the API to r                                                                                                                                                                                                                              gems/gems/bundler-2.4.19/lib/bundler/plugin.rb                                                      0000644                 00000026374 15040313352 0014652 0                                                                                                    ustar 00                                                                                                                                                                                                                                                         # Checks if any plugin declares the source
    def source?(name)
      !index.source_plugin(name.to_s).nil?
    end

    # @return [Class] that handles the source. The class includes API::Source
    def source(name)
      raise UnknownSourceError, "Source #{name} not found" unless source? name

      load_plugin(index.source_plugin(name)) unless @sources.key? name

      @sources[name]
    end

    # @param [Hash] The options that are present in the lock file
    # @return [API::Source] the instance of the class that handles the source
    #                       type passed in locked_opts
    def source_from_lock(locked_opts)
      src = source(locked_opts["type"])

      src.new(locked_opts.merge("uri" => locked_opts["remote"]))
    end

    # To be called via the API to register a hooks and corresponding block that
    # will be called to handle the hook
    def add_hook(event, &block)
      unless Events.defined_event?(event)
        raise ArgumentError, "Event '#{event}' not defined in Bundler::Plugin::Events"
      end
      @hooks_by_event[event.to_s] << block
    end

    # Runs all the hooks that are registered for the passed event
    #
    # It passes the passed arguments and block to the block registered with
    # the api.
    #
    # @param [String] event
    def hook(event, *args, &arg_blk)
      return unless Bundler.feature_flag.plugins?
      unless Events.defined_event?(event)
        raise ArgumentError, "Event '#{event}' not defined in Bundler::Plugin::Events"
      end

      plugins = index.hook_plugins(event)
      return unless plugins.any?

      (plugins - @loaded_plugin_names).each {|name| load_plugin(name) }

      @hooks_by_event[event].each {|blk| blk.call(*args, &arg_blk) }
    end

    # currently only intended for specs
  