gems/gems/bundler-2.4.19/lib/bundler/plugin/api.rb                                                  0000644                 00000005520 15040313342 0015410 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Bundler
  # This is the interfacing class represents the API that we intend to provide
  # the plugins to use.
  #
  # For plugins to be independent of the Bundler internals they shall limit their
  # interactions to methods of this class only. This will save them from breaking
  # when some internal change.
  #
  # Currently we are delegating the methods defined in Bundler class to
  # itself. So, this class acts as a buffer.
  #
  # If there is some change in the Bundler class that is incompatible to its
  # previous behavior or if otherwise desired, we can reimplement(or implement)
  # the method to preserve compatibility.
  #
  # To use this, either the class can inherit this class or use it directly.
  # For example of both types of use, refer the file `spec/plugins/command.rb`
  #
  # To use it without inheriting, you will have to create an object of this
  # to use the functions (except for declaration functions like command, source,
  # and hooks).
  module Plugin
    class API
      autoload :Source, File.expand_path("api/source", __dir__)

      # The plugins should declare that they handle a command through this helper.
      #
      # @param [String] command being handled by them
      # @param [Class] (optional) class that handles the command. If not
      #                 provided, the `self` class will be used.
      def self.command(command, cls = self)
        Plugin.add_command command, cls
      end

      # The plugins should declare that they provide a installation source
      # through this helper.
      #
      # @param [String] the source type they provide
      # @param [Class] (optional) class that handles the source. If not
      #                 provided, the `self` class will be used.
      def self.source(source, cls = self)
        cls.send :include, Bundler::Plugin::API::Source
        Plugin.add_source source, cls
      end

      def self.hook(event, &block)
        Plugin.add_hook(event, &block)
      end

      # The cache dir to be used by the plugins for storage
      #
      # @return [Pathname] path of the cache dir
      def cache_dir
        Plugin.cache.join("plugins")
      end

      # A tmp dir to be used by plugins
      # Accepts names that get concatenated as suffix
      #
      # @return [Pathname] object for the new directory created
      def tmp(*names)
        Bundler.tmp(["plugin", *names].join("-"))
      end

      def method_missing(name, *args, &blk)
        return Bundler.send(name, *args, &blk) if Bundler.respond_to?(name)

        return SharedHelpers.send(name, *args, &blk) if SharedHelpers.respond_to?(name)

        super
      end

      def respond_to_missing?(name, include_private = false)
        SharedHelpers.respond_to?(name, include_private) ||
          Bundler.respond_to?(name, include_private) || super
      end
    end
  end
end
                                                                                                                                                                                gems/gems/bundler-2.4.19/lib/bundler/plugin/api/source.rb                                           0000644                 00000027262 15040313342 0016717 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Bundler
  module Plugin
    class API
      # This class provides the base to build source plugins
      # All the method here are required to build a source plugin (except
      # `uri_hash`, `gem_install_dir`; they are helpers).
      #
      # Defaults for methods, where ever possible are provided which is
      # expected to work. But, all source plugins have to override
      # `fetch_gemspec_files` and `install`. Defaults are also not provided for
      # `remote!`, `cache!` and `unlock!`.
      #
      # The defaults shall work for most situations but nevertheless they can
      # be (preferably should be) overridden as per the plugins' needs safely
      # (as long as they behave as expected).
      # On overriding `initialize` you should call super first.
      #
      # If required plugin should override `hash`, `==` and `eql?` methods to be
      # able to match objects representing same sources, but may be created in
      # different situation (like form gemfile and lockfile). The default ones
      # checks only for class and uri, but elaborate source plugins may need
      # more comparisons (e.g. git checking on branch or tag).
      #
      # @!attribute [r] uri
      #   @return [String] the remote specified with `source` block in Gemfile
      #
      # @!attribute [r] options
      #   @return [String] options passe                                                                                                                                             gems/gems/bundler-2.4.19/lib/bundler/plugin/api.rb                                                  0000644                 00000005520 15040313342 0015410 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       pts
          @dependency_names = []
          @uri = opts["uri"]
          @type = opts["type"]
          @name = opts["name"] || "#{@type} at #{@uri}"
        end

        # This is used by the default `spec` method to constructs the
        # Specification objects for the gems and versions that can be installed
        # by this source plugin.
        #
        # Note: If the spec method is overridden, this function is not necessary
        #
        # @return [Array<String>] paths of the gemspec files for gems that can
        #                         be installed
        def fetch_gemspec_files
          []
        end

        # Options to be saved in the lockfile so that the source plugin is able
        # to check out same version of gem later.
        #
        # There options are passed when the source plugin is created from the
        # lock file.
        #
        # @return [Hash]
        def options_to_lock
          {}
        end

        # Install the gem specified by the spec at appropriate path.
        # `install_path` provides a sufficient default, if the source can only
        # satisfy one gem,  but is not binding.
        #
        # @return [String] post installation message (if any)
        def install(spec, opts)
          raise MalformattedPlugin, "Source plugins need to override the install method."
        end

        # It builds extensions, generates bins and installs them for the spec
        # provided.
        #
        # It depends on `spec.loaded_from` to get full_gem_path. The source
        # plugins should set that.
        #
        # It should be called in `install` after the plugin is done placing the
        # gem at correct install location.
        #
        # It also runs Gem hooks `pre_install`, `post_build` and `post_install`
        #
        # Note: Do not override if you don't know what you are doing.
        def post_install(spec, disable_exts = false)
          opts = { :env_shebang => false, :disable_extensions => disable_exts }
          installer = Bundler::Source::Path::Installer.new(spec, opts)
          installer.post_install
        end

        # A default installation path to install a single gem. If the source
        # servers multiple gems, it's not of much use and the source should one
        # of its own.
        def install_path
          @install_path ||=
            begin
              base_name = File.basename(Bundler::URI.parse(uri).normalize.path)

              gem_install_dir.join("#{base_name}-#{uri_hash[0..11]}")
            end
        end

        # Parses the gemspec files to find the specs for the gems that can be
        # satisfied by the source.
        #
        # Few important points to keep in mind:
        #   - If the gems are not installed then it shall return specs for all
        #   the gems it can satisfy
        #   - If gem is installed (that is                                                                                                                                                                                 gems/gems/bundler-2.4.19/lib/bundler/plugin/api/source.rb                                           0000644                 00000027262 15040313342 0016717 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       end
        end

        # Set internal representation to fetch the gems/specs locally.
        #
        # When this is called, the source should try to fetch the specs and
        # install from the local system.
        def local!
        end

        # Set internal representation to fetch the gems/specs from remote.
        #
        # When this is called, the source should try to fetch the specs and
        # install from remote path.
        def remote!
        end

        # Set internal representation to fetch the gems/specs from app cache.
        #
        # When this is called, the source should try to fetch the specs and
        # install from the path provided by `app_cache_path`.
        def cached!
        end

        # This is called to update the spec and installation.
        #
        # If the source plugin is loaded from lockfile or otherwise, it shall
        # refresh the cache/specs (e.g. git sources can make a fresh clone).
        def unlock!
        end

        # Name of directory where plugin the is expected to cache the gems when
        # #cache is called.
        #
        # Also this name is matched against the directories in cache for pruning
        #
        # This is used by `app_cache_path`
        def app_cache_dirname
          base_name = File.basename(Bundler::URI.parse(uri).normalize.path)
          "#{base_name}-#{uri_hash}"
        end

        # This method is called while caching to save copy of the gems that the
        # source can resolve to path provided by `app_cache_app`so that they can
        # be reinstalled from the cache without querying the remote (i.e. an
        # alternative to remote)
        #
        # This is stored with the app and source plugins should try to provide
        # specs and install only from this cache when `cached!` is called.
        #
        # This cache is different from the internal caching that can be done
        # at sub paths of `cache_path` (from API). This can be though as caching
        # by bundler.
        def cache(spec, custom_path = nil)
          new_cache_path = app_cache_path(custom_path)

          FileUtils.rm_rf(new_cache_path)
          FileUtils.cp_r(install_path, new_cache_path)
 