# frozen_string_literal: true

module Bundler
  module Plugin
    # Dsl to parse the Gemfile looking for plugins to install
    class DSL < Bundler::Dsl
      class PluginGemfileError < PluginError; end
      alias_method :_gem, :gem # To use for plugin installation as gem

      # So that we don't have to override all there methods to dummy ones
      # explicitly.
      # They will be handled by method_missing
      [:gemspec, :gem, :install_if, :platforms, :env].each {|m| undef_method m }

      # This lists the plugins that was added automatically and not specified by
      # the user.
      #
      # When we encounter :type attribute with a source block, we add a plugin
      # by name bundler-source-<type> to list of plugins to be installed.
      #
      # These plugins are optional and are not installed when there is conflict
      # with any other plugin.
      attr_reader :inferred_plugins

      def initialize
        super
        @sour                                                              gems/gems/bundler-2.4.19/lib/bundler/vendored_pub_grub.rb                                           0000644                 00000000143 15040313341 0017027 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       "bundler-source-#{options["type"]}"

        return if @dependencies.any? {|d| d.name == plugin_nam                                                                                                                                                                                                                                                                                                                                                                                                                             gems/gems/bundler-2.4.19/lib/bundler/plugin/events.rb                                               0000644                 00000004104 15040313341 0016137 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Bundler
  # SourceList object to be used while parsing the Gemfile, setting the
  # approptiate options to be used with Source classes for plugin installation
  module Plugin
    class SourceList < Bundler::SourceList
      def add_git_source(options = {})
        add_source_to_list Plugin::Installer::Git.new(options), git_sources
      end

      def add_rubygems_source(options = {})
        add_source_to_list Plugin::Installer::Rubygems.new(options), @rubygems_sources
      end

      def all_sources
        path_sources + git_sources + rubygems_sources + [metadata_source]
      end

      def default_source
        git_sources.first || global_rubygems_source
      end

      private

      def rubygems_aggregate_class
        Plugin::Installer::Rubygems
      end
    end
  end
end
                                                                                                                                                                                               gems/gems/bundler-2.4.19