# frozen_string_literal: true

module Bundler
  module RubyDsl
    def ruby(*ruby_version)
      options = ruby_version.last.is_a?(Hash) ? ruby_version.pop : {}
      ruby_version.flatten!

      raise GemfileError, "Please define :engine_version" if options[:engine] && options[:engine_version].nil?
      raise GemfileError, "Please define :engine" if options[:engine_version] && options[:engine].nil?

      if options[:file]
        raise GemfileError, "Cannot specify version when using the file option" if ruby_version.any?
        ruby_version << Bundler.read_file(options[:file]).strip
      end

      if options[:engine] == "ruby" && options[:engine_version] &&
         ruby_version != Array(options[:engine_version])
        raise GemfileEvalError, "ruby_version must match the :engine_version for MRI"
      end
      @ruby_version = RubyVersion.new(ruby_version, options[:patchlevel], options[:engine], options[:engine_version])
    end
  end
end
                                                               gems/gems/bundler-2.4.19/lib/bundler/resolver/package.rb                                            0000644                 00000003341 15040313346 0016600 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Bundler
  class Resolver
    #
    # Represents a gem being resolved, in a format PubGrub likes.
    #
    # The class holds the following information:
    #
    # * Platforms this gem will be resolved on.
    # * The locked version of this gem resolution sh