# frozen_string_literal: true

module Bundler
  class FeatureFlag
    def self.settings_flag(flag, &default)
      unless Bundler::Settings::BOOL_KEYS.include?(flag.to_s)
        raise "Cannot use `#{flag}` as a settings feature flag since it isn't a bool key"
      end

      settings_method("#{flag}?", flag, &default)
    end
    private_class_method :settings_flag

    def self.settings_option(key, &default)
      settings_method(key, key, &default)
    end
    private_class_method :settings_option

    def self.settings_method(name, key, &default)
      define_method(name) do
        value = Bundler.settings[key]
        value = instance_eval(&default) if value.nil?
        value
      end
    end
    private_class_method :settings_method

    (1..10).each {|v| define_method("bundler_#{v}_mode?") { major_version >= v } }

    settings_flag(:allow_offline_install) { bundler_3_mode? }
    settings_flag(:auto_clean_without_path) { bundler_3_mode? }
    settings_flag(:cache_all) { bundler_3_mode? }
    settings_flag(:default_install_uses_path) { bundler_3_mode? }
    settings_flag(:forget_cli_options) { bundler_3_mode? }
    settings_flag(:global_gem_cache) { bundler_3_mode? }
    settings_flag(:path_relative_to_cwd) { bundler_3_mode? }
    settings_flag(:plugins) { @bundler_version >= Gem::Version.new("1.14") }
    settings_flag(:print_only_version_number) { bundler_3_mode? }
    settings_flag(:setup_makes_kernel_gem_public) { !bundler_3_mode? }
    settings_flag(:update_requires_all_flag) { bundler_4_mode? }

    settings_option(:default_cli_command) { bundler_3_mode? ? :cli_help : :install }

    def initialize(bundler_version)
      @bundler_version = Gem::Version.create(bundler_version)
    end

    def major_version
      @bundler_version.segments.first
    end
    private :major_version
  end
end
                                                                                                                                                                                                                     gems/gems/bundler-2.4.19/lib/bundler/setup.rb                                                       0000644                 00000001703 15040313344 0014502 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "shared_helpers"

if Bundler::SharedHelpers.in_bundle?
  require_relative "../bundler"

  if STDOUT.tty? || ENV["BUNDLER_FORCE_TTY"]
    begin
      Bundler.ui.silence { Bundler.setup }
    rescue Bundler::BundlerError => e
      Bundler.ui.error e.message
      Bundler.ui.warn e.backtrace.join("\n") if ENV["DEBUG"]
      if e.is_a?(Bundler::GemNotFound)
        suggested_cmd = "bundle install"
        original_gemfile = Bundler.original_env["BUNDLE_GEMFILE"]
        suggested_cmd += " --gemfile #{original_gemfile}" if original_gemfile
        Bundler.ui.warn "Run `#{suggested_cmd}` to install missing gems."
      end
      exit e.status_code
    end
  else
    Bundler.ui.silence { Bundler.setup }
  end

  # We might be in the middle of shelling out to rubygems
  # (RUBYOPT=-rbundler/setup), so we need to give rubygems the opportunity of
  # not being silent.
  Gem::DefaultUserInteraction.ui = nil
end
                                                             gems/gems/bundler-2.4.19/lib/bundler/runtime.rb                                                     0000644                 00000024231 15040313344 0015026 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Bundler
  class Runtime
    include SharedHelpers

    def initialize(root, definition)
      @root = root
      @definition = definition
    end

    def setup(*groups)
      @definition.ensure_equivalent_gemfile_and_lockfile if Bundler.frozen_bundle?

      # Has to happen first
      clean_load_path

      specs = @definition.specs_for(groups)

      SharedHelpers.set_bundle_environment
      Bundler.rubygems.replace_entrypoints(specs)

      # Activate the specs
      load_paths = specs.map do |spec|
        check_for_activated_spec!(spec)

        Bundler.rubygems.mark_loaded(spec)
        spec.load_paths.reject {|path| $LOAD_PATH.include?(path) }
      end.reverse.flatten

      Bundler.rubygems.add_to_load_path(load_path                                                                                                                                                                                                                                                         gems/gems/bundler-2.4.19/lib/bundler/feature_flag.rb                                                0000644                 00000003453 15040313344 0015772 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       rue` as an alias for `require: <name>`
            file = dep.name if file == true
            required_file = file
            begin
              Kernel.require file
            rescue RuntimeError => e
              raise e if e.is_a?(LoadError) # we handle this a little later
              raise Bundler::GemRequireError.new e,
                "There was an error while trying to load the gem '#{file}'."
            end
          end
        rescue LoadError => e
          raise if dep.autorequire || e.path != required_file

          if dep.autorequire.nil? && dep.name.include?("-")
            begin
              namespaced_file = dep.name.tr("-", "/")
              Kernel.require namespaced_file
            rescue LoadError => e
              raise if e.path != namespaced_file
            end
          end
        end
      end
    end

    def self.definition_method(meth)
      define_method(meth) do
        raise ArgumentError, "no definition when calling Runtime##{meth}" unless @definition
        @definition.send(meth)
      end
    end
    private_class_method :definition_method

    definition_method :requested_specs
    definition_method :specs
    definition_method :dependencies
    definition_method :current_dependencies
    definition_method :requires

    def lock(opts = {})
      return if @definition.no_resolve_needed?
      @definition.lock(Bundler.default_lockfile, opts[:preserve_unknown_sections])
    end

    alias_method :gems, :specs

    def cache(custom_path = nil, local = false)
      cache_path = Bundler.app_cache(custom_path)
      SharedHelpers.filesystem_access(cache_path) do |p|
        FileUtils.mkdir_p(p)
      end unless File.exist?(cache_path)

      Bundler.ui.info "Updating files in #{Bundler.settings.app_cache_path}"

      specs_to_cache = if Bundler.settings[:cach                                                                                                                                                                                                                     gems/gems/bundler-2.4.19/lib/bundler/setup.rb                                                       0000644                 00000001703 15040313344 0014502 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       rune_cache(cache_path) unless Bundler.settings[:no_prune]
    end

    def prune_cache(cache_path)
      SharedHelpers.filesystem_access(cache_path) do |p|
        FileUtils.mkdir_p(p)
      end unless File.exist?(cache_path)
      resolve = @definition.resolve
      prune_gem_cache(resolve, cache_path)
      prune_git_and_path_cache(resolve, cache_path)
    end

    def clean(dry_run = false)
      gem_bins             = Dir["#{Gem.dir}/bin/*"]
      git_dirs             = Dir["#{Gem.dir}/bundler/gems/*"]
      git_cache_dirs       = Dir["#{Gem.dir}/cache/bundler/git/*"]
      gem_dirs             = Dir["#{Gem.dir}/gems/*"]
      gem_files            = Dir["#{Gem.dir}/cache/*.gem"]
      gemspec_files        = Dir["#{Gem.dir}/specifications/*.gemspec"]
      extension_dirs       = Dir["#{Gem.dir}/extensions/*/*/*"] + Dir["#{Gem.dir}/bundler/gems/extensions/*/*/*"]
      spec_gem_paths       = []
      # need to keep git sources around
      spec_gi                                                             gems/gems/bundler-2.4.19/lib/bundler/runtime.rb                                                     0000644                 00000024231 15040313344 0015026 0                                                                                                    ustar 00                                                                                                                                                                                                                                                        do |executable|
          e = "#{Bundler.rubygems.gem_bindir}/#{executable}"
          [e, "#{e}.bat"]
        end
        spec_cache_paths << spec.cache_file
        spec_gemspec_paths << spec.spec_file
        spec_extension_paths << spec.extension_dir if spec.respond_to?(:extension_dir)
        spec_git_cache_dirs << spec.source.cache_path.to_s if spec.source.is_a?(Bundler::Source::Git)
      end
      spec_gem_paths.uniq!
      spec_gem_executables.flatten!

      stale_gem_bins       = gem_bins - spec_gem_executables
      stale_git_dirs       = git_dirs - spec_git_paths - ["#{Gem.dir}/bundler/gems/extensions"]
      stale_git_cache_dirs = git_cache_d