ned in
        # docstring for `==` method.
        alias_method :eql?, :==

        # When overriding `hash` please preserve the behaviour as mentioned in
        # docstring for `==` method, i.e. two methods equal by above comparison
        # should have same hash.
        def hash
          [self.class, uri].hash
        end

        # A helper method, not necessary if not used internally.
        def installed?
          File.directory?(install_path)
        end

        # The full path where the plugin should cache the gem so that it can be
        # installed latter.
        #
        # Note: Do not override if you don't know what you are doing.
        def app_cache_path(custom_path = nil)
          @app_cache_path ||= Bundler.app_cache(custom_path).join(app_cache_dirname)
        end

        # Used by definition.
        #
        # Note: Do not override if you don't know what you are doing.
        def unmet_deps
          specs.unmet_dependency_names
        end

        # Used by definition.
        #
        # Note: Do not override if you don't know what you are doing.
        def spec_names
          specs.spec_names
        end

        # Used by definition.
        #
        # Note: Do not override if you don't know what you are doing.
        def add_dependency_names(names)
          @dependencies |= Array(names)
        end

        # NOTE: Do not override if you don't know what you are doing.
        def can_lock?(spec)
          spec.source == self
        end

        # Generates the content to be entered into the lockfile.
        # Saves type and remote and also calls to `options_to_lock`.
        #
        # Plugin should use `options_to_lock` to save information in lockfile
        # and not override this.
        #
        # Note: Do not override if you don't know what you are doing.
        def to_lock
          out = String.new("#{LockfileParser::PLUGIN}\n")
          out << "  remote: #{@uri}\n"
          out << "  type: #{@type}\n"
          options_to_lock.each do |opt, value|
            out << "  #{opt}: #{value}\n"
          end
          out << "  specs:\n"
        end

        def to_s
          "plugin source for #{@type} with uri #{@uri}"
        end
        alias_method :identifier, :to_s

        # NOTE: Do not override if you don't know what you are doing.
        def include?(other)
          other == self
        end

        def uri_hash
          SharedHelpers.digest(:SHA1).hexdigest(uri)
        end

        # NOTE: Do not override if you don't know what you are doing.
        def gem_install_dir
          Bundler.install_path
        end

        # It is used to obtain the full_gem_path.
        #
        # spec's loaded_from path is expanded against this to get full_gem_path
        #
        # Note: Do not override if you don't know what you are doing.
        def root
          Bundler.root
        end

        # @private
        # This API on source might not be stable, and for now we expect plugins
        # to download all specs in `#specs`, so we implement the method for
        # compatibility purposes an