me.new(path).absolute?
            file.puts %($:.unshift "#{path}")
          else
            file.puts %($:.unshift File.expand_path("\#{__dir__}/#{path}"))
          end
        end
      end
    end

    private

    def paths
      @specs.map do |spec|
        next if spec.name == "bundler"
        Array(spec.require_paths).map do |path|
          gem_path(path, spec).
            sub(version_dir, '#{RUBY_ENGINE}/#{Gem.ruby_api_version}').
            sub(extensions_dir, 'extensions/\k<platform>/#{Gem.extension_api_version}')
          # This is a static string intentionally. It's interpolated at a later time.
        end
      end.flatten.compact
    end

    def version_dir
      "#{RUBY_ENGINE}/#{Gem.ruby_api_version}"
    end

    def extensions_dir
      %r{extensions/(?<platform>[^/]+)/#{Regexp.escape(Gem.extension_api_version)}}
    end

    def bundler_path
      Bundler.root.join(Bundler.settings[:path].to_s, "bundler")
    end

    def gem_path(path, spec)
      full_path = Pathname.new(path).absolute? ? path : File.join(spec.full_gem_path, path)
      if spec.source.instance_of?(Source::Path) && spec.source.path.absolute?
        full_path
      else
        Pathname.new(full_path).relative_path_from(Bundler.root.join(bundler_path)).to_s
      end
    rescue TypeError
      error_message = "#{spec.name} #{spec.version} has an invalid gemspec"
      raise Gem::InvalidSpecificationException.new(error_message)
    end

    def define_path_helpers
      <<~'END'
        unless defined?(Gem)
          module Gem
            def self.ruby_api_version
              RbConfig::CONFIG["ruby_version"]
            end

            def self.extension_api_version
              if 'no' == RbConfig::CONFIG['ENABLE_SHARED']
                "#{ruby_api_version}-static"
              else
                ruby_api_version
              end
            end