pec)
      end

      def load_spec_files
        index = Index.new

        if File.directory?(expanded_path)
          # We sort depth-first since `<<` will override the earlier-found specs
          Gem::Util.glob_files_in_dir(@glob, expanded_path).sort_by {|p| -p.split(File::SEPARA                                                                                                                                                                                                                                  gems/gems/bundler-2.4.19/lib/bundler/source/path.rb                                                 0000644                 00000017514 15040313353 0015605 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       one"]
              if expanded_path.join("bin").exist?
                executables = expanded_path.join("bin").children
                executables.reject! {|p| File.directory?(p) }
                s.executables = executables.map {|c| c.basename.to_s }
              end
            end
          end
        else
          message = String.new("The path `#{expanded_path}` ")
          message << if File.exist?(expanded_path)
            "is not a directory."
          else
            "does not exist."
          end
          raise PathError, message
        end

        index
      end

      def relative_path(path = self.path)
        if path.to_s.start_with?(root_path.to_s)
          return path.relative_path_from(root_path)
        end
        path
      end

      def generate_bin(spec, options = {})
        gem_dir = Pathname.new(spec.full_gem_path)

        # Some gem authors put absolute paths in their gemspec
        # and we have to save them from themselves
        spec.files = spec.files.map do |path|
          next path unless /\A#{Pathname::SEPARATOR_PAT}/.match?(path)
          next if File.directory?(path)
          begin
            Pathname.new(path).relative_path_from(gem_dir).to_s
          rescue ArgumentError
            path
          end
        end.compact

        installer = Path::Installer.new(
          spec,
          :env_shebang => false,
          :disable_extensions => options[:disable_extensions],
          :build_args => options[:build_args],
          :bundler_extension_cache_path => extension_cache_path(spec)
        )
        installer.post_install
      rescue Gem::InvalidSpecificationException => e
        Bundler.ui.warn "\n#{spec.name} at #{spec.full_gem_path} did not have a valid gemspec.\n" \
                        "This prevents bundler from installing bins or native extensions, but " \
                        "that may not affect its functionality."

        if !spec.extensions.empty? && !spec.email.empty?
          Bundler.ui.warn "If you need to use this package without installing it from a gem " \
                          "repository, please contact #{spec.email} and ask them " \
                          "to modify their .gemspec so it can work with `gem build`."
        end

        Bundler.ui.warn "The validation message from RubyGems was:\n  #{e.message}"
      end
    end
  end
end
                                                                                                                                                                                    gems/gems/bundler-2.4.19/lib/bundler/source/git/git_proxy.rb                                        0000644                 00000033127 15040313353 0017456 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Bundler
  class Source
    class Git
      class GitNotInstalledError < GitError
        def initialize
          msg = String.new
          msg << "You need to install git to be able to use gems from git repositories. "
          msg << "For help installing git, please refer to GitHub's tutorial at https://help.github.com/articles/set-up-git"
          super msg
        end
      end

      class GitNotAllowedError < GitError
        def initialize(command)
          msg = String.new
          msg << "Bundler is trying to run `#{command}` at runtime. You probably need to run `bundle install`. However, "
          msg << "this error message could probably be more useful. Please submit a ticket at https://github.com/rubygems/rubygems/issues/new?labels=Bundler&template=bundler-related-issue.md "
          msg << "with steps to reproduce as well as the following\n\nCALLER: #{caller.join("\n")}"
          super msg
        end
      end

      class GitCommandError < GitError
        attr_reader :command

        def initialize(command, path, extra_info = nil)
          @command = command

          msg = String.new("Git error: command `#{command}`")
          msg << " in directory #{path}" if path
          msg << " has failed."
          msg << "\n#{extra_info}" if extra_info
          super msg
        end
      end

      class MissingGitRevisionError < GitCommandError
        def initialize(command, destination_path, ref, repo)
          msg = "Revision #{ref} does not exist in the repository #{repo}. Maybe you misspelled it?"
          super command, destination_path, msg
        end
      end

      # The GitProxy is responsible to interact with git repositories.
      # All actions required by the Git source is encapsulated in this
      # object.
      class GitProxy
        attr_accessor :path, :uri, :branch, :tag, :ref, :explicit_ref
        attr_writer :revision

        def initialize(path, uri, options = {}, revision = nil, git = nil)
          @path     = path
          @uri      = uri
          @branch   = options["branch"]
          @tag      = options["tag"]
          @ref      = options["ref"]
          @explicit_ref = branch || tag || ref
          @revision = revision
          @git      = git
          @commit_ref = nil
        end

        def revision
          @revision ||= allowed_with_path { find_local_revision }
        end

        def current_branch
          @current_branch ||= with_path do
            git_local("rev-parse", "--abbrev-ref", "HEAD", :dir => path).strip
          end
        end

        def contains?(commit)
          allowed_with_path do
            result, status = git_null("branch", "--contains", commit, :dir => path)
            status.success? && result =~ /^\* (.*)$/
          end
        end

        def version
          @version ||= full_version.match(/((\.?\d+)+).*/)[1]
        end

        def full_version
          @full_version ||= git_local("--version").sub(/git version\s*/, "").strip
        end

        def checkout
          return if has_revision_cached?

          Bundler.ui.info "Fetching #{credential_filtered_uri}"

          extra_fetch_needed = clone_needs_extra_fetch?
          unshallow_needed = clone_needs_unshallow?
          return unless extra_fetch_needed || unshallow_needed

          git_remote_fetch(unshallow_needed ? ["--unshallow"] : depth_args)
        end

        def copy_to(destination, submodules = false)
          unless File.exist?(destination.join(".git"))
            begin
              SharedHelpers.filesystem_access(destination.dirname) do |p|
                FileUtils.mkdir_p(p)
              end
              SharedHelpers.filesystem_access(destination) do |p|
                FileUtils.rm_rf(p)
              end
              git "clone", "--no-checkout", "--quiet", path.to_s, destination.to_s
              File.chmod(((File.stat(destination).mode | 0o777) & ~File.umask), destination)
            rescue Errno::EEXIST => e
              file_path = e.message[%r{.*?((?:[a-zA-Z]:)?/.*)}, 1]
              raise GitError, "Bundler could not install a gem because it needs to " \
                "create a directory, but a file exists - #{file_path}. Please delete " \
                "this file and try again."
            end
          end

          git "fetch", "--force", "--quiet", *extra_fetch_args, :dir => destination if @commit_ref

          git "reset", "--hard", @revision, :dir => destination

          if submodules
            git_retry "submodule", "update", "--init", "--recursive", :dir => destination
          elsif Gem::Version.create(version) >= Gem::Version.create("2.9.0")
            inner_command = "git -C $toplevel submodule deinit --force $sm_path"
            git_retry "submodule", "foreach", "--quiet", inner_command, :dir => destination
          end
        end

        private

        def git_remote_fetc                                                                                                                                                                                    gems/gems/bundler-2.4.19/lib/bundler/source/git/git_proxy.rb                                        0000644                 00000033127 15040313353 0017456 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       ntials, path, err)
            end
          end
        end

        def clone_needs_extra_fetch?
          return true if path.exist?

          SharedHelpers.filesystem_access(path.dirname) do |p|
            FileUtils.mkdir_p(p)
          end

          command = ["clone", "--bare", "--no-hardlinks", "--quiet", *extra_clone_args, "--", configured_uri, path.to_s]
          command_with_no_credentials = check_allowed(command)

          Bundler::Retry.new("`#{command_with_no_credentials}`", [MissingGitRevisionError]).attempts do
            _, err, status = capture(command, nil)
            return extra_ref if status.success?

            if err.include?("Could not find remote branch") || # git up to 2.49
               err.include?("Remote branch #{branch_option} not found") # git 2.49 or higher
              raise MissingGitRevisionError.new(command_with_no_credentials, nil, explicit_ref, credential_filtered_uri)
            else
              raise GitCommandError.new(command_with_no_credentials, path, err)
            end
          end
        end

        def clone_needs_unshallow?
          return false unless path.join("shallow").exist?
          return true if full_clone?

          @revision && @revision != head_revision
        end

        def extra_ref
          return false if not_pinned?
          return true unless full_clone?

          ref.start_with?("refs/")
        end

        def depth
          return @depth if defined?(@depth)

          @depth = if !supports_fetching_unreachable_refs?
            nil
          elsif not_pinned? || pinned_to_full_sha?
            1
          elsif ref.include?("~")
            parsed_depth = ref.split("~").last
            parsed_depth.to_i + 1
          end
        end

        def refspec
          if commit
            @commit_ref = "refs/#{commit}-sha"
            return "#{commit}:#{@commit_ref}"
          end

          reference = fully_qualified_ref

          reference ||= if ref.include?("~")
            ref.split("~").first
          elsif ref.start_with?("refs/")
            ref
          else
            "refs/*"
          end

          "#{reference}:#{reference}"
        end

        def commit
          @commit ||= pinned_to_full_sha? ? ref : @revision
        end

        def fully_qualified_ref
          if branch
            "refs/heads/#{branch}"
          elsif tag
            "refs/tags/#{tag}"
          elsif ref.nil?
            "refs/heads/#{current_branch}"
          end
        end

        def not_pinned?
          branch_option || ref.nil?
        end

        def pinned_to_full_sha?
          ref =~ /\A\h{40}\z/
        end

        def git_null(*command, dir: nil)
          check_allowed(command)

          capture(command, dir, :ignore_err => true)
        end

        def git_retry(*command, dir: nil)
          command_with_no_credentials = check_allowed(command)

          Bundler::Retry.new("`#{command_with_no_credentials}` at #{dir || SharedHelpers.pwd}").attempts do
            git(*command, :dir => dir)
          end
        end

        def git(*command, dir: nil)
          run_command(*command, :dir => dir) do |unredacted_command|
            check_allowed(unredacted_command)
          end
        end

        def git_local(*command, dir: nil)
          run_command(*command, :dir => dir) do |unredacted_command|
            redact_and_check_presence(unredacted_command)
          end
        end

        def has_revision_cached?
          return unless @revision && path.exist?
          git("cat-file", "-e", @revision, :dir => path)
          true
        rescue GitError
          false
        end

        def find_local_revision
          return head_revision if explicit_ref.nil?

          find_revision_for(explicit_ref)
        end

        def head_revision
          verify("HEAD")
        end

        def find_revision_for(reference)
          verify(reference)
        rescue GitCommandError => e
          raise MissingGitRevisionError.new(e.command, path, reference, credential_filtered_uri)
        end

        def verify(reference)
          git("rev-parse", "--verify", reference, :dir => path).strip
 