# frozen_string_literal: true

module Bundler
  class Source
    class RubygemsAggregate
      attr_reader :source_map, :sources

      def initialize(sources, source_map)
        @sources = sources
        @source_map = source_map

        @index = build_index
      end

      def specs
        @index
      end

      def identifier
        to_s
      end

      def to_s
        "any of the sources"
      end

      private

      def build_index
        Index.build do |idx|
          dependency_names = source_map.pinned_spec_names

          sources.all_sources.each do |source|
            source.dependency_names = dependency_names - source_map.pinned_spec_names(source)
            idx.add_source source.specs
            dependency_names.concat(source.unmet_deps).uniq!
          end

          double_check_for_index(idx, dependency_names)
        end
      end

      # Suppose the gem Foo depends on the gem Bar.  Foo exists in Source A.  Bar has some versions that exist in both
      # sources A and B.  At this point, the API request will have found all the versions of Bar in source A,
      # but will not have found any versions of Bar from source B, which is a problem if the requested version
      # of Foo specifically depends on a version of Bar that is only found in source B. This ensures that for
      # each spec we found, we add all possible versions from all sources to the index.
      def double_check_for_index(idx, dependency_names)
        pinned_names = source_map.pinned_spec_names

        names = :names # do this so we only have to traverse to get dependency_names from the index once
        unmet_dependency_names = lambda do
          return names unless names == :names
          new_names = sources.all_sources.map(&:dependency_names_to_double_check)
          return names = nil if new_names.compact!
          names = new_names.flatten(1).concat(dependency_names)
          names.uniq!
          names -= pinned_names
          names
        end

        sources.all_sources.each do |source|
          source.double_check_for(unmet_dependency_names)
        end
      end
    end
  end
end
                                                                                                                                                                                                                                                                                                                                                                                                                                    gems/gems/bundler-2.4.19/lib/bundler/source/gemspec.rb                                              0000644                 00000000436 15040313353 0016267 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Bundler
  class Source
    class Gemspec < Path
      attr_reader :gemspec

      def initialize(options)
        super
        @gemspec = options["gemspec"]
      end

      def as_path_source
        Path.new(options)
      end
    end
  end
end
                                                                                                                                                                                                                                  gems/gems/bundler-2.4.19/lib/bundler/source/path.rb                                                 0000644                 00000017514 15040313353 0015605 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Bundler
  class Source
    class Path < Source
      autoload :Installer, File.expand_path("path/installer", __dir__)

      attr_reader :path, :options, :root_path, :original_path
      attr_writer :name
      attr_accessor :version

      protected :original_path

      DEFAULT_GLOB = "{,*,*/*}.gemspec"

      def initialize(options)
        @options = options.dup
        @glob = options["glob"] || DEFAULT_GLOB

        @allow_cached = false
        @allow_remote = false

        @root_path = options["root_path"] || root

        if options["path"]
          @path = Pathname.new(optio                                                                                                                                                                                                                                                                                                                                                                                                         gems/gems/bundler-2.4.19/lib/bundler/source/rubygems_aggregate.rb                                   0000644                 00000004134 15040313353 0020506 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       ob == DEFAULT_GLOB
        out << "  specs:\n"
      end

      def to_s
        "source at `#{@path}`"
      end

      def hash
        [self.class, expanded_path, version].hash
      end

      def eql?(other)
        return unless other.class == self.class
        expanded_original_path == other.expanded_original_path &&
          version == other.version
      end

      alias_method :==, :eql?

      def name
        File.basename(expanded_path.to_s)
      end

      def install(spec, options = {})
        using_message = "Using #{version_message(spec, options[:previous_spec])} from #{self}"
        using_message += " and installing its executables" unless spec.executables.empty?
        print_using_message using_message
        generate_bin(spec, :disable_extensions => true)
        nil # no post-install message
      end

      def cache(spec, custom_path = nil)
        app_cache_path = app_cache_path(custom_path)
        return unless Bundler.feature_flag.cache_all?
        return if expand(@original_path).to_s.index(root_path.to_s + "/") == 0

        unless @original_path.exist?
          raise GemNotFound, "Can't cache gem #{version_message(spec)} because #{self} is missing!"
        end

        FileUtils.rm_rf(app_cache_path)
        FileUtils.cp_r("#{@original_path}/.", app_cache_path)
        FileUtils.touch(app_cache_path.join(".bundlecache"))
      end

      def local_specs(*)
        @local_specs ||= load_spec_files
      end

      def specs
        if has_app_cache?
          @path = app_cache_path
          @expanded_path = nil # Invalidate
        end
        local_specs
      end

      def app_cache_dirname
        name
      end

      def root
        Bundler.root
      end

      def expanded_original_path
        @expanded_original_path ||= expand(original_path)
      end

      private

      def expanded_path
        @expanded_path ||= expand(path)
      end

      def expand(somepath)
        if Bundler.current_ruby.jruby? # TODO: Unify when https://github.com/rubygems/bundler/issues/7598 fixed upstream and all supported jrubies include the fix
          somepath.expand_                                                                                                                                                                                                                                                