p do |dep_package, dep_constraint|
        name = dep_package.name

        next [dep_package, dep_constraint] if name == "bundler"

        versions = versions_for(dep_package, dep_constraint.range)
        if versions.empty? && dep_package.ignores_prereleases?
          @sorted_versions.delete(dep_package)
          dep_package.consider_prereleases!
          versions = versions_for(dep_package, dep_constraint.range)
        end
        next [dep_package, dep_constraint] unless versions.empty?

        next unless dep_package.current_platform?

        raise_not_found!(dep_package)
      end.compact.to_h
    end

    def other_specs_matching_message(specs, requirement)
      message = String.new("The source contains the following gems matching '#{requirement}':\n")
      message << specs.map {|s| "  * #{s.full_name}" }.join("\n")
      message
    end

    def requirement_to_range(requirement)
      ranges = requirement.requirements.map do |(op, version)|
        ver = Resolver::Candidate.new(version).generic!
        platform_ver = Resolver::Candidate.new(version).platform_specific!

        case op
        when "~>"
          name = "~> #{ver}"
          bump = Resolver::Candidate.new(version.bump.to_s + ".A")
          PubGrub::VersionRange.new(:name => name, :min => ver, :max => bump, :include_min => true)
        when ">"
          PubGrub::VersionRange.new(:min => platform_ver)
        when ">="
          PubGrub::VersionRange.new(:min => ver, :include_min => true)
        when "<"
          PubGrub::VersionRange.new(:max => ver)
        when "<="
          PubGrub::VersionRange.new(:max => platform_ver, :include_max => true)
        when "="
          PubGrub::VersionRange.new(:min => ver, :max => platform_ver, :include_min => true, :include_max => true)
        when "!="
          PubGrub::VersionRange.new(:min => ver, :max => platform_ver, :include_min => true, :include_max => true).invert
        else
          raise "bad version specifier: #{op}"
        end
      end

      ranges.inject(&:intersect)
    end

    def to_dependency_hash(dependencies, packages)
      dependencies.inject({}) 