gems/gems/bundler-2.4.19/lib/bundler/vendored_uri.rb                                                0000644                 00000000131 15040313370 0016020 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       ciding what versions best resolve all dependencies in the bundle.
    # @param package [R                                                                                                                                                                                                                                                                                                                                                                                                                                       gems/gems/bundler-2.4.19/lib/bundler/similarity_detector.rb                                         0000644                 00000003534 15040313370 0017424 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       spec.version

        must_match = minor? ? [0] : [0, 1]

        all_match = must_match.all? {|idx| gsv.segments[idx] == locked_version.segments[idx] }
        all_match && gsv >= locked_version
      end
    end

    def sort_dep_specs(specs, package)
      locked_version = package.locked_version

      result = specs.sort do |a, b|
        unless package.prerelease_specified? || pre?
          a_pre = a.prerelease?
          b_pre = b.prerelease?

          next -1 if a_pre && !b_pre
          next  1 if b_pre && !a_pre
        end

        if major?
          a <=> b
        elsif either_version_older_than_locked?(a, b, locked_version)
          a <=> b
        elsif segments_do_not_match?(a, b, :major)
          b <=> a
        elsif !minor? && segments_do_not_match?(a, b, :minor)
          b <=> a
        else
          a <=> b
        end
      end
      post_sort(result, package.unlock?, locked_version)
    end

    def either_version_older_than_locked?(a, b, locked_version)
      locked_version && (a.version < locked_version || b.version < locked_version)
    end

    def segments_do_not_match?(a, b, level)
      index = [:major, :minor].index(level)
      a.segments[index] != b.segments[index]
    end

    # Specific version moves can't always reliably be done during sorting
    # as not all elements are compared against each other.
    def post_sort(result, unlock, locked_version)
      # default :major behavior in Bundler does not do this
      return result if major?
      if unlock || locked_version.nil?
        result
      else
        move_version_to_end(result, locked_version)
      end
    end

    def move_version_to_end(result, version)
      move, keep = result.partition {|s| s.version.to_s == version.to_s }
      keep.concat(move)
    end
  end
end
                                                                                                                                                                                                                                                      gems/gems/bundler-2.4.19/lib/bundler/gem_version_promoter.rb                                        0000644                 00000011412 15040313370 0017603 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "vendored_tsort"

module Bundler
  class SpecSet
    include Enumerable
    include TSort

    attr_reader :incomplete_specs

    def initialize(specs, incomplete_specs = [])
      @specs = specs
      @incomplete_specs = incomplete_specs
    end

    def for(dependencies, check = false, platforms = [nil])
      handled = ["bundler"].product(platforms).map {|k| [k, true] }.to_h
      deps = dependencies.product(platforms)
      specs = []

      loop do
        break unless dep = deps.shift

        name = dep[0].name
        platform = dep[1]
        incomplete = false

        key = [name, platform]
        next if handled.key?(key)

        handled[key] = true

        specs_for_dep = specs_for_dependency(*dep)
        if specs_for_dep.any?
          specs.concat(specs_for_dep)

          specs_for_dep.first.dependencies.each do |d|
            next if d.type == :development
            incomplete = true if d.name != "bundler" && lookup[d.name].empty?
            deps << [d, dep[1]]
          end
        else
          incomplete = true
