_method :===

      def ===(other)
        return nil unless Gem::Platform === other

        # universal-mingw32 matches x64-mingw-ucrt
        return true if (@cpu == "universal" || other.cpu == "universal") &&
                       @os.start_with?("mingw") && other.os.start_with?("mingw")

        # cpu
        ([nil,"universal"].include?(@cpu) || [nil, "universal"].include?(other.cpu) || @cpu == other.cpu ||
        (@cpu == "arm" && other.cpu.start_with?("arm"))) &&

          # os
          @os == other.os &&

          # version
          (
            (@os != "linux" && (@version.nil? || other.version.nil?)) ||
            (@os == "linux" && (normalized_linux_version_ext == other.normalized_linux_version_ext || ["musl#{@version}", "musleabi#{@version}", "musleabihf#{@version}"].include?(other.version))) ||
            @version == other.version
          )
      end

      # This is a copy of RubyGems 3.3.23 or higher `normalized_linux_method`.
      # Once only 3.3.23 is supported, we can use the method in RubyGems.
      def normalized_linux_version_ext
        return nil unless @version

        without_gnu_nor_abi_modifiers = @version.sub(/\Agnu/, "").sub(/eabi(hf)?\Z/, "")
        return nil if without_gnu_nor_abi_modifiers.empty?

        without_gnu_nor_abi_modifiers
      end
    end

    if RUBY_ENGINE == "truffleruby" && !defined?(REUSE_AS_BINARY_ON_TRUFFLERUBY)
      REUSE_AS_BINARY_ON_TRUFFLERUBY = %w[libv8 libv8-node sorbet-static].freeze
    end
  end

  Platform.singleton_class.module_eval do
    unless Platform.singleton_methods.include?(:match_spec?)
      def match_spec?(spec)
        match_gem?(spec.platform, spec.name)
      end

      def match_gem?(platform, gem_name)
        match_platforms?(platform, Gem.platforms)
      end
    end

    match_platforms_defined = Gem::Platform.respond_to?(:match_platforms?, true)

    if !match_platforms_defined || Gem::Platform.send(:match_platforms?, Gem::Platform::X64_LINUX_MUSL, [Gem::Platform::X64_LINUX])

      private

      remove_method :match_platforms? if match_platforms_defined

      def match_platforms?(platform, platforms)
        platforms.any? do |local_platform|
          platform.nil? ||
            local_platform == platform ||
            (local_platform != Gem::Platform::RUBY && platform =~ local_platform)
        end
      end
    end
  end

  # On universal Rubies, resolve the "universal" arch to the real CPU arch, without changing the extension directory.
  class Specification
    if /^universal\.(?<arch>.*?)-/ =~ (CROSS_COMPILING || RUBY_PLATFORM)
      local_platform = Platform.local
      if local_platform.cpu == "universal"
        ORIGINAL_LOCAL_PLATFORM = local_platform.to_s.freeze

        local_platform.cpu = if arch == "arm64e" # arm64e is only permitted for Apple system binaries
          "arm64"
        e