USER_HOME"]).join("config")
      elsif Bundler.rubygems.user_home && !Bundler.rubygems.user_home.empty?
        Pathname.new(Bundler.rubygems.user_home).join(".bundle/config")
      end
    end

    def local_config_file
      Pathname.new(@root).join("config") if @root
    end

    def load_config(config_file)
      return {} if !config_file || ignore_config?
      SharedHelpers.filesystem_access(config_file, :read) do |file|
        valid_file = file.exist? && !file.size.zero?
        return {} unless valid_file
        require_relative "yaml_serializer"
        YAMLSerializer.load(file.read).inject({}) do |config, (k, v)|
          new_k = k

          if k.include?("-")
            Bundler.ui.warn "Your #{file} config includes `#{k}`, which contains the dash character (`-`).\n" \
              "This is deprecated, because configuration through `ENV` should be possible, but `ENV` keys cannot include dashes.\n" \
              "Please edit #{file} and replace any dashes in configuration keys with a triple underscore (`___`)."

            new_k = k.gsub("-", "___")
          end

          config[new_k] = v
          config
        end
      end
    end

    PER_URI_OPTIONS = %w[
      fallback_timeout
    ].freeze

    NORMALIZE_URI_OPTIONS_PATTERN =
      /
        \A
        (\w+\.)? # optional prefix key
        (https?.*?) # URI
        (\.#{Regexp.union(PER_URI_OPTIONS)})? # optional suffix key
        \z
      /ix.freeze

    def self.key_for(key)
      key = normalize_uri(key).to_s if key.is_a?(String) && key.start_with?("http", "mirror.http")
      key = key.to_s.gsub(".", "__").gsub("-", "___").upcase
      "BUNDLE_#{key}"
    end

    # TODO: duplicates Rubygems#normalize_uri
    # TODO: is this the correct place to validate mirror URIs?
    def self.normalize_uri(uri)
      uri = uri.to_s
      if uri =~ NORMALIZE_URI_OPTIONS_PATTERN
        prefix = $1
        uri = $2
        suffix = $3
      end
      uri = URINormalizer.normalize_suffix(uri)
      require_relative "vendored_uri"
      uri = Bundler::URI(uri)
      unless uri.absolute?
        raise ArgumentError, format("Gem sources must be absolute. You provided '%s'.", uri)
      end
      "#{prefix}#{uri}#{suffix}"
    end
  end
end
                                                                                                                                                                                                                                                                                                                           gems/gems/bundler-2.4.19/lib/bundler/ui/rg_proxy.rb                                                 0000644                 00000000460 15040313351 0015625 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

require_relative "../ui"
require "rubygems/user_interaction"

module Bundler
  module UI
    class RGProxy < ::Gem::SilentUI
      def initialize(ui)
        @ui = ui
        super()
      end

      def say(message)
        @ui&.debug(message)
      end
    end
  end
end
                                                                                                                                                                                                                gems/gems/bundler-2.4.19/lib/bundler/ui/shell.rb                                                    0000644                 00000007247 15040313351 0015075 0          