r)
      end

      def info(msg = nil, newline = nil)
        return unless info?

        tell_me(msg || yield, nil, newline)
      end

      def confirm(msg = nil, newline = nil)
        return unless confirm?

        tell_me(msg || yield, :green, newline)
      end

      def warn(msg = nil, newline = nil, color = :yellow)
        return unless warn?
        return if @warning_history.include? msg
        @warning_history << msg

        tell_err(msg || yield, color, newline)
      end

      def error(msg = nil, newline = nil, color = :red)
        return unless error?

        tell_err(msg || yield, color, newline)
      end

      def debug(msg = nil, newline = nil)
        return unless debug?

        tell_me(msg || yield, nil, newline)
      end

      def info?
        level("info")
      end

      def confirm?
        level("confirm")
      end

      def warn?
        level("warn")
      end

      def error?
        level("error")
      end

      def debug?
        level("debug")
      end

      def quiet?
        level("quiet")
      end

      def ask(msg)
        @shell.ask(msg)
      end

      def yes?(msg)
        @shell.yes?(msg)
      end

      def no?
        @shell.no?(msg)
      end

 