m.to_s }
  end

  # Returns +true+ if method +mid+ accepts the given option +opt+, +false+ otherwise;
  # the arguments may be strings or symbols:
  #
  #   Bundler::FileUtils.have_option?(:chmod, :noop) # => true
  #   Bundler::FileUtils.have_option?('chmod', 'secure') # => false
  #
  def self.have_option?(mid, opt)
    li = OPT_TABLE[mid.to_s] or raise ArgumentError, "no such method: #{mid}"
    li.include?(opt)
  end

  # Returns an array of the string keyword name for method +mid+;
  # the argument may be a string or a symbol:
  #
  #   Bundler::FileUtils.options_of(:rm) # => ["force", "noop", "verbose"]
  #   Bundler::FileUtils.options_of('mv') # => ["force", "noop", "verbose", "secure"]
  #
  def self.options_of(mid)
    OPT_TABLE[mid.to_s].map {|sym| sym.to_s }
  end

  # Returns an array of the string method names of the methods
  # that accept the given keyword option +opt+;
  # the argument must be a symbol:
  #
  #   Bundler::FileUtils.collect_method(:preserve) # => ["cp", "copy", "cp_r", "install"]
  #
  def self.collect_method(opt)
    OPT_TABLE.keys.select {|m| OPT_TABLE[m].include?(opt) }
  end

  private

  LOW_METHODS = singleton_methods(false) - collect_method(:noop).map(&:intern) # :nodoc:
  module LowMethods # :nodoc: internal use only
    private
    def _do_nothing(*)end
    ::Bundler::FileUtils::LOW_METHODS.map {|name| alias_method name, :_do_nothing}
  end

  METHODS = singleton_methods() - [:private_module_function,                  # :nodoc:
      :commands, :options, :have_option?, :options_of, :collect_method]

  #
  # This module has all methods of Bundler::FileUtils module, but it outputs messages
  # before acting.  This equates to passing the <tt>:verbose</tt> flag to
  # methods in Bundler::FileUtils.
  #
  module Verbose
    include Bundler::FileUtils
    names = ::Bundler::FileUtils.collect_method(:verbose)
    names.each do |name|
      module_eval(<<-EOS, __FILE__, __LINE__ + 1)
        def #{name}(*args, **options)
          super(*args, **options, verbose: true)
        end
      EOS
    end
    private(*names)
    extend self
    class << self
      public(*::Bundler::FileUtils::METHODS)
    end
  end

  #
  # This module has all methods of Bundler::FileUtils module, but never changes
  # files/directories.  This equates to passing the <tt>:noop</tt> flag
  # to methods in Bundler::FileUtils.
  #
  module NoWrite
    include Bundler::FileUtils
    include LowMethods
    names = ::Bundler::FileUtils.collect_method(:noop)
    names.each do |name|
      module_eval(<<-EOS, __FILE__, __LINE__ + 1)
        def #{name}(*args, **options)
          super(*args, **options, noop: true)
        end
      EOS
    end
    private(*names)
    extend self
    class << self
      public(*::Bundler::FileUtils::METHODS)
    end
  end

  #
  # This module has all methods of Bundler::FileUtils module, but never changes
  # files/directories, with printing message before acting.
  # This equates to passing the <tt>:noop</tt> and <tt>:verbose</tt> flag
  # to methods in Bundler::FileUtils.
  #
  module DryRun
    include Bundler::FileUtils
    include LowMethods
    names = ::Bundler::FileUtils.collect_method(:noop)
    names.each do |name|
      module_eval(<<-EOS, __FILE__, __LINE__ + 1)
        def #{name}(*args, **options)
          super(*args, **options, noop: true, verbose: true)
        end
      EOS
    end
    private(*names)
    extend self
    class << self
      public(*::Bundler::Fil