     # the gem specification using the instructions provided by `gem help install`
      installed_by_version == Gem::Version.new(0)
    end

    # This is defined directly to avoid having to loading the full spec
    def missing_extensions?
      return false if default_gem?
      return false if extensions.empty?
      return false if File.exist? gem_build_complete_path
      return false if manually_installed?

      true
    end

    def activated
      stub.activated
    end

    def activated=(activated)
      stub.instance_variable_set(:@activated, activated)
    end

    def extensions
      stub.extensions
    end

    def gem_build_complete_path
      File.join(extension_dir, "gem.build_complete")
    end

    def default_gem?
      stub.default_gem?
    end

    def full_gem_path
      stub.full_gem_path
    end

    def full_gem_path=(path)
      stub.full_gem_path = path
    end

    def full_require_paths
      stub.full_require_paths
    end

    def load_paths
      full_require_paths
    end

    def loaded_from
      stub.loaded_from
    end

    def matches_for_glob(glob)
      stub.matches_for_glob(glob)
    end

    def raw_require_paths
      stub.raw_require_paths
    end

    private

    def _remote_specification
      @_remote_specification ||= begin
        rs = stub.to_spec
        if rs.equal?(self) # happens when to_spec gets the spec from Gem.loaded_specs
          rs = Gem::Specification.load(loaded_from)
          Bundler.rubygems.stub_set_spec(stub, rs)
        end

        unless rs
          raise GemspecError, "The gemspec for #{full_name} at #{loaded_from}" \
            " was missing or broken. Try running `gem pristine #{name} -v #{version}`" \
            " to fix the cached spec."
        end

        rs.source = source

        rs
      end
    end
  end
end
                                                                                                                                                                                                                        gems/gems/bundler-2.4.19/lib/bundler/match_remote_metadata.rb                                       0000644                 00000001537 15040313372 0017657 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       # frozen_string_literal: true

module Bundler
  module FetchMetadata
    # A fallback is included because the original version of the specification
    # API didn't include that field, so some marshalled specs in the index have it
    # set to +nil+.
    def matches_current_ruby?
      @required_ruby_version ||= _remote_specification.required_ruby_version || Gem::Requirement.default

      super
    end

    def matches_current_rubygems?
      # A fallback is included because the original version of the specification
      # API didn't include that field, so some marshalled specs in the index have it
      # set to +nil+.
      @required_rubygems_version ||= _remote_specification.required_rubygems_version || Gem::Requirement.default

      super
    end
  end

  module MatchRemoteMetadata
    include MatchMetadata

    prepend FetchMetadata
  end
end
                                                                                                                                                                 gems/gems/bundler-2.4.19/lib/bundler/vendor/pub_grub/lib/pub_grub/basic_package_source.rb           0000644                 00000014021 15040313372 0025131 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       gems/gems/bundler-2.4.19/lib/bundler/stub_specification.rb                                          0000644                 00000005450 15040313372 0017223 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       ses: String ("rails")
  #
  #
  # ## "Version":
  #
  # This class will be used to represent a single version number.
  #
  # Versions don't need to store their associated package, however they will
  # only be compared against other versions of the same package.
  #
  # It must be Comparible (and implement <=> reasonably)
  #
  # Example classes: Gem::Version, Integer
  #
  #
  # ## "Dependency"
  #
  # This class represents the requirement one package has on another. It is
  # returned by dependencies_for(package, version) and will be passed to
  # parse_dependency to convert it to a format Bundler::PubGrub understands.
  #
  # It must also have a reasonable definition of #==
  #
  # Example classes: String ("~> 1.0"), Gem::Requirement
  #
  class BasicPackageSource
    # Override me!
    #
    # This is called per package to find all possible versions of a package.
    #
    # It is called at most once per-package
    #
    # Returns: Array of versions for a package, in preferred order of selection
    def all_versions_for(package)
      raise NotImplementedError
    end

    # Override me!
    #
    # Returns: Hash in the form of { package => requirement, ... }
    def dependencies_for(package, version)
      raise NotImplementedError
    end

    # Override me!
    #
    # Convert a (user-defined) dependency into a format Bundler::PubGrub understands.
    #
    # Package is passed to this method but for many implementations is not
    # needed.
    #
    # Returns: either a Bundler::PubGrub::VersionRange, Bundler::PubGrub: