eturn false if !include_max && other.include_max
        when 1
        end
      end

      true
    end

    def any?
      !min && !max
    end

    def empty?
      false
    end

    def to_s
      @name ||= constraints.join(", ")
    end

    def inspect
      "#<#{self.class} #{to_s}>"
    end

    def upper_invert
      return self.class.empty unless max

      VersionRange.new(min: max, include_min: !include_max)
    end

    def invert
      return self.class.empty if any?

      low = VersionRange.new(max: min, include_max: !include_min)
      high = VersionRange.new(min: max, include_min: !include_max)

      if !min
        high
      elsif !max
        low
      else
        low.union(high)
      end
    end

    def ==(other)
      self.class == other.class &&
        min == other.min &&
        max == other.max &&
        include_min == other.include_min &&
        include_max == other.include_max
    end

    private

    def constraints
      return ["any"] if any?
      return ["= #{min}"] if min.to_s == max.to_s

      c = []
      c << "#{include_min ? ">=" : ">"} #{min}" if min
      c << "#{include_max ? "<=" : "<"} #{max}" if max
      c
    end

  end
end
                                                                                                                                                                                                                                                                                                                                                 gems/gems/bundler-2.4.19/lib/bundler/vendor/pub_grub/lib/pub_grub/static_package_source.rb          0000644                 00000002704 15040313375 0025347 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       require_relative 'package'
require_relative 'version_constraint'
require_relative 'incompatibility'
require_relative 'basic_package_source'

module Bundler::PubGrub
  class StaticPackageSource < BasicPackageSource
    class DSL
      def initialize(packages, root_deps)
        @packages = packages
        @root_deps = root_deps
      end

      def root(deps:)
        @root_deps.update(deps)
      end

      def add(name, version, deps: {})
        version = Gem::Version.new(version)
        @packages[name] ||= {}
        raise ArgumentError, "#{name} #{version} declared twice" if @packages[name].key?(version)
        @packages[name][version] = clean_deps(name, version, deps)
      end

      private

      # Exclude redundant self-referencing dependencies
      def clean_deps(name, version, deps)
        deps.reject {|dep_name, req| name == dep_name && Bundler::PubGrub::RubyGems.parse_range(req).include?(version) }
      end
    end

    def initialize
      @root_deps = {}
      @packages = {}

      yield DSL.new(@packages, @root_deps)

      super()
    end

    def all_versions_for(package)
      @packages[package].keys
    end

    def root_dependencies
      @root_deps
    end

    def dependencies_for(package, version)
      @packages[package][version]
    end

    def parse_dependency(package, dependency)
      return false unless @packages.key?(package)

      Bundler::PubGrub::RubyGems.parse_constraint(package, dependency)
    end
  end
end
                                                            gems/gems/bundler-2.4.19/lib/bundler/vendor/pub_grub/lib/pub_grub/failure_writer.rb                 0000644                 00000013130 15040313375 0024043 0                                                                                                    ustar 00                                                                                                                                                                                                                                                       module Bundler::PubGrub
  class FailureWriter
    def initialize(root)
      @root = root

      # { Incompatibility => Integer }
      @derivations = {}

      # [ [ String, Integer or nil ] ]
      @lines = []

      # { Incompatibility => Integer }
      @line_numbers = {}

      count_derivations(root)
    end

    def write
      return @root.to_s unless @root.conflict?

      visit(@root)

      padding = @line_numbers.empty? ? 0 : "(#{@line_numbers.values.last}) ".length

      @lines.map do |message, number|
        next "" if message.empty?

        lead = number ? "(#{number}) " : ""
        lead = lead.ljust(padding)
        message = message.gsub("\n", "\n" + " " * (padding + 2))
        "#{lead}#{message}"
      end.join("\n")
    end

    private

    def write_line(incompatibility, message, numbered:)
      if numbered
        number = @line_numbers.length + 1
        @line_numbers[incompatibility] = number
      end

      @lines << [message, number]
    end

    def visit(incompatibility, conclusion: false)
      raise unless incompatibility.conflict?

      numbered = conclusion || @derivations[incompatibility] > 1;
      conjunction = conclusion || incompatibility == @root ? "So," : "And"

      cause = incompatibility.cause

      if cause.conflict.conflict? && cause.other.conflict?
        conflict_line = @line_numbers[cause.conflict]
        other_line = @line_numbers[cause.other]

        if conflict_line && other_line
          write_line(
            incompatibility,
            "Because #{cause.conflict} (#{conflict_line})\nand #{cause.other} (#{other_line}),\n#{incompati