     constraint.eql?(other.constraint)
    end

    def invert
      self.class.new(@constraint, !@positive)
    end
    alias_method :inverse, :invert

    def intersect(other)
      raise ArgumentError, "packages must match" if package != other.package

      if positive? && other.positive?
        self.class.new(constraint.intersect(other.constraint), true)
      elsif negative? && other.negative?
        self.class.new(constraint.union(other.constraint), false)
      else
        positive = positive? ? self : other
        negative = negative? ? self : other
        self.class.new(positive.constraint.intersect(negative.constraint.invert), true)
      end
    end

    def difference(other)
      intersect(other.invert)
    end

    def relation(other)
      if positive? && other.positive?
        constraint.relation(other.constraint)
      elsif negative? && other.positive?
        if constraint.allows_all?(other.constraint)
          :disjoint
        else
          :overlap
        end
      elsif positive? && other.negative?
        if !other.constraint.allows_any?(constraint)
          :subset
        elsif other.constraint.allows_all?(constraint)
          :disjoint
        else
          :overlap
        end
      elsif negative? && other.negative?
        if constraint.allows_all?(other.constraint)
          :subset
       