package|
        @decisions.key?(package)
      end.map do |package|
        @terms[package]
      end
    end

    def decide(package, version)
      @attempted_solutions += 1 if @backtracking
      @backtracking = false;

      decisions[package] = version
      assignment = Assignment.decision(package, version, decision_level, assignments.length)
      add_assignment(assignment)
    end

    def backtrack(previous_level)
      @backtracking = true

      new_assignments = assignments.select do |assignment|
        assignment.decision_level <= previous_level
      end

      new_decisions = Hash[decisions.first(previous_level)]

      reset!

      @decisions = new_decisions

      new_assignments.each do |assignment|
        add_assignment(assignment)
      end
    end

    private

    def reset!
      # { Array<Assignment> }
      @assignments = []

      # { Package => Array<Assignment> }
      @assignments_by = Hash.new { |h,k| h[k] = [] }
      @cumulative_assignments = {}.compare_by_identity

      # { Package => Package::Version }
      @decisions = {}

      # { Package => Term }
      @terms = {}
      @relation_cache = Hash.new { |h,k| h[k] = {} }

      # { Package => Boolean }
      @required = {}
    end

    def add_assignment(assignment)
      term = assignment.term
      package = term.package

      @assignments << assignment
      @assignments_by[package] << assignment

      @required[package] = true if term.positive?

      if @terms.key?(package)
        old_term = @terms[package]
        @terms[package] = old_term.intersect(term)
      else
        @terms[package] = term
      end
      @relation_cache[package].clear

      @cumulative_assignments[assignment] = @terms[package]
    end
  end
end
                                                                                                                                                                                                                                                                                                           gems/gems/bundler-2.4.19/lib/bundler/vendor/pub_grub/lib/pub_grub/package.rb                        0000644                 00000001130 15040313373 0022406 0                                                                                                    ustar 00                                                                                                                           